#version 120
//#define DOTSIZE 32.0f
uniform float DOTSIZE;
uniform float phaze;
varying vec2 texCoord;
uniform sampler2D colorMap;
//uniform sampler2D polkaMap;
uniform sampler2D polkaBigMap;
uniform sampler2D polkaBack;
uniform float offsetx;
uniform float offsety;


void main(void){
    float phazeoff;
    float dotsz=DOTSIZE;
    float pixx=texCoord.x*1920.0f;
    float pixy=texCoord.y*1080.0f;
    float counter=0.0f;
    float groupx=floor(pixx/DOTSIZE)*DOTSIZE;
    float groupy=floor(pixy/DOTSIZE)*DOTSIZE;
    float shade=0.0f;
    float x1,y1;

    for (float i=0; i<dotsz; i+=dotsz/4.0f){
        for (float j=0; j<dotsz; j+=dotsz/4.0f){
            if (phaze!=0) phazeoff=0.0f; else phazeoff=DOTSIZE/2.0f;
            x1=(groupx+i+phazeoff)/1920.0f;
            y1=(groupy+j+phazeoff)/1080.0f;
            if (x1<0.9999f&&y1<0.9999f&&x1>0.0f&&y1>0.0f){
                vec4 pixel=texture2D(colorMap, vec2(x1,y1));
                shade=shade+pixel.r+pixel.g+pixel.b;
                counter+=3.0f;
            }
        }
    }

    shade=1.0f-shade/counter;



x1=(pixx-groupx)/DOTSIZE;
y1=(pixy-groupy)/DOTSIZE;

vec2 texCoordBigMap=vec2(x1,y1);
vec4 polkadot=texture2D(polkaBigMap,texCoordBigMap);

vec4 pixel;
if (polkadot.x<shade)
    pixel=vec4(0.0f);
else
    pixel=vec4(1.0f);
/*
vec2 texCoord2;
   x1=texCoord.x+((1.0f/1920.0f)*DOTSIZE/2.0f);
   y1=texCoord.y+((1.0f/1080.0f)*DOTSIZE/2.0f);

if (phaze==0) texCoord2=vec2(texCoord.x,texCoord.y); else texCoord2=vec2(x1,y1);
*/
if (phaze==0.0f)
    gl_FragColor = pixel;//+texture2D(polkaBack,texCoord2);
else{
    x1=texCoord.x-((1.0f/1920.0f)*DOTSIZE/2.0f);
    y1=texCoord.y-((1.0f/1080.0f)*DOTSIZE/2.0f);
    x1=clamp(x1,0.0f,0.9999f);
    y1=clamp(y1,0.0f,0.9999f);
    vec2 texCoord2=vec2(x1,y1);
    gl_FragColor = pixel+texture2D(polkaBack,texCoord2);
}

/*
    //float dotposx=(pixx-groupx)/1920.0f;
    //float dotposy=(pixy-groupy)/1080.0f;
    float dotposx=(pixx-floor(pixx/DOTSIZE)*DOTSIZE)/1920.0f;
    float dotposy=(pixy-floor(pixy/DOTSIZE)*DOTSIZE)/1080.0f;

    vec2 texCoordBigMap=vec2(dotposx,dotposy);
    vec4 polkadot=texture2D(polkaBigMap,texCoordBigMap);
    vec4 pixel;
    if (polkadot.x>shade)
        pixel=vec4(0.0f);
    else
        pixel=vec4(1.0f);


    gl_FragColor = pixel;
    //gl_FragColor = polkadot;
    //gl_FragColor = texture2D(polkaBigMap,texCoord);
*/
}

/*
void main (void)
{
float shade=0.0f;
float counter=0.0f;

if (phaze==0)
for (float i=0; i<DOTSIZE; i=i+(DOTSIZE/4.0f))
    for (float j=0; j<DOTSIZE; j=j+(DOTSIZE/4.0f))
    {
        //float x1=1.0f/DOTSIZE/2*floor(1920.0f*texCoord.x/DOTSIZE)+1.0f/1920.f*i;
        //float y1=1.0f/DOTSIZE*floor(1080.0f*texCoord.y/DOTSIZE)+1.0f/1080.f*j;
        //float x1=texCoord.x; float y1=texCoord.y;
        float x1=texCoord.x*1920.0f;
        x1=floor(x1/DOTSIZE)*DOTSIZE;
        x1=x1+i;
        //x1=x1+1920.0f/2.0f;
        x1=x1*(1.0f/1920.0f);
        float y1=texCoord.y*1080.0f;
        y1=floor(y1/DOTSIZE)*DOTSIZE;
        y1=y1+j;
        //y1=y1+1080.0f/2.0f;
        y1=y1*(1.0f/1080.0f);

        clamp(x1,0.0f,0.99999f);
        clamp(y1,0.0f,0.99999f);
        vec4 pixel=texture2D(colorMap, vec2(x1,y1));
        shade=shade+pixel.r+pixel.g+pixel.b;
        counter+=3.0f;
    }
else
for (float i=0; i<DOTSIZE; i=i+(DOTSIZE/4.0f))
    for (float j=0; j<DOTSIZE; j=j+(DOTSIZE/4.0f))
    {
        //float x1=1.0f/DOTSIZE/2*floor(1920.0f*texCoord.x/DOTSIZE)+((1.0f/1920.f)*(i+DOTSIZE/2.0f));
        //float y1=1.0f/DOTSIZE*floor(1080.0f*texCoord.y/DOTSIZE)+((1.0f/1080.f)*(j+DOTSIZE/2.0f));
        float x1=texCoord.x*1920.0f;
        x1=floor(x1/DOTSIZE)*DOTSIZE;
        x1=x1+i+DOTSIZE/2.0f;
        //x1=x1+1920.0f/2.0f;
        x1=x1*(1.0f/1920.0f);
        float y1=texCoord.y*1080.0f;
        y1=floor(y1/DOTSIZE)*DOTSIZE;
        y1=y1+j+DOTSIZE/2.0f;
        //y1=y1+1080.0f/2.0f;
        y1=y1*(1.0f/1080.0f);

        clamp(x1,0.0f,0.99999f);
        clamp(y1,0.0f,0.99999f);
        vec4 pixel=texture2D(colorMap, vec2(x1,y1));
        shade=shade+pixel.r+pixel.g+pixel.b;
        counter+=3.0f;
    }
//shade=1.0f-shade/4.0f/4.0f/3.0f;
shade=1.0f-shade/counter;

float x1, y1;
x1=texCoord.x-1.0f/(1920.0f-floor((texCoord.x*1920.0f)/DOTSIZE)*DOTSIZE);
y1=texCoord.y-1.0f/(1080.0f-floor((texCoord.y*1080.0f)/DOTSIZE)*DOTSIZE);

x1=(x1*1920.0f/256.0f)*(256.0f/DOTSIZE);
y1=(y1*1080.0f/256.0f)*(256.0f/DOTSIZE);

clamp(x1,0.0f,0.99999f);
clamp(y1,0.0f,0.99999f);

vec2 texCoordBigMap=vec2(x1,y1);
vec4 polkadot=texture2D(polkaBigMap,texCoordBigMap);

vec4 pixel;
if (polkadot.x<shade)
    pixel=vec4(0.0f);
else
    pixel=vec4(1.0f);

vec2 texCoord2;
   x1=texCoord.x+((1.0f/1920.0f)*DOTSIZE/2.0f);
   y1=texCoord.y+((1.0f/1080.0f)*DOTSIZE/2.0f);

if (phaze==0) texCoord2=vec2(texCoord.x,texCoord.y); else texCoord2=vec2(x1,y1);

gl_FragColor = pixel+texture2D(polkaBack,texCoord2);
}

*/
