uniform sampler2D colorMap;
uniform sampler2D distortMap;
in vec2 texCoord;
uniform float testvalue;
uniform float rotbounce;
uniform float x_rotation;

vec2 bulge(vec2 v)
{
 //vec2 cen = vec2(0.5,0.5) - v;
 float factor=0.07*0.4;
 float rf=0.2*0.7;
 vec2 cen = vec2(0.0,0.0) - v;
 vec2 mcen = - // delete minus for implosion effect
      factor*log(length(cen))*normalize(cen);
 if (length(cen)<rf) mcen=mix(vec2(0,0),mcen,length(cen)/rf); // mirrored center fix
 if (length(cen)<0.001*12.0) mcen=vec2(0,0); // center dot fix
 return v.xy+mcen;
}

mat3 getrot(vec3 r)
{
    float cx = cos(radians(r.x));
    float sx = sin(radians(r.x));
    float cy = cos(radians(r.y));
    float sy = sin(radians(r.y));
    float cz = cos(radians(r.z));
    float sz = sin(radians(r.z));

    float m1 = cy * cz;
    float m2= cx * sz + sx * sy * cz;
    float m3= sx * sz - cx * sy * cz;
    float m4= -cy * sz;
    float m5= cx * cz - sx * sy * sz;
    float m6= sx * cz + cx * sy * sz;
    float m7= sy;
    float m8= -sx * cy;
    float m9= cx * cy;

    return mat3
    (
        m1,m2,m3,
        m4,m5,m6,
        m7,m8,m9
    );
};

const float PI=3.1415926535897932384626433832795;
/*
float atan2(in float y, in float x)
{
    ///if (abs(x)==0 || abs(y)==0) return 0.0;

    bool s = (abs(x) > abs(y));
    float s_;
    if (!s) s_=1.0; else s_=0.0;
    return mix(PI/2.0 - atan(x,y), atan(y,x), s_);
}
*/

vec3 getRot2(float zangle, vec3 v){
float ct=cos(zangle); float st=sin(zangle);
	mat4 rotm=mat4( ct, -st, 0.0,  0.0,
	              st,  ct, 0.0,  0.0,
	             0.0, 0.0, 1.0,  0.0,
	             0.0, 0.0, 0.0,  1.0);
    vec4 v2=vec4(v,1.0)*rotm;
    return v2.xyz;
}

vec3 getRot3(float xangle, vec3 v){
float ct=cos(xangle); float st=sin(xangle);
//x axis
	mat4 rotm=mat4(1.0, 0.0, 0.0,  0.0,
	         0.0,  ct, -st,  0.0,
	         0.0,  st,  ct,  0.0,
	         0.0, 0.0, 0.0,  1.0);
             /*
             // y axis
	rotm=mat4( ct, 0.0,  st,  0.0,
	         0.0, 1.0, 0.0,  0.0,
	         -st, 0.0,  ct,  0.0,
	         0.0, 0.0, 0.0,  1.0);
             */
    vec4 v2=vec4(v,1.0)*rotm;
    return v2.xyz;
}


vec3 rotateXY(vec3 p, vec2 angle) {
    vec2 c = cos(angle), s = sin(angle);
    p = vec3(p.x, c.x*p.y + s.x*p.z, -s.x*p.y + c.x*p.z);
    return vec3(c.y*p.x + s.y*p.z, p.y, -s.y*p.x + c.y*p.z);
}

vec4 TinyPlanet()
{
    float ar = 1.0 * 2048.0 / 1024.0;
    float ar2 = 1.0 * 1920.0 / 1080.0;
    //ar2=2.0;
    ///float ar2 = 2.0;
    ar=ar/ar2*0.5;

    ///mat3 rot = getrot(vec3(center_x, center_y, z_rotation));
    float z_rotation=3.14+rotbounce;//testvalue;//0.0; // animatable
    ///float xrot=testvalue;
    ///mat3 rot = getrot(vec3(0.0, 0.0, z_rotation));

    vec2 rads = vec2(PI * 2.0 , PI);
    //vec2 offset = vec2(0.0,0.0);
    //float scale = 4.5*1.6;

    //const float pi=3.14;
    //float testvalue2=-(1.0+sin(testvalue/2.0*-pi/2)); // 0,-1 to 0,pi/2 then -1,0 to 0,-1
    //testvalue=testvalue2;
    
    vec2 offset = vec2(0.0,-0.5);
    float scale = 4.5*1.6 /(1.0+1.0)/1.35;
    if (testvalue<0.0) offset*=vec2(0.0,pow(1.0+testvalue,3.0)); //0,-1 -> 1,0
    if (testvalue<0.0) scale*=1.0+pow(abs(testvalue),5.2); //0,-1 -> 1,2
    vec2 pnt = (texCoord - 0.5 - offset).xy * vec2(scale, scale*ar);
    

    // Project to Sphere
    float x2y2 = pnt.x * pnt.x + pnt.y * pnt.y;
    vec3 sphere_pnt = vec3(2.0 * pnt, x2y2 - 1.0) / (x2y2 + 1.0);
    ///sphere_pnt = sphere_pnt * rot; // doing this for any value for z_rotation but 0 results in an erroneous edge
    sphere_pnt=getRot2(z_rotation,sphere_pnt);

    float fader=x_rotation/6.28;
    if (fader>0.5) fader=1.0-fader;
    fader*=2.0;
    float x_rot;
    if (x_rotation>0) x_rot=x_rotation+texture2D(distortMap, gl_FragCoord/vec2(1920.0,1080.0)).x*fader; else x_rot=0;
    sphere_pnt=getRot3(x_rot,sphere_pnt);

    // Convert to Spherical Coordinates
    float r2=length(sphere_pnt.xy); 
    float r = length(sphere_pnt);

    /*
    if (r2>0.2) r+=(1.0-1.021); 
    else 
    {
        ///r+=(1.0-1.021)/pow(0.2/r2,testvalue);
        sphere_pnt.x*=testvalue;
    }
    */
    

    float lon = atan(sphere_pnt.x,sphere_pnt.y);
    //if (isnan(lon)) lon=0.0;
    //if (isinf(lon)) lon=0.0;
    ///r+=0.01f; // fix for r=0 center wrong pixel
    float lat = acos(sphere_pnt.z / r);
    //if (isnan(lat)) lat=0.0;
    //if (isinf(lat)) lat=0.0;

    vec2 coos=vec2(lon, lat) / rads;/// * vec2(1.0,1.0/0.952);

    /*
    ///coos.x*=testvalue;
    if (coos.y>=1.0-1.0/1024.0) {
        coos.y-=1.0/1024.0;
        coos.x/=testvalue;
    }
    */

    const float hfovDegrees=90.0;
    const float vfovDegrees=90.0/(1920.0/1080.0);
    vec2 uv = texCoord.xy * 2.- 1.;
    //to spherical
#define DEG2RAD 0.01745329251994329576923690768489
    vec3 camDir = normalize(vec3(uv.xy * vec2(tan(0.5 * hfovDegrees * DEG2RAD), tan(0.5 * vfovDegrees * DEG2RAD)), 1.0));

///camDir=getRot2(rotbounce, camDir);

    //camRot is angle vec in rad
    //vec3 camRot = vec3( ((iMouse.xy / iResolution.xy) - 0.5) * vec2(2.0 * PI,  PI), 0.);
    //vec3 camRot = vec3( (vec2(0.5,0.5) - 0.5) * vec2(2.0 * PI,  PI), 0.);
    ///vec3 camRot=vec3((90.0)*DEG2RAD,0,0);
    vec3 camRot=vec3((90.0)*DEG2RAD,0,0);
    //rotate
    vec3 rd = normalize(rotateXY(camDir, camRot.yx));
    //radial azmuth polar
    vec2 coos2 = vec2(atan(rd.z, rd.x) + PI, acos(-rd.y)) / vec2(2.0 * PI, PI);
    coos2.y*=-1.0;
//    coos2+=vec2(0.5,0.0);

    coos2=mod(coos2,1.0);
    coos=mod(coos,1.0);

    ///vec2 coosr=mix(coos2,coos,1.0-clamp(testvalue,0.0,1.0));
    vec2 coosr;//=mix(coos2,coos,1.0-clamp(testvalue,0.0,1.0));

    //float mixvalue=lamp(testvalue*2.0,0.0,1.0);
    float mixvalue=clamp(testvalue,0.0,1.0);
    coosr.x=coos2.x*(mixvalue)+(-coos.x+1.0)*(1.0-mixvalue);
    coosr.y=coos2.y*(mixvalue)+(coos.y)*(1.0-mixvalue);

    ///vec4 col=vec4(coosr.y,coosr.x,0.0,1.0);
    ///return col;

    return texture2D(colorMap, coosr);
    ///return texture2D(colorMap, texCoord);
}
/*
float atan2(float x, float y) {return atan(y,x);}
float hypot(float x, float y) {return sqrt(x*x+y*y);}

vec4 TinyPlanet2()
{
const float PI=3.1415926535897932384626433832795;
vec2 uv=texCoord*vec2(1920.0,1080.0);
float h=1024.0; float w=2048.0;
//geq="1920*(0.9999 + atan2(Y-1920\,X-1920)/PI)"
//geq="1920*(1-hypot((2*X/3840)-1\,(2*Y/3840)-1))"

    float xmap=h*(0.9999+atan2(uv.y-h,uv.x-h)/PI);
    float ymap=h*(1.0-hypot((2.0*uv.x/w)-1.0,(2.0*uv.y/w)-1.0));
    return texture2D(colorMap, vec2(xmap,ymap)/vec2(w,h));
}

vec4 TinyPlanet3()
{
    const float r_inner=0.0;//0.25; 
    const float r_outer=1.0;//0.5; 

    vec2 x = texCoord.yx - vec2(0.5);
    float radius = length(x);
    float angle = atan(x.y, x.x)*testvalue;

    vec2 tc_polar; // the new polar texcoords
    // map radius so that for r=r_inner -> 0 and r=r_outer -> 1
    tc_polar.s = ( radius - r_inner) / (r_outer - r_inner);

    // map angle from [-PI,PI] to [0,1]
    tc_polar.t = angle * 0.5 / PI + 0.5;

        tc_polar.s*=-1.0;

    // texture mapping
    return texture2D(colorMap, tc_polar.ts);
}
*/

void main()
{
    gl_FragColor = TinyPlanet();
}
