//#version 120
// It was expressed that some drivers required this next line to function properly
//precision highp float;
#define MAX_LIGHTS 1
in vec3 alightVec[MAX_LIGHTS];
in vec3 aeyeVec[MAX_LIGHTS];
in vec2 texCoord;

uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];
uniform sampler2D colorMap;
uniform sampler2D normalMap;
uniform sampler2D lightMap;
uniform sampler2D specularMap;

//uniform vec3 cameraeyevector;
//uniform float invRadius;
//out vec4 gl_FragColor;

//--------------------------------------------------------------------------------------------

varying vec3 alVec[MAX_LIGHTS];
varying vec3 avVec[MAX_LIGHTS];
//varying vec3 aeyeVec[MAX_LIGHTS];


void main (void)
{
    vec4 result;
    vec3 eVec;

    vec3 lightVec;
    vec3 eyeVec;
    vec4 accvDiffuse = vec4(0.0);
    vec4 accvSpecular = vec4(0.0);
    float distSqr;
    vec3 lVec;
    vec3 vVec;
    float att;
    vec4 base;
    vec4 vAmbient;
    vec3 bump;
    float diffuse;
    vec4 vDiffuse;
    vec4 vSpecular;
    float specular;
    vec3 nrmltexture;

    base = texture2D(colorMap, texCoord);
    vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;
    for (int i=0; i<MAX_LIGHTS; i++)
    {
        if (lightsEnabled[i]>0.0)
        {
            lightVec=alightVec[i];
            eyeVec=aeyeVec[i];
            distSqr = dot(lightVec, lightVec);
            att = clamp(1.0 - lightsinvRadius[i] * sqrt(distSqr), 0.0, 1.0);
            lVec = lightVec * inversesqrt(distSqr);
            vVec = normalize(eyeVec);

            bump = normalize( texture2D(normalMap, texCoord).xyz * 2.0f - 1.0);
            diffuse = clamp( dot(lVec, bump), 0.0, 1.0 );
            vDiffuse = gl_LightSource[i].diffuse * diffuse *
                       texture2D(lightMap, vec2(diffuse-0.01,lightMapSelect[i]));
            accvDiffuse = accvDiffuse + vDiffuse;
            specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), 32.0 ) * texture2D(specularMap, texCoord).r; //here shiness is replaced with 1.0, should introduce material functionality in obj loader //16.0

            vSpecular = gl_LightSource[i].specular * specular * texture2D(lightMap, vec2(specular-0.01,lightMapSelect[i]));
            accvSpecular = accvSpecular + vSpecular;
        }
    }
    gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular);

    vVec=aeyeVec[0];
    //float alpha = texture2D(lightMap, vec2(0.0,clamp(vvec, 0.1, 1.0))) ;
    float alpha=clamp(vVec.x,0,1.0f);
    result=( clamp(accvDiffuse,1.0,1.0)*base );
    gl_FragColor = result*alpha;

}

