//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID33b2f4fc_d1d5_4ee7_924c_ab80f54a0c24
{
    public class Class_Fog : OperatorPart.Function, IFogSettings
    {
        //>>> _inputids
        private enum InputId
        {
            Scene = 0,
            ColorR = 1,
            ColorG = 2,
            ColorB = 3,
            ColorA = 4,
            Start = 5,
            End = 6,
            Mode = 7,
            Density = 8,
            Exponent = 9
        }
        //<<< _inputids
    
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Scene = inputs[(int)InputId.Scene];
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
            var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
            var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
            var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
            var Start = inputs[(int)InputId.Start].Eval(context).Value;
            var End = inputs[(int)InputId.End].Eval(context).Value;
            var Mode = (int) inputs[(int)InputId.Mode].Eval(context).Value;
            var Density = inputs[(int)InputId.Density].Eval(context).Value;
            var Exponent = inputs[(int)InputId.Exponent].Eval(context).Value;
            //<<< _params

            // store values for later use of IMaterial
            this.Color = Color;
            this.Start = Start;
            this.End = End;
            this.Mode = (FogMode) Mode;
            this.Density = Density;
            this.Exponent = Exponent;

            var prevFogSettings = (IFogSettings) context.Objects[OperatorPartContext.FOG_SETTINGS_ID];
            context.Objects[OperatorPartContext.FOG_SETTINGS_ID] = this;

            Scene.Eval(context);

            context.Objects[OperatorPartContext.FOG_SETTINGS_ID] = prevFogSettings;

            return context;
        }

        public Color4 Color { get; private set; }
        public float Start { get; private set; }
        public float End { get; private set; }
        public FogMode Mode { get; private set; }
        public float Density { get; private set; }
        public float Exponent { get; private set; }
    }
}

