//      stuff.cpp

#include "midasdll.h"
#include "mode13.h"
#include "stuff.h"

unsigned position, pattern, row;
MIDASmodulePlayHandle playhandle;
int lastresult, rowflag;

//	Midas stuff
void GetMusicInfo() {
	static MIDASplayStatus status;
	MIDASgetPlayStatus(playhandle, &status);
	position = status.position;
	pattern = status.pattern;
        if (row == status.row) rowflag = 0;
        else {  rowflag = 1; row = status.row; }
}


//	various cool functions
void ClearPalette(TPalette pal) {
        unsigned int off = (unsigned int)pal;
	_asm {
		mov edi, [off]
		mov ecx, 192
		xor eax, eax
		rep stosd
	}
}

void FadePalette(TPalette pal, int first, int last) {
	for (int i = first; i <= last; i++) {
		if (pal[i][0]) pal[i][0]--;
		if (pal[i][1]) pal[i][1]--;
		if (pal[i][2]) pal[i][2]--;
	}
}

void FadePaletteTo(TPalette pal, TPalette dest, int first, int last) {
	for (int i = first; i <= last; i++) {
		if (pal[i][0] > dest[i][0]) pal[i][0]--;
		if (pal[i][0] < dest[i][0]) pal[i][0]++;
		if (pal[i][1] > dest[i][1]) pal[i][1]--;
		if (pal[i][1] < dest[i][1]) pal[i][1]++;
		if (pal[i][2] > dest[i][2]) pal[i][2]--;
		if (pal[i][2] < dest[i][2]) pal[i][2]++;
	}
}

void CopyPalette(TPalette src, TPalette dst, int first, int last) {
	for (int i = first; i <= last; i++) {
		dst[i][0] = src[i][0];
		dst[i][1] = src[i][1];
		dst[i][2] = src[i][2];
	}
}


void DrawBanner(unsigned int source, int sx, int sy, int x, int y, unsigned int where) {
        _asm {
                mov esi, [source]
                mov edi, [where]
                mov eax, 320
                mul [y]
                add eax, [x]
                add edi, eax
                mov ebx, 320
                sub ebx, [sx]
                mov edx, [sy]
                mov dh, 0FFh
                loopy:  mov ecx, [sx]
                loopx:  mov al, [esi]
                        inc esi
                        add [edi], al
                        jnc cont
                        mov [edi], dh
                cont:   inc edi
                        dec ecx
                        jnz loopx
                        add edi, ebx
                        dec dl
                        jnz loopy
        }
}
