//	obj3d.h

#ifndef _OBJ3D_
#define _OBJ3D_

#include "vectors.h"

#define MaxObjectVertex 2048
#define MaxPolyVertex   4
#define MaxObjectPoly   2048


class TPolygon {
	public:
			int NumVertex;
			unsigned int zorder;
			TVector normal;
			TVertex *(*Vertex);
			
			TPolygon();
			~TPolygon();
			
			void AddVertex(TVertex *v);
			void Draw(unsigned int where);
			void CalcNormal();
			int Visible();
			void CalcZOrder();
};


class TObject3D {
	public:
			int XCenter, YCenter;
			int NumVertex, NumPolygons;
			int Style;
			TVertex *(*Vertex);
			TPolygon *(*Poly);
			
			TObject3D();
			~TObject3D();
			
			void SetCenter(int xc, int yc) { XCenter = xc; YCenter = yc; };
			void AddVertex(double nx, double ny, double nz);
			void AddVertexUV(double nx, double ny, double nz, double nu, double nv);
			void AddPolygon(TPolygon *poly);
			void CalcNormals();
			void MapEnviroment();
			void Traslate(double tx, double ty, double tz);
			void Rotate(int ax, int ay, int az);
			void FlatFastRotate(int ax, int ay, int az);
			void NotFlatFastRotate(int ax, int ay, int az);
			void Scale(double sx, double sy, double sz);
			void Draw(unsigned int where);
			void DrawCylinder(unsigned int where);
			void DrawParticles(unsigned int where);
};


// load a 3d object
void Load3DObject(char *filename, TObject3D *obj);
void Read3DObject(int *vkx, TObject3D *obj);


#endif
