//      beckkkck.cpp

#include <conio.h>
#include <math.h>
#include "mode13.h"
#include "obj3d.h"
#include "triangle.h"
#include "vectors.h"
#include "cuadro.h"
#include "stuff.h"
#include "beckkkck.h"

#include "beck.h"
#include "env3.h"
#include "banner6.h"

#include "kkck.h"

double b_ZoomTable[256], k_ZoomTable[256];
TPalette b_pal;
int b_rottable[256][3];

void BECKKKCK_Setup() {
        double ang;
        for (int i = 0; i < 128; i++) {
                b_ZoomTable[i] = -200 * sin(i * Pi / 64.0);
                b_ZoomTable[i + 128] = 100 - 300 * sin(i * Pi / 64.0);
                k_ZoomTable[i] = 300 * sin(i * Pi / 32.0);
                k_ZoomTable[i + 128] = 100 * sin(i * Pi / 32.0);
        }
        CopyPalette(BECK_PAL, b_pal, 0, 127);
        CopyPalette(ENV3_PAL, b_pal, 128, 255);
        for (i = 0; i < 256; i++) {
                ang = i * Pi / 128.0;
                b_rottable[i][0] = sin(ang) * 3.0 + 1.0;
                b_rottable[i][1] = cos(ang) * 3.0 + 2.0;
                b_rottable[i][2] = -cos(ang / 2.0) * 3.0 - 2.0;
	}
}


void b_DrawBanner(unsigned int source, unsigned int where);
#pragma aux b_DrawBanner =      \
"mov edx, 128"  \
"loopy: mov ecx, 200"   \
"loopx: mov al, [esi]"  \
"       inc esi"        \
"       or al, al"      \
"       jz skip"        \
"       mov [edi], al"  \
"skip:  inc edi"        \
"       dec ecx"        \
"       jnz loopx"      \
"       add edi, 120"   \
"       dec edx"        \
"       jnz loopy"      \
parm [esi] [edi]        \
modify [eax ecx edx];


void b_FillPal(unsigned int paloff);
#pragma aux b_FillPal = \
"mov ecx, 192"  \
"mov eax, 03F3F3F3Fh"   \
"rep stosd"     \
parm [edi]      \
modify [eax ecx];


void b_FadePal(TPalette pal) {
        for (int i = 0; i < 256; i++) {
                if (pal[i][0] > b_pal[i][0]) pal[i][0]--;
                if (pal[i][1] > b_pal[i][1]) pal[i][1]--;
                if (pal[i][2] > b_pal[i][2]) pal[i][2]--;
	}
}


void BECKKKCK_Run() {
        TObject3D *back = new TObject3D();
        TObject3D *kkck = new TObject3D();
        PTVirtual vscr;
        unsigned int voff;
        char a = 0;
        TPalette pal;

        SetupVirtual(&vscr, &voff);
        ClearScreen(0, voff);
        GeneraCuadro(2, 240, back);
        back->SetCenter(160, 100);
        back->Scale(3.2, 2.0, 1.0);
        
        Read3DObject(KKCK_VKX, kkck);
        kkck->Scale(2.0, 2.0, 2.0);
        kkck->SetCenter(280, 160);

        GlobalStyle = c_texturemapped;
        b_FillPal((unsigned int)pal);

        GetMusicInfo();
        while (position < 17) {
                ClearScreen(0, voff);
                TextureOffset = (unsigned int)BECK;
                back->Traslate(0, 0, b_ZoomTable[a]);
                back->Draw(voff);
                back->Traslate(0, 0, -b_ZoomTable[a++]);

                if (((row & 15) > 7) && ((row & 15) < 12))
                        b_DrawBanner((unsigned int)BANNER6, voff);

                kkck->Traslate(0, 0, k_ZoomTable[a]);
                TextureOffset = (unsigned int)ENV3;
                kkck->MapEnviroment();
                kkck->Draw(voff);
                kkck->Traslate(0, 0, -k_ZoomTable[a]);

                VRetrace();
                SetPalette(pal);
                CopyScreen(voff, VGA);

                kkck->Rotate(b_rottable[a][0], b_rottable[a][1], b_rottable[a][2]);
                b_FadePal(pal);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }

        b_FillPal((unsigned int)pal);
        while (position < 18) {
                ClearScreen(0, voff);
                TextureOffset = (unsigned int)BECK;
                back->Traslate(0, 0, b_ZoomTable[a]);
                back->Draw(voff);
                back->Traslate(0, 0, -b_ZoomTable[a++]);

                if (((row & 15) > 7) && ((row & 15) < 12))
                        b_DrawBanner((unsigned int)BANNER6, voff);

                kkck->Traslate(0, 0, k_ZoomTable[a]);
                TextureOffset = (unsigned int)ENV3;
                kkck->MapEnviroment();
                kkck->Draw(voff);
                kkck->Traslate(0, 0, -k_ZoomTable[a]);

                VRetrace();
                SetPalette(pal);
                CopyScreen(voff, VGA);

                kkck->Rotate(b_rottable[a][0], b_rottable[a][1], b_rottable[a][2]);
                b_FadePal(pal);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }
        ShutDownVirtual(&vscr);
        delete back;
        delete kkck;
}
