
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include "bitmaps.h"
#include "blitter.h"
#include "circles.h"
#include "plasmafx.h"
#include "globals.h"
#include "midas.h"
#include "part6.h"

#include "pcode1.h"
#include "credfac.h"
#include "us3.h"

byte p6_pt1[256], p6_pt2[256];
int p6_td[256];

void EFX6(TBitmap8bpp *source, TBitmap8bpp *dest, TBitmap8bpp *plas) {
	byte *src;
	byte *dst = dest->datos;
	byte *pls = plas->datos;
	for (int y = 0; y < dest->alto; y++) {
                src = source->datos + source->tablay[y + FX6ym] + FX6xm;
		for (int x = 0; x < dest->ancho; x++)
                        *dst++ = *((src++) + p6_td[*pls++]);
	}
}

void Part6_Setup() {
        GeneratePlasmaTable(p6_pt1, 0, 0, 0);
        GeneratePlasmaTable(p6_pt1, 1, 64, 1);
        GeneratePlasmaTable(p6_pt1, 4, 8, 2);
        GeneratePlasmaTable(p6_pt2, 0, 0, 0);
        GeneratePlasmaTable(p6_pt2, 2, 64, 2);
        GeneratePlasmaTable(p6_pt2, 7, 8, 1);
	for (int i = 0; i < 256; i++)
                p6_td[i] = (int)((FX6ym - 1) * sin(i * 3.14159265 / 128.0)) * ScreenWidth +
                        (int)((FX6xm - 1) * cos(i * 3.14159265 / 128.0));
}


void luchador_Part6() {
        TBitmap8bpp *fondo = new TBitmap8bpp(PCODE1_ANCHO, PCODE1_ALTO, PCODE1, PCODE1_PAL);
        TBitmap8bpp *logo = new TBitmap8bpp(CREDFAC_ANCHO, CREDFAC_ALTO, CREDFAC, CREDFAC_PAL);
        TBitmap8bpp *mono = new TBitmap8bpp(US3_ANCHO, US3_ALTO, US3, US3_PAL);
        TBitmap8bpp *deform = new TBitmap8bpp(fondo->ancho - FX6xm * 2, fondo->alto - FX6ym * 2);
	TBitmap8bpp *plasma = new TBitmap8bpp(deform->ancho, deform->alto);
        TBitmap *vscr2 = new TBitmap(ScreenWidth, ScreenHeight);
        TBitmap8bpp *mask = new TBitmap8bpp(20, 15);

        memcpy(deform->paleta, fondo->paleta, 256 * sizeof(unsigned));

	byte t1, t2, t3, t4;
        int x, y, n;
        double a;
        byte *maskdata;

        m_timer = 0;
        while (m_position < 18) {
                vscr2->Borra(0);

                GeneratePlasma(plasma, p6_pt1, p6_pt2, t1, t2, t3, t4);
                EFX6(fondo, deform, plasma);
                deform->BlitTo(vscr2, FX6xm, FX6ym);

                GeneratePlasma(mask, p6_pt2, p6_pt1, t4, t3, t2, t1);

                maskdata = mask->datos;
                for (y = 0; y < 15; y++)
                        for (x = 0; x < 20; x++)
                                *maskdata++ += (byte)(((y << 4) + t1) ^ ((x << 3) + t2));

                if (m_position > 16) DrawCircleFX2(mask, vscr, vscr2, 12, 0);
                else vscr->Copia(vscr2);

                t1 += 1; t2 -= 2; t3 -= 1; t4 += 2;

                a = m_timer / 50.0;
                mono->TransBlitTo(vscr, 238 + dtoi(82.0 * cos(a)), 0, 13);

                n = (((m_row & 15) >= 8) && ((m_row & 15) < 12)) * (4 - (m_row & 3)) + 1;
                n = dtoi(pow(2, n)) - 1;

                if (m_timer < 176)
                        logo->TransBlitTo(vscr, m_timer - 176 + (rand() & 3), rand() & 3, 197);
                else logo->TransBlitTo(vscr, rand() & n, rand() & 3, 197);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        delete fondo;
        delete logo;
        delete mono;
        free(deform->datos); delete deform;
        free(plasma->datos); delete plasma;
        free(mask->datos); delete mask;
        delete vscr2;
}


