--      TRIANGLES.PAS   --       triangle rendering unit by FAC

--      The rendering algorithm was taken from the FATMAP.TXT document
--      (Fast Affine Texture Mapping) by Mats Byggmaster aka MRI / Doomsday
--      Infinite thanks to MRI for those great documents.

--      The routines were modified so they can draw flat triangles too
--      and perform clipping against the screen (except the wireframe,
--      which isn't used in the stupikeffyloopy demo).

--      The textures must be 256*256 and the loader only works with PCX.


unit Triangle;

interface

uses Mode13pm, Vectors;

{ tipos, constantes y variables globales }
-- drawing types (gouraud was taken out cause it's not used in the demo)
type ShadingType = (wireframe, flatshaded, texturemapped);

-- texture type definition
type PTTexture = ^TTexture;
     TTexture = array[0..65535] of byte;

-- global variables
var StartCol, WidthCol : byte;  { initial color and color range         }
    TextureOffset : dword;      { offset of the current texture used    }
    GlobalStyle : ShadingType;  { current drawing style                 }


{ this procedure draws a triangle with the style in GlobalStyle         }
procedure DrawTriangle(v1, v2, v3 : PTVertex; where : dword);

{ and the texture loader }
procedure LoadTexture(filename : string; texture : PTTexture; var pal : TPalette);

implementation


uses LightSrc;

{ triangle rendering procedures }

{ WireTriangle -  just draws the triangle sides (no clipping) }
procedure WireTriangle(vt1, vt2, vt3 : PTVertex; where : dword);
begin
     Line(vt1^.x2d, vt1^.y2d, vt2^.x2d, vt2^.y2d, StartCol, where);
     Line(vt2^.x2d, vt2^.y2d, vt3^.x2d, vt3^.y2d, StartCol, where);
     Line(vt3^.x2d, vt3^.y2d, vt1^.x2d, vt1^.y2d, StartCol, where);
end;

{ FlatTriangle - take a look at FATMAP.TXT to see how it works  }
procedure FlatTriangle(vt1, vt2, vt3 : PTVertex; where : dword);
var larray, rarray : array[0..2] of PTVertex;
    lsection, rsection, lheight, rheight : integer;
    leftx, leftdx, rightx, rightdx : single;

    function DoRightSide : integer;
    var tv1, tv2 : PTVertex;
        height : integer;
    begin
         tv1 := rarray[rsection];
         tv2 := rarray[rsection - 1];
         height := tv2^.y2d - tv1^.y2d;
         DoRightSide := height;
         if height = 0 then exit;
         rightdx := (tv2^.x2d - tv1^.x2d) / height;
         rightx := tv1^.x2d;
         rheight := height;
    end;

    function DoLeftSide : integer;
    var tv1, tv2 : PTVertex;
        height : integer;
    begin
         tv1 := larray[lsection];
         tv2 := larray[lsection - 1];
         height := tv2^.y2d - tv1^.y2d;
         DoLeftSide := height;
         if height = 0 then exit;
         leftdx := (tv2^.x2d - tv1^.x2d) / height;
         leftx := tv1^.x2d;
         lheight := height;
    end;

var v1, v2, v3, v : PTVertex;
    height : longint;
    temp, longest : single;
    off : dword;
    x1, x2, width : longint;
    clipymax : dword;

begin
     v1 := vt1;
     v2 := vt2;
     v3 := vt3;
     if v1^.y2d > v2^.y2d then begin v := v1; v1 := v2; v2 := v; end;
     if v1^.y2d > v3^.y2d then begin v := v1; v1 := v3; v3 := v; end;
     if v2^.y2d > v3^.y2d then begin v := v2; v2 := v3; v3 := v; end;
     height := v3^.y2d - v1^.y2d;
     if height = 0 then exit;
     temp := (v2^.y2d - v1^.y2d) / height;
     longest := temp * (v3^.x2d - v1^.x2d) + v1^.x2d - v2^.x2d;
     if longest = 0 then exit;
     if longest < 0 then
     begin
          rarray[0] := v3;
          rarray[1] := v2;
          rarray[2] := v1;
          rsection := 2;
          larray[0] := v3;
          larray[1] := v1;
          lsection := 1;
          if DoLeftSide <= 0 then exit;
          if DoRightSide <= 0 then
          begin
               dec(rsection);
               if DoRightSide <= 0 then exit;
          end;
          if longest > -1 then longest := -1;
     end
     else
     begin
          larray[0] := v3;
          larray[1] := v2;
          larray[2] := v1;
          lsection := 2;
          rarray[0] := v3;
          rarray[1] := v1;
          rsection := 1;
          if DoRightSide <= 0 then exit;
          if DoLeftSide <= 0 then
          begin
               dec(lsection);
               if DoLeftSide <= 0 then exit;
          end;
          if longest < 1 then longest := 1;
     end;
     clipymax := where + 63680;
     off := where + v1^.y2d * 320;
     while true do
     begin
          if (off >= where) and (off <= clipymax) then
          begin
               x1 := trunc(leftx);
               x2 := trunc(rightx + 0.5);
               width := x2 - x1;
               if x1 < 0 then
               begin
                    width := x2;
                    x1 := 0;
               end;
               if x2 > 319 then width := 319 - x1;

               if width > 0 then
               begin
                    asm
                       mov edi, [x1]
                       add edi, [off]
                       mov al, StartCol
                       mov ecx, [width]
                       @loop1:
                              mov [edi], al
                              inc edi
                              dec ecx
                              jnz @loop1
                    end;
               end;
          end;
          inc(off, 320);
          dec(lheight);
          if lheight <= 0 then
          begin
               dec(lsection);
               if lsection <= 0 then exit;
               if DoLeftSide <= 0 then exit;
          end
          else leftx := leftx + leftdx;
          dec(rheight);
          if rheight <= 0 then
          begin
               dec(rsection);
               if rsection <= 0 then exit;
               if DoRightSide <= 0 then exit;
          end
          else rightx := rightx + rightdx;
     end;
end;



{ TextureTriangle - take a look at FATMAP.TXT to see how it works }
procedure TextureTriangle(vt1, vt2, vt3 : PTVertex; where : dword);
var larray, rarray : array[0..2] of PTVertex;
    lsection, rsection, lheight, rheight : integer;
    leftx, leftdx, rightx, rightdx : single;
    leftu, leftdu, leftv, leftdv : single;

    function DoRightSide : integer;
    var tv1, tv2 : PTVertex;
        height : integer;
    begin
         tv1 := rarray[rsection];
         tv2 := rarray[rsection - 1];
         height := tv2^.y2d - tv1^.y2d;
         DoRightSide := height;
         if height = 0 then exit;
         rightdx := (tv2^.x2d - tv1^.x2d) / height;
         rightx := tv1^.x2d;
         rheight := height;
    end;

    function DoLeftSide : integer;
    var tv1, tv2 : PTVertex;
        height : integer;
    begin
         tv1 := larray[lsection];
         tv2 := larray[lsection - 1];
         height := tv2^.y2d - tv1^.y2d;
         DoLeftSide := height;
         if height = 0 then exit;
         leftdx := (tv2^.x2d - tv1^.x2d) / height;
         leftx := tv1^.x2d;
         leftdu := (tv2^.u - tv1^.u) / height;
         leftu := tv1^.u;
         leftdv := (tv2^.v - tv1^.v) / height;
         leftv := tv1^.v;
         lheight := height;
    end;

var v1, v2, v3, vv : PTVertex;
    height : longint;
    temp, longest : single;
    off : dword;
    x1, x2, width : longint;
    dudx, dvdx : single;
    u, v, du, dv : longint;
    clipymax : dword;
    clipflag : longint;

begin
     v1 := vt1;
     v2 := vt2;
     v3 := vt3;
     if v1^.y2d > v2^.y2d then begin vv := v1; v1 := v2; v2 := vv; end;
     if v1^.y2d > v3^.y2d then begin vv := v1; v1 := v3; v3 := vv; end;
     if v2^.y2d > v3^.y2d then begin vv := v2; v2 := v3; v3 := vv; end;
     height := v3^.y2d - v1^.y2d;
     if height = 0 then exit;
     temp := (v2^.y2d - v1^.y2d) / height;
     longest := temp * (v3^.x2d - v1^.x2d) + v1^.x2d - v2^.x2d;
     if longest = 0 then exit;
     if longest < 0 then
     begin
          rarray[0] := v3;
          rarray[1] := v2;
          rarray[2] := v1;
          rsection := 2;
          larray[0] := v3;
          larray[1] := v1;
          lsection := 1;
          if DoLeftSide <= 0 then exit;
          if DoRightSide <= 0 then
          begin
               dec(rsection);
               if DoRightSide <= 0 then exit;
          end;
          if longest > -1 then longest := -1;
     end
     else
     begin
          larray[0] := v3;
          larray[1] := v2;
          larray[2] := v1;
          lsection := 2;
          rarray[0] := v3;
          rarray[1] := v1;
          rsection := 1;
          if DoRightSide <= 0 then exit;
          if DoLeftSide <= 0 then
          begin
               dec(lsection);
               if DoLeftSide <= 0 then exit;
          end;
          if longest < 1 then longest := 1;
     end;
     dudx := (temp * (v3^.u - v1^.u) + v1^.u - v2^.u) / longest;
     dvdx := (temp * (v3^.v - v1^.v) + v1^.v - v2^.v) / longest;
     clipymax := where + 63680;
     off := where + v1^.y2d * 320;
     while true do
     begin
          if (off >= where) and (off <= clipymax) then
          begin
               x1 := trunc(leftx);
               x2 := trunc(rightx + 0.5);
               width := x2 - x1;
               clipflag := 0;
               if x1 < 0 then
               begin
                    width := x2;
                    clipflag := -x1;
                    x1 := 0;
               end;
               if x2 > 319 then width := 319 - x1;
               if width > 0 then
               begin
                    u := trunc(leftu * 65536);
                    v := trunc(leftv * 65536);
                    du := trunc(dudx * 65536);
                    dv := trunc(dvdx * 65536);
                    if clipflag <> 0 then
                    begin
                         inc(u, du * clipflag);
                         inc(v, dv * clipflag);
                    end;
                    asm
                       mov edi, [x1]
                       mov esi, [v]
                       mov edx, [u]
                       add edi, [off]
                       mov ecx, [width]
                       dec edi
                       @loop1:
                              movzx ebx, si
                              add esi, [dv]
                              mov bl, dh
                              add edx, [du]
                              add ebx, [TextureOffset]
                              inc edi
                              mov al, [ebx]
                              mov [edi], al
                              dec ecx
                              jnz @loop1
                    end;
               end;
          end;
          inc(off, 320);
          dec(lheight);
          if lheight <= 0 then
          begin
               dec(lsection);
               if lsection <= 0 then exit;
               if DoLeftSide <= 0 then exit;
          end
          else
          begin
               leftx := leftx + leftdx;
               leftu := leftu + leftdu;
               leftv := leftv + leftdv;
          end;
          dec(rheight);
          if rheight <= 0 then
          begin
               dec(rsection);
               if rsection <= 0 then exit;
               if DoRightSide <= 0 then exit;
          end
          else rightx := rightx + rightdx;
     end;
end;



{ this is the general triangle procedure                                }
procedure DrawTriangle(v1, v2, v3 : PTVertex; where : dword);
begin
     case GlobalStyle of
          wireframe : WireTriangle(v1, v2, v3, where);
          flatshaded : FlatTriangle(v1, v2, v3, where);
          texturemapped : TextureTriangle(v1, v2, v3, where);
     end;
end;


{ the texture loader is just a 256*256*256 PCX loader }
procedure LoadTexture(filename : string; texture : PTTexture; var pal : TPalette);
type TTemp = array[0..100000] of byte;
     PTTemp = ^TTemp;

var f : file;
    off : word;
    c, i, r, g, b : byte;
    flag : boolean;
    temp : PTTemp;
    pos : longint;

begin
     temp := new(PTTemp);
     assign(f, filename);
     reset(f, 1);
     BlockRead(f, temp^, filesize(f));
     pos := 128;
     flag := false;
     off := 0;
     while not flag do
     begin
           i := temp^[pos];
           inc(pos);
          if (i and $C0) = $C0 then
          begin
                c := temp^[pos];
                inc(pos);
               for i := 1 to (i and $3F) do
               begin
                    texture^[off] := c;
                    inc(off);
                    flag := (off = 0);
               end;
          end
          else
          begin
               texture^[off] := i;
               inc(off);
               flag := (off = 0);
          end;
     end;
     pos := filesize(f) - 768;
     for i := 0 to 255 do
     begin
          r := temp^[pos];
          g := temp^[pos+1];
          b := temp^[pos+2];
          inc(pos, 3);
          pal[i][0] := r div 4;
          pal[i][1] := g div 4;
          pal[i][2] := b div 4;
     end;
     close(f);
     dispose(temp);
end;


begin
     GlobalStyle := wireframe;
end.

