--      unit BACKGRS.PAS        by FAC / Delabu Alama
--      a very important part of the loopy demo
--
--      don't forget to read README.TXT
--
--      the coding style of this part is awful and i don't recommend it
--      lots of global vars and unoptimized stuff
--
--      batteries not included

unit Backgrs;

interface

uses Mode13PM;

procedure LoadLogo;             { loads the delabu alama logo }
procedure LoadBackgrounds;      { loads the background pictures }
procedure KillBackgrounds;      { releases everything }
procedure DoBackground(where : dword);          { draws a background }
procedure SwitchBackground(var pal : TPalette); { switchs the effect }

implementation

uses Triangle, Obj3D;

{ global vars }
var CurrentBackground : integer;        { current background effect }

{ stuff for tha plasmotic background }
var PlasmaTab1 : array[0..319] of byte;   { plasma table 1 }
    PlasmaTab2 : array[0..255] of byte;   { plasma table 2 }
    PlasmaTab1Off, PlasmaTab2Off : dword; { offsets to those tables }
    pp1, pp2, pp3, pp4 : byte;            { plasma control vars }


{ stuff for tha rotologo }
var LogoPic : PTTexture;    { pointer to delabu alama logo }
    LogoOff : dword;        { and it's offset }
    LogoPal : TPalette;     { the logo palette }
    LogoObj : PTObject3D;   { a simple 3d object to map the logo on }


{ stuff for tha wobbling background }
var WobBackPic : PTVirtual;  { pointer to background picture }
    WobBackOff : dword;      { and it's offset }
    WobBackPos : byte;       { wobbling control }
    WobBackTrans : array[0..255] of longint;  { transformation table }
    WobBackTransOff : dword;                  { and it's offset }
    WobBackPal : TPalette;                    { and it's palette }


{ stuff for tha noisy background }
var NoisyBackPic : PTVirtual;    { pointer to lornette mason }
    NoisyBackOff : dword;        { and the offset }
    NoisyBackPos : byte;         { effect control }
    NoisyBackTrans : array[0..255] of longint; { transformation table }
    NoisyBackTransOff : dword;   { offset of table }
    NoisyBackPal : TPalette;     { picture palette }

{ stuff for tha zooming word }
var WordScr, BlurScr : PTVirtual; { virtual screens used }
    WordOff, BlurOff : dword;     { and their offsets }
    WordPal : TPalette;           { the palette }
    dx1, dy1, dx2, dy2 : longint; { coords of the destination rectangle }


{ sh*t starts here }

{ procedures for the zoomingblurringword }

{ this procedure scales the whole screen at WordScr to a rectangle
  (dx1, dy1) - (dx2, dy2)  in BlurScr }
procedure ScaleWord;
var ddx, ddy, stepx, stepy, tempy, tempx : longint;
    ddx1, ddx2, ddy1, ddy2 : longint;
begin
     ddx1 := dx1 + random(3) - 1; { a little randomness to the effect }
     ddx2 := dx2 + random(3) - 1;
     ddy1 := dy1 + random(3) - 1;
     ddy2 := dy2 + random(3) - 1;
     ddx := ddx2 - ddx1;          { find the width of the rectangle }
     ddy := ddy2 - ddy1;          { and it's height }
     stepx := round(20905984 / ddx); { the x increment in fixed point }
     stepy := round(13041664 / ddy); { the same for the y increment }
     tempx := 0;  { starting source coords }
     tempy := 0;
     asm
        mov ebx, [ddy1]
        lea edi, [ebx + ebx * 4]
        shl edi, 6
        add edi, [BlurOff]
        add edi, [ddx1]             { edi = BlurOff + ddy1 * 320 + ddx1 }
        mov edx, [ddy]
        mov dh, dl                  { dh = height of rectangle }

        @loopy: mov ebx, [tempy]
                shr ebx, 16         { get current y in source screen }
                lea eax, [ebx + ebx * 4]
                shl eax, 6
                mov esi, [tempx]    { esi = tempx (which is always zero   }
                                    {       so this can be simplified)    }
                add eax, [WordOff]  { eax = WordOff + tempy * 320 }
                mov ecx, [ddx]      { ecx = width of rectangle }

        @loopx: mov ebx, esi
                add esi, [stepx]
                shr ebx, 16
                add ebx, eax        { ebx = position of next pixel to plot }
                mov dl, [ebx]       { get the pixel color in dl }
                or dl, dl           { is it zero? }
                jz @nope            { yes? then jump }
                mov [edi], dl       { no? then plot it }
        @nope:  inc edi             { inc horizontal position }
                dec ecx             { dec width }
                jnz @loopx          { continue horizontal loop }
                add edi, 320        { go to the next line }
                mov ebx, [stepy]
                add [tempy], ebx    { tempy = tempy + stepy }
                sub edi, [ddx]      { next line }
                dec dh              { dec height }
                jnz @loopy          { go on }
     end;
end;


{ this procedure blurs the screen at BlurScr }
{ very similar to the fire effect }
procedure MotionBlur; assembler;
asm
   mov edi, [BlurOff]
   mov ecx, 57600    { well, we don't need to blur ALL the screen }
   add edi, 3200
   @loop:   movzx eax, byte ptr [edi - 320]
            add al, [edi + 320]      { add the four adjacent pixels }
            adc ah, 0
            add al, [edi - 1]
            adc ah, 0
            add al, [edi + 1]
            adc ah, 0
            shr eax, 2               { and divide by 4 }
            mov [edi], al
            inc edi
            dec ecx
            jnz @loop
end;

{ this procedure does the zoomingblurringword effect }
procedure DoWord(where : dword);
begin
     ScaleWord;
     MotionBlur;
     CopyScreen(BlurOff, where);
     { zooming out until it's too small }
     inc(dx1);
     inc(dy1);
     dec(dx2);
     dec(dy2);
     if (dy2 - dy1) < 5 then
     begin
          dx1 := 1; dx2 := 318; dy1 := 1; dy2 := 198;
     end;
end;

{ this procedure does the noisy background }
procedure DoNoisyBack(where : dword); assembler;
asm
   mov esi, [NoisyBackOff]      { offset of source picture }
   mov edi, [where]             { offset of destination screen }
   add esi, 321                 { start from position (1, 1)   }
   add edi, 321                 { in both screens }
   mov dh, 198                  { y counter }
   @loopy:    mov ecx, 318      { x counter }
   @loopx:    movzx eax, [NoisyBackPos]     { get position in table }
              shl eax, 2                    { mul by 4 (table of longints) }
              add eax, [NoisyBackTransOff]  { add offset of table }
              mov ebx, [eax]                { get value in table }
              mov dl, [esi + ebx]           { get transformed pixel }
              mov [edi], dl                 { and plot it }
              inc esi
              inc edi
              inc byte ptr [NoisyBackPos]   { increment table position }
              dec ecx
              jnz @loopx                    { continue horizontal loop }
              add esi, 2                    { go to the next line }
              add edi, 2
              dec dh
              jnz @loopy                    { continue vertical loop }
end;


{ the procedure that does the wobbling background }
procedure DoWobBack(where : dword); assembler;
asm
   mov esi, [WobBackOff]        { offset of source picture }
   mov edi, [where]             { offset of destination screen }
   add esi, 3210                { start from (5, 5)            }
   add edi, 3210
   mov dh, 180                  { plot only 180 lines }
   @loopy:    mov ecx, 300      { 300 pixels wide     }
              movzx eax, [WobBackPos]   { get position in table }
              shl eax, 2                { mul by 4 cause it's longints }
              add eax, [WobBackTransOff]  { add to the offset of the table }
              mov ebx, [eax]              { get the value in table }
   @loopx:    mov dl, [esi + ebx]         { get the transformed pixel }
              mov [edi], dl               { and plot it, yes }
              inc esi
              inc edi
              dec ecx
              jnz @loopx        { go on horizontally }
              add esi, 20       { go to the next line }
              add edi, 20
              inc byte ptr [WobBackPos]  { inc table position }
              dec dh
              jnz @loopy        { continue till bottom }
end;


{ this proc calculates the wobbler table and the noise table }
procedure SetupWobBackTable;
var a, x, y : longint;
begin
     { the wobbling table is just a circular pattern }
     for a := 0 to 255 do
     begin
          x := round(10 * cos(a * Pi / 128));
          y := round(10 * sin(a * Pi / 128));
          WobBackTrans[a] := y * 320 + x;
     end;
     WobBackTransOff := ofs(WobBackTrans);
     WobBackPos := 0;

     { the noise table adds just a little randomness }
     for a := 0 to 255 do
     begin
          x := random(3) - 1;
          y := random(3) - 1;
          NoisyBackTrans[a] := y * 320 + x;
     end;
     NoisyBackTransOff := ofs(NoisyBackTrans);
     NoisyBackPos := 0;
end;


{ the procedure that loads the background pictures }
procedure LoadBackgrounds;
begin
     SetupVirtual(WobBackPic, WobBackOff);
     LoadPCX('fondo.pcx', WobBackOff, 320, 200, 0, 0, WobBackPal);
     SetupVirtual(NoisyBackPic, NoisyBackOff);
     LoadPCX('angela.pcx', NoisyBackOff, 320, 200, 0, 0, NoisyBackPal);
     SetupVirtual(WordScr, WordOff);
     SetupVirtual(BlurScr, BlurOff);
     LoadPCX('peep!.pcx', WordOff, 320, 200, 0, 0, WordPal);
     ClearScreen(0, BlurOff);
end;

{ loads the delabu alama logo and the 3d square used to rotate it }
{ this is the simplest and slowest of all backgrounds             }
procedure LoadLogo;
begin
        LogoPic := new(PTTexture);
        LogoOff := ofs(LogoPic^);
        LoadTexture('logo2.pcx', LogoPic, LogoPal);
        LogoObj := new(PTObject3D, Init);
        Load3DObject('cuadro.vkx', LogoObj);
        LogoObj^.SetCenter(160, 0);
        LogoObj^.Rotate(180, 0, 0);
        LogoObj^.Traslate(0, 0, 700);
end;


{ releases all memory allocated in this unit }
procedure KillBackgrounds;
begin
     ShutDownVirtual(WobBackPic);
     ShutDownVirtual(NoisyBackPic);
     ShutDownVirtual(WordScr);
     ShutDownVirtual(BlurScr);
     dispose(LogoPic);
     dispose(LogoObj);
end;

{ this procedure does the rotating delabu alama logo background }
procedure DoRotoLogo(where : dword);
begin
        GlobalStyle := TextureMapped;  { change style to texture mapping }
        ClearScreen(0, where);         { clear destination screen }
        LogoObj^.Draw(where);          { draw logo }
        LogoObj^.Rotate(0, 0, -1);     { rotate it a little bit }
        GlobalStyle := FlatShaded;     { change style back to flat shading }
end;


{ this proc calculates the plasma tables }
procedure SetupPlasmaTables;
var i : integer;
begin
        { just some simple sin/cos stuff }
        for i := 0 to 159 do
                PlasmaTab1[i] := round(cos(i * Pi / 160) * 64) + 64;
        for i := 0 to 255 do
                PlasmaTab2[i] := round(sin(i * Pi / 128) * 32);
        PlasmaTab1Off := ofs(PlasmaTab1); { offsets of the tables }
        PlasmaTab2Off := ofs(PlasmaTab2); { for easy asm access   }
        pp1 := 0;  { initial position of the plasma }
        pp2 := 1;
        pp3 := 2;
        pp4 := 3;
end;

{ this procedure (obviously) draws the plasma }
{ the plasma resolution is 160 * 100 }
procedure DrawPlasma(where : dword); assembler;
asm
                mov edi, [where]                 { destination screen }
                mov dh, [pp3]                    -- dh = p3
                mov dl, [pp4]                    -- dl = p4
                mov ch, 100                      -- ch = contador y

                @loopy: mov bh, [pp1]            -- bh = p1
                        mov bl, [pp2]            -- bl = p2
                        mov cl, 160              -- cl = contador x

                @loopx: movzx esi, dh            { get index }
                        xor eax, eax             { eax = 0 }
                        add esi, [PlasmaTab2Off] { get position in table }
                        mov al, [esi]            { get value in al }
                        movzx esi, dl            { get next index }
                        add esi, [PlasmaTab2Off] { position in table }
                        add al, [esi]            { add value to al }
                        adc eax, 0               { consider the carry }
                        movzx esi, bh            { next index }
                        add esi, [PlasmaTab2Off]
                        add al, [esi]
                        adc eax, 0
                        movzx esi, bl
                        add esi, [PlasmaTab2Off] { next index }
                        add al, [esi]
                        adc eax, 0
                        movzx esi, cl
                        add esi, [PlasmaTab1Off] { use x-counter as index }
                        add al, [esi]
                        adc eax, 0
                        movzx esi, ch
                        add esi, [PlasmaTab2Off] { use y-counter as index }
                        add al, [esi]
                        adc eax, 0
                        add bh, 2     { increment one index }
                        xor ah, ah    { we only want the low byte }
                        shr eax, 2    { make it between 0 and 63 }
                        dec bl        { increment the other index }
                        add eax, 40h  { make the color between 64 and 127 }
                        mov ah, al    { put it in ah so we can copy words }
                        mov [edi], ax       { draw two pixels }
                        mov [edi+320], ax   { and two more pixels }
                        inc edi
                        inc edi
                        dec cl
                        jnz @loopx    { continue horizontal loop }
                        sub dh, 3     { increment third index }
                        add edi, 320  { skip next line }
                        add dl, 2     { increment fourth index }
                        dec ch
                        jnz @loopy    { continue vertical loop }
end;

{ just draws and moves the plasma }
procedure DoPlasma(where : dword);
begin
        DrawPlasma(where);
        inc(pp1, 2 + random(2));
        dec(pp2, 3);
        inc(pp3, random(5) - 3);
        dec(pp4, 2);
end;
                        
                
{ this procedure draws a specific background }
procedure DoBackground(where : dword);
begin
        case CurrentBackground of
                0 : DoPlasma(where);            { plasma }
                1 : DoRotoLogo(where);          { rotatinglogo }
                2 : DoWord(where);              { zoomingblurringword }
                3 : begin                       { wobblingbackground }
                         ClearScreen(0, where);
                         DoWobBack(where);
                         dec(WobBackPos, 177);
                    end;
                4 : begin                       { noisybackground }
                         ClearScreen(0, where);
                         DoNoisyBack(where);
                         inc(NoisyBackPos);
                    end;
                else ClearScreen(0, where);     { the best background }
        end;
end;

{ the procedure that sets up and switchs to the next background effect }
{ all background effects can use only the colors from 64 to 127        }
procedure SwitchBackground(var pal : TPalette);
var i : integer;
begin
        { switch to nect background }
        CurrentBackground := (CurrentBackground + 1) mod 5;
        case CurrentBackground of

                0 : begin  { setup palette for the plasma }
                        for i := 0 to 31 do
                        begin
                                pal[i+64][0] := i * 2;
                                pal[i+64][1] := i;
                                pal[i+64][2] := 0;
                        end;
                        for i := 0 to 31 do
                        begin
                                pal[i+96][0] := 63 - i * 2;
                                pal[i+96][1] := 32 - i;
                                pal[i+96][2] := 0;
                        end;
                    end;

                1 : begin  { setup palette and stuff for the rotating logo }
                        TextureOffset := LogoOff;
                        for i := 64 to 127 do pal[i] := LogoPal[i];
                    end;

                2 : begin  { setup palette for the zoomingblurringword }
                         for i := 64 to 127 do pal[i] := WordPal[i];
                         dx1 := 1; dx2 := 318; dy1 := 1; dy2 := 198;
                         ClearScreen(0, BlurOff);
                    end;

                3 : begin   { setup palette for the wobbling background }
                         for i := 0 to 9 do
                         begin
                              pal[64 + i][0] := i div 3;
                              pal[64 + i][1] := 0;
                              pal[64 + i][2] := 0;
                         end;
                         for i := 0 to 21 do
                         begin
                              pal[74 + i][0] := i * 3;
                              pal[74 + i][1] := 0;
                              pal[74 + i][2] := 0;
                         end;
                    end;
                    { and the palette for the noisy background }
                4 : for i := 64 to 127 do pal[i] := NoisyBackPal[i];
        end;
        SetPalette(pal); { activates the new palette }
end;

{ initialization }
begin
        SetupPlasmaTables;
        SetupWobBackTable;
        CurrentBackground := 4;
        dx1 := 1; dx2 := 318; dy1 := 1; dy2 := 198;
end.

