// #define _DEBUGVERSION_
// #define _NOMUSIC_

#ifdef _DEBUGVERSION_
#include <stdio.h>
#endif

#include <stdlib.h>
#include "mymath.h"
#include "usmplay.h"
#include "bitmaps.h"
#include "blitter.h"
#include "cameras.h"
#include "lightsrc.h"
#include "obj3d.h"
#include "phongpal.h"
#include "plasmafx.h"
#include "polygons.h"
#include "primitiv.h"
#include "scenes.h"
#include "triangle.h"
#include "tunnel.h"
#include "vectors.h"
#include "vesavbe.h"
#include "globals.h"
#include "textures.h"
#include "fac8.h"
#include "font.h"
#include "logo.h"

// globals

#define NumPlasmaTables 4
double Sin256[256];
TBitmap *vscr;
TBitmap8bpp *fontset;
TBitmap8bpp *logo, *biglogo;
int blurflag;
unsigned frames;
int timer, supertimer;        // for a 100 Hz timer
USM *music;
TCamera *defcam;
byte PlasmaTable[NumPlasmaTables][256];


int fontstart[26] = {  0, 8, 16, 24, 34, 42, 49, 57, 65, 70, 77, 86, 91,
                       104, 114, 122, 131, 139, 145, 152, 158, 166, 174,
                       186, 194, 203 };

// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif

void Timer(void) { timer++; supertimer++; }


void Initialize() {
        _write(36, "  dating your sister... please wait");
        VBE_Init();
        InitializeEngine();
        for (int i = 0; i < 256; i++) Sin256[i] = fsin(i * PI / 128.0);
        vscr = new TBitmap(ScreenWidth, ScreenHeight);
        if (!vscr->datos) {
                _write(30, "Could not create back buffer\n\r");
                exit(EXIT_FAILURE);
        }
        vscr->Borra(0);

        fontset = new TBitmap8bpp(FONT_ANCHO, FONT_ALTO, FONT, FONT_PAL);
        logo = new TBitmap8bpp(LOGO_ANCHO, LOGO_ALTO, LOGO, LOGO_PAL);
        biglogo = new TBitmap8bpp(LOGO_ANCHO * 2, LOGO_ALTO * 2);
        _memcpy(biglogo->paleta, logo->paleta, 256 * sizeof(unsigned));
        byte *loff = logo->datos;
        byte *bloff = biglogo->datos;
        for (int y = 0; y < LOGO_ALTO; y++) {
                for (int x = 0; x < LOGO_ANCHO; x++) {
                        *bloff = *loff;
                        *(bloff + 1) = *loff;
                        *(bloff + biglogo->ancho) = *loff;
                        *(bloff + biglogo->ancho + 1) = *loff;
                        bloff += 2;
                        loff++;
                }
                bloff += biglogo->ancho;
        }

        GenerateTextures();
        TFX_CalcTables();

        // Generate Plasma Tables
        GeneratePlasmaTable(PlasmaTable[0], 0, 0, 0);
        GeneratePlasmaTable(PlasmaTable[0], 5, 64, 4);
        GeneratePlasmaTable(PlasmaTable[0], 1, 32, 8);
        GeneratePlasmaTable(PlasmaTable[0], 2, 16, 16);
        GeneratePlasmaTable(PlasmaTable[1], 0, 0, 0);
        GeneratePlasmaTable(PlasmaTable[1], 4, 64, 4);
        GeneratePlasmaTable(PlasmaTable[1], 6, 32, 8);
        GeneratePlasmaTable(PlasmaTable[1], 2, 16, 16);
        GeneratePlasmaTable(PlasmaTable[2], 0, 0, 0);
        GeneratePlasmaTable(PlasmaTable[2], 5, 32, 2);
        GeneratePlasmaTable(PlasmaTable[2], 7, 64, 4);
        GeneratePlasmaTable(PlasmaTable[2], 2, 16, 8);
        GeneratePlasmaTable(PlasmaTable[3], 0, 0, 0);
        GeneratePlasmaTable(PlasmaTable[3], 4, 64, 1);
        GeneratePlasmaTable(PlasmaTable[3], 6, 32, 2);
        GeneratePlasmaTable(PlasmaTable[3], 8, 16, 4);

        // texture 6
        _memcpy(texture[6]->datos, texture[4]->datos, 65536);
        PhongPal(0.3, 0.6, 0.8, 0.3, 0.4, 0.6, 0.1, 0.2, 0.4, 10, texture[6]->paleta, 256);
        byte *dst = texture[6]->datos + texture[6]->tablay[96];
        byte *src = logo->datos;
        double px;
        byte c;
        for (y = 0; y < 32; y++) {
                px = 0;
                for (int x = 0; x < 256; x++) {
                        c = *(src + (int)px);
                        if (c) *dst = 255 - (*dst);
                        dst++;
                        px += 160.0 / 256.0;
                }
                _memcpy(dst, dst - 256, 256);
                src += 160;
                dst += 256;
        }

        
        InitVideo();

#ifndef _NOMUSIC_
        USS_AutoSetup();
        if (Error_Number==0) {
                music = (USM *)FAC8_USM;
                USMP_LoadInternalModule(music);
                if (Error_Number!=0) { Display_Error(Error_Number); exit(0); }
                USMP_StartPlay(music);
                if (Error_Number!=0) { Display_Error(Error_Number); exit(0); }
                supertimer = 0;
                Timer_Start(&Timer, TimerSpeed / 100);
     }
#endif

     defcam = new TCamera();
     defcam->ax = defcam->ay = defcam->az = 0;
     defcam->direction.SetP(0, 0, 1);
}


void Finalize() {
#ifndef _NOMUSIC_
     Timer_Stop(&timer);
     USMP_StopPlay();
#endif
     VBE_SetMode(3, 0, 1);
     _write(44, "\n CIENKA - a 100K intro for the OverSeas\n\n\r");
     _write(46, "code and gfx by FAC (fac@slp1.telmex.net.mx)\n\r");
     _write(45, "  funky music by Uctumi (uctumi@yahoo.com)\n\n\r");

#ifdef _DEBUGVERSION_
        printf("framerate: %5.2f fps\n", frames * 100.0 / (double)supertimer);
        printf("time: %d seconds\n", dtoi(supertimer / 100.0));
        printf("timer value: %d\n", timer);
#endif

     delete vscr;
     delete fontset;
     delete logo;
     free(biglogo->datos); delete biglogo;
     for (int i = 0; i < NumTextures; i++) {
        free(texture[i]->datos);
        delete texture[i];
     }
     VBE_Done();
     exit(0);
}

// font functions
int DrawChar(char c, int x, int y, TBitmap *where) {
        int width, start = fontstart[c - 97];
        if (c < 122) width = fontstart[c - 96] - start;
        else width = FONT_ANCHO - start;

        if ((y < 0) || (x < 0) || (y >= 220) || ((x + width) >= 320)) return -1;

        unsigned *dest = where->datos + where->tablay[y] + x;
        byte *src = fontset->datos + start;
        unsigned *pal = fontset->paleta;

        _asm {
                mov edx, 20
                mov ebx, [pal]
                cicloy: mov esi, [src]
                        mov edi, [dest]
                        mov ecx, [width]
                ciclox: movzx eax, byte ptr [esi]
                        inc esi
                        or eax, eax
                        jz nada
                        shl eax, 2
                        mov eax, [ebx + eax]
                        mov [edi], eax
                nada:   add edi, 4
                        dec ecx
                        jnz ciclox
                        add [dest], 1280
                        add [src], FONT_ANCHO
                        dec edx
                        jnz cicloy
        }

        return width + 1;
}


void DrawString(char *string, int x, int y, TBitmap *where) {
        int r, i = 0;
        while (string[i] != 0) {
                if ((string[i] < 'a') || (string[i] > 'z')) x += 10;
                else x += (r = DrawChar(string[i], x + (rand() & 1), y + (rand() & 1), where));
                if (r < 0) break;
                i++;
        }
}


int DrawChar2(char c, unsigned bc, int x, int y, TBitmap *where) {
        int width, start = fontstart[c - 97];
        if (c < 122) width = fontstart[c - 96] - start;
        else width = FONT_ANCHO - start;

        if ((y < 0) || (x < 0) || (y >= 220) || ((x + width) >= 320)) return -1;

        unsigned *dest = where->datos + where->tablay[y] + x;
        byte *src = fontset->datos + start;
        unsigned *pal = fontset->paleta;

        _asm {
                mov edx, 20
                mov ebx, [pal]
                cicloy: mov esi, [src]
                        mov edi, [dest]
                        mov ecx, [width]
                ciclox: movzx eax, byte ptr [esi]
                        inc esi
                        or eax, eax
                        jnz oki
                        mov eax, [bc]
                        jmp plot
                oki:    shl eax, 2
                        mov eax, [ebx + eax]
                plot:   mov [edi], eax
                        add edi, 4
                        dec ecx
                        jnz ciclox
                        add [dest], 1280
                        add [src], FONT_ANCHO
                        dec edx
                        jnz cicloy
        }

        return width + 1;
}


void DrawString2(char *string, unsigned bc, int x, int y, TBitmap *where) {
        int r, i = 0;
        while (string[i] != 0) {
                if ((string[i] < 'a') || (string[i] > 'z')) {
                        unsigned *off = where->datos + where->tablay[y + (rand() & 1)] + x + (rand() & 1);
                        for (int a = 0; a < 20; a++) {
                                _asm {
                                        mov eax, [bc]
                                        mov edi, [off]
                                        mov ecx, 8
                                        rep stosd
                                }
                                off += where->ancho;
                        }
                        x += 10;
                }
                else x += (r = DrawChar2(string[i], bc, x + (rand() & 1), y + (rand() & 1), where));
                if (r < 0) break;
                i++;
        }
}


void ColorFade(unsigned *where, int depth);
#pragma aux ColorFade =  \
"mov ecx, 307200"       \
"ciclo: movzx eax, byte ptr [edi]"      \
"       sub eax, edx"   \
"       jns ok" \
"       xor eax, eax"   \
"ok:    mov [edi], al"  \
"       inc edi"        \
"       dec ecx"        \
"       jnz ciclo"      \
parm [edi] [edx]        \
modify [ecx];



// PART #1

#define p1_TorusSides           20
#define p1_TorusSections        20

void cienka_Part1() {
        TObject3D *sphere = new TObject3D;
        MakeSphere(sphere, 20, 20);
        sphere->FitSphere(10.0);
        sphere->SetStyle(c_texturemapped);
        sphere->SetTexture(texture[1]);
        sphere->FlipFaces();
        sphere->CalcNormals();
        sphere->MapEnviroment();
        camera->location.SetP(0, 0, 0);
        camera->ax = camera->ay = camera->az = 0;

        TObject3D *torus = new TObject3D;
        MakeTorus(torus, 4.0, 1.6, p1_TorusSides, p1_TorusSections, 0);
        torus->SetStyle(c_texturemapped);
        torus->SetTexture(texture[2]);
        torus->Rotate(300, 0, 0);

        TObject3D *torusmalla = new TObject3D;
        MakeTorus(torusmalla, 4.0, 2.0, p1_TorusSides, p1_TorusSections, 0);
        torusmalla->SetStyle(c_wireframe);
        torusmalla->SetColor(RGB(64, 128, 255), 0, NULL);
        torusmalla->Rotate(300, 0, 0);

        TScene *scene = new TScene;
        scene->AddObject(torus);
        scene->AddObject(torusmalla);


        timer = 0;
        while (timer < 1700) {
                sphere->Draw(vscr);

                sphere->FlatRotate(dtoi(8.0 * fsin(timer / 100.0)),
                                   dtoi(8.0 * fcos(timer / 130.0)),
                                   dtoi(8.0 * fsin(timer / 60.0)));

                ColorFade(vscr->datos, 100 - dtoi(80.0 * fcos(timer / 20.0)));

                if (timer < 300) ;
                else if (timer < 800) {
                        DrawString2("fac  and  uctumi", 0, 90, 60, vscr);
                        DrawString2("present", 0, 120, 130, vscr);
                }
                else if (timer < 1200) {
                        DrawString2("an intro for", 0, 50, 60, vscr);
                        DrawString2("the overseas party", 0, 130, 130, vscr);
                }
                else biglogo->TransBlitTo(vscr, 0, 80, 0);
                        

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                if (_port0x60() == 1) Finalize();
        }


        TVertex **v, **vm;
        int i, j, ax, ay, az;
        double ang, a, d;
        double freq1 = 3.0 * (2.0 * PI / p1_TorusSections);
        double freq2 = 4.0 * (2.0 * PI / p1_TorusSides);
        timer = 0;
        while (timer < 1650) {
                sphere->Draw(vscr);

                sphere->FlatRotate(dtoi(8.0 * fsin(timer / 100.0)),
                                   dtoi(8.0 * fcos(timer / 130.0)),
                                   dtoi(8.0 * fsin(timer / 60.0)));

                ColorFade(vscr->datos, 100 - dtoi(80.0 * fcos(timer / 20.0)));

                if (timer < 640) biglogo->TransBlitTo(vscr, -(timer >> 1), 80, 0);

                v = torus->Vertex;
                vm = torusmalla->Vertex;
                ang = timer / 90.0;
                for (i = 0; i < p1_TorusSections; i++) {
                        a = timer / 130.0;
                        for (j = 0; j < p1_TorusSides; j++) {
                                d = (0.02 * fsin(a)) + (0.03 * fcos(ang));
                                (*v)->x += d * (*v)->normal.x;
                                (*v)->y += d * (*v)->normal.y;
                                (*v)->z += d * (*v)->normal.z;

                                (*vm)->x += d * (*v)->normal.x;
                                (*vm)->y += d * (*v)->normal.y;
                                (*vm)->z += d * (*v)->normal.z;
                                a += freq2;
                                v++;
                                vm++;
                        }
                        ang += freq1;
                }
                for (i = 0; i < torus->NumPolygons; i++) {
                        torus->Poly[i]->CalcNormal();
                        torusmalla->Poly[i]->CalcNormal();
                }

                if (timer < 500) {
                        ay = 500 - timer;
                        torus->origin.SetP(0, ay * 0.1, 8.0);
                        torusmalla->origin.SetP(0, ay * 0.1, 8.0);
                }

                torus->MapEnviroment();
                scene->Draw(vscr);

                ax = dtoi(7.0 * fcos(timer / 70.0));
                ay = dtoi(6.0 * fcos(timer / 95.0));
                az = dtoi(8.0 * fsin(timer / 135.0));
                torus->Rotate(ax, ay, az);
                torusmalla->FlatRotate(ax, ay, az);

                if (timer > 800)
                        DrawString("mess with the mesh", 80, 210, vscr);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                if (_port0x60() == 1) Finalize();
        }

        delete sphere;
        delete torus;
        delete torusmalla;
}


// PART #2

void MoveCamera(int ax, int ay, int az, TVector *displace) {
        TVector *p = new TVector(defcam->location.x, defcam->location.y, defcam->location.z);
        p->Rotate(ax, ay, az);
        *p += *displace;
        camera->location.SetP(p->x, p->y, p->z);
	camera->ax = ax;
	camera->ay = ay;
        camera->az = az;
}


#define p2_NumTubes     10
#define p2_TubeSides    6
void cienka_Part2() {
        int i, j, k;
        TVector *disp = new TVector(0, 0, 0);

        TBitmap8bpp *plasma = new TBitmap8bpp(p2_NumTubes, p2_NumTubes);

        unsigned ColorTable[256];
        TScene *scene = new TScene();
        TObject3D *tube[p2_NumTubes][p2_NumTubes];
        TObject3D *wiretube[p2_NumTubes][p2_NumTubes];

        for (i = 0; i < p2_NumTubes; i++)
                for (j = 0; j < p2_NumTubes; j++) {
                        tube[i][j] = new TObject3D();
                        MakeCylinder(tube[i][j], p2_TubeSides);
                        tube[i][j]->Scale(0.8, 9.8, 0.8);
                        tube[i][j]->SetStyle(c_flatshaded);
                        tube[i][j]->SetColor(0, 127, (int *)ColorTable);
                        tube[i][j]->origin.SetP((j - (p2_NumTubes / 2)) * 2 + 1,
                                                -10.0,
                                                (i - (p2_NumTubes / 2)) * 2 + 1);

                        wiretube[i][j] = new TObject3D();
                        MakeCylinder(wiretube[i][j], p2_TubeSides);
                        wiretube[i][j]->Scale(1.0, 10.0, 1.0);
                        wiretube[i][j]->SetStyle(c_wireframe);
                        wiretube[i][j]->SetColor(RGB(128, 0, 200), 0, NULL);
                        wiretube[i][j]->origin.SetP((j - (p2_NumTubes / 2)) * 2 + 1,
                                                -10.0,
                                                (i - (p2_NumTubes / 2)) * 2 + 1);

                        scene->AddObject(tube[i][j]);
                        scene->AddObject(wiretube[i][j]);
                }

        PhongPal(0.0, 0.5, 0.8, 0.0, 0.4, 0.7, 0.0, 0.0, 0.4, 40, ColorTable, 256);

        defcam->location.SetP(0, 0, -p2_NumTubes * 1.2);

        TObject3D *sphere = new TObject3D;
        MakeSphere(sphere, 16, 16);
        sphere->FitSphere(p2_NumTubes * 4.0);
        sphere->SetStyle(c_texturemapped);
        sphere->SetTexture(texture[0]);
        sphere->FlipFaces();
        sphere->CalcNormals();
        sphere->MapEnviroment();
        scene->AddObject(sphere);

        byte *plasmaoff;
        double height;

        SetLightPosition(1, 1, -2);

        timer = 0;
        while (timer < 1700) {
                GeneratePlasma( plasma, PlasmaTable[0], PlasmaTable[1],
                                128 + 127 * fsin(timer * 0.001),
                                128 + 127 * fcos(timer * 0.0003),
                                255 * fcos(timer * 0.001) * fcos(timer * 0.0009),
                                128 - 127 * fsin(timer * 0.0012));

                defcam->location.SetP(0, 0, -p2_NumTubes * (1.0 + 0.1 * fsin(timer / 170.0)));

                MoveCamera(100 + dtoi(40.0 * fsin(timer / 130.0)),
                           dtoi(360.0 * fcos(timer / 200.0)),
                           dtoi(80 * fsin(timer / 60.0)), disp);

                plasmaoff = plasma->datos;
                for (i = 0; i < p2_NumTubes; i++)
                        for (j = 0 ; j < p2_NumTubes; j++) {
                                if (*plasmaoff < 128)
                                        height = (*plasmaoff++) * 0.08;
                                else height = (256 - (*plasmaoff++)) * 0.08;
                                for (k = 0; k < p2_TubeSides; k++) {
                                        tube[i][j]->Vertex[k]->y = height - 0.2;
                                        wiretube[i][j]->Vertex[k]->y = height;
                                }
                        }
                                
                scene->Draw(vscr);

                logo->TransBlitTo(vscr, 160, 0, 0);

                Light.Rotate(0, dtoi(6.0 * fsin(timer / 300.0)), 0);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                if (_port0x60() == 1) Finalize();
        }

        delete scene;
        delete disp;
        free(plasma->datos); delete plasma;
}



// PART #3

#define p3_NumCubes     7

void cienka_Part3() {
        TVector *disp = new TVector(0, -1, 0);
        TScene *scene = new TScene();
        TObject3D *cube[p3_NumCubes];
        int i;
        unsigned ColorTable[256];
        for (i = 0; i < p3_NumCubes; i++) {
                cube[i] = new TObject3D();
                MakeCube(cube[i]);
                cube[i]->Rotate(rand() % NumDegrees, rand() & NumDegrees, rand() & NumDegrees);
                cube[i]->SetStyle(c_flatshaded);
                cube[i]->SetColor(0, 127, (int *)ColorTable);
                cube[i]->origin.SetP((i - p3_NumCubes / 2) * 2.5, 0, abs(i - p3_NumCubes / 2));
                scene->AddObject(cube[i]);
        }

        defcam->location.SetP(0, 0, -4);
        MoveCamera(-80, 0, 0, disp);

        PhongPal(0.0, 0.4, 0.2, 0.0, 0.2, 0.6, 0.0, 0.6, 0.2, 10, ColorTable, 256);
        SetLightPosition(1, 1, 2);

	int centers[6];
	TFX_centers = centers;
	TFX_count = 3;
        byte a, d;
        double theta = 0.0;

        timer = 0;
        while (timer < 850) {
                theta = timer / 150.0;
                centers[0] = 160 + 120 * fsin(theta);
                centers[1] = 120 + 80 * fcos(theta * 3.0);
                centers[2] = 160 - 120 * fcos(theta * 1.5);
                centers[3] = 120 - 80 * fsin(theta * 2.0);
                centers[4] = 160 - 120 * fsin(theta * 3.0);
                centers[5] = 120 - 80 * fcos(theta);
                TFX_DrawWobbler(a, d, texture[3], vscr);
                a -= 2; d += 2;

                ColorFade(vscr->datos, 40 - dtoi(40.0 * fcos(timer / 40.0)));

                scene->Draw(vscr);

                DrawString("code and gfx by fac", 70, 76, vscr);
                DrawString("music by uctumi", 90, 106, vscr);

                for (i = 0; i < p3_NumCubes; i++) {
                        cube[i]->FlatRotate(dtoi(8.0 * fsin(theta * 1.5)),
                                            dtoi(8.0 * fcos(theta * 1.2)),
                                            dtoi(8.0 * fsin(theta * 0.7)));
                        theta += 0.3;
                }

                Light.Rotate(4, 4, 4);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                if (_port0x60() == 1) Finalize();
        }

        delete scene;
        delete disp;
}



// PART #4

#define p4_NumTorus      20
#define p4_TorusWidth    0.4

void cienka_Part4() {
        int i;
        double r;
        TScene *scene = new TScene();
        TObject3D *torus[p4_NumTorus];
        TVector *disp = new TVector(0, 0, 0);
        
        TObject3D *sphere = new TObject3D;
        MakeSphere(sphere, 16, 16);
        sphere->FitSphere(p4_NumTorus * 2.0);
        sphere->SetStyle(c_texturemapped);
        sphere->SetTexture(texture[1]);
        sphere->FlipFaces();
        sphere->CalcNormals();
        sphere->MapEnviroment();
        scene->AddObject(sphere);

        r = p4_TorusWidth;
        for (i = 0; i < p4_NumTorus; i++) {
                torus[i] = new TObject3D();
                MakeTorus(torus[i], r, p4_TorusWidth, 4, 6, PI / 4.0);
                torus[i]->SetStyle(c_texturemapped);
                torus[i]->SetTexture(texture[4]);
                scene->AddObject(torus[i]);
                r += p4_TorusWidth * 1.8;
        }

        defcam->location.SetP(0, 0, -p4_TorusWidth * p4_NumTorus * 1.5);

        timer = 0;
        while (timer < 2270) {
                vscr->Borra(0);

                MoveCamera(200 + dtoi(40.0 * fsin(timer / 130.0)),
                           dtoi(360.0 * fcos(timer / 200.0)),
                           dtoi(80 * fsin(timer / 60.0)), disp);

                r = timer / 100.0;
                for (int i = 0; i < p4_NumTorus; i++) {
                        torus[i]->origin.SetP(0, 5.0 * fsin(r), 0);
                        r += 0.2;
                        torus[i]->FlatRotate(0, dtoi(6.0 * fsin(r * 1.3)), 0);
                }
                                
                scene->Draw(vscr);

                logo->TransBlitTo(vscr, 0, 0, 0);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                if (_port0x60() == 1) Finalize();
        }

        delete scene;
        delete disp;
}



// PART #5

#define p5_ArmCubes     10
#define p5_Delay        0.8
#define p5_CubeDistance 2.5
#define p5_NumSideCubes 15

void cienka_Part5() {
        int i, j, k;
        double d;
        unsigned ColorTable1[256];
        unsigned ColorTable2[256];
        TScene *scene = new TScene();

        TObject3D *cube[p5_ArmCubes][6];
        TObject3D *wirecube[p5_ArmCubes][6];

        double cubedelay[p5_ArmCubes][6];

        for (i = 0; i < p5_ArmCubes; i++) {
                d = p5_CubeDistance * (i + 1);
                for (j = 0; j < 6; j++) {
                        cube[i][j] = new TObject3D();
                        MakeCube(cube[i][j]);
                        cube[i][j]->SetStyle(c_flatshaded);
                        cube[i][j]->SetColor(0, 127 - (i << 2), (int *)ColorTable1);
                        switch (j) {
                                case 0: cube[i][j]->origin.SetP(d, 0, 0); break;
                                case 1: cube[i][j]->origin.SetP(-d, 0, 0); break;
                                case 2: cube[i][j]->origin.SetP(0, d, 0); break;
                                case 3: cube[i][j]->origin.SetP(0, -d, 0); break;
                                case 4: cube[i][j]->origin.SetP(0, 0, d); break;
                                case 5: cube[i][j]->origin.SetP(0, 0, -d); break;
                        }
                        scene->AddObject(cube[i][j]);

                        wirecube[i][j] = new TObject3D();
                        MakeCube(wirecube[i][j]);
                        wirecube[i][j]->SetStyle(c_wireframe);
                        wirecube[i][j]->SetColor(RGB(255, 200, 20), 0, NULL);
                        wirecube[i][j]->Scale(1.2, 1.2, 1.2);
                        switch (j) {
                                case 0: wirecube[i][j]->origin.SetP(d, 0, 0); break;
                                case 1: wirecube[i][j]->origin.SetP(-d, 0, 0); break;
                                case 2: wirecube[i][j]->origin.SetP(0, d, 0); break;
                                case 3: wirecube[i][j]->origin.SetP(0, -d, 0); break;
                                case 4: wirecube[i][j]->origin.SetP(0, 0, d); break;
                                case 5: wirecube[i][j]->origin.SetP(0, 0, -d); break;
                        }
                        scene->AddObject(wirecube[i][j]);

                        cubedelay[i][j] = p5_Delay * i / (double)p5_ArmCubes;
                }
        }

        PhongPal(0.0, 0.3, 0.4, 0.0, 0.0, 0.2, 0.0, 0.6, 0.8, 10, ColorTable1, 256);

        camera->location.SetP(0, 0, -p5_ArmCubes * p5_CubeDistance);
        camera->ax = camera->ay = camera->az = 0;

        int centers[2];
	TFX_centers = centers;
        TFX_count = 1;
        centers[0] = 160; centers[1] = 120;

        double ang, a;
        int ax, ay, az;

        TVector *disp = new TVector(0, 0, 0);

        timer = 0;
        while (timer < 1970) {
                TFX_DrawRipples(128 + dtoi(127.0 * fsin(timer / 230.0)), timer >> 2, texture[4], vscr);

                defcam->location.SetP(0, 0, -p5_ArmCubes * p5_CubeDistance * (0.7 + 0.3 * fcos(timer / 80.0)));

                MoveCamera(dtoi(180.0 * fsin(timer / 130.0)),
                           dtoi(240.0 * fcos(timer / 200.0)),
                           dtoi(100.0 * fsin(timer / 170.0)), disp);


                ang = timer / 100.0;
                for (i = 0; i < p5_ArmCubes; i++)
                        for (j = 0; j < 6; j++) {
                                a = ang - cubedelay[i][j];
                                ax = dtoi(8.0 * fcos(a));
                                ay = dtoi(8.0 * fsin(a * 1.3));
                                az = dtoi(8.0 * fsin(a * 0.8));
                                cube[i][j]->FlatRotate(ax, ay, az);
                                cube[i][j]->origin.Rotate(ax, ay, az);
                                wirecube[i][j]->FlatRotate(ax, ay, az);
                                wirecube[i][j]->origin.Rotate(ax, ay, az);
                        }

                scene->Draw(vscr);

                DrawString2("fucking", 0x080010, 240, 20, vscr);
                DrawString2(" cubes ", 0x0C0018, 240, 45, vscr);
                DrawString2(" still  ", 0x100020, 240, 70, vscr);
                DrawString2("  look ", 0x140028, 240, 95, vscr);
                DrawString2("  so   ", 0x180030, 240, 120, vscr);
                DrawString2("fucking", 0x1C0038, 240, 145, vscr);
                DrawString2(" cool  ", 0x200040, 240, 170, vscr);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                if (_port0x60() == 1) Finalize();
        }                

        delete disp;
        delete scene;
}



// PART #6

#define p6_aSections    24
#define p6_bSections    24
#define p6_Radius       10.0

void cienka_Part6() {
        int i, j;
        TVector *disp = new TVector(0, 0, 0);
        TVertex **v, **wv;

        TObject3D *sphere = new TObject3D;
        MakeSphere(sphere, p6_aSections + 1, p6_bSections);
        sphere->SetStyle(c_texturemapped);
        sphere->SetTexture(texture[0]);
        sphere->FitSphere(p6_Radius);
        sphere->Rotate(360, 0, 0);
        sphere->SphericalMap(1.0);

        TObject3D *wiresphere = new TObject3D;
        MakeSphere(wiresphere, p6_aSections + 1, p6_bSections);
        wiresphere->SetStyle(c_wireframe);
        wiresphere->SetColor(RGB(200, 160, 200), 0, NULL);
        wiresphere->FitSphere(p6_Radius * 1.05);
        wiresphere->Rotate(360, 0, 0);

        TScene *scene = new TScene();
        scene->AddObject(sphere);
        scene->AddObject(wiresphere);

        defcam->location.SetP(0, 0, -p6_Radius * 2.0);
        MoveCamera(0, 0, 0, disp);

        int centers[2];
	TFX_centers = centers;
        TFX_count = 1;
        centers[0] = 160; centers[1] = 120;

        double freq1 = 4.0 * 2.0 * PI / p6_bSections;
        double freq2 = 5.0 * 2.0 * PI / p6_aSections;
        double a1, a2, d;
        int ax, ay, az;

        timer = 0;
        while (timer < 1660) {
                TFX_DrawTunnel(0, timer >> 2, texture[3], vscr);

                a1 = timer / 70.0;
                v = sphere->Vertex + 2;
                wv = wiresphere->Vertex + 2;
                for (i = 0; i < p6_bSections; i++) {
                        a2 = timer / 100.0;
                        for (j = 0; j < p6_aSections; j++) {
                                d = 0.08 * fcos(a1) + 0.06 * fsin(a2);
                                (*v)->x += d * (*v)->normal.x;
                                (*v)->y += d * (*v)->normal.y;
                                (*v)->z += d * (*v)->normal.z;
                                (*wv)->x += d * (*v)->normal.x;
                                (*wv)->y += d * (*v)->normal.y;
                                (*wv)->z += d * (*v)->normal.z;
                                a2 += freq2;
                                v++;
                                wv++;
                        }
                        a1 += freq1;
                }

                for (int i = 0; i < sphere->NumPolygons; i++) {
                        sphere->Poly[i]->CalcNormal();
                        wiresphere->Poly[i]->CalcNormal();
                }

                scene->Draw(vscr);

                switch ((timer / 70) & 3) {
                        case 0: logo->TransBlitTo(vscr, 2, 206, 0); break;
                        case 1: logo->TransBlitTo(vscr, 2, 2, 0); break;
                        case 2: logo->TransBlitTo(vscr, 158, 2, 0); break;
                        case 3: logo->TransBlitTo(vscr, 158, 206, 0); break;
                }

                ax = dtoi(10.0 * fcos(timer / 90.0));
                ay = dtoi(10.0 * fcos(timer / 120.0));
                az = dtoi(10.0 * fsin(timer / 155.0));
                sphere->Rotate(ax, ay, az);
                wiresphere->FlatRotate(ax, ay, az);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                if (_port0x60() == 1) Finalize();
        }

        delete scene;
        delete disp;
}


// PART #7

void cienka_Part7() {
        char *greet[16] = {     " acidbrain ",
                                "  acme   ",
                                " arlequin  ",
                                " biomemo ",
                                "   cubic  ",
                                "  delabu  ",
                                "  freddyv ",
                                "   fudge  ",
                                "  imago  ",
                                " irondude ",
                                "   pulse  ",
                                "  purple  ",
                                "   pvm   ",
                                "   pyro   ",
                                "   reduz  ",
                                "   tpolm  " };

	int centers[6];
	TFX_centers = centers;
	TFX_count = 3;
        double theta = 0.0;
        int i;

        timer = 0;
        while (timer < 1700) {
                theta = timer / 100.0;
                centers[0] = 160 + 120 * fsin(theta * 1.2);
                centers[1] = 120 + 80 * fcos(theta * 0.9);
                centers[2] = 160 - 120 * fcos(theta * 1.4);
                centers[3] = 120 - 80 * fsin(theta * 2.3);
                centers[4] = 160 - 120 * fsin(theta * 1.7);
                centers[5] = 120 - 80 * fcos(theta * 0.7);
                TFX_DrawTunnel(0, timer << 1, texture[5], vscr);

                ColorFade(vscr->datos, 60 - dtoi(60.0 * fcos(timer / 50.0)));

                DrawString2(" hellos go out to ", 0, 80, 4, vscr);

                for (i = 0; i < 8; i++) {
                        DrawString2(greet[i], 0, 2, 40 + i * 24, vscr);
                        DrawString2(greet[i + 8], 0, 220, 40 + i * 24, vscr);
                }

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                if (_port0x60() == 1) Finalize();
        }
}



// PART #8

#define p8_xSections    27
#define p8_ySections    27
#define p8_Depth        3.0

void cienka_Part8() {
        TVector *disp = new TVector(0, 0, 0);
        TBitmap8bpp *plasma = new TBitmap8bpp(p8_xSections + 1, p8_ySections + 1);

        TScene *scene = new TScene();

        TObject3D *sphere = new TObject3D;
        MakeSphere(sphere, 16, 16);
        sphere->FitSphere(20);
        sphere->SetStyle(c_texturemapped);
        sphere->SetTexture(texture[1]);
        sphere->FlipFaces();
        sphere->CalcNormals();
        sphere->MapEnviroment();
        scene->AddObject(sphere);

        TObject3D *hf_source = new TObject3D();
        MakeQuadPatch(hf_source, p8_xSections, p8_ySections);
        hf_source->Rotate(360, 0, 0);
        hf_source->Scale(10.0, 10.0, 10.0);

        TObject3D *hf = new TObject3D();
        MakeQuadPatch(hf, p8_xSections, p8_ySections);
        hf->SetStyle(c_texturemapped);
        hf->SetTexture(texture[6]);

        scene->AddObject(hf);

        defcam->location.SetP(0, 0, -8.0);
        MoveCamera(100, 0, 0, disp);

        int i;
        double a;
        byte *plasmaoff;

        timer = 0;
        while (1) {
                vscr->Borra(0);

                MoveCamera(200 + dtoi(60.0 * fcos(timer / 110.0)),
                           dtoi(180.0 * fsin(timer / 160.0)),
                           dtoi(60 * fcos(timer / 70.0)), disp);

                a = timer / 500.0;
                GeneratePlasma(plasma, PlasmaTable[2], PlasmaTable[3],
                        128 + 127 * fsin(a),
                        128 + 127 * fcos(a * 0.3),
                        255 * fcos(a * 1.2) * fcos(a * 0.9),
                        128 - 127 * fsin(a * 0.7));

                plasmaoff = plasma->datos;
                for (i = 0; i < hf_source->NumVertex; i++) {
                        hf->Vertex[i]->x = hf_source->Vertex[i]->x;
                        hf->Vertex[i]->y = hf_source->Vertex[i]->y;
                        hf->Vertex[i]->z = hf_source->Vertex[i]->z;
                        *(hf->Vertex[i]) += hf_source->Vertex[i]->normal *
                                            (Sin256[*plasmaoff++] * p8_Depth);
                }

                scene->Draw(vscr);

                biglogo->TransBlitTo(vscr, 0, 0, 0);

                DrawString2(" press esc to exit ", 0, 75, 218, vscr);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                if (_port0x60() == 1) Finalize();
        }

        free(plasma->datos); delete plasma;
        delete disp;
        delete scene;
        delete hf_source;
}



// MAIN

void main() {
        HardwareInit(_psp); // This must be the first function call !
        Initialize();
        srand(timer);

        cienka_Part1();
        cienka_Part2();
        cienka_Part3();
        cienka_Part4();
        cienka_Part5();
        cienka_Part6();
        cienka_Part7();
        cienka_Part8();

        Finalize();
}
