//	obj3d.h

#ifndef _OBJ3D_
#define _OBJ3D_

#include "vectors.h"

#define MaxObjectVertex 1000
#define MaxPolyVertex   10
#define MaxObjectPoly   2000
#define MaxScenePoly    5000
#define MaxSceneObjects 50


#define ScreenCenterX 320
#define ScreenCenterY 240
#define PerspectiveX  256.0
#define PerspectiveY  256.0


class TPolygon {
	public:
			int NumVertex;
			unsigned int zorder;
			TVector normal;
			TVertex *(*Vertex);
			int style, cstart, crange;
			unsigned int texture;
			
			TPolygon();
			~TPolygon();
			
			void AddVertex(TVertex *v);
			void Draw(unsigned int where);
			void CalcNormal();
			int Visible();
			void CalcZOrder();
};


class TObject3D {
	public:
			TVector origin;
			int NumVertex, NumPolygons;
			TVertex *(*Vertex);
			TPolygon *(*Poly);
			
			TObject3D();
			~TObject3D();
			
			void AddVertex(double nx, double ny, double nz);
			void AddVertexUV(double nx, double ny, double nz, double nu, double nv);
			void AddPolygon(TPolygon *poly);
			void CalcNormals();
			void MapEnviroment();
			void Traslate(double tx, double ty, double tz);
			void Rotate(int ax, int ay, int az);
            void FlatRotate(int ax, int ay, int az);
			void Scale(double sx, double sy, double sz);
			void TransformView();
			void Draw(unsigned int where);
            void SphericalMap(double scale);
            void FlipFaces();
            void Centre();
            void FitSphere(double radius);
            void SetColor(int cstart, int crange);
            void SetStyle(int style);
            void SetTexture(unsigned int texture);
};


// load a 3d object
void Load3DObject(char *filename, TObject3D *obj);
void Read3DObject(int *vkx, TObject3D *obj);


void InitializeEngine();


// radix sort
void radixsort(TPolygon **source, long N);


#endif
