#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "hires256.h"
#include "stuff.h"
#include "phongpal.h"
#include "obj3d.h"
#include "triangle.h"
#include "polygons.h"
#include "vectors.h"
#include "scenes.h"
#include "cameras.h"
#include "final.h"

// picture files
#include "final1.h"
#include "final2.h"
#include "final3.h"
#include "final4.h"
#include "finback.h"
#include "tex2.h"

// 3d files
#include "globe.h"


// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


TObject3D *Final_obj;
char Final_Table1[65536];
int Final_Table2[256];


void Final_Setup() {
        for (int i = 0; i < 64000; i++) {
                if (FINAL1[i]) FINAL1[i] = 128 + FINAL1[i] / 2;
                if (FINAL2[i]) FINAL2[i] = 128 + FINAL2[i] / 2;
                if (FINAL3[i]) FINAL3[i] = 128 + FINAL3[i] / 2;
                if (FINAL4[i]) FINAL4[i] = 128 + FINAL4[i] / 2;
        }

        Final_obj = new TObject3D();
        Read3DObject(GLOBE_VKX, Final_obj);
        Final_obj->Centre();
        Final_obj->FitSphere(100);
        Final_obj->FlipFaces();
        Final_obj->CalcNormals();
        Final_obj->SetStyle(c_wireframe);
        Final_obj->SetColor(255, 0);

        for (i = 0; i < 65536; i++) Final_Table1[i] = 128 + (rand() & 31);
        for (i = 0; i < 256; i++) Final_Table2[i] = rand() % 20;
}


void Final_Free() {
        delete Final_obj;
}


void ClipLogo(int x, int y, unsigned int source, unsigned int dest) {
        if ((x <= -640) || (x > 639) || (y <= -100) || (y > 479)) return;
        int xa = ((x < 0) ? (-x) : 0);
        int ya = ((y < 0) ? (-y) : 0);
        int width = ((x > 0) ? (640 - x) : (640 + x));
        int height = ((y > 380) ? (480 - y) : (100 - ya));
        if (x < 0) x = 0;
        if (y < 0) y = 0;
        _asm {
                mov ebx, [y]
                mov edi, [dest]
                imul ebx, 640
                add edi, [x]
                add edi, ebx

                mov ebx, [ya]
                mov esi, [source]
                imul ebx, 640
                add esi, [xa]
                add esi, ebx

                mov ebx, 640
                sub ebx, [width]

                mov edx, [height]
                yloop:  mov ecx, [width]
                        push edi
                xloop:  mov al, [esi]
                        inc esi
                        or al, al
                        jz nope
                        mov [edi], al
                nope:   inc edi
                        dec ecx
                        jnz xloop
                        pop edi
                        add esi, ebx
                        add edi, 640
                        dec edx
                        jnz yloop
        }
}


void FDrawInterference(unsigned int where) {
        unsigned char TableIndex = rand() & 0xFF;
        unsigned short RandomIndex;
        unsigned int off = (unsigned int)Final_Table1;
        int y = Final_Table2[TableIndex++];
        where += 640 * y;
        while (y < 480) {
                RandomIndex = rand() & 0xFC00;
                _asm {
                        movzx esi, word ptr [RandomIndex]
                        mov edi, [where]
                        add esi, [off]
                        mov ecx, 160
                        rep movsd
                }
                y += Final_Table2[TableIndex];
                where += 640 * Final_Table2[TableIndex++];
        }
}


void Final() {
        TVirtual *vs = new TVirtual;
        TPalette pal;
        unsigned int logo = (unsigned int)FINBACK;
        unsigned int voff = (unsigned int)vs;
        int x, y;
        double a = 0.0;

        CopyPalette(FINBACK_PAL, pal, 0, 127);
        for (int i = 0; i < 128; i++) 
                pal[128 + i][0] = pal[128 + i][1] = pal[128 + i][2] = i >> 1;
        HClearScreen(0, SCREEN_OFF);
        HClearScreen(0, (unsigned int)vs);
        SetPalette(pal);

        camera->location.SetP(0, 0, 0);

        x = 640;
        GetMusicInfo();
        while (row < 32) {
//                if (row >= 56) camera->location.SetP(5 - (rand() % 10), 5 - (rand() % 10), 5 - (rand() % 10));
//                else {
//                        camera->location.SetP(0, 0, 0);
                        camera->ax = dtoi(720 + 719 * sin(a));
                        camera->ay = dtoi(720 + 719 * cos(a));
                        camera->az = dtoi(720 + 719 * sin(a / 2.0));
                        a += 0.01;
//                }
                Final_obj->Draw((unsigned int)vs);

                ClipLogo(x, 80, (unsigned int)FINAL1, (unsigned int)vs); 

                _asm {
                        mov edi, [voff]
                        mov esi, [logo]
                        add edi, 243200
                        mov edx, 100
                        ylp:    mov ecx, 420
                        xlp:    mov al, [esi]
                                inc esi
                                or al, al
                                jz nope
                                mov [edi], al
                        nope:   inc edi
                                dec ecx
                                jnz xlp
                                add edi, 220
                                dec edx
                                jnz ylp
                }

                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (x > 0) x -= 10;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        y = 80;
        while (position < 41) {
                if (row >= 56) camera->location.SetP(5 - (rand() % 10), 5 - (rand() % 10), 5 - (rand() % 10));
                else {
                        camera->location.SetP(0, 0, 0);
                        camera->ax = dtoi(720 + 719 * sin(a));
                        camera->ay = dtoi(720 + 719 * cos(a));
                        camera->az = dtoi(720 + 719 * sin(a / 2.0));
                        a += 0.01;
                }
                Final_obj->Draw((unsigned int)vs);

                ClipLogo(0, y, (unsigned int)FINAL1, (unsigned int)vs); 

                _asm {
                        mov edi, [voff]
                        mov esi, [logo]
                        add edi, 243200
                        mov edx, 100
                        ylp:    mov ecx, 420
                        xlp:    mov al, [esi]
                                inc esi
                                or al, al
                                jz nope
                                mov [edi], al
                        nope:   inc edi
                                dec ecx
                                jnz xlp
                                add edi, 220
                                dec edx
                                jnz ylp
                }

                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (y < 480) y += 8;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        camera->location.SetP(0, 0, 0);
        x = -640;

        while (row < 32) {
//                if (row >= 56) camera->location.SetP(5 - (rand() % 10), 5 - (rand() % 10), 5 - (rand() % 10));
//                else {
//                        camera->location.SetP(0, 0, 0);
                        camera->ax = dtoi(720 + 719 * sin(a));
                        camera->ay = dtoi(720 + 719 * cos(a));
                        camera->az = dtoi(720 + 719 * sin(a / 2.0));
                        a += 0.01;
//                }
                Final_obj->Draw((unsigned int)vs);

                ClipLogo(x, 240, (unsigned int)FINAL2, (unsigned int)vs); 

                _asm {
                        mov edi, [voff]
                        mov esi, [logo]
                        add edi, 243200
                        mov edx, 100
                        ylp:    mov ecx, 420
                        xlp:    mov al, [esi]
                                inc esi
                                or al, al
                                jz nope
                                mov [edi], al
                        nope:   inc edi
                                dec ecx
                                jnz xlp
                                add edi, 220
                                dec edx
                                jnz ylp
                }

                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (x < 0) x += 10;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        y = 240;
        while (position < 42) {
                if (row >= 56) camera->location.SetP(5 - (rand() % 10), 5 - (rand() % 10), 5 - (rand() % 10));
                else {
                        camera->location.SetP(0, 0, 0);
                        camera->ax = dtoi(720 + 719 * sin(a));
                        camera->ay = dtoi(720 + 719 * cos(a));
                        camera->az = dtoi(720 + 719 * sin(a / 2.0));
                        a += 0.01;
                }
                Final_obj->Draw((unsigned int)vs);

                ClipLogo(0, y, (unsigned int)FINAL2, (unsigned int)vs); 

                _asm {
                        mov edi, [voff]
                        mov esi, [logo]
                        add edi, 243200
                        mov edx, 100
                        ylp:    mov ecx, 420
                        xlp:    mov al, [esi]
                                inc esi
                                or al, al
                                jz nope
                                mov [edi], al
                        nope:   inc edi
                                dec ecx
                                jnz xlp
                                add edi, 220
                                dec edx
                                jnz ylp
                }

                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (y > -100) y -= 8;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        camera->location.SetP(0, 0, 0);

        x = 640;
        GetMusicInfo();
        while (row < 32) {
//                if (row >= 56) camera->location.SetP(5 - (rand() % 10), 5 - (rand() % 10), 5 - (rand() % 10));
//                else {
//                        camera->location.SetP(0, 0, 0);
                        camera->ax = dtoi(720 + 719 * sin(a));
                        camera->ay = dtoi(720 + 719 * cos(a));
                        camera->az = dtoi(720 + 719 * sin(a / 2.0));
                        a += 0.01;
//                }
                Final_obj->Draw((unsigned int)vs);

                ClipLogo(x, 80, (unsigned int)FINAL3, (unsigned int)vs); 

                _asm {
                        mov edi, [voff]
                        mov esi, [logo]
                        add edi, 243200
                        mov edx, 100
                        ylp:    mov ecx, 420
                        xlp:    mov al, [esi]
                                inc esi
                                or al, al
                                jz nope
                                mov [edi], al
                        nope:   inc edi
                                dec ecx
                                jnz xlp
                                add edi, 220
                                dec edx
                                jnz ylp
                }

                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (x > 0) x -= 10;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        y = 80;
        while (position < 43) {
                if (row >= 56) camera->location.SetP(5 - (rand() % 10), 5 - (rand() % 10), 5 - (rand() % 10));
                else {
                        camera->location.SetP(0, 0, 0);
                        camera->ax = dtoi(720 + 719 * sin(a));
                        camera->ay = dtoi(720 + 719 * cos(a));
                        camera->az = dtoi(720 + 719 * sin(a / 2.0));
                        a += 0.01;
                }
                Final_obj->Draw((unsigned int)vs);

                ClipLogo(0, y, (unsigned int)FINAL3, (unsigned int)vs); 

                _asm {
                        mov edi, [voff]
                        mov esi, [logo]
                        add edi, 243200
                        mov edx, 100
                        ylp:    mov ecx, 420
                        xlp:    mov al, [esi]
                                inc esi
                                or al, al
                                jz nope
                                mov [edi], al
                        nope:   inc edi
                                dec ecx
                                jnz xlp
                                add edi, 220
                                dec edx
                                jnz ylp
                }

                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (y < 480) y += 8;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        camera->location.SetP(0, 0, 0);
        x = -640;

        while (row < 32) {
//                if (row >= 56) camera->location.SetP(5 - (rand() % 10), 5 - (rand() % 10), 5 - (rand() % 10));
//                else {
//                        camera->location.SetP(0, 0, 0);
                        camera->ax = dtoi(720 + 719 * sin(a));
                        camera->ay = dtoi(720 + 719 * cos(a));
                        camera->az = dtoi(720 + 719 * sin(a / 2.0));
                        a += 0.01;
//                }
                Final_obj->Draw((unsigned int)vs);

                ClipLogo(x, 240, (unsigned int)FINAL4, (unsigned int)vs); 

                _asm {
                        mov edi, [voff]
                        mov esi, [logo]
                        add edi, 243200
                        mov edx, 100
                        ylp:    mov ecx, 420
                        xlp:    mov al, [esi]
                                inc esi
                                or al, al
                                jz nope
                                mov [edi], al
                        nope:   inc edi
                                dec ecx
                                jnz xlp
                                add edi, 220
                                dec edx
                                jnz ylp
                }

                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (x < 0) x += 10;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        y = 240;
        while (position < 44) {
                if (row >= 56) camera->location.SetP(5 - (rand() % 10), 5 - (rand() % 10), 5 - (rand() % 10));
                else {
                        camera->location.SetP(0, 0, 0);
                        camera->ax = dtoi(720 + 719 * sin(a));
                        camera->ay = dtoi(720 + 719 * cos(a));
                        camera->az = dtoi(720 + 719 * sin(a / 2.0));
                        a += 0.01;
                }
                Final_obj->Draw((unsigned int)vs);

                ClipLogo(0, y, (unsigned int)FINAL4, (unsigned int)vs); 

                _asm {
                        mov edi, [voff]
                        mov esi, [logo]
                        add edi, 243200
                        mov edx, 100
                        ylp:    mov ecx, 420
                        xlp:    mov al, [esi]
                                inc esi
                                or al, al
                                jz nope
                                mov [edi], al
                        nope:   inc edi
                                dec ecx
                                jnz xlp
                                add edi, 220
                                dec edx
                                jnz ylp
                }

                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                if (y > -100) y -= 8;

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        camera->location.SetP(0, 0, -80);
        camera->ax = camera->az = 0;
        camera->ay = 180;
        Final_obj->SetTexture((unsigned int)TEX2);
        Final_obj->SetStyle(c_texturemapped);
        Final_obj->SphericalMap(1.0);

        HClearScreen(0, SCREEN_OFF);
        HClearScreen(0, (unsigned int)vs);
        SetPalette(TEX2_PAL);

        while (row < 60) {
                Final_obj->Draw((unsigned int)vs);
                FDrawInterference((unsigned int)vs);

                SetPalette(TEX2_PAL);
                HCopyAndClear((unsigned int)vs, SCREEN_OFF);

                Final_obj->Rotate(0, 20, 0);
                if (row > 32) FadePalette(TEX2_PAL, 0, 255);
                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

//        delete vs;
}

