'$DYNAMIC
'$INCLUDE: 'BWSB\INCLUDE\BWSB.BI'
'$INCLUDE: 'BWSB\INCLUDE\GDMTYPE.BI'
DEFINT A-Z
TYPE PicData
	Height AS LONG
	Width AS LONG
	Colors AS INTEGER
	ClearColor AS INTEGER
	Seg AS INTEGER
	Offs AS INTEGER
	Handle AS INTEGER
	HandleOffset AS INTEGER
END TYPE
TYPE ParamType
	Current AS SINGLE
	PStart AS SINGLE
	PEnd AS SINGLE
END TYPE
TYPE LibHeaderType
	FileName AS STRING * 12
	Offset AS LONG
	Size AS LONG
END TYPE

DECLARE SUB GetSoundCardInfo ()
DECLARE SUB QTInit ()
DECLARE SUB QTDelay (BYVAL Time)
DECLARE SUB QTSetTimer (BYVAL Channel, BYVAL Time)
DECLARE FUNCTION QTGetTimer (BYVAL Channel)
DECLARE SUB QTDone ()
DECLARE FUNCTION IsXMSInstalled ()
DECLARE FUNCTION AllocateXMS (BYVAL Bytes&)
DECLARE SUB DeallocateXMS (BYVAL Handle)
DECLARE FUNCTION FreeXMSmemory& ()
DECLARE SUB MoveXMS (BYVAL SourceHandle, BYVAL SourceOffset&, BYVAL DestHandle, BYVAL DestOffset&, BYVAL Bytes&)
DECLARE SUB MoveToXMS (BYVAL Handle, BYVAL Segment, BYVAL Offset, BYVAL Bytes&, BYVAL XMSOffset&)
DECLARE SUB MoveFromXMS (BYVAL Handle, BYVAL Segment, BYVAL Offset, BYVAL Bytes&, BYVAL XMSOffset&)

DECLARE SUB LoadBMP (Slot, Handle, HandleOffset, BMPFile$, ClearColor, ColorOffset)
DECLARE SUB LoadBMPFromLib (Slot, Handle, HandleOffset, Lib$, BMPFile$, ClearColor, ColorOffset)
DECLARE SUB RestorePic (Slot, Array() AS STRING * 1)
DECLARE SUB RestorePalette (Pal)
DECLARE SUB SavePalette (Pal)
DECLARE SUB TriFill (BYVAL x1, BYVAL y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, Col)
DECLARE SUB TriGFill (BYVAL x1, BYVAL y1, Col1, BYVAL X2, BYVAL Y2, Col2, BYVAL X3, BYVAL Y3, Col3)
DECLARE SUB Shellsort (Array())
DECLARE SUB sprink (BYVAL X, BYVAL Y, C)
DECLARE SUB FPrint (Text$, X, Y)
DECLARE SUB Parrot (mode)
DECLARE SUB Beefman (mode)
DECLARE SUB Oldskool (mode)
DECLARE SUB FadeToColor (Palett(), BYVAL R, BYVAL G, BYVAL B, BYVAL Percentage AS SINGLE)
DECLARE SUB Line2 (BYVAL A, BYVAL B, BYVAL C, BYVAL D, BYVAL Col)
DECLARE SUB menger (BYVAL X AS SINGLE, BYVAL Y AS SINGLE, BYVAL z AS SINGLE, BYVAL R AS SINGLE)
DECLARE FUNCTION GetLibOffset& (Lib$, File$)

DIM X(0) AS SINGLE, Y(0) AS SINGLE
DIM SHARED VirtScr(0 TO 319, 0 TO 199) AS STRING * 1
DIM SHARED Pic(0, 0) AS STRING * 1
DIM SHARED Palett(0 TO 255, 1 TO 3)
DIM SHARED Pics(60) AS PicData
DIM SHARED Handles(25)
DIM SHARED PalHandle
DIM SHARED PS, PO
CONST Lib$ = "ARF.DAT"

' *** SOUND INIT ***

DIM ModHeader AS GDMHeader
DIM Flags AS INTEGER, MusChans AS INTEGER
DIM Device(6) AS LONG: Device(1) = 0: Device(2) = 12278: Device(3) = 22708: Device(4) = 33155: Device(5) = 44722: Device(6) = 56138
A& = SETMEM(-180000)  ' mem to free for BWSB - adjust as needed
GetSoundCardInfo        ' gets Dev, Port, IRQ, & DMA
'ErrorFlag = LoadMSE("DATA\SOUND.DAT", Device(Dev), 45, 4096, Port, IRQ, DMA)
ErrorFlag = LoadMSE(Lib$, GetLibOffset(Lib$, "SOUND.DAT") - 1 + Device(Dev), 45, 4096, Port, IRQ, DMA)
ERASE Device
Flags = EmsExist AND 1
IF Dev > 1 AND Flags = 0 THEN
	PRINT "EMS is required for a non-GUS soundcard.": END 'StopBanner: END
END IF

' *** XMS INIT, LOAD ***

IF IsXMSInstalled = -1 THEN
	PRINT FreeXMSmemory& \ 1024; "k extended memory detected."
ELSE
	PRINT "Extended memory (XMS) required.": END
END IF

SCREEN 13
LINE (33, 85)-(282, 120), 15, BF
LINE (35, 87)-(280, 118), 0, BF
Size& = 256 * 3 * 2 * 30& ' one handle for all palettes - 256 colors * 3 attributes * 2 byte int * 30 palettes
PalHandle = AllocateXMS(Size&)
LoadBMPFromLib 9, 9, 0, Lib$, "monster1.bmp", 5, 1
LoadBMPFromLib 10, 9, 1, Lib$, "monster2.bmp", 5, 1
DIM Pic1(0, 0) AS STRING * 1, Pic2(0, 0) AS STRING * 1
RestorePic 9, Pic1()
RestorePic 10, Pic2()
FOR L = 0 TO Pics(9).Colors
	OUT &H3C8, L
	FOR M = 1 TO 3: OUT &H3C9, Palett(L, M): NEXT M
NEXT L
DIM SHARED LoadCount
LoadCount = 0

LoadBMPFromLib 1, 1, 0, Lib$, "hello.bmp", 1, 0
SavePalette 1

LoadBMPFromLib 2, 2, 0, Lib$, "intro.bmp", 0, 0
SavePalette 2
LoadBMPFromLib 3, 3, 0, Lib$, "rapline1.bmp", 0, 0
LoadBMPFromLib 4, 4, 0, Lib$, "rapline2.bmp", 0, 0
LoadBMPFromLib 5, 5, 0, Lib$, "rapline3.bmp", 0, 0
SavePalette 3
LoadBMPFromLib 6, 6, 0, Lib$, "noise.bmp", 0, 0
SavePalette 4

LoadBMPFromLib 7, 7, 0, Lib$, "holycrap.bmp", 132, 128
Palett(0, 1) = 50: Palett(0, 2) = 6: Palett(0, 3) = 6
FOR L = 1 TO 63: Palett(L, 1) = L \ 2 + 30: Palett(L, 2) = L / 1.5: Palett(L, 3) = L \ 4: NEXT L
SavePalette 5
LoadBMPFromLib 8, 8, 0, Lib$, "donuts!.bmp", 0, 228
'LoadBMPFromLib 9, 9, 0, Lib$, "monster1.bmp", 5, 1
'LoadBMPFromLib 10, 9, 1, Lib$, "monster2.bmp", 5, 1
LoadBMPFromLib 11, 9, 2, Lib$, "monster3.bmp", 5, 1
LoadBMPFromLib 12, 9, 3, Lib$, "monster4.bmp", 5, 1
LoadBMPFromLib 13, 9, 4, Lib$, "monster5.bmp", 5, 1
LoadBMPFromLib 14, 9, 5, Lib$, "monster6.bmp", 5, 1
Palett(0, 1) = 63: Palett(0, 2) = 40: Palett(0, 3) = 20
FOR L = 0 TO 31
	Palett(L + 32, 1) = L \ 2: Palett(L + 32, 2) = L \ 2: Palett(L + 32, 3) = L \ 2
	Palett(L + 64, 1) = L * 1.5: Palett(L + 64, 2) = L: Palett(L + 64, 3) = 0
	Palett(L + 96, 1) = L * 2: Palett(L + 96, 2) = L * 1.5: Palett(L + 96, 3) = 0
	Palett(L + 128, 1) = 63: Palett(L + 128, 2) = L * 1.5: Palett(L + 128, 3) = L * 1.5
	Palett(L + 160, 1) = INT(RND * 32) + 31: Palett(L + 160, 2) = INT(RND * 32) + 31: Palett(L + 160, 3) = INT(RND * 32) + 31
	Palett(L + 196, 1) = L + 32: Palett(L + 196, 2) = L + 32: Palett(L + 196, 3) = L + 32
NEXT L
SavePalette 6
Palett(0, 1) = 0: Palett(0, 2) = 0: Palett(0, 3) = 0
FOR L = 32 TO 227
	Palett(L, 1) = INT(RND * 63): Palett(L, 2) = INT(RND * 63): Palett(L, 3) = INT(RND * 63)
NEXT L
SavePalette 7

LoadBMPFromLib 17, 10, 0, Lib$, "iconball.bmp", 1, 1
LoadBMPFromLib 15, 11, 0, Lib$, "dc5logo2.bmp", 61 + 128, 128
LoadBMPFromLib 16, 12, 0, Lib$, "letstake.bmp", 240, 240
Palett(0, 1) = 0: Palett(0, 2) = 0: Palett(0, 3) = 10
SavePalette 8
LoadBMPFromLib 18, 10, 1, Lib$, "icondoom.bmp", 32, 1
SavePalette 9
LoadBMPFromLib 19, 10, 2, Lib$, "iconpimp.bmp", 7, 1
SavePalette 10
LoadBMPFromLib 20, 10, 3, Lib$, "icondisk.bmp", 8, 1
SavePalette 11
LoadBMPFromLib 21, 10, 4, Lib$, "keen.bmp", 32, 1
SavePalette 12
LoadBMPFromLib 22, 10, 5, Lib$, "lemon.bmp", 14, 1
SavePalette 13
LoadBMPFromLib 23, 10, 6, Lib$, "dopefish.bmp", 32, 1
SavePalette 14
LoadBMPFromLib 24, 10, 7, Lib$, "star1.bmp", 32, 1
LoadBMPFromLib 25, 10, 8, Lib$, "star2.bmp", 32, 1
LoadBMPFromLib 26, 10, 9, Lib$, "star3.bmp", 32, 1
LoadBMPFromLib 27, 10, 10, Lib$, "star4.bmp", 32, 1
LoadBMPFromLib 28, 10, 11, Lib$, "star5.bmp", 32, 1
LoadBMPFromLib 29, 10, 12, Lib$, "star6.bmp", 32, 1
LoadBMPFromLib 30, 10, 13, Lib$, "star7.bmp", 32, 1
LoadBMPFromLib 31, 10, 14, Lib$, "star8.bmp", 32, 1
LoadBMPFromLib 32, 10, 15, Lib$, "star9.bmp", 32, 1
LoadBMPFromLib 33, 10, 16, Lib$, "star10.bmp", 32, 1
LoadBMPFromLib 34, 10, 17, Lib$, "star11.bmp", 32, 1
LoadBMPFromLib 35, 10, 18, Lib$, "star12.bmp", 32, 1
LoadBMPFromLib 36, 10, 19, Lib$, "star13.bmp", 32, 1
LoadBMPFromLib 37, 10, 20, Lib$, "star14.bmp", 32, 1
LoadBMPFromLib 38, 10, 21, Lib$, "star15.bmp", 32, 1
SavePalette 15

LoadBMPFromLib 40, 14, 0, Lib$, "drama1.bmp", 0, 0
LoadBMPFromLib 41, 14, 1, Lib$, "drama2.bmp", 0, 0
LoadBMPFromLib 42, 14, 2, Lib$, "drama3.bmp", 0, 0
LoadBMPFromLib 43, 14, 3, Lib$, "drama4.bmp", 0, 0
LoadBMPFromLib 44, 14, 4, Lib$, "drama5.bmp", 0, 0
LoadBMPFromLib 45, 14, 5, Lib$, "drama6.bmp", 0, 0
LoadBMPFromLib 46, 14, 6, Lib$, "drama7.bmp", 0, 0
LoadBMPFromLib 47, 14, 7, Lib$, "drama8.bmp", 0, 0
LoadBMPFromLib 48, 14, 8, Lib$, "drama9.bmp", 0, 0
LoadBMPFromLib 39, 13, 0, Lib$, "cgatext.bmp", 254, 254
Palett(0, 1) = 0: Palett(0, 2) = 0: Palett(0, 3) = 0
SavePalette 16

LoadBMPFromLib 49, 15, 0, Lib$, "rap1.bmp", 0, 0
SavePalette 17
LoadBMPFromLib 50, 16, 0, Lib$, "rap2.bmp", 0, 0
SavePalette 18
LoadBMPFromLib 51, 17, 0, Lib$, "rap3.bmp", 0, 0
SavePalette 19

LoadBMPFromLib 52, 18, 0, Lib$, "parrote0.bmp", 0, 0
LoadBMPFromLib 53, 18, 1, Lib$, "parrote2.bmp", 0, 0
SavePalette 21

LoadBMPFromLib 54, 19, 0, Lib$, "beefman1.bmp", 0, 0
LoadBMPFromLib 55, 19, 1, Lib$, "beefman2.bmp", 0, 0
SavePalette 22

'RestorePalette 8
Size& = 256 * 3 * 2&
MoveFromXMS PalHandle, VARSEG(Palett(0, 1)), VARPTR(Palett(0, 1)), Size&, (8 - 1) * Size&

LoadBMPFromLib 60, 24, 0, Lib$, "dc5logo.bmp", 0, 150
FOR L = 131 TO 138
	Palett(L, 1) = 63: Palett(L, 2) = 63: Palett(L, 3) = 63
NEXT L
FOR L = 139 TO 146
	Palett(L, 1) = 63: Palett(L, 2) = 0: Palett(L, 3) = 0
NEXT L
FOR L = 21 TO 43
	Palett(L, 1) = 0: Palett(L, 2) = 0: Palett(L, 3) = L * 2 - 30
NEXT L
LoadBMPFromLib 56, 20, 0, Lib$, "scroll1.bmp", 0, 44
SavePalette 23
LoadBMPFromLib 57, 21, 0, Lib$, "scroll2.bmp", 0, 44
SavePalette 24
LoadBMPFromLib 58, 22, 0, Lib$, "scroll3.bmp", 0, 44
SavePalette 25
LoadBMPFromLib 59, 23, 0, Lib$, "scroll4.bmp", 0, 44
SavePalette 26

ERASE Pic1, Pic2

' ** MUSIC LOAD **

OPEN Lib$ FOR BINARY AS 1
'OPEN "data\arf.gdm" FOR BINARY AS 1
LoadGDM FILEATTR(1, 2), GetLibOffset(Lib$, "ARF.GDM") - 1, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
'LoadGDM FILEATTR(1, 2), 0, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
CLOSE 1
MusChans = 0
FOR J = 1 TO 32                  'Scan for used music channels
  IF ASC(MID$(ModHeader.PanMap, J, 1)) <> &HFF THEN
	 MusChans = MusChans + 1
  END IF
NEXT

OverRate& = StartOutput(MusChans, 0)
StartMusic
L = MusicVolume(52)
IF INSTR(UCASE$(COMMAND$), "GUSEMU") > 0 THEN L = MusicTempo(8)

SCREEN 13
RANDOMIZE TIMER
QTInit
VS = VARSEG(VirtScr(0, 0)): VO = VARPTR(VirtScr(0, 0))

' **STATIC**

DIM S(4000) AS STRING * 1
SS = VARSEG(S(0)): SO = VARPTR(S(0))
FOR L = 1 TO 4000
	S(L) = CHR$(INT(RND * 16))
NEXT L

RestorePic 1, Pic()
RestorePalette 1
PS = Pics(1).Seg: PO = Pics(1).Offs
PH = Pics(1).Height - 1: PW = Pics(1).Width: PCC = Pics(1).ClearColor

QTSetTimer 1, 32767: t2 = 32767: blocks = 1
DIM blockpos(1 TO 16)
FOR L = 1 TO 16: READ blockpos(L): NEXT L
DO
	'CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)

	IF MusicOrder(255) = 0 AND MusicRow = 0 THEN blocks = 1
	IF MusicOrder(255) = 0 AND MusicRow = 16 THEN blocks = 2
	IF MusicOrder(255) = 0 AND MusicRow = 32 THEN blocks = 3
	IF MusicOrder(255) = 0 AND MusicRow = 48 THEN blocks = 4
	IF MusicOrder(255) = 0 AND MusicRow = 52 THEN blocks = 5
	IF MusicOrder(255) = 1 AND MusicRow = 0 THEN blocks = 6
	IF MusicOrder(255) = 1 AND MusicRow = 16 THEN blocks = 7
	IF MusicOrder(255) = 1 AND MusicRow = 32 THEN blocks = 8
	IF MusicOrder(255) = 1 AND MusicRow = 48 THEN blocks = 9
	IF MusicOrder(255) = 1 AND MusicRow = 52 THEN blocks = 10
	IF MusicOrder(255) = 2 AND MusicRow = 0 THEN blocks = 11
	IF MusicOrder(255) = 2 AND MusicRow = 16 THEN blocks = 12
	IF MusicOrder(255) = 2 AND MusicRow = 32 THEN blocks = 13
	IF MusicOrder(255) = 2 AND MusicRow = 48 THEN blocks = 14
	IF MusicOrder(255) = 2 AND MusicRow = 52 THEN blocks = 15
	IF MusicOrder(255) = 3 AND MusicRow = 0 THEN blocks = 16

	FOR k = 1 TO blocks
		X = (blockpos(k) MOD 4) * 80
		Y = (blockpos(k) \ 4) * 50
		FOR L = 0 TO 49
			M = INT(RND * 50)
			CALL BlockMove(SS, SO + M * 80, VS, X + (Y + L) * 320, 80, 0)
		NEXT L
	NEXT k

	IF MusicOrder(255) = 3 AND MusicRow >= 48 THEN
		DEF SEG = PS
		FOR L = 0 TO PH
			POLW = PO + L * PW
			YRow = (40 + L) * 320
			FOR M = 0 TO Pics(1).Width - 1
				IF PEEK(M + POLW) <> PCC THEN
					CALL BlockMove(PS, M + POLW, VS, VO + 60 + M + YRow, 1, 0)
				END IF
			NEXT M
		NEXT L
	END IF

	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	IF INKEY$ = CHR$(27) THEN GOTO TheEnd
LOOP UNTIL MusicOrder(255) = 4

ERASE blockpos, Pic, S

' **INTRO CREDITS**

L = MusicOrder(4)
mode = 0
DIM SHARED duration AS SINGLE
DIM elapsed AS SINGLE
Curve:
CLS
DIM Pic(0, 0) AS STRING * 1
DIM GridX(0 TO 159, 0 TO 139) AS STRING * 1
DIM GridY(0 TO 159, 0 TO 139) AS STRING * 1
GxS = VARSEG(GridX(0, 0)): GxO = VARPTR(GridX(0, 0))
GyS = VARSEG(GridY(0, 0)): GyO = VARPTR(GridY(0, 0))

DEF SEG = &HA000

SELECT CASE mode
CASE 0: P = 2: Pal = 2
CASE 1: P = 3: Pal = 3
CASE 2: P = 4: Pal = 3
CASE 3: P = 5: Pal = 3
CASE 4: P = 6: Pal = 4
END SELECT
RestorePic P, Pic()
RestorePalette Pal
PS = Pics(P).Seg: PO = Pics(P).Offs
PW = Pics(P).Width: PH = Pics(P).Height
	
FOR X = 0 TO 159
IF X > 70 THEN
	 x1 = ((X * 2 - 132) ^ 2) / 600 + 40
ELSE
	 x1 = 40 - (((X * 2 - 162) ^ 2) / 600)
END IF
FOR Y = 0 TO 139
	IF X > 70 THEN
		y1 = ((Y - 80) / (SIN((X * 2 + 20) / 100) + .3) * .16) + 7
	ELSE
		y1 = ((Y - 80) / (SIN((X * 2 - 10) / 80) + .3) * .16) + 7
	END IF
	
	IF x1 >= 0 AND x1 <= 100 AND y1 >= 0 AND y1 <= PH - 1 THEN
		DEF SEG = GxS
		POKE GxO + X + Y * 160, x1
		DEF SEG = GyS
		POKE GyO + X + Y * 160, y1
	END IF
NEXT Y
NEXT X

QTSetTimer 1, 32767
t2 = 32767
SELECT CASE mode
CASE 0: RESTORE CreditsData
CASE 1: RESTORE RapLine1Data
CASE 2: RESTORE RapLine2Data
CASE 3: RESTORE RapLine3Data
CASE 4: RESTORE CurveNoiseData
END SELECT
READ distance1, duration
duration = duration * 1000
distance0 = 0
DO
	IF mode = 4 THEN
		CALL BlockMove(INT(RND * 10000), 0, &HA000, 0, 64000, 0)
	END IF

	t = QTGetTimer(1)
	IF t2 - t >= duration THEN
		distance0 = distance0 + distance1 'distance
		READ distance1, duration
		duration = duration * 1000
		t2 = t
	END IF

	elapsed = (t2 - t) / duration
	distance = distance0 + distance1 * elapsed
	Offs = PO + distance

	FOR Y = 20 TO 119
		YRow = (Y + 30) * 320
		Y160 = Y * 160
		FOR X = 8 TO 152
			IF PEEK(GxO + X + Y160) <> 0 THEN
				DEF SEG = GxS
				p1 = PEEK(GxO + X + Y160)
				DEF SEG = GyS
				p2 = PEEK(GyO + X + Y160)
				P = Offs + p1 + p2 * PW
				CALL BlockMove(PS, P, &HA000, X * 2 + YRow, 1, 0)
				CALL BlockMove(PS, P, &HA000, X * 2 + YRow - 1, 1, 0)
			END IF
	NEXT X, Y
	IF mode = 1 AND MusicRow >= 10 AND MusicRow <= 20 THEN EXIT DO
	IF mode = 2 AND MusicRow >= 28 AND MusicRow <= 38 THEN EXIT DO
	IF mode = 3 AND MusicRow >= 40 THEN EXIT DO
	IF INKEY$ = CHR$(27) THEN GOTO TheEnd
	
	IF (MusicOrder(255) = 4 OR MusicOrder(255) = 5) AND (MusicRow >= 16 AND MusicRow <= 20) THEN
	' flash
		OUT &H3C8, 0: OUT &H3C9, 31 + (20 - MusicRow) * 8: : OUT &H3C9, 31 + (20 - MusicRow) * 8: : OUT &H3C9, 31 + (20 - MusicRow) * 8
		OUT &H3C8, 1: OUT &H3C9, 63: : OUT &H3C9, 45 + (20 - MusicRow) * 4: : OUT &H3C9, 0 + (20 - MusicRow) * 7
	ELSEIF MusicOrder(255) = 7 AND MusicRow >= 60 THEN
	' fade to red
		FadeToColor Palett(), 50, 6, 6, (MusicRow - 59) / 4
		'OUT &H3C8, 0: OUT &H3C9, 31 + (MusicRow - 56) * 4: OUT &H3C9, 31 - (MusicRow - 56) * 3: OUT &H3C9, 31 - (MusicRow - 56) * 3
		'OUT &H3C8, 1: OUT &H3C9, 63: OUT &H3C9, 45 - (MusicRow - 56) * 5: OUT &H3C9, (MusicRow - 56)
	END IF
	
	IF mode = 0 AND MusicOrder(255) = 8 THEN EXIT DO
	IF mode = 4 AND MusicRow >= 56 THEN
		OUT &H3C8, 0: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
		OUT &H3C8, 7: OUT &H3C9, 32: OUT &H3C9, 32: OUT &H3C9, 32
		COLOR 7: LOCATE 10, 10: PRINT " Syntax error ";
		DO: LOOP UNTIL MusicRow >= 60
		LOCATE 20, 20: PRINT " Out of DATA ";
		DO: LOOP UNTIL MusicOrder(255) = 44
		EXIT DO
	END IF
LOOP

CLS
ERASE GridX, GridY, Pic
SELECT CASE mode
CASE 1: GOTO RapLine1Done
CASE 2: GOTO RapLine2Done
CASE 3: GOTO RapLine3Done
CASE 4: GOTO CurveNoiseDone
END SELECT

' ***IT'S A CUBE!***

L = MusicOrder(8)
mode = 0
DIM xrot AS SINGLE, yrot AS SINGLE, zrot AS SINGLE
DIM xrot0 AS SINGLE, yrot0 AS SINGLE, zrot0 AS SINGLE
DIM xrot1 AS SINGLE, yrot1 AS SINGLE, zrot1 AS SINGLE
DIM cosx AS SINGLE, sinx AS SINGLE
DIM cosy AS SINGLE, siny AS SINGLE
DIM cosz AS SINGLE, sinz AS SINGLE
DIM camdist AS SINGLE
DIM SHARED BlankScr(0 TO 319, 0 TO 199) AS STRING * 1
DIM JX AS SINGLE, JY AS SINGLE, JX1 AS SINGLE, JY1 AS SINGLE, JZ1 AS SINGLE

Cube:
DIM Pic(0, 0) AS STRING * 1
RestorePic 7, Pic()
RestorePalette 5
PS = Pics(7).Seg: PO = Pics(7).Offs
PH = Pics(7).Height: PW = Pics(7).Width: PCC = Pics(7).ClearColor

BS = VARSEG(BlankScr(0, 0)): BO = VARPTR(BlankScr(0, 0))
DEF SEG = BS
FOR L = 0 TO 319: FOR M = 0 TO 199: POKE BO + L + M * 320, 0: NEXT M, L
CONST pi = 3.14159

points = 8: faces = 12
REDIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE, rad(points)
DIM F1(faces), F2(faces), F3(faces)
REDIM zavg(faces)
REDIM fsort(faces)
DIM Dx(points), Dy(points)
DIM JZ(points) AS SINGLE
 
X(1) = -60: Y(1) = -60: z(1) = -60
X(2) = -60: Y(2) = 60: z(2) = -60
X(3) = 60: Y(3) = 60: z(3) = -60
X(4) = 60: Y(4) = -60: z(4) = -60
X(5) = -60: Y(5) = -60: z(5) = 60
X(6) = -60: Y(6) = 60: z(6) = 60
X(7) = 60: Y(7) = 60: z(7) = 60
X(8) = 60: Y(8) = -60: z(8) = 60
F1(1) = 1: F2(1) = 2: F3(1) = 3
F1(2) = 1: F2(2) = 3: F3(2) = 4
F1(3) = 5: F2(3) = 6: F3(3) = 7
F1(4) = 5: F2(4) = 7: F3(4) = 8
F1(5) = 1: F2(5) = 5: F3(5) = 6
F1(6) = 1: F2(6) = 2: F3(6) = 6
F1(7) = 3: F2(7) = 7: F3(7) = 8
F1(8) = 3: F2(8) = 4: F3(8) = 8
F1(9) = 1: F2(9) = 4: F3(9) = 8
F1(10) = 1: F2(10) = 5: F3(10) = 8
F1(11) = 2: F2(11) = 3: F3(11) = 7
F1(12) = 2: F2(12) = 6: F3(12) = 7
 
IF mode = 1 THEN
	CALL BlockMove(3000, 0, PS, PO, PH * PW, 0)
END IF

QTSetTimer 1, 32767
RESTORE CubeData
READ Rows
xtrans0 = 0: ytrans0 = 0: ztrans0 = 0: xrot0 = 0: yrot0 = 0: zrot0 = 0
MR0 = -1: MR1 = 0
READ xtrans1, ytrans1, ztrans1
READ xrot1, yrot1, zrot1, transform

DO
	IF mode = 1 THEN
		CALL BlockMove(INT(RND * 10000), 0, BS, BO, 64000, 0)
	END IF
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	MR = MusicRow
	 
	IF MR <> MR0 AND (MR - MR1 >= Rows OR MR = 0) THEN
		xtrans0 = xtrans0 + xtrans1: ytrans0 = ytrans0 + ytrans1: ztrans0 = ztrans0 + ztrans1
		xrot0 = xrot0 + xrot1: yrot0 = yrot0 + yrot1: zrot0 = zrot0 + zrot1
		READ Rows
		duration = Rows * 73.5

		READ xtrans1, ytrans1, ztrans1
		READ xrot1, yrot1, zrot1, transform
		IF transform = 1 THEN
		  x1o = X(1): y1o = Y(1): z1o = z(1)
		  x4o = X(4): y4o = Y(4): z4o = z(4)
		ELSEIF transform = 2 THEN
		  x1o = X(1): y1o = Y(1): z1o = z(1)
		  x2o = X(2): y2o = Y(2): z2o = z(2)
		  x5o = X(5): y5o = Y(5): z5o = z(5)
		ELSEIF transform = 3 THEN
		  x3o = X(3): y3o = Y(3): z3o = z(3)
		  x4o = X(4): y4o = Y(4): z4o = z(4)
		  x6o = X(6): y6o = Y(6): z6o = z(6)
		ELSEIF transform = 4 THEN
		  x1o = X(1): y1o = Y(1): z1o = z(1)
		  x2o = X(2): y2o = Y(2): z2o = z(2)
		  x5o = X(5): y5o = Y(5): z5o = z(5)
		END IF
		t2 = t
		MR1 = MR
	END IF
  
	elapsed = (t2 - t) / duration
	IF elapsed > 1 THEN elapsed = 1
	
	xoffset = xtrans0 + xtrans1 * elapsed
	yoffset = ytrans0 + ytrans1 * elapsed
	camdist = ztrans0 + ztrans1 * elapsed
	xrot = xrot0 + xrot1 * elapsed
	yrot = yrot0 + yrot1 * elapsed
	zrot = zrot0 + zrot1 * elapsed
 
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
 
	IF transform = 1 THEN
		X(1) = x1o + 20 * elapsed
		Y(1) = y1o + 10 * elapsed
		z(1) = z1o + 30 * elapsed
		X(4) = x4o - 20 * elapsed
		Y(4) = y4o + 20 * elapsed
		z(4) = z4o - 15 * elapsed
	ELSEIF transform = 2 THEN
		X(1) = x1o - 35 * elapsed
		Y(1) = y1o - 15 * elapsed
		z(1) = z1o - 20 * elapsed
		X(2) = x2o + 10 * elapsed
		Y(2) = y2o + 25 * elapsed
		z(2) = z2o + 20 * elapsed
		X(5) = x5o - 10 * elapsed
		Y(5) = y5o - 30 * elapsed
		z(5) = z5o - 15 * elapsed
	ELSEIF transform = 3 THEN
		X(3) = x3o + 10 * elapsed
		Y(3) = y3o - 5 * elapsed
		z(3) = z3o + 15 * elapsed
		X(4) = x4o + 5 * elapsed
		Y(4) = y4o - 35 * elapsed
		z(4) = z4o + 20 * elapsed
		X(6) = x6o + 15 * elapsed
		Y(6) = y6o - 10 * elapsed
		z(6) = z6o - 10 * elapsed
	ELSEIF transform = 4 THEN
		X(1) = x1o + 15 * elapsed
		Y(1) = y1o + 5 * elapsed
		z(1) = z1o - 30 * elapsed
		X(2) = x2o - 20 * elapsed
		Y(2) = y2o - 20 * elapsed
		z(2) = z2o + 5 * elapsed
		X(5) = x5o + 20 * elapsed
		Y(5) = y5o + 25 * elapsed
		z(5) = z5o + 20 * elapsed
	END IF
 
	FOR P = 1 TO points
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		Dx(P) = (-JX * 150) / (JZ(P) + camdist) + xoffset
		Dy(P) = (-JY * 125) / (JZ(P) + camdist) + yoffset
	NEXT P
	FOR L = 1 TO faces STEP 2
		fsort(L) = L
		fsort(L + 1) = L + 1
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L)) + JZ(F1(L + 1)) + JZ(F2(L + 1)) + JZ(F3(L + 1))) / 6
		zavg(L + 1) = zavg(L)
	NEXT
	Shellsort zavg()
	IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS
	FOR L = faces / 1 TO 1 STEP -1
		M = fsort(L)
		TriGFill Dx(F1(M)), Dy(F1(M)), 21 - JZ(F1(M)) / 3, Dx(F2(M)), Dy(F2(M)), 21 - JZ(F2(M)) / 3, Dx(F3(M)), Dy(F3(M)), 21 - JZ(F3(M)) / 3
	NEXT L
 
	IF MR0 <> MR THEN
	SELECT CASE MR
		CASE 1, 17, 33, 49, 53
			'OUT &H3C8, 0: OUT &H3C9, 58: OUT &H3C9, 24: OUT &H3C9, 24
			FOR L = 0 TO 255
				OUT &H3C8, L
				FOR M = 1 TO 3
					A = Palett(L, M) * 2
					IF A > 63 THEN A = 63
					OUT &H3C9, A
			NEXT M, L
		CASE 0, 2, 16, 18, 32, 34, 48, 50, 52, 54
			FOR L = 0 TO 255
				OUT &H3C8, L
				FOR M = 1 TO 3
					A = Palett(L, M) * 1.5
					IF A > 63 THEN A = 63
					OUT &H3C9, A
			NEXT M, L
			'OUT &H3C8, 0: OUT &H3C9, 54: OUT &H3C9, 15: OUT &H3C9, 15
		CASE 3, 19, 35, 51, 55
			RestorePalette 5
			'OUT &H3C8, 0: OUT &H3C9, 50: OUT &H3C9, 6: OUT &H3C9, 6
	END SELECT
	END IF

	DEF SEG = PS

	FOR L = 0 TO PH - 1
		POLW = PO + L * PW
		YRow = (yoffset - 30 + L) * 320
		IF yoffset - 30 + L >= 0 AND yoffset - 30 + L < 200 THEN
		FOR M = 0 TO PW - 1
			xoffs = xoffset - 150 + M
			IF xoffs >= 0 AND xoffs < 320 THEN
			IF PEEK(M + POLW) <> PCC AND (xoffset - 150 + M) >= 0 THEN
				CALL BlockMove(PS, M + POLW, VS, VO + xoffs + YRow, 1, 0)
			END IF
			END IF
		NEXT M
		END IF
	NEXT L
  
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	MR0 = MR
	IF INKEY$ = CHR$(27) THEN GOTO TheEnd
	IF MusicOrder(255) = 12 THEN EXIT DO
	IF MusicOrder(255) = 11 AND MusicRow >= 58 THEN
		FadeToColor Palett(), 63, 42, 20, (MusicRow - 57) / 6
	ELSEIF mode = 1 AND MusicRow >= 56 THEN
		OUT &H3C8, 7: OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
		COLOR 7: LOCATE 10, 10: PRINT " Illegal function call ";
		DO: LOOP UNTIL MusicOrder(255) = 42
		EXIT DO
	END IF

LOOP

CLS
ERASE Pic

' *** DONUTS ***

IF mode = 0 THEN L = MusicOrder(12)
DIM Pic1(0, 0) AS STRING * 1
DIM Pic2(0, 0) AS STRING * 1
DIM Pic3(0, 0) AS STRING * 1
DIM Pic4(0, 0) AS STRING * 1
DIM Pic5(0, 0) AS STRING * 1
DIM Pic6(0, 0) AS STRING * 1

DEF SEG = BS
FOR Y = 0 TO 199
	YRow = Y * 320
	FOR X = 0 TO 319: POKE BO + X + YRow, 0: NEXT X
NEXT Y
points = 144: faces = 288
donuts = 9
REDIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE, rad(points)
REDIM F1(faces), F2(faces), F3(faces)
REDIM zavg(faces)
REDIM fsort(faces)
REDIM Dx(points), Dy(points)
REDIM JZ(points) AS SINGLE
REDIM camdist(donuts) AS SINGLE
REDIM xoffset(donuts), yoffset(donuts)
DIM toffs(donuts), dcolor(donuts)
DIM sprinkle(points), frosting(points)

RESTORE DonutsData
FOR L = 1 TO donuts
	READ camdist(L), xoffset(L), yoffset(L), toffs(L), dcolor(L)
NEXT L

tr = 40: rr = 20    ' torus radius, ring radius

IF mode = 0 THEN
	RestorePalette 6
ELSEIF mode = 1 THEN
	RestorePalette 7
END IF

FOR P = 1 TO points
	rang! = ((P - 1) \ 12) / (12 / (pi * 2))  ' ring angle
	rx! = COS(rang!) * tr
	ry! = SIN(rang!) * tr
	dang! = (P MOD 12) / (12 / (pi * 2))      ' dot angle
	X(P) = rx! + (rr * COS(dang!) * COS(rang!))
	Y(P) = ry! + (rr * COS(dang!) * SIN(rang!))
	z(P) = rr * SIN(dang!)

	IF P < points - 11 THEN
		F1(P * 2) = P
		F2(P * 2) = P + (SGN(P MOD 12) * 12) - 11 'p+1 or p-15
		F3(P * 2) = P + 12
		F1(P * 2 - 1) = P + (SGN(P MOD 12) * 12) - 11
		F2(P * 2 - 1) = P + 12
		F3(P * 2 - 1) = P + (SGN(P MOD 12) * 12) + 1 'p+17 or p+1
	END IF
	IF P MOD 12 > 6 THEN
	 sprinkle(P) = INT(RND * 32) + 160
	 frosting(P) = 1
	ELSE
	 sprinkle(P) = 0
	 frosting(P) = 0
	END IF

NEXT P
FOR P = points - 11 TO points
	F1(P * 2) = P
	F2(P * 2) = P + (SGN(P MOD 12) * 12) - 11 'p+1 or p-15
	F3(P * 2) = ((P - 1) MOD 12) + 1
	F1(P * 2 - 1) = P + (SGN(P MOD 12) * 12) - 11 'p+1 or p-15
	F2(P * 2 - 1) = ((P - 1) MOD 12) + 1
	F3(P * 2 - 1) = ((P - 1) MOD 12) + (SGN(P MOD 12) * 12) - 10 'p-14 or p+2
NEXT P

RestorePic 8, Pic()

PS = Pics(8).Seg: PO = Pics(8).Offs
PH = Pics(8).Height: PW = Pics(8).Width
FOR Y = 0 TO PH - 1
CALL BlockMove(PS, PO + Y * PW, BS, BO + 200 + Y * 320, PW, 0)
NEXT Y

RestorePic 9, Pic1()
RestorePic 10, Pic2()
RestorePic 11, Pic3()
RestorePic 12, Pic4()
RestorePic 13, Pic5()
RestorePic 14, Pic6()
PH = Pics(9).Height: PW = Pics(9).Width: PCC = Pics(9).ClearColor

QTSetTimer 1, 32767
IF mode = 0 THEN RESTORE MonsterData ELSE RESTORE MonsterData2
READ Sprite, direction, distance, duration
duration = duration * 1000
t2 = 32767
spritex0 = 320: spritey = 0
IF mode = 1 THEN
	CALL BlockMove(3000, 0, BS, BO, 64000, 0)
END IF

DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t1 = QTGetTimer(1)

	IF t2 - t1 >= duration THEN
		spritex0 = spritex0 + distance
		READ Sprite, direction, distance, duration
		duration = duration * 1000
		t2 = t1
	END IF

	elapsed = (t2 - t1) / duration
	spritex = spritex0 + distance * elapsed
	IF mode = 1 THEN
		spritey = spritey + ABS(distance * elapsed)
		IF spritey >= 150 THEN spritey = 0
	END IF

	FOR D = 1 TO donuts
	IF mode = 0 THEN
	 yoffset = yoffset(D) + (32767 - t1) / 18
	ELSEIF mode = 1 THEN
	 yoffset = yoffset(D) + (32767 - t1) / 9
	END IF
	 IF yoffset > -50 AND yoffset < 250 THEN
		  t = t1 - toffs(D) * 1000
		  xrot = t / 1300
		  yrot = t / 1300
		  zrot = t / 2200
		  'IF t = 0 THEN QTSetTimer 1, 32767   ' only lasts 32.7 seconds :/
		  cosx = COS(xrot): sinx = SIN(xrot)
		  cosy = COS(yrot): siny = SIN(yrot)
		  cosz = COS(zrot): sinz = SIN(zrot)
		  FOR P = 1 TO points
				' x-axis rotate
				JY1 = cosx * Y(P) - sinx * z(P)
				JZ1 = sinx * Y(P) + cosx * z(P)
				' y-axis rotate
				JX1 = siny * JZ1 + cosy * X(P)
				JZ(P) = cosy * JZ1 - siny * X(P)
				' z-axis rotate
				JX = cosz * JX1 - sinz * JY1
				JY = sinz * JX1 + cosz * JY1
				' map 3d to 2d
				Dx(P) = (-JX * 150) / (JZ(P) + camdist(D)) + xoffset(D)
				Dy(P) = (-JY * 125) / (JZ(P) + camdist(D)) + yoffset
		  NEXT P
		  FOR L = 1 TO faces
				fsort(L) = L
				zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L))) / 3
		  NEXT
		  Shellsort zavg()
		  IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS
		  dc = dcolor(D) * 32 + 16
		  IF dcolor(D) = 1 THEN
			FOR L = faces / 1.1 TO 1 STEP -1
				M = fsort(L)
				TriGFill Dx(F1(M)), Dy(F1(M)), frosting(F1(M)) * 32 + dc - JZ(F1(M)) / 6, Dx(F2(M)), Dy(F2(M)), frosting(F2(M)) * 32 + dc - JZ(F2(M)) / 6, Dx(F3(M)), Dy(F3(M)), frosting(F3(M)) * 32 + dc - JZ(F3(M)) / 6
			NEXT L
		  ELSEIF dcolor(D) = 3 THEN
			FOR L = faces / 1.1 TO 1 STEP -1
				M = fsort(L)
				TriGFill Dx(F1(M)), Dy(F1(M)), frosting(F1(M)) * 32 + dc - JZ(F1(M)) / 6, Dx(F2(M)), Dy(F2(M)), frosting(F1(M)) * 32 + dc - JZ(F2(M)) / 6, Dx(F3(M)), Dy(F3(M)), frosting(F1(M)) * 32 + dc - JZ(F3(M)) / 6
				IF (L AND 1 = 1) THEN
					IF sprinkle(F1(M)) <> 0 THEN sprink Dx(F1(M)), Dy(F1(M)), sprinkle(F1(M))
					IF sprinkle(F2(M)) <> 0 THEN sprink Dx(F2(M)), Dy(F2(M)), sprinkle(F2(M))
					IF sprinkle(F3(M)) <> 0 THEN sprink Dx(F3(M)), Dy(F3(M)), sprinkle(F3(M))
				END IF
			NEXT L
		  ELSE
			FOR L = faces / 1.1 TO 1 STEP -1
				M = fsort(L)
				TriGFill Dx(F1(M)), Dy(F1(M)), dc - JZ(F1(M)) / 6, Dx(F2(M)), Dy(F2(M)), dc - JZ(F2(M)) / 6, Dx(F3(M)), Dy(F3(M)), dc - JZ(F3(M)) / 6
			NEXT L
		  END IF
	 END IF
	NEXT D

	PS = Pics(Sprite + 8).Seg: PO = Pics(Sprite + 8).Offs: DEF SEG = PS
	IF direction = 1 THEN
		FOR Y = 0 TO PH - 1
			FOR X = 0 TO PW - 1
			IF (spritex + X < 320) AND (PEEK(PO + X + Y * PW) <> PCC) THEN
				CALL BlockMove(PS, PO + X + Y * PW, VS, VO + spritex + X + (Y - spritey + 150) * 320, 1, 0)
			END IF
		NEXT X, Y
	ELSE
		FOR Y = 0 TO PH - 1
			FOR X = PW - 1 TO 0 STEP -1
			IF (spritex + (PW - X) < 320) AND (PEEK(PO + X + Y * PW) <> PCC) THEN
				CALL BlockMove(PS, PO + X + Y * PW, VS, VO + spritex + (PW - X - 1) + (Y - spritey + 150) * 320, 1, 0)
			END IF
		NEXT X, Y
	END IF

	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	IF INKEY$ = CHR$(27) THEN GOTO TheEnd
	IF mode = 0 AND MusicOrder(255) = 16 THEN EXIT DO
	IF mode = 1 AND MusicRow >= 56 THEN
		OUT &H3C8, 0: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
		OUT &H3C8, 7: OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
		COLOR 7: LOCATE 10, 10: PRINT " Out of memory ";
		DO: LOOP UNTIL MusicOrder(255) = 43
		EXIT DO
	END IF

LOOP

ERASE toffs, dcolor, sprinkle, frosting, Pic
IF mode = 1 THEN
	ERASE Pic1, Pic2, Pic3, Pic4, Pic5, Pic6
	GOTO DonutsDone
END IF

' ** PSYCHO WARP/SPIKE DONUT **
L = MusicOrder(16)
DIM Param(11) AS ParamType
points = 256: faces = 512
REDIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE, rad(points)
REDIM F1(faces), F2(faces), F3(faces), fcolor(faces)
REDIM zavg(faces)
REDIM fsort(faces)
REDIM Dx(points), Dy(points)
REDIM JZ(points) AS SINGLE

DEF SEG = BS
FOR Y = 0 TO 199
	YRow = Y * 320
	FOR X = 0 TO 319: POKE BO + X + YRow, 0: NEXT X
NEXT Y
DEF SEG = VS

OUT &H3C8, 0: OUT &H3C9, 10: OUT &H3C9, 0: OUT &H3C9, 0
FOR L = 0 TO 63
	OUT &H3C8, L + 64
	OUT &H3C9, L \ 2 + 32: OUT &H3C9, L: OUT &H3C9, 0
	OUT &H3C8, L + 128
	OUT &H3C9, 63 - L: OUT &H3C9, 0: OUT &H3C9, L \ 2 + 32
NEXT L

tr = 90: rr = 30    ' torus radius, ring radius

FOR P = 1 TO points
	rang! = ((P - 1) \ 16) / (16 / (pi * 2))  ' ring angle
	rx! = COS(rang!) * tr
	ry! = SIN(rang!) * tr
	dang! = (P MOD 16) / (16 / (pi * 2))      ' dot angle
	X(P) = rx! + (rr * COS(dang!) * COS(rang!))
	Y(P) = ry! + (rr * COS(dang!) * SIN(rang!))
	z(P) = rr * SIN(dang!)

	IF P < points - 15 THEN
		F1(P * 2) = P
		F2(P * 2) = P + (SGN(P MOD 16) * 16) - 15 'p+1 or p-15
		F3(P * 2) = P + 16
		fcolor(P * 2) = 86
		F1(P * 2 - 1) = P + (SGN(P MOD 16) * 16) - 15
		F2(P * 2 - 1) = P + 16
		F3(P * 2 - 1) = P + (SGN(P MOD 16) * 16) + 1 'p+17 or p+1
		fcolor(P * 2 - 1) = 150
	END IF
NEXT P
FOR P = points - 15 TO points
	F1(P * 2) = P
	F2(P * 2) = P + (SGN(P MOD 16) * 16) - 15 'p+1 or p-15
	F3(P * 2) = ((P - 1) MOD 16) + 1
	fcolor(P * 2) = 86
	F1(P * 2 - 1) = P + (SGN(P MOD 16) * 16) - 15 'p+1 or p-15
	F2(P * 2 - 1) = ((P - 1) MOD 16) + 1
	F3(P * 2 - 1) = ((P - 1) MOD 16) + (SGN(P MOD 16) * 16) - 14 'p-14 or p+2
	fcolor(P * 2 - 1) = 150
NEXT P

QTSetTimer 1, 32767
t2 = 32767
RESTORE DonutData
READ Rows: duration = Rows * 73.5
FOR L = 1 TO 11: Param(L).PStart = 0: READ Param(L).PEnd: NEXT L
MR1 = 0: MR0 = -1
spritex0 = spritex: Sprite = 1: distance = 200

DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	MR = MusicRow
	
	IF t > 31767 THEN
		OUT &H3C8, 0: OUT &H3C9, 10 + ((t - 31767) \ 20): OUT &H3C9, (t - 31767) \ 16: OUT &H3C9, (t - 31767) \ 16
	END IF
	
	IF MR <> MR0 AND (MR - MR1 >= Rows OR MR = 0) THEN 't2 - t >= duration THEN
		FOR L = 1 TO 11: Param(L).PStart = Param(L).PStart + Param(L).PEnd: NEXT L
		READ Rows
		duration = Rows * 73.5
		FOR L = 1 TO 11: READ Param(L).PEnd: NEXT L
		t2 = t: MR1 = MR
	END IF

	elapsed = (t2 - t) / duration
	FOR L = 1 TO 11
	 Param(L).Current = Param(L).PStart + Param(L).PEnd * elapsed
	NEXT L
	
	IF MusicOrder(255) = 16 AND MR < 16 THEN
		spritex = spritex0 + distance * elapsed
	END IF

	xoffset = Param(1).Current
	yoffset = Param(2).Current
	camdist = Param(3).Current
	xrot = Param(4).Current
	yrot = Param(5).Current
	zrot = Param(6).Current

	FOR P = 1 TO points
	 rang! = ((P - 1) \ 16) / (16 / (pi * 2))  ' ring angle
	 tr2 = tr * (COS(rang! * Param(11).Current) * Param(10).Current + 1)
	 rx! = COS(rang!) * tr2
	 ry! = SIN(rang!) * tr2
	 dang! = (P MOD 16) / (16 / (pi * 2))      ' dot angle
	 rr2 = rr * (COS(rang! * Param(9).Current) * Param(8).Current + 1)
	 IF (P AND 1) = 0 AND ((P \ 16) AND 1) = 0 THEN
		  rr2 = rr2 * Param(7).Current   'spike
	 END IF
	 X(P) = rx! + (rr2 * COS(dang!) * COS(rang!))
	 Y(P) = ry! + (rr2 * COS(dang!) * SIN(rang!))
	 z(P) = rr2 * SIN(dang!)
	NEXT P

	'IF t = 0 THEN QTSetTimer 1, 32767   ' only lasts 32.7 seconds :/
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		Dx(P) = (-JX * 150) / (JZ(P) + camdist) + xoffset
		Dy(P) = (-JY * 125) / (JZ(P) + camdist) + yoffset
	NEXT P
	FOR L = 1 TO faces
		fsort(L) = L
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L))) / 4
	NEXT
	Shellsort zavg()
	FOR L = faces / 1.1 TO 1 STEP -1
		M = fsort(L)
		TriFill Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), fcolor(M) - zavg(L) / 3
	NEXT L

	IF MR <> MR0 THEN
	SELECT CASE MR
		CASE 0, 16, 32, 48, 52
			OUT &H3C8, 0: OUT &H3C9, 50: OUT &H3C9, 30: OUT &H3C9, 30
		CASE 1, 17, 33, 49, 53
			OUT &H3C8, 0: OUT &H3C9, 25: OUT &H3C9, 15: OUT &H3C9, 15
		CASE 2, 18, 34, 50, 54
			OUT &H3C8, 0: OUT &H3C9, 10: OUT &H3C9, 0: OUT &H3C9, 0
	END SELECT
	END IF
	
	IF MusicOrder(255) = 16 AND MR < 16 THEN
		PS = Pics(9).Seg: PO = Pics(9).Offs: DEF SEG = PS
		FOR Y = 0 TO PH - 1
		FOR X = 0 TO PW - 1
		IF (spritex + X < 320) AND (PEEK(PO + X + Y * PW) <> PCC) THEN
			CALL BlockMove(PS, PO + X + Y * PW, VS, VO + spritex + X + (Y - spritey + 150) * 320, 1, 0)
		END IF
		NEXT X, Y
		DEF SEG = VS
	END IF


	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	A$ = INKEY$
	IF A$ = CHR$(27) THEN GOTO TheEnd
	MR0 = MR
LOOP UNTIL MusicOrder(255) = 20 'LEN(A$)

ERASE Pic1, Pic2, Pic3, Pic4, Pic5, Pic6, Pic, Param, rad, F1, F2, F3, fcolor, JZ, Dx, Dy

' ** STARFIELDS **
L = MusicOrder(20)
DIM Sprite1(0, 0) AS STRING * 1
DIM Sprite2(0, 0) AS STRING * 1
DIM Sprite3(0, 0) AS STRING * 1
DIM Sprite4(0, 0) AS STRING * 1
DIM Sprite5(0, 0) AS STRING * 1
DIM Sprite6(0, 0) AS STRING * 1
DIM Sprite7(0, 0) AS STRING * 1
DIM Sprite8(0, 0) AS STRING * 1
DIM Sprite9(0, 0) AS STRING * 1
DIM Sprite10(0, 0) AS STRING * 1
DIM Sprite11(0, 0) AS STRING * 1
DIM Sprite12(0, 0) AS STRING * 1
DIM Sprite13(0, 0) AS STRING * 1
DIM Sprite14(0, 0) AS STRING * 1
DIM Sprite15(0, 0) AS STRING * 1
DIM Sprite16(0, 0) AS STRING * 1
DIM Sprite17(0, 0) AS STRING * 1
DIM Sprite18(0, 0) AS STRING * 1
DIM Sprite19(0, 0) AS STRING * 1
DIM Sprite20(0, 0) AS STRING * 1
DIM Sprite21(0, 0) AS STRING * 1
DIM Sprite22(0, 0) AS STRING * 1

DIM Logo(0, 0) AS STRING * 1  ', LogoD AS PicData
DIM Pic(0, 0) AS STRING * 1

points = 150
REDIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
DIM Dsx(points) AS SINGLE, Dsy(points) AS SINGLE
DIM IZ(points)
REDIM fsort(points)

'DEF SEG = BS
'FOR Y = 0 TO 199: FOR X = 0 TO 319: POKE BO + X + Y * 320, 0: NEXT X, Y

RestorePic 17, Sprite1()
RestorePic 18, Sprite2()
RestorePic 19, Sprite3()
RestorePic 20, Sprite4()
RestorePic 21, Sprite5()
RestorePic 22, Sprite6()
RestorePic 23, Sprite7()
RestorePic 24, Sprite8()
RestorePic 25, Sprite9()
RestorePic 26, Sprite10()
RestorePic 27, Sprite11()
RestorePic 28, Sprite12()
RestorePic 29, Sprite13()
RestorePic 30, Sprite14()
RestorePic 31, Sprite15()
RestorePic 32, Sprite16()
RestorePic 33, Sprite17()
RestorePic 34, Sprite18()
RestorePic 35, Sprite19()
RestorePic 36, Sprite20()
RestorePic 37, Sprite21()
RestorePic 38, Sprite22()
RestorePic 15, Logo()
RestorePic 16, Pic()

LogoS = Pics(15).Seg: LogoO = Pics(15).Offs
LogoW = Pics(15).Width: LogoH = Pics(15).Height: LogoCC = Pics(15).ClearColor
'PS = VARSEG(Pic(0, 0)): PO = VARPTR(Pic(0, 0))
PS = Pics(16).Seg: PO = Pics(16).Offs
PW = Pics(16).Width: PH = Pics(16).Height: PCC = Pics(16).ClearColor

camdist = 250: xoffset = 160: yoffset = 100

FOR P = 1 TO points
	X(P) = RND * 500 - 250: Y(P) = RND * 500 - 250: z(P) = RND * 500 - 250
NEXT P

QTSetTimer 1, 32767
t0 = 32767: t1 = 32767
RESTORE StarData
READ sprset, toffs, Rows
'duration = rows * 73.5
toffs = toffs * 1000
RestorePalette 8

MR0 = 0: MR1 = 0
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	MR = MusicRow

	IF MR <> MR0 AND (MR - MR1 > Rows OR MR = 0) THEN
		READ sprset, toffs, Rows
		toffs = toffs * 1000 ': duration = rows * 73.5
		t1 = t
		RestorePalette sprset + 7
		MR1 = MR
	END IF

	IF sprset = 8 THEN
		Sprite = ((t \ 100) MOD 15) + 8
	ELSE Sprite = sprset
	END IF
	SS = Pics(Sprite + 16).Seg: SO = Pics(Sprite + 16).Offs: CC = Pics(Sprite + 16).ClearColor
	DEF SEG = SS

	xoff! = (t0 - t) / 3
	xrot = (t - toffs) / 1500
	yrot = (t - toffs) / 1500
	zrot = (t - toffs) / 2500
	'IF t = 0 THEN QTSetTimer 1, 32767   ' only lasts 32.7 seconds :/
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		X(P) = X(P) - xoff!: IF X(P) < -250 THEN X(P) = X(P) + 500
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		IZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		Dsx(P) = (-JX * 150) / (.01 + IZ(P) + camdist) + xoffset
		Dsy(P) = (-JY * 125) / (.01 + IZ(P) + camdist) + yoffset
	NEXT P
	FOR P = 1 TO points: fsort(P) = P: NEXT P
	Shellsort IZ()
	
	FOR P = points TO points * .3 STEP -1
		M = fsort(P)
		Dx = Dsx(M): Dy = Dsy(M)
		Sc = 1
		IF IZ(P) > 125 THEN Sc = 2
		IF IZ(P) > 225 THEN Sc = 3
		IF Dx >= 0 AND Dx < 300 AND Dy >= 0 AND Dy < 180 THEN
			FOR Y = 0 TO 15 STEP Sc
				SOL16 = SO + Y * 16
				YRow = (Dy + Y) * 320
				FOR X = 0 TO 15 STEP Sc
				IF PEEK(X + SOL16) <> CC THEN
					CALL BlockMove(SS, X + SOL16, VS, VO + Dx + X + YRow, 1, 0)
				END IF
				NEXT X
			NEXT Y
		END IF
	NEXT P

	
	DEF SEG = LogoS
	FOR Y = 0 TO LogoH - 1
		SOL16 = LogoO + Y * LogoW
		YRow = (145 + Y) * 320
		FOR X = 0 TO LogoW - 1
		IF PEEK(X + SOL16) <> LogoCC THEN
			CALL BlockMove(LogoS, X + SOL16, VS, VO + 225 + X + YRow, 1, 0)
		END IF
	NEXT X, Y

	IF (MusicOrder(255) < 24 OR MR <= 3) AND MR <> MR0 THEN
	SELECT CASE MR
		CASE 0, 16, 32, 48, 52
			OUT &H3C8, 0: OUT &H3C9, 32: OUT &H3C9, 32: OUT &H3C9, 63
		CASE 1, 17, 33, 49, 53
			OUT &H3C8, 0: OUT &H3C9, 16: OUT &H3C9, 16: OUT &H3C9, 35
		CASE 3, 19, 35, 51, 55
			OUT &H3C8, 0: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 10
	END SELECT
	END IF

	IF MusicOrder(255) = 24 AND MusicRow >= 4 THEN
		DEF SEG = PS
		FOR L = 0 TO PH - 1
			POLW = PO + L * PW
			YRow = L * 320
			FOR M = 0 TO PW - 1
				IF PEEK(M + POLW) <> PCC THEN
					CALL BlockMove(PS, M + POLW, VS, VO + M + YRow, 1, 0)
				END IF
			NEXT M
		NEXT L
		IF MusicRow > 48 THEN
			FadeToColor Palett(), 63, 63, 63, (MusicRow - 48) / 16
		END IF
	END IF
	
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	t0 = t: MR0 = MR
	IF INKEY$ = CHR$(27) THEN GOTO TheEnd
	
LOOP UNTIL MusicOrder(255) = 25

CLS

ERASE Dsx, Dsy, IZ
ERASE Sprite1, Sprite2, Sprite3, Sprite4, Sprite5, Sprite6, Sprite7, Sprite8
ERASE Sprite9, Sprite10, Sprite11, Sprite12, Sprite13, Sprite14, Sprite15
ERASE Sprite16, Sprite17, Sprite18, Sprite19, Sprite20, Sprite21, Sprite22
ERASE Logo, Pic

' **GREETS**
L = MusicOrder(25)
mode = 0

Greets:
'DEF SEG = BS
'FOR Y = 0 TO 199: FOR X = 0 TO 319: POKE BO + X + Y * 320, 0: NEXT X, Y
DIM SHARED Font(0, 0) AS STRING * 1

IF mode = 0 THEN
	RestorePalette 16
ELSE
	OUT &H3C8, 255: OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
END IF
RestorePic 39, Font()

L = 0
RESTORE GreetsData
DIM Text$(25)

Rows = 0: t0 = 32767: tv = 0: MR1 = 0 'duration = 0
DO
	' "vid" mode
	t = QTGetTimer(1)
	MR = MusicRow
	IF tv = 1 OR mode = 1 THEN
		IF mode = 1 THEN
			X = INT(RND * 9) + 1
		ELSEIF MR > 44 AND MR <= 52 THEN
			X = (((t + 300) \ 65) MOD 9) + 1
		ELSE
			X = ((t \ 131) MOD 9) + 1
		END IF
		IF X <> X0 THEN
			MoveFromXMS Handles(14), BS, BO, 64000, 64000 * (9 - X)
			CALL BlockMove(BS, BO, VS, VO, 64000, 0)
		END IF
		X0 = X
	END IF

	' read new text line when duration expires
	IF MR <> MR1 AND (MR - MR1 >= Rows OR MR = 0) THEN
	
		L = L + 1
		READ S$, Rows
		IF mode = 1 THEN
			FOR M = 1 TO LEN(S$)
				X = ASC(MID$(S$, M, 1)) + INT(RND * 30)
				IF X > 127 THEN X = 32
				MID$(S$, M, 1) = CHR$(X)
			NEXT M
			Rows = 1
		END IF
		
		IF L > 25 THEN
			FOR M = 1 TO 24
				Text$(M) = Text$(M + 1)
			NEXT M
			Text$(25) = S$
		ELSE
			Text$(L) = S$
		END IF
		
		MR1 = MR
	END IF

	' reprint text and copy virt screen every loop
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	FOR M = 1 TO L
		IF M > 25 THEN EXIT FOR
		FPrint Text$(M), 0, (M - 1) * 8
	NEXT M
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)

	' change palette when drama vid starts
	IF (mode = 1 OR MusicOrder(255) = 27) AND tv = 0 THEN
		tv = 1
		QTSetTimer 1, 32500
	END IF
	IF MusicOrder(255) = 31 AND tv = 1 THEN
		DEF SEG = BS
		OUT &H3C8, 0: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
		FOR Y = 0 TO 199
			YRow = Y * 320
			FOR X = 0 TO 319: POKE BO + X + YRow, 0: NEXT X
		NEXT Y
		tv = 0
	END IF
	IF INKEY$ = CHR$(27) THEN GOTO TheEnd
	IF mode = 0 AND MusicOrder(255) = 32 THEN EXIT DO
	IF mode = 1 AND MusicOrder(255) = 45 THEN EXIT DO
LOOP

ERASE Font, Text$
IF mode = 1 THEN GOTO GreetsDone

' ** RAP **
Rap:
'L = MusicOrder(32)
' dr sbaitso, strictly 8 bit
RestorePalette 17
MoveFromXMS Handles(15), &HA000, 0, 64000, 0
DO: LOOP UNTIL MusicRow >= 28
'ShowBMP "data\rap1.bmp"

' can't stand fake shit
Parrot 1

' get blazed then i get your bitch nake ed
mode = 1
GOTO Curve
RapLine1Done:

' i stick it, plahw through it, screw it
Beefman 1

' kick it, get cash like jews do it
Parrot 2

' i'm the bomb like o sama, no drama
' flip the script, (scratch) kick a bitch!
Oldskool 1

' break them down till they trick it and lick it
mode = 2
GOTO Curve
RapLine2Done:

' broke bitches get lipstick all over my dick tip
Parrot 3

' s, b, ay, i, t, s, o
RestorePalette 18
MoveFromXMS Handles(16), &HA000, 0, 64000, 0
DO: LOOP UNTIL MusicRow >= 30

' the mack on the track with them trees and that XO
Oldskool 2

' twenty eights on the lexo
Beefman 2

' homie, let's go.
mode = 3
GOTO Curve
RapLine3Done:

' i just let these effects go
Parrot 4

' i'm a! veteran, fucker, you still in a stroller
Beefman 3

' send your bitch ass home with some plasmas and scrollers
Oldskool 3

' fuck what you know, eat a dick, i ain't lyin'
Parrot 5

' lit off cherry wine in oh nine
RestorePalette 19
MoveFromXMS Handles(17), &HA000, 0, 64000, 0
DO: LOOP UNTIL MusicOrder(255) = 40

' **GLITCHES**
' oldskool - scroller becomes noise, 1 second repeat screen - error

L = MusicOrder(40)
Oldskool 4

' cube - noise background, random x/y/z shifts
L = MusicOrder(41)
mode = 1
GOTO Cube

' donuts - random palette (still gouraud), big monster, random sprite changes, loop across screen, error
' mode is still 1, still back at previous code
DonutsDone:

' curve scroll - random dot scroll, noise background, error
L = MusicOrder(43)
mode = 4
GOTO Curve
CurveNoiseDone:

' greets - random text, random drama sprite, error lines
L = MusicOrder(44)
mode = 1
GOTO Greets
GreetsDone:

' errors.bas, end
L = MusicOrder(45)
OUT &H3C8, 0: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
OUT &H3C8, 7: OUT &H3C9, 32: OUT &H3C9, 32: OUT &H3C9, 32
errc = 54
CONST hidden$ = "stargazer"
hiddenchar = 0
DIM errors$(errc)
OPEN Lib$ FOR INPUT AS 1
SEEK 1, GetLibOffset(Lib$, "errors.txt")
FOR L = 1 TO errc
	LINE INPUT #1, errors$(L)
NEXT
CLOSE 1
'CLS
DO
	X = INT(RND * 40) + 1: Y = INT(RND * 24) + 1
	er = INT(RND * errc) + 1
	COLOR 7  'col
	LOCATE Y, X
	IF 41 - X < LEN(errors$(er)) THEN
		PRINT LEFT$(errors$(er), 41 - X);
		LOCATE Y + 1, 1: PRINT MID$(errors$(er), 41 - X + 1);
	ELSE
		PRINT errors$(er);
	END IF
	IF MusicRow < 52 THEN QTDelay 150 - INT(MusicRow ^ 1.2) ELSE WAIT &H3DA, 8
LOOP UNTIL MusicOrder(255) = 46

CLS
COLOR 7
LOCATE 9, 9: PRINT "       "
LOCATE 10, 9: PRINT "        "
LOCATE 11, 9: PRINT "          "
LOCATE 12, 9: PRINT "              "
LOCATE 13, 9: PRINT "              "
LOCATE 14, 9: PRINT "          "
LOCATE 15, 9: PRINT "        "
LOCATE 18, 1
QTSetTimer 1, 1000
DO
	OUT &H3C8, 0: OUT &H3C9, t \ 16: OUT &H3C9, t \ 16: OUT &H3C9, t \ 16
	OUT &H3C8, 7: OUT &H3C9, 31 + t \ 32: OUT &H3C9, 31 + t \ 32: OUT &H3C9, 31 + t \ 32
	t = QTGetTimer(1)
	WAIT &H3DA, 8
LOOP UNTIL t = 0

Here:
PRINT "Abort, Retry, Fail?"
Y = CSRLIN * 8
Here2:
DO
	LINE (153, Y - 9)-(159, Y - 8), 7, BF
	t! = TIMER
	DO
		A$ = INKEY$
		IF LEN(A$) > 0 THEN GOTO There
	LOOP UNTIL TIMER - t! > .3
	LINE (153, Y - 9)-(159, Y - 8), 0, BF
	t! = TIMER
	DO
		A$ = INKEY$
		IF LEN(A$) > 0 THEN GOTO There
	LOOP UNTIL TIMER - t! > .3
LOOP
There:
IF A$ = MID$(hidden$, hiddenchar + 1, 1) THEN
	BEEP
	hiddenchar = hiddenchar + 1
	IF hiddenchar = 9 THEN GOTO HiddenPart
	GOTO Here2
ELSEIF A$ <> CHR$(27) THEN
	hiddenchar = 0
	LINE (153, Y - 9)-(159, Y - 8), 0, BF
	GOTO Here
END IF

' **END**
TheEnd:
SCREEN 0: WIDTH 80
QTDone

StopMusic                               'Disable music processing
StopOutput                              'Stop all sound output
UnloadModule                            'Free module memory
'StopBanner                              'Do not show BWSB banner
FreeMSE                                 'Remove MSE from memory

FOR Slot = 1 TO 25
	IF Handles(Slot) > 0 THEN DeallocateXMS Handles(Slot)
NEXT Slot

END

HiddenPart:

points = 680
lines = 1272
DIM SHARED mx(points) AS SINGLE, my(points) AS SINGLE, mz(points) AS SINGLE
REDIM SHARED L1(lines), L2(lines)
DIM SHARED pc, lc
REDIM Dx(points), Dy(points)
DIM XP AS SINGLE, YP AS SINGLE, ZP AS SINGLE
DIM xmove AS SINGLE, ymove AS SINGLE, zmove AS SINGLE
DIM xmove0 AS SINGLE, ymove0 AS SINGLE, zmove0 AS SINGLE
DIM xmove1 AS SINGLE, ymove1 AS SINGLE, zmove1 AS SINGLE
DIM camspeed AS SINGLE

camdist = 150: xoffset = 160: yoffset = 100
 
pc = 0: lc = 0: r3 = 80
X = 0: Y = 0: z = 0
FOR S = -1 TO 1 STEP 2
 mx(pc + 1) = r3 * S: my(pc + 1) = r3: mz(pc + 1) = r3
 mx(pc + 2) = r3 * S: my(pc + 2) = -r3: mz(pc + 2) = r3
 mx(pc + 3) = r3 * S: my(pc + 3) = -r3: mz(pc + 3) = -r3
 mx(pc + 4) = r3 * S: my(pc + 4) = r3: mz(pc + 4) = -r3
 L1(lc + 1) = pc + 1: L2(lc + 1) = pc + 2
 L1(lc + 2) = pc + 2: L2(lc + 2) = pc + 3
 L1(lc + 3) = pc + 3: L2(lc + 3) = pc + 4
 L1(lc + 4) = pc + 4: L2(lc + 4) = pc + 1
 pc = pc + 4: lc = lc + 4
NEXT S
FOR L = 1 TO 4
 L1(lc + L) = L: L2(lc + L) = L + 4
NEXT L
lc = lc + 4
 
mode = 0
menger 0, 0, 0, 80

CLS
'L = MusicTempo(3)
L = MusicOrder(48)
QTSetTimer 1, 32767
t2 = 32767
RESTORE HiddenData
READ duration
READ xmove1, ymove1, zmove1
READ xtrans1, ytrans1, ztrans1
READ xrot1, yrot1, zrot1
xtrans0 = 0: ytrans0 = 0: ztrans0 = 0
xrot0 = 0: yrot0 = 0: zrot0 = 0
xmove0 = 0: ymove0 = 0: zmove0 = 0

DEF SEG = BS
FOR L = 0 TO 19
	OUT &H3C8, L + 32
	OUT &H3C9, 0: OUT &H3C9, L \ 2: OUT &H3C9, L
	FOR X = 0 TO 319
	  FOR Y = 0 TO 10
		 POKE BO + X + (L * 10 + Y) * 320, 51 - L
	NEXT Y, X
NEXT L
DEF SEG = VS

DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
 
 IF t < 16500 AND mode = 0 THEN
  mode = 1
  points = 1320
  lines = 2472
  pc = 0: lc = 0
  REDIM SHARED mx(points) AS SINGLE, my(points) AS SINGLE, mz(points) AS SINGLE
  REDIM SHARED L1(lines), L2(lines)
  REDIM Dx(points), Dy(points)
  pc = 0: lc = 0: r3 = 80
  FOR S = -1 TO 1 STEP 2
	mx(pc + 1) = r3 * S: my(pc + 1) = r3: mz(pc + 1) = r3
	mx(pc + 2) = r3 * S: my(pc + 2) = -r3: mz(pc + 2) = r3
	mx(pc + 3) = r3 * S: my(pc + 3) = -r3: mz(pc + 3) = -r3
	mx(pc + 4) = r3 * S: my(pc + 4) = r3: mz(pc + 4) = -r3
	L1(lc + 1) = pc + 1: L2(lc + 1) = pc + 2
	L1(lc + 2) = pc + 2: L2(lc + 2) = pc + 3
	L1(lc + 3) = pc + 3: L2(lc + 3) = pc + 4
	L1(lc + 4) = pc + 4: L2(lc + 4) = pc + 1
	pc = pc + 4: lc = lc + 4
  NEXT S
  FOR L = 1 TO 4
	L1(lc + L) = L: L2(lc + L) = L + 4
  NEXT L
  lc = lc + 4
  menger 0, 0, 0, 80
  t0 = t
  camspeed = .05
  camdist = ztrans0
  DEF SEG = BS
  FOR Y = 0 TO 199
	  YRow = Y * 320
	  FOR X = 0 TO 319: POKE BO + X + YRow, 0: NEXT X
  NEXT Y
  DEF SEG = VS
 END IF
  
	IF t2 - t >= duration THEN
	  xtrans0 = xtrans0 + xtrans1: ytrans0 = ytrans0 + ytrans1: ztrans0 = ztrans0 + ztrans1
	  xmove0 = xmove0 + xmove1: ymove0 = ymove0 + ymove1: zmove0 = zmove0 + zmove1
	  xrot0 = xrot0 + xrot1: yrot0 = yrot0 + yrot1: zrot0 = zrot0 + zrot1
	  READ duration: duration = duration * 1000
	  READ xmove1, ymove1, zmove1
	  READ xtrans1, ytrans1, ztrans1
	  READ xrot1, yrot1, zrot1
	  t2 = t
	END IF
  
	elapsed = (t2 - t) / duration
	xoffset = xtrans0 + xtrans1 * elapsed
	yoffset = ytrans0 + ytrans1 * elapsed
	IF mode = 0 THEN
	camdist = ztrans0 + ztrans1 * elapsed
	ELSE
	camdist = camdist - (t0 - t) * camspeed
	IF camdist < -65 THEN camdist = 80: camspeed = camspeed * 1.25
	END IF
	xrot = xrot0 + xrot1 * elapsed
	yrot = yrot0 + yrot1 * elapsed
	zrot = fzrot0 + zrot1 * elapsed
	xmove = xmove0 + xmove1 * elapsed
	ymove = ymove0 + ymove1 * elapsed
	zmove = zmove0 + zmove1 * elapsed

	FOR R = mode - 1 TO 0

	  cosx = COS(xrot + R * .5): sinx = SIN(xrot + R * .5)
	  cosy = COS(yrot + R * .5): siny = SIN(yrot + R * .5)
	  cosz = COS(zrot + R * .5): sinz = SIN(zrot + R * .5)
	  
	  FOR P = 1 TO points
		XP = mx(P) + xmove + R * 100
		YP = my(P) + ymove - R * 100
		ZP = mz(P) + zmove - R * 250
		
		' x-axis rotate
		JY1 = cosx * YP - sinx * ZP
		JZ1 = sinx * YP + cosx * ZP
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * XP
		JZ = cosy * JZ1 - siny * XP
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		IF (JZ + camdist) > 1 THEN
			Dx(P) = (-JX * 150) / (JZ + camdist) + xoffset
			Dy(P) = (-JY * 125) / (JZ + camdist) + yoffset
		ELSE Dx(P) = -1: Dy(P) = -1
		END IF
	  NEXT P
	  FOR L = 1 TO lines
	  IF Dx(L1(L)) >= 0 AND Dx(L2(L)) >= 0 THEN
		Line2 Dx(L1(L)), Dy(L1(L)), Dx(L2(L)), Dy(L2(L)), 7 - R * 2
	  END IF
	  NEXT L
	NEXT R
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)

	IF t < 1000 THEN
	OUT &H3C8, 0: OUT &H3C9, 63 - t \ 16: OUT &H3C9, 63 - t \ 16: OUT &H3C9, 63 - t \ 16
	OUT &H3C8, 7: OUT &H3C9, 63 - t \ 32: OUT &H3C9, 63 - t \ 32: OUT &H3C9, 63 - t \ 32
	END IF
	t0 = t
LOOP UNTIL LEN(INKEY$) OR t = 0
CLS
OUT &H3C8, 0: OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
OUT &H3C8, 7: OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
COLOR 7
LOCATE 11, 11: PRINT "0 polys and shaders"
LOCATE 13, 5: PRINT "Greets to Orb and Andromeda :)"
QTSetTimer 1, 1000
DO
	t = QTGetTimer(1)
	WAIT &H3DA, 8
	OUT &H3C8, 0: OUT &H3C9, t \ 16: OUT &H3C9, t \ 16: OUT &H3C9, t \ 16
	OUT &H3C8, 7: OUT &H3C9, t \ 32 + 32: OUT &H3C9, t \ 32 + 32: OUT &H3C9, t \ 32 + 32
LOOP UNTIL t = 0
QTDelay 3000
GOTO TheEnd

DATA 4, 11, 3, 6, 1, 12, 14, 5, 9, 7, 2, 10, 15, 8, 13, 0

CreditsData:
' offset (pixels), duration (seconds)
DATA 67, 1.2
DATA 20, 2.9
DATA 150, 1.9
DATA 20, 3
DATA 450, 5.5
DATA 0, 1.5
DATA 96, .4
DATA 0, .23
DATA 110, .4
DATA 0, .23
DATA 106, .4
DATA 0, .23
DATA 111, .45
DATA 0, 10

CubeData:
' duration, translate, rotate
' time, x, y, z, x, y, z, transform
 
' initial values
DATA 0, 400, 100, 250, 0, 0, 0, 0
' successive values
DATA 5, -240, 0, 0, 1, 1, 1, 0
DATA 11, 0, 0, 0, 0.5, 0.5, 0.5, 0
DATA 5, 0, 0, -80, 1, 1, 1, 0
DATA 11, 0, 0, 0, .5, .5, .5, 0
DATA 5, 0, 0, 0, 1, 1, 1, 0
DATA 11, 0, 0, 0, .5, .5, .5, 0
DATA 4, -80, 0, 200, 1, 1, 1, 0
DATA 4, 160, 0, 0, 1, 1, 1, 0
DATA 8, 0, 0, 0, 1, 1, 1, 0

DATA 5, -130, 0, -120, 1, 1, 1, 0
DATA 11, 0, 0, 0, .5, .5, .5, 0
DATA 5, 0, 100, 0, 1, 1, 1, 0
DATA 11, 0, 0, 0, .5, .5, .5, 0
DATA 5, 0, -150, -100, 1, 1, 1, 0
DATA 11, 0, 0, 0, .5, .5, .5, 0
DATA 4, 0, 50, 50, 1, 1, 1, 0
DATA 4, 80, 0, 50, -1, -1, -1, 0
DATA 8, 0, 0, 0, 8, 0, 0, 0

DATA 16, 0, 0, -100, .6, .6, .6, 0
DATA 5, 0, 0, 0, .6, .6, .6, 1
DATA 11, 0, 0, 0, .5, .5, .5, 0
DATA 5, 40, 30, 40, -1, -1, 1, 0
DATA 11, 0, 0, 0, -.5, -.5, .5, 0
DATA 4, 0, 0, 30, 1, -1, 1, 2
DATA 4, -60, -40, -30, .5, .5, .5, 0
DATA 8, 0, 0, 0, 1, 1, 1, 0

DATA 5, 50, -30, 80, -1, -1, -1, 3
DATA 11, 0, 0, 0, -.5, -.5, -.5, 0
DATA 5, 30, 90, 40, 2, 1, 2, 0
DATA 11, 0, 0, 0, 1, .5, 1, 0
DATA 5, -100, -50, 140, 1, 1, 1, 4
DATA 11, 0, 0, 0, .5, .5, .5, 0
DATA 4, 20, 0, -250, 1, 2, 1, 0
DATA 4, 0, 0, 0, -1, -1, -1, 0
DATA 8, 0, 0, 1000, 1, 1, 1, 0

DATA 10, 0, 0, 0, 0, 0, 0, 0

DonutsData:
'donuts
' camdist, x, y, rotate offset, color
DATA 200, 100, 0, 0, 6
DATA 250, 220, -100, 1, 2
DATA 150, 90, -200, 4, 1
DATA 200, 200, -300, 3, 3
DATA 200, 110, -400, 0, 6
DATA 250, 240, -500, 5, 1
DATA 150, 130, -600, 1, 3
DATA 200, 210, -700, 3, 2
DATA 200, 80, -800, 2, 6
'DATA 250, 220, -900, 0, 3
'DATA 150, 100, -1000, 3, 1
'DATA 200, 230, -1100, 3, 2
'DATA 200, 90, -1200, 0, 1
'DATA 250, 200, -1300, 1, 6
'DATA 150, 100, -1400, 2, 3
'DATA 200, 220, -1500, 3, 6

MonsterData:
' monster moves
' sprite, direction (1/-1), x move, seconds
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 3, 1, 0, .2
DATA 4, 1, 0, .2
DATA 3, 1, 0, .2
DATA 4, 1, 0, .2
DATA 3, 1, 0, .2
DATA 4, 1, 0, .2
DATA 1, 1, 20, .2
DATA 2, 1, 20, .2
DATA 1, 1, 20, .2
DATA 2, 1, 20, .2
DATA 1, 1, 20, .2
DATA 2, 1, 20, .2
DATA 5, 1, 0, .2
DATA 6, 1, 0, .2
DATA 5, 1, 0, .2
DATA 6, 1, 0, .2
DATA 5, 1, 0, .2
DATA 6, 1, 0, .2
DATA 1, -1, -20, .2
DATA 2, -1, -20, .2
DATA 1, -1, -20, .2
DATA 2, -1, -20, .2
DATA 1, -1, -20, .2
DATA 2, -1, -20, .2
DATA 1, -1, -20, .2
DATA 2, -1, -20, .2
DATA 3, 1, 0, .2
DATA 4, 1, 0, .2
DATA 3, 1, 0, .2
DATA 4, 1, 0, .2
DATA 1, 1, 20, .2
DATA 2, 1, 20, .2
DATA 1, 1, 20, .2
DATA 2, 1, 20, .2
DATA 5, 1, 0, .2
DATA 6, 1, 0, .2
DATA 5, 1, 0, .2
DATA 6, 1, 0, .2
DATA 1, -1, -20, .2
DATA 2, -1, -20, .2
DATA 1, -1, -20, .2
DATA 2, -1, -20, .2
DATA 3, 1, 0, .2
DATA 4, 1, 0, .2
DATA 3, 1, 0, .2
DATA 4, 1, 0, .2
DATA 1, 1, 20, .2
DATA 2, 1, 20, .2
DATA 1, 1, 20, .2
DATA 2, 1, 20, .2
DATA 1, 1, 20, .2
DATA 2, 1, 20, .2
DATA 5, 1, 0, .2
DATA 6, 1, 0, .2
DATA 5, 1, 0, .2
DATA 6, 1, 0, .2
DATA 1, -1, -20, .2
DATA 2, -1, -20, .2
DATA 1, -1, -20, .2
DATA 2, -1, -20, .2
DATA 1, -1, -20, .2
DATA 3, 1, 0, .2
DATA 4, 1, 0, .2
DATA 3, 1, 0, .2
DATA 4, 1, 0, .2
DATA 3, 1, 0, .2
DATA 4, 1, 0, .2
DATA 1, 1, 20, .2
DATA 2, 1, 20, .2
DATA 1, 1, 20, .2
DATA 2, 1, 20, .2
DATA 1, 1, 20, .2
DATA 2, 1, 20, .2
DATA 5, 1, 0, .2
DATA 6, 1, 0, .2
DATA 5, 1, 0, .2
DATA 6, 1, 0, .2
DATA 1, -1, -20, .2
DATA 2, -1, -20, .2
DATA 1, -1, -20, .2
DATA 2, -1, -20, .2
DATA 1, -1, 0, 10

DonutData:
' time, trans x, y, z, rotate x, y, z, spikiness (1-2), ring size amp (0-1),
'  ring size freq (1-20), bend amp (0-1), bend freq (1-20)

' initial values
DATA 0, 160, 250, 350, 0, 0, 0, 1, 0, 1, 0, 1
' successive values
DATA 16, 0, -150, -100, 1, 1, 1, 0, 0, 0, 0, 0
DATA 5, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0
DATA 11, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0
DATA 5, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0
DATA 11, 0, 0, 0, 1, 1, 1, -1, 0, 0, 0, 0
DATA 5, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0
DATA 11, 0, 0, 0, 1, 1, 1, 0, .5, 2, 0, 0

DATA 5, 0, 0, 0, 1, 1, 1, 0, 0, 2, 0, 0
DATA 11, 0, 0, 0, 1, 1, 1, 0, 0, -4, 0, 0
DATA 5, 0, 0, 0, 1, 1, 1, 1, -.5, 0, 0, 0
DATA 11, 0, 0, 0, 1, 1, 1, -1, 0, 0, 0, 0
DATA 5, 0, 0, 120, 1, 1, 1, 0, 3, 1, 0, 0
DATA 11, 0, 0, -60, 1, 1, 1, 0, 0, -.5, 0, 0
DATA 4, 0, 0, 0, 0, 0, 0, 0.5, -1, -.5, 0, 0
DATA 4, 0, 0, 0, 0, 0, 0, -0.5, -2, 0, 0, 0
DATA 8, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0

DATA 5, 0, 0, 0, 1, 1, 1, .5, 0, 0, .5, 1
DATA 11, 0, 0, 0, 1, 1, 1, -.5, 0, 0, 0, 2
DATA 5, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 3
DATA 11, 0, 0, 0, 1, 1, 1, 0, 0, 3, 0, 0
DATA 5, 0, 0, 50, 1, 1, 0, 0, .5, 0, 0, 0
DATA 11, 0, 0, 0, 1, 1, 0, 0.5, -0.5, 0, 0, -3
DATA 4, 0, 0, 0, -1, -1, -1, -0.5, 0, -3, 0, -2
DATA 4, 0, 0, 0, 1, 1, 1, 0.5, 0, 0, 0, -1
DATA 8, 0, 0, 0, -1, 1, 1, -0.5, 0, 0, 0, 0

DATA 5, 0, 0, 0, 1, 1, -1, 0, 0, 0, -.5, 0
DATA 11, 0, 0, 0, 1, 1, -1, 0, 0.5, 1.5, 0, 0
DATA 5, 0, 0, -40, 1, -1, -1, 0.6, 0, 1.5, 0, 0
DATA 11, 0, 0, -30, 1, -1,- 1, -0.6, 0, -1, .2, 1
DATA 5, 0, 0, 0, -1, 1, 1, .5, 0, -1, .2, 2
DATA 11, 0, 0, -30, -1, 1, 1, -.5, -0.5, 0, 0, 0
DATA 4, 0, 0, 40, 1, 1, 1, 0.6, 0, -1, 0, -2
DATA 4, 0, 0, 0, -1, 1, -1, -0.6, 0, 0, 0, -1
DATA 8, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0
DATA 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

StarData:
' spriteset, time-offset, duration
DATA 1, 0, 16
DATA 1, 5, 16
DATA 1, 2, 16
DATA 1, 7, 4
DATA 1, 3, 12

DATA 8, 0, 16
DATA 8, 5, 16
DATA 8, 2, 16
DATA 8, 7, 4
DATA 8, 3, 12

DATA 2, 0, 16
DATA 3, 5, 16
DATA 4, 2, 16
DATA 5, 7, 4
DATA 6, 3, 12

DATA 7, 0, 16
DATA 2, 5, 16
DATA 3, 2, 16
DATA 4, 7, 4
DATA 5, 3, 12

DATA 8, 0, 64

GreetsData:
DATA "Dennis Courtney ROM BIOS", 6
DATA "Copyright (C) 1984-2009, DC5, Inc.", 4
DATA "All Rights Reserved", 6
DATA "", 0
DATA "00640K System RAM Passed", 6
DATA "02048K Extended RAM Passed", 4
DATA "", 0
DATA "Current date is Tue  1-01-1980", 6
DATA "Enter new date: 6-01-2009", 6
DATA "Current time is  0:00:14.99", 4
DATA "Enter new time: 22:42:55.34", 6
DATA "", 0
DATA "Microsoft(R) MS-DOS(R) Version 3.30", 6
DATA "(C)Copyright Microsoft Corp 1981-1987", 4
DATA "", 0
DATA "C>prompt $p$g", 2
DATA "", 0
DATA "C:\>cd dc5", 4
DATA "", 0
DATA "C:\DC5>greets", 6
DATA "Bad command or file name", 4
DATA "", 0
DATA "C:\DC5>type greets.txt", 6
DATA "", 0
DATA "!=", 6
DATA "8BITPEOPLES", 4
DATA "ALPHA DESIGN", 6
DATA "ATE BIT", 6
DATA "BARFRAUSCH", 4
DATA "BAWLZ", 6
DATA "BDSE", 6
DATA "BITS", 4
DATA "BOOZOHOLICS", 2
DATA "CRITICALARTWARE", 4
DATA "", 0
DATA "C:\DC5>cd greets", 6
DATA "", 0
DATA "C:\DC5\GREETS>dir", 4
DATA "", 0
DATA " Volume in drive C is ARFARFARF", 6
DATA " Volume Serial Number is 3133-7DC5", 6
DATA "", 0
DATA " Directory of C:\DC5\GREETS", 4
DATA "", 0
DATA ".          <DIR>         03/26/09 05:00", 6
DATA "..         <DIR>         03/26/09 05:00", 6
DATA "DA JORMAS     5,076,340  02/20/09 05:08", 4
DATA "DC5        <DIR>         02/16/09 01:03", 6
DATA "DISASTER AREA   433,100  03/18/09 08:50", 6
DATA "DRIFTERS        928,946  02/06/09 12:10", 4
DATA "DUAL CORE       107,089  03/25/09 06:36", 2
DATA "FAILRIGHT        54,270  03/24/09 09:02", 4
DATA "FAT MAN &     1,590,020  03/26/09 05:10", 6
DATA "CIRCUIT GIRL    274,913  04/21/09 07:10", 4
DATA "FEARMOTHS       341,667  01/30/09 04:49", 6
DATA "FLO        <DIR>         03/26/09 03:07", 6
DATA "ISO        <DIR>         03/29/09 11:40", 4
DATA "JUMALAUTA       880,545  01/05/09 08:35", 6
DATA "KOSMOPLOVCI     130,172  03/23/09 06:20", 6
DATA "      9 File(s)    9,767,210 bytes", 4
DATA "      4 Dir(s)    82,140,020 bytes free", 6
DATA "", 0
DATA "C:\DC5\GREETS>cd \", 6
DATA "", 0
DATA "C:\>copy A:*.*", 4
DATA "", 0
DATA "LIMP NINJA", 2
DATA "MEGAHAWKS", 4
DATA "MERIKAN MORANS", 6
DATA "MFX", 4
DATA "MINIMALARTIFACT", 6
DATA "NDIVIA", 6
DATA "ODD", 4
DATA "OPTIMUS", 6
DATA "POLYGONY", 6
DATA "PENISHURE", 4
DATA "PWP", 6
DATA "SAD", 6
DATA "", 0
DATA "14 file(s) copied", 4
DATA "", 0
DATA "C:\>del /p d:*.*", 2
DATA "", 0
DATA "SHITFACED CLOWNS, Delete (Y/N)? y", 4
DATA "SIGFLUP, Delete (Y/N)? y", 6
DATA "SPARKARTS, Delete (Y/N)? y", 4
DATA "SYNTAX TERROR, Delete (Y/N)? y", 6
DATA "TPOLM, Delete (Y/N)? n", 6
DATA "TRAKTOR, Delete (Y/N)? y", 4
DATA "TRILOBIT, Delete (Y/N)? y", 6
DATA "UKSCENE ALLSTARS, Delete (Y/N)? y", 6
DATA "ULTRALAME, Delete (Y/N)? y", 4
DATA "UMLAUT DESIGN, Delete (Y/N)? y", 6
DATA "UP ROUGH, Delete (Y/N)? y", 6
DATA "WAMMA, Delete (Y/N)? y", 4
DATA "YOUTH UPRISING, Delete (Y/N)? y", 2
DATA "", 0
DATA "C:\>cd sbaitso", 4
DATA "", 0
DATA "C:\SBAITSO>sbtalk ", 4
DATA "", 0
DATA "SmoothTalker (R), v 3.5, male voice", 4
DATA "Copyright (c) 1983-1990 First Byte", 4
DATA "Protected by U.S. Patent #4,692,941", 4
DATA "  -- Resident Driver Installed --", 4
DATA "Using driver BLASTER.DRV", 4
DATA "", 0
DATA "C:\SBAITSO>read < rap.txt", 4
DATA "", 0
DATA "SOUND BLASTER Text-to-Speech v1.00", 8
DATA "(c) CREATIVE LABS,INC. 1989-1991", 4
DATA "All rights reserved.", 4
DATA "", 64

RapLine1Data:
DATA 300, 2.059
DATA 0, 10

RapLine2Data:
DATA 300, 2
DATA 0, 10

RapLine3Data:
DATA 150, 2
DATA 0, 10

Parrot1Data:
' sprite, x, y, duration
DATA 1, 0, 12, .15
DATA 2, 0, 12, .15
DATA 1, 0, 12, .15
DATA 2, 0, 12, .15
DATA 1, 0, 12, .2
DATA 2, 0, 12, .2
DATA 1, 0, 12, .15
DATA 2, 0, 12, .15
DATA 1, 0, 12, 10

Parrot2Data:
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .25
DATA 2, 0, 12, .15
DATA 1, 0, 12, .15
DATA 2, 0, 12, .2
DATA 1, 0, 12, .2
DATA 2, 0, 12, .2
DATA 1, 0, 12, .2
DATA 2, 0, 12, .2
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, 10

Parrot3Data:
DATA 1, 0, 12, .2
DATA 2, 0, 12, .2
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .2
DATA 2, 0, 12, .2
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, 10

Parrot4Data:
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .2
DATA 2, 0, 12, .2
DATA 1, 0, 12, .2
DATA 2, 0, 12, .2
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .2
DATA 2, 0, 12, .2
DATA 1, 0, 12, 10

Parrot5Data:
DATA 1, 0, 12, .15
DATA 2, 0, 12, .15
DATA 1, 0, 12, .15
DATA 2, 0, 12, .15
DATA 1, 0, 12, .15
DATA 2, 0, 12, .2
DATA 1, 0, 12, .25
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .15
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, .1
DATA 2, 0, 12, .1
DATA 1, 0, 12, 10

Beefman1Data:
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .1
DATA 2, 110, 20, .2
DATA 1, 110, 20, .2
DATA 2, 110, 20, .1
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .2
DATA 2, 110, 20, .2
DATA 1, 110, 20, .15
DATA 2, 110, 20, .15
DATA 1, 110, 20, .15
DATA 2, 110, 20, .15
DATA 1, 110, 20, 10

Beefman2Data:
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .2
DATA 2, 110, 20, .2
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, 10

Beefman3Data:
DATA 1, 110, 20, .15
DATA 2, 110, 20, .15
DATA 1, 110, 20, .15
DATA 2, 110, 20, .15
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .2
DATA 2, 110, 20, .2
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .2
DATA 2, 110, 20, .2
DATA 1, 110, 20, .15
DATA 2, 110, 20, .15
DATA 1, 110, 20, .15
DATA 2, 110, 20, .15
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, .1
DATA 2, 110, 20, .1
DATA 1, 110, 20, 10

Oldskool1Data:
' time, speed, direction
DATA 3, 1.8, 1
DATA .2, 2, -1
DATA .2, 2, 1
DATA .2, 2, -1
DATA .2, 2, 1
DATA .2, 2, -1
DATA .5, 1.5, 1
DATA 10, 0, 1

Oldskool2Data:
' time, speed, direction
DATA 2.65, 1.7, 1
DATA 10, 0, 1

Oldskool3Data:
' time, speed, direction
DATA 3.1, 2.1, 1
DATA 10, 0, 1

Oldskool4Data:
' time, speed, direction
DATA 2.5, 3, 1
DATA .2, 5, -1
DATA .2, 5, 1
DATA .2, 5, -1
DATA .2, 5, 1
DATA .2, 5, -1
DATA .05, 5, 1
DATA .05, 5, -1
DATA .05, 5, 1
DATA .3, 1, 1
DATA .05, 5, 1
DATA .3, 1, 1
DATA .05, 5, 1
DATA 10, 0, 1

CurveNoiseData:
DATA 300, 5
DATA 0, 10

MonsterData2:
' monster moves
' sprite, direction (1/-1), x move, seconds
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 3, -1, -25, .2
DATA 4, -1, -25, .2
DATA 3, -1, -25, .2
DATA 4, -1, -25, .2
DATA 1, 1, 25, .2
DATA 2, 1, 25, .2
DATA 1, 1, 25, .2
DATA 2, 1, 25, .2
DATA 5, 1, 25, .2
DATA 6, 1, 25, .2
DATA 5, 1, 25, .2
DATA 6, 1, 25, .2
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 5, -1, -25, .2
DATA 6, -1, -25, .2
DATA 5, -1, -25, .2
DATA 6, -1, -25, .2
DATA 1, 1, 25, .2
DATA 2, 1, 25, .2
DATA 1, 1, 25, .2
DATA 2, 1, 25, .2
DATA 3, 1, 25, .2
DATA 4, 1, 25, .2
DATA 3, 1, 25, .2
DATA 4, 1, 25, .2
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 3, -1, -25, .2
DATA 4, -1, -25, .2
DATA 3, -1, -25, .2
DATA 4, -1, -25, .2
DATA 1, 1, 25, .2
DATA 2, 1, 25, .2
DATA 1, 1, 25, .2
DATA 2, 1, 25, .2
DATA 5, 1, 25, .2
DATA 6, 1, 25, .2
DATA 5, 1, 25, .2
DATA 6, 1, 25, .2
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 1, -1, -25, .2
DATA 2, -1, -25, .2
DATA 5, -1, -25, .2
DATA 6, -1, -25, .2
DATA 5, -1, -25, .2
DATA 6, -1, -25, .2
DATA 1, 1, 25, .2
DATA 2, 1, 25, .2
DATA 1, 1, 25, .2
DATA 2, 1, 25, .2
DATA 3, 1, 25, .2
DATA 4, 1, 25, .2
DATA 3, 1, 25, .2
DATA 4, 1, 25, .2

HiddenData:
' duration, scene move, camera pan/zoom, rotate
' time, x, y, z, x, y, z, x, y, z
 
' initial values
DATA 0, 0, 80, 0, 160, 100, 200, .2, .4, 0
' successive values
DATA 4, 0, 0, -100, 0, 0, 0, 0, .2, 0
DATA 0.001, -30, -80, 100, 0, 0, 0, 0, -.2, 0
DATA 4, 0, 0, -30, 0, 0, 0, 0, .2, 0
DATA 0.001, 30, 0, 30, 0, 0, -1, -.2, -.6, 0
DATA 0.001, 100, -100, -100, 0, 0, 170, .5, .5, .5

DATA 8, 0, 0, 0, 0, 0, -450, 0, 0, .5

DATA 0.001, -100, 100, 100, 0, 0, 320, -.5, -.5, -1
DATA 0.001, 0, 0, 0, 0, 0, 0, .7854, -.6154, 0
DATA 100, 0, 0, 0, 0, 0, -300, 0, 0, 0

SUB Beefman (mode)
	CLS
	RestorePalette 22
	
	PH = Pics(54).Height: PW = Pics(54).Width

	SELECT CASE mode
	CASE 1: RESTORE Beefman1Data: t2 = 1765
	CASE 2: RESTORE Beefman2Data: t2 = 1618
	CASE 3: RESTORE Beefman3Data: t2 = 2350
	END SELECT
	QTSetTimer 1, t2

	READ Sprite, sx, sy, duration
	duration = duration * 1000
	
	DO
		t1 = QTGetTimer(1)
	
		IF t2 - t1 >= duration THEN
			READ Sprite, sx, sy, duration
			duration = duration * 1000
			t2 = t1
		END IF
	
		Size& = PH * PW
		FOR Y = 0 TO PH - 1
			MoveFromXMS Handles(Pics(Sprite + 53).Handle), &HA000, sx + (Y + sy) * 320, PW, (Sprite - 1) * Size& + Y * PW
		NEXT Y

		IF mode = 1 AND MusicRow >= 34 THEN EXIT DO
		IF mode = 2 AND MusicRow >= 26 THEN EXIT DO
		IF mode = 3 AND (MusicRow >= 31 AND MusicRow <= 60) THEN EXIT DO
	LOOP

END SUB

SUB FadeToColor (Palett(), BYVAL R, BYVAL G, BYVAL B, BYVAL Amount AS SINGLE)
	FOR L = 0 TO 255
		OUT &H3C8, L
		OUT &H3C9, Palett(L, 1) + ((R - Palett(L, 1)) * Amount)
		OUT &H3C9, Palett(L, 2) + ((G - Palett(L, 2)) * Amount)
		OUT &H3C9, Palett(L, 3) + ((B - Palett(L, 3)) * Amount)
	NEXT L
END SUB

SUB FPrint (Text$, X, Y)
SHARED VS, VO
FS = VARSEG(Font(0, 0)): FO = VARPTR(Font(0, 0))
DEF SEG = FS
FOR L = 0 TO LEN(Text$) - 1
	C = ASC(MID$(Text$, L + 1, 1)) - 32
	FX = (C MOD 40) * 8
	FY = (C \ 40) * 8
	FOR VY = 0 TO 7
		FY320 = (FY + VY) * 320
		VY320 = (Y + VY) * 320
		FOR VX = 0 TO 7
			DEF SEG = FS
			IF PEEK(FO + FX + VX + FY320) <> 254 THEN
				DEF SEG = VS
				POKE VO + X + VX + L * 8 + VY320, 255
				'CALL BlockMove(FS, FO + FX + VX + FY + Y320, VS, VO + X + VX + L * 8 + (Y + VY) * 320, 1, 0)
			END IF
	NEXT VX, VY
	
NEXT L
END SUB

REM $STATIC
FUNCTION GetLibOffset& (Lib$, File$)
	DIM LibHeader AS LibHeaderType
	GetLibOffset& = 0
	H = FREEFILE
	OPEN Lib$ FOR BINARY AS H
	SEEK H, 7: GET H, , F
	FOR L = 1 TO F
		GET H, , LibHeader
		IF UCASE$(File$) = RTRIM$(UCASE$(LibHeader.FileName)) THEN
			GetLibOffset& = LibHeader.Offset
			EXIT FOR
		END IF
	NEXT L
	CLOSE H
END FUNCTION

REM $DYNAMIC
SUB GetSoundCardInfo
SHARED Dev, Port, IRQ, DMA
	IF INSTR(COMMAND$, "SETUP") THEN Setup = 1
	IF LEN(ENVIRON$("ULTRASND")) AND Setup = 0 THEN
		PRINT "Gravis Ultrasound detected."
		Dev = 1: Port = &HFFFF: IRQ = &HFF: DMA = &HFF
	ELSEIF LEN(ENVIRON$("BLASTER")) AND Setup = 0 THEN
		t$ = MID$(ENVIRON$("BLASTER"), INSTR(ENVIRON$("BLASTER"), "T") + 1, 1)
		SELECT CASE t$
		CASE "1"
			PRINT "Sound Blaster 1.x detected."
			Dev = 2
		CASE "2"
			PRINT "Sound Blaster 2.x detected."
			Dev = 3
		CASE "4"
			PRINT "Sound Blaster Pro detected."
			Dev = 4
		CASE "6"
			PRINT "Sound Blaster 16 detected."
			Dev = 5
		END SELECT
		Port = &HFFFF: IRQ = &HFF: DMA = &HFF
	ELSE
		PRINT "Select soundcard:"
		PRINT "1) Gravis Ultrasound"
		PRINT "2) Sound Blaster 1.x"
		PRINT "3) Sound Blaster 2.x"
		PRINT "4) Sound Blaster Pro"
		PRINT "5) Sound Blaster 16"
		PRINT "6) Pro Audio Spectrum"
		PRINT "0) Abort"
		DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "6"
		IF In$ = "0" THEN END ELSE Dev = ASC(In$) - 48
		PRINT "Port address (2x0h, 0 to autodetect):"
		DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "9"
		IF In$ = "0" THEN Port = &HFFFF ELSE Port = (16 * (ASC(In$) - 48)) + 512
		PRINT "IRQ (in hex, 0 to autodetect):"
		DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9") OR (In$ >= "a" AND In$ <= "f")
		IF In$ = "0" THEN
			IRQ = &HFF
		ELSEIF In$ <= "9" THEN IRQ = ASC(In$) - 48
		ELSE IRQ = ASC(In$) - 87
		END IF
		PRINT "DMA (0 to autodetect):"
		DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9")
		IF In$ = "0" THEN DMA = &HFF ELSE DMA = ASC(In$) - 48
	END IF
END SUB

REM $STATIC
SUB Line2 (BYVAL A, BYVAL B, BYVAL C, BYVAL D, BYVAL Col)
  U = C - A: V = D - B
  d1x = SGN(U): d1y = SGN(V): d2x = SGN(U): d2y = 0
  M = ABS(U): N = ABS(V)
  IF M <= N THEN
	d2x = 0: d2y = SGN(V)
	M = ABS(V): N = ABS(U)
  END IF
  S = M \ 2
  FOR I = 0 TO M
	IF A >= 0 AND A < 320 AND B >= 0 AND B < 200 THEN POKE A + B * 320, Col
	S = S + N
	IF S > M THEN
	  S = S - M: A = A + d1x: B = B + d1y
	ELSE
	  A = A + d2x: B = B + d2y
	END IF
  NEXT I
END SUB

REM $DYNAMIC
SUB LoadBMP (Slot, Handle, HandleOffset, BMPFile$, ClearColor, ColorOffset)
	OPEN BMPFile$ FOR BINARY AS 1
	TmpInt$ = "  ": TmpLong$ = "    ": TmpByte$ = " "
	GET 1, 11, TmpInt$: Offset = CVI(TmpInt$)
	GET 1, 19, TmpInt$: Wid = CVI(TmpInt$)
	GET 1, 23, TmpLong$: Hei& = CVL(TmpLong$)
	GET 1, 47, TmpInt$: PalCount = CVI(TmpInt$)
	IF PalCount = 0 THEN PalCount = 256
	REDIM Array(Wid - 1, ABS(Hei&) - 1) AS STRING * 1
	PS = VARSEG(Array(0, 0)): PO = VARPTR(Array(0, 0))
	DEF SEG = PS

	SEEK 1, 55
	FOR L = ColorOffset TO (PalCount - 1) + ColorOffset
		IF L > 255 THEN EXIT FOR
		GET 1, , TmpLong$
		Palett(L, 1) = ASC(MID$(TmpLong$, 3, 1)) \ 4
		Palett(L, 2) = ASC(MID$(TmpLong$, 2, 1)) \ 4
		Palett(L, 3) = ASC(MID$(TmpLong$, 1, 1)) \ 4
	NEXT L
	SEEK 1, Offset + 1
	
	FOR Y = 0 TO ABS(Hei&) - 1
		YRow = Y * Wid: YRow2 = (ABS(Hei&) - Y - 1) * Wid
		FOR X = 0 TO Wid - 1
			GET 1, , TmpByte$
			A = ASC(TmpByte$) + ColorOffset
			IF Hei& < 0 THEN
				POKE PO + X + YRow, A
			ELSE
				POKE PO + X + YRow2, A
			END IF
		NEXT X
		IF Wid MOD 4 = 3 THEN GET 1, , TmpByte$
		IF Wid MOD 4 = 2 THEN GET 1, , TmpInt$
		IF Wid MOD 4 = 1 THEN GET 1, , TmpInt$: GET 1, , TmpByte$
	NEXT Y

	CLOSE 1
	Pics(Slot).Height = ABS(Hei&): Pics(Slot).Width = Wid: Pics(Slot).Colors = PalCount
	Pics(Slot).ClearColor = ClearColor
	Pics(Slot).Handle = Handle: Pics(Slot).HandleOffset = HandleOffset
	Size& = ABS(Hei&) * Wid

	' allocate xms - custom for some grouped in one slot/handle
	SELECT CASE Handle
	CASE 9
		IF HandleOffset = 0 THEN Handles(Handle) = AllocateXMS(Size& * 6)
	CASE 10
		IF HandleOffset = 0 THEN Handles(Handle) = AllocateXMS(Size& * 22)
	CASE 14
		IF HandleOffset = 0 THEN Handles(Handle) = AllocateXMS(Size& * 9)
	CASE 18
		IF HandleOffset = 0 THEN Handles(Handle) = AllocateXMS(Size& * 2)
	CASE 19
		IF HandleOffset = 0 THEN Handles(Handle) = AllocateXMS(Size& * 2)
	CASE ELSE
		Handles(Handle) = AllocateXMS(Size&)
	END SELECT

	' copy arrays to xms
	MoveToXMS Handles(Handle), PS, PO, Size&, HandleOffset * Size&
	IF Handles(Handle) = 0 THEN PRINT FreeXMSmemory& \ 1024; "k free, no handle on"; Slot: END

	PRINT ".";
END SUB

REM $STATIC
SUB LoadBMPFromLib (Slot, Handle, HandleOffset, Lib$, BMPFile$, ClearColor, ColorOffset)
	OPEN Lib$ FOR BINARY AS 1
	Offs& = GetLibOffset(Lib$, BMPFile$) - 1&
	TmpInt$ = "  ": TmpLong$ = "    ": TmpByte$ = " "
	GET 1, Offs& + 11, Offset
	GET 1, Offs& + 19, Wid
	GET 1, Offs& + 23, Hei&
	GET 1, Offs& + 47, PalCount
	IF PalCount = 0 THEN PalCount = 256
	REDIM Array(Wid - 1, ABS(Hei&) - 1) AS STRING * 1
	PS = VARSEG(Array(0, 0)): PO = VARPTR(Array(0, 0))
	DEF SEG = PS

	SEEK 1, Offs& + 55
	FOR L = ColorOffset TO (PalCount - 1) + ColorOffset
		IF L > 255 THEN EXIT FOR
		GET 1, , TmpLong$
		Palett(L, 1) = ASC(MID$(TmpLong$, 3, 1)) \ 4
		Palett(L, 2) = ASC(MID$(TmpLong$, 2, 1)) \ 4
		Palett(L, 3) = ASC(MID$(TmpLong$, 1, 1)) \ 4
	NEXT L
	SEEK 1, Offs& + Offset + 1

	FOR Y = 0 TO ABS(Hei&) - 1
		YRow = Y * Wid: YRow2 = (ABS(Hei&) - Y - 1) * Wid
		FOR X = 0 TO Wid - 1
			GET 1, , TmpByte$
			A = ASC(TmpByte$) + ColorOffset
			IF Hei& < 0 THEN
				POKE PO + X + YRow, A
			ELSE
				POKE PO + X + YRow2, A
			END IF
		NEXT X
		IF Wid MOD 4 = 3 THEN GET 1, , TmpByte$
		IF Wid MOD 4 = 2 THEN GET 1, , TmpInt$
		IF Wid MOD 4 = 1 THEN GET 1, , TmpInt$: GET 1, , TmpByte$
	NEXT Y

	CLOSE 1
	Pics(Slot).Height = ABS(Hei&): Pics(Slot).Width = Wid: Pics(Slot).Colors = PalCount
	Pics(Slot).ClearColor = ClearColor
	Pics(Slot).Handle = Handle: Pics(Slot).HandleOffset = HandleOffset
	Size& = ABS(Hei&) * Wid

	' allocate xms - custom for some grouped in one slot/handle
	SELECT CASE Handle
	CASE 9
		IF HandleOffset = 0 THEN Handles(Handle) = AllocateXMS(Size& * 6)
	CASE 10
		IF HandleOffset = 0 THEN Handles(Handle) = AllocateXMS(Size& * 22)
	CASE 14
		IF HandleOffset = 0 THEN Handles(Handle) = AllocateXMS(Size& * 9)
	CASE 18
		IF HandleOffset = 0 THEN Handles(Handle) = AllocateXMS(Size& * 2)
	CASE 19
		IF HandleOffset = 0 THEN Handles(Handle) = AllocateXMS(Size& * 2)
	CASE ELSE
		Handles(Handle) = AllocateXMS(Size&)
	END SELECT

	' copy arrays to xms
	MoveToXMS Handles(Handle), PS, PO, Size&, HandleOffset * Size&
	'IF Handles(Handle) = 0 THEN PRINT FreeXMSmemory& \ 1024; "k free, no handle on"; Slot: END

	'PRINT ".";
	
	LoadCount = LoadCount + 1
	PH = Pics(9).Height: PW = Pics(9).Width: PCC = Pics(9).ClearColor
	PS = Pics(9 + (LoadCount MOD 2)).Seg: PO = Pics(9 + (LoadCount MOD 2)).Offs
	
	IF LoadCount > 2 THEN
	LINE (27 + (LoadCount - 1) * 4, 87)-(27 + PW + (LoadCount - 1) * 4, 87 + PH), 0, BF
	DEF SEG = PS
	FOR Y = 0 TO PH - 1
		FOR X = 0 TO PW - 1
			IF PEEK(PO + X + Y * PW) <> PCC THEN
				CALL BlockMove(PS, PO + X + Y * PW, &HA000, X + 27 + LoadCount * 4 + (Y + 87) * 320, 1, 0)
			END IF
		NEXT X
	NEXT Y
	END IF
		
END SUB

SUB menger (BYVAL X AS SINGLE, BYVAL Y AS SINGLE, BYVAL z AS SINGLE, BYVAL R AS SINGLE)
' draws an "inside-the-cube" section, rather than 20 new ones
	SHARED mode
	DIM r3 AS SINGLE
	r3 = R / 3
	p0 = pc
 
 IF pc = 1320 THEN EXIT SUB
 ' point count = 32, line count = 60
  
 ' center cube
 FOR S = -1 TO 1 STEP 2
  mx(pc + 1) = X + r3 * S: my(pc + 1) = Y + r3: mz(pc + 1) = z + r3
  mx(pc + 2) = X + r3 * S: my(pc + 2) = Y - r3: mz(pc + 2) = z + r3
  mx(pc + 3) = X + r3 * S: my(pc + 3) = Y - r3: mz(pc + 3) = z - r3
  mx(pc + 4) = X + r3 * S: my(pc + 4) = Y + r3: mz(pc + 4) = z - r3
  L1(lc + 1) = pc + 1: L2(lc + 1) = pc + 2
  L1(lc + 2) = pc + 2: L2(lc + 2) = pc + 3
  L1(lc + 3) = pc + 3: L2(lc + 3) = pc + 4
  L1(lc + 4) = pc + 4: L2(lc + 4) = pc + 1
  pc = pc + 4: lc = lc + 4
 NEXT S
 FOR L = 1 TO 4
  L1(lc + L) = p0 + L: L2(lc + L) = p0 + L + 4
 NEXT L
 lc = lc + 4
  
 ' outer left/right cubes
 FOR S = -1 TO 1 STEP 2
  mx(pc + 1) = X + R * S: my(pc + 1) = Y + r3: mz(pc + 1) = z + r3
  mx(pc + 2) = X + R * S: my(pc + 2) = Y - r3: mz(pc + 2) = z + r3
  mx(pc + 3) = X + R * S: my(pc + 3) = Y - r3: mz(pc + 3) = z - r3
  mx(pc + 4) = X + R * S: my(pc + 4) = Y + r3: mz(pc + 4) = z - r3
  L1(lc + 1) = pc + 1: L2(lc + 1) = pc + 2
  L1(lc + 2) = pc + 2: L2(lc + 2) = pc + 3
  L1(lc + 3) = pc + 3: L2(lc + 3) = pc + 4
  L1(lc + 4) = pc + 4: L2(lc + 4) = pc + 1
  pc = pc + 4: lc = lc + 4
 NEXT S
 FOR L = 1 TO 8
  L1(lc + L) = p0 + 8 + L: L2(lc + L) = p0 + L
 NEXT L
 lc = lc + 8
 
 ' top/bottom cubes
 FOR S = -1 TO 1 STEP 2
  mx(pc + 1) = X + r3: my(pc + 1) = Y + R * S: mz(pc + 1) = z + r3
  mx(pc + 2) = X - r3: my(pc + 2) = Y + R * S: mz(pc + 2) = z + r3
  mx(pc + 3) = X - r3: my(pc + 3) = Y + R * S: mz(pc + 3) = z - r3
  mx(pc + 4) = X + r3: my(pc + 4) = Y + R * S: mz(pc + 4) = z - r3
  L1(lc + 1) = pc + 1: L2(lc + 1) = pc + 2
  L1(lc + 2) = pc + 2: L2(lc + 2) = pc + 3
  L1(lc + 3) = pc + 3: L2(lc + 3) = pc + 4
  L1(lc + 4) = pc + 4: L2(lc + 4) = pc + 1
  pc = pc + 4: lc = lc + 4
 NEXT S
 L1(lc + 1) = p0 + 17: L2(lc + 1) = p0 + 6
 L1(lc + 2) = p0 + 18: L2(lc + 2) = p0 + 2
 L1(lc + 3) = p0 + 19: L2(lc + 3) = p0 + 3
 L1(lc + 4) = p0 + 20: L2(lc + 4) = p0 + 7
 L1(lc + 5) = p0 + 21: L2(lc + 5) = p0 + 5
 L1(lc + 6) = p0 + 22: L2(lc + 6) = p0 + 1
 L1(lc + 7) = p0 + 23: L2(lc + 7) = p0 + 4
 L1(lc + 8) = p0 + 24: L2(lc + 8) = p0 + 8
 lc = lc + 8
 
	' front/back cubes
 FOR S = -1 TO 1 STEP 2
  mx(pc + 1) = X + r3: my(pc + 1) = Y + r3: mz(pc + 1) = z + R * S
  mx(pc + 2) = X - r3: my(pc + 2) = Y + r3: mz(pc + 2) = z + R * S
  mx(pc + 3) = X - r3: my(pc + 3) = Y - r3: mz(pc + 3) = z + R * S
  mx(pc + 4) = X + r3: my(pc + 4) = Y - r3: mz(pc + 4) = z + R * S
  L1(lc + 1) = pc + 1: L2(lc + 1) = pc + 2
  L1(lc + 2) = pc + 2: L2(lc + 2) = pc + 3
  L1(lc + 3) = pc + 3: L2(lc + 3) = pc + 4
  L1(lc + 4) = pc + 4: L2(lc + 4) = pc + 1
  pc = pc + 4: lc = lc + 4
 NEXT S
 L1(lc + 1) = p0 + 25: L2(lc + 1) = p0 + 8
 L1(lc + 2) = p0 + 26: L2(lc + 2) = p0 + 4
 L1(lc + 3) = p0 + 27: L2(lc + 3) = p0 + 3
 L1(lc + 4) = p0 + 28: L2(lc + 4) = p0 + 7
 L1(lc + 5) = p0 + 29: L2(lc + 5) = p0 + 5
 L1(lc + 6) = p0 + 30: L2(lc + 6) = p0 + 1
 L1(lc + 7) = p0 + 31: L2(lc + 7) = p0 + 2
 L1(lc + 8) = p0 + 32: L2(lc + 8) = p0 + 6
 lc = lc + 8
 
IF (R > 20 AND pc <= 680 AND mode = 1) OR R = 80 THEN
 menger X + 2 * r3, Y + 2 * r3, z + 2 * r3, r3
 menger X - 2 * r3, Y + 2 * r3, z + 2 * r3, r3
 menger X - 2 * r3, Y - 2 * r3, z + 2 * r3, r3
 menger X + 2 * r3, Y - 2 * r3, z + 2 * r3, r3
 menger X + 2 * r3, Y + 2 * r3, z - 2 * r3, r3
 menger X - 2 * r3, Y + 2 * r3, z - 2 * r3, r3
 menger X - 2 * r3, Y - 2 * r3, z - 2 * r3, r3
 menger X + 2 * r3, Y - 2 * r3, z - 2 * r3, r3
 menger X, Y + 2 * r3, z + 2 * r3, r3
 menger X, Y - 2 * r3, z + 2 * r3, r3
 menger X, Y - 2 * r3, z - 2 * r3, r3
 menger X, Y + 2 * r3, z - 2 * r3, r3
 menger X + 2 * r3, Y, z + 2 * r3, r3
 menger X - 2 * r3, Y, z + 2 * r3, r3
 menger X - 2 * r3, Y, z - 2 * r3, r3
 menger X + 2 * r3, Y, z - 2 * r3, r3
 menger X + 2 * r3, Y + 2 * r3, z, r3
 menger X - 2 * r3, Y + 2 * r3, z, r3
 menger X - 2 * r3, Y - 2 * r3, z, r3
 menger X + 2 * r3, Y - 2 * r3, z, r3
END IF
 
END SUB

REM $DYNAMIC
SUB Oldskool (mode)
	DIM Sprite(0, 0) AS STRING * 1
	DIM Logo(0, 0) AS STRING * 1
	DIM Scroller(0, 0) AS STRING * 1

	CLS
	BS = VARSEG(BlankScr(0, 0)): BO = VARPTR(BlankScr(0, 0))
	VS = VARSEG(VirtScr(0, 0)): VO = VARPTR(VirtScr(0, 0))
	DEF SEG = BS
	FOR M = 0 TO 199
		YRow = M * 320
		FOR L = 0 TO 319: POKE BO + L + YRow, 0: NEXT L
	NEXT M

	RestorePalette 22 + mode
	RestorePic 17, Sprite()
	SS = Pics(17).Seg: SO = Pics(17).Offs
	SCC = Pics(17).ClearColor

	RestorePic mode + 55, Scroller()
	ScS = VARSEG(Scroller(0, 0)): ScO = VARPTR(Scroller(0, 0))
	ScW = Pics(mode + 55).Width

	Size& = Pics(60).Height * Pics(60).Width
	MoveFromXMS Handles(24), BS, BO, Size&, 0

	points = 50
	DIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
	DIM Dx(points), Dy(points), JZ(points) AS INTEGER
	DIM Shy(points)
	DIM xrot AS SINGLE, yrot AS SINGLE, zrot AS SINGLE
	DIM cosx AS SINGLE, sinx AS SINGLE
	DIM cosy AS SINGLE, siny AS SINGLE
	DIM cosz AS SINGLE, sinz AS SINGLE
	DIM camdist AS SINGLE
	DIM fsort(points)
	
	camdist = 200: xoffset = 160: yoffset = 100
	
	DEF SEG = BS
	FOR Y = 45 TO 109
		YRow = Y * 320: y1 = Y \ 3 + 6
		FOR X = 0 TO 319
			POKE X + YRow, y1
		NEXT X
	NEXT Y
	' draw logo
	'FOR Y = 0 TO LogoD.Height - 1
		'CALL BlockMove(LogoS, LogoO + Y * LogoD.Width, BS, BO + Y * 320, LogoD.Width, 0)
	'NEXT Y
	' draw trailblazer
	FOR Y = 70 TO 135
			  YRow = (Y + 40) * 320
			  y1 = 16 - ((((200 - Y) / 25) ^ 2.5) MOD 16)
			  FOR X = 0 TO 319
				  IF ((1.5 * (X - 160)) / (Y - 20)) MOD 2 = 0 THEN
					POKE BO + X + YRow, y1 + 130
				  ELSE
					POKE BO + X + YRow, ((y1 + 7) MOD 16) + 131
				  END IF
			  NEXT X
	NEXT Y
	
	' generate balls
	FOR P = 1 TO points
		X(P) = RND * 100 - 50: Y(P) = RND * 100 - 50: z(P) = RND * 100 - 50
	NEXT P
	
	SELECT CASE mode
	CASE 1: RESTORE Oldskool1Data
	CASE 2: RESTORE Oldskool2Data
	CASE 3: RESTORE Oldskool3Data
	CASE 4: RESTORE Oldskool4Data
	END SELECT
	READ duration, speed!, direction
	duration = duration * 1000
	QTSetTimer 1, 32767
	t0 = 32767: t3 = t0

	DO
		CALL BlockMove(BS, BO, VS, VO, 64000, 0)

		t1 = QTGetTimer(1)

		IF t0 - t1 > duration THEN
			t0 = t1
			t3 = t
			READ duration, speed!, direction
			duration = duration * 1000
		END IF

		t = t3 - ((t0 - t1) * speed! * direction)

		' scroller
		X = (4681 - t \ 7)
		FOR Y = 0 TO 24
			CALL BlockMove(ScS, ScO + X + Y * ScW, VS, VO + (Y + 175) * 320, 320, 0)
		NEXT Y

		' rotate trailblazer palette
		t2 = 16 - ((t \ 50) MOD 16)
		FOR L = 1 TO 16
			  OUT &H3C8, L + 130
			  IF ((L - t2) + 16) MOD 16 >= 1 AND ((L - t2) + 16) MOD 16 <= 8 THEN
					OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
			  ELSE
					OUT &H3C9, 63: OUT &H3C9, 0: OUT &H3C9, 0
			  END IF
		NEXT L
	
		' rotate balls
		xrot = t / 1500
		yrot = t / 1500
		zrot = t / 2500
		'IF t = 0 THEN QTSetTimer 1, 32767   ' only lasts 32.7 seconds :/
		cosx = COS(xrot): sinx = SIN(xrot)
		cosy = COS(yrot): siny = SIN(yrot)
		cosz = COS(zrot): sinz = SIN(zrot)
		FOR P = 1 TO points
			' x-axis rotate
			JY1 = cosx * Y(P) - sinx * z(P)
			JZ1 = sinx * Y(P) + cosx * z(P)
			' y-axis rotate
			JX1 = siny * JZ1 + cosy * X(P)
			JZ(P) = cosy * JZ1 - siny * X(P)
			' z-axis rotate
			JX = cosz * JX1 - sinz * JY1
			JY = sinz * JX1 + cosz * JY1
			' map 3d to 2d
			Dx(P) = (-JX * 150) / (JZ(P) + camdist) + xoffset
			Dy(P) = (-JY * 125) / (JZ(P) + camdist) + yoffset
			Shy(P) = (100 * 125) / (JZ(P) + camdist) + yoffset
		NEXT P
		DEF SEG = VS
		FOR P = 1 TO points
			IF Dx(P) >= 0 AND Dx(P) < 300 AND Shy(P) >= 0 AND Shy(P) < 175 THEN
					FOR L = 0 TO 15: POKE Dx(P) + L + Shy(P) * 320, 0: NEXT L
					FOR L = 2 TO 13: POKE Dx(P) + L + (Shy(P) + 1) * 320, 0: POKE Dx(P) + L + (Shy(P) - 1) * 320, 0: NEXT L
			END IF
		NEXT P
		FOR P = 1 TO points: fsort(P) = P: NEXT P
		Shellsort JZ()
		DEF SEG = SS
		FOR P = points TO 1 STEP -1
			M = fsort(P)
			Dx = Dx(M): Dy = Dy(M)
			IF JZ(P) > -150 THEN
			  IF Dx >= 0 AND Dx < 300 AND Dy >= 0 AND Dy < 180 THEN
					FOR L = 0 TO 15
						SOL16 = SO + L * 16
						YRow = (Dy + L) * 320
						FOR M = 0 TO 15
							IF PEEK(M + SOL16) <> SCC THEN
								CALL BlockMove(SS, M + SOL16, VS, VO + Dx + M + YRow, 1, 0)
							END IF
						NEXT M
					NEXT L
			  END IF
			END IF
		NEXT P
		CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
		'IF INKEY$ = CHR$(27) THEN GOTO TheEnd
		IF mode = 1 AND MusicRow >= 60 THEN EXIT DO
		IF mode = 2 AND MusicRow >= 4 AND MusicRow <= 20 THEN EXIT DO
		IF mode = 3 AND MusicRow >= 10 AND MusicRow <= 20 THEN EXIT DO
		IF mode = 4 AND MusicOrder(255) = 41 THEN EXIT DO

		IF mode = 4 AND MusicRow >= 32 THEN
			CALL BlockMove(INT(RND * 1000), 0, SS, SO, 256, 0)
		END IF
	LOOP

ERASE Sprite, Logo, Scroller, X, Y, z, Dx, Dy, JZ, Shy, fsort

END SUB

SUB Parrot (mode)
	CLS
	RestorePalette 21
	PH = Pics(52).Height: PW = Pics(52).Width
	Size& = PH * PW

	SELECT CASE mode
	CASE 1: RESTORE Parrot1Data: t2 = 1323
	CASE 2: RESTORE Parrot2Data: t2 = 2206
	CASE 3: RESTORE Parrot3Data: t2 = 2647
	CASE 4: RESTORE Parrot4Data: t2 = 1618
	CASE 5: RESTORE Parrot5Data: t2 = 2132
	END SELECT
	QTSetTimer 1, t2

	READ Sprite, sx, sy, duration
	duration = duration * 1000
	
	DO
		t1 = QTGetTimer(1)
	
		IF t2 - t1 >= duration THEN
			READ Sprite, sx, sy, duration
			duration = duration * 1000
			t2 = t1
		END IF
	
		FOR Y = 0 TO PH - 1
			MoveFromXMS Handles(Pics(Sprite + 51).Handle), &HA000, sx + (Y + sy) * 320, PW, (Sprite - 1) * Size& + Y * PW
		NEXT Y

		IF mode = 1 AND MusicRow >= 46 THEN EXIT DO
		IF mode = 2 AND MusicRow <= 10 THEN EXIT DO
		IF mode = 3 AND MusicRow <= 10 THEN EXIT DO
		IF mode = 4 AND (MusicRow >= 62 OR MusicRow <= 10) THEN EXIT DO
		IF mode = 5 AND MusicRow >= 39 THEN EXIT DO
	LOOP
	
END SUB

SUB RestorePalette (Pal)
	Size& = 256 * 3 * 2&
	MoveFromXMS PalHandle, VARSEG(Palett(0, 1)), VARPTR(Palett(0, 1)), Size&, (Pal - 1) * Size&
	FOR L = 0 TO 255
		OUT &H3C8, L
		FOR M = 1 TO 3: OUT &H3C9, Palett(L, M): NEXT M
	NEXT L
END SUB

SUB RestorePic (Slot, Array() AS STRING * 1)
	REDIM Array(Pics(Slot).Width - 1, Pics(Slot).Height - 1) AS STRING * 1
	Pics(Slot).Seg = VARSEG(Array(0, 0)): Pics(Slot).Offs = VARPTR(Array(0, 0))
	Size& = Pics(Slot).Width * Pics(Slot).Height
	MoveFromXMS Handles(Pics(Slot).Handle), Pics(Slot).Seg, Pics(Slot).Offs, Size&, Pics(Slot).HandleOffset * Size&
END SUB

SUB SavePalette (Pal)
	Size& = 256 * 3 * 2&
	MoveToXMS PalHandle, VARSEG(Palett(0, 1)), VARPTR(Palett(0, 1)), Size&, (Pal - 1) * Size&
END SUB

' SubRoutine by Andy Voss '94
' Sorts an array, quickly.
SUB Shellsort (Array())
SHARED fsort()
Span = UBOUND(Array) \ 2
DO WHILE Span > 0
	 FOR I = Span TO UBOUND(Array) - 1
		  FOR J = (I - Span + 1) TO 1 STEP -Span
				IF Array(J) <= Array(J + Span) THEN EXIT FOR
				SWAP Array(J), Array(J + Span)
				SWAP fsort(J), fsort(J + Span)
		  NEXT J
	 NEXT I
	 Span = Span \ 2
LOOP
 
END SUB

SUB sprink (BYVAL X, BYVAL Y, C)
	IF Y >= 0 AND Y < 200 THEN
		POKE X + Y * 320, C
		POKE X + 1 + Y * 320, C
	END IF
END SUB

SUB TriFill (BYVAL x1, BYVAL y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, Col)
' sort point pairs top-to-bottom
IF Y2 < y1 THEN SWAP Y2, y1: SWAP X2, x1
IF Y3 < y1 THEN SWAP Y3, y1: SWAP X3, x1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2
Y21 = Y2 - y1: Y31 = Y3 - y1: X21 = X2 - x1: X31 = X3 - x1
Y23 = Y2 - Y3: Y13 = y1 - Y3: X23 = X2 - X3: X13 = x1 - X3
IF Y31 = 0 THEN EXIT SUB
S = SGN((x1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB
IF y1 <> Y2 THEN
	FOR Y = y1 TO Y2
		IF Y > 0 AND Y < 199 THEN
			YRow = Y * 320
			MidX = x1 + ((Y - y1) / Y21) * X21
			BottomX = x1 + ((Y - y1) / Y31) * X31
			FOR X = MidX TO BottomX STEP S
				POKE X + YRow, Col   ' PSET (X, Y), Col
			NEXT X
		END IF
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y > 0 AND Y < 199 THEN
			YRow = Y * 320
			MidX = X3 + ((Y - Y3) / Y23) * X23
			TopX = X3 + ((Y - Y3) / Y13) * X13
			FOR X = MidX TO TopX STEP S
				POKE X + YRow, Col  ' PSET (X, Y), Col
			NEXT X
		END IF
	NEXT Y
END IF
END SUB

SUB TriGFill (BYVAL x1, BYVAL y1, Col1, BYVAL X2, BYVAL Y2, Col2, BYVAL X3, BYVAL Y3, Col3)
' sort point pairs top-to-bottom
IF Y2 < y1 THEN SWAP Y2, y1: SWAP X2, x1: SWAP Col2, Col1
IF Y3 < y1 THEN SWAP Y3, y1: SWAP X3, x1: SWAP Col3, Col1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2: SWAP Col3, Col2
Y21 = Y2 - y1: Y31 = Y3 - y1: X21 = X2 - x1: X31 = X3 - x1
Y23 = Y2 - Y3: Y13 = y1 - Y3: X23 = X2 - X3: X13 = x1 - X3
Col12 = Col1 - Col2: Col13 = Col1 - Col3: Col23 = Col2 - Col3
IF Y31 = 0 THEN EXIT SUB
S = SGN((x1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB
IF y1 <> Y2 THEN
	FOR Y = y1 TO Y2
		IF Y >= 0 AND Y < 200 THEN
		YRow = Y * 320
		MidX = x1 + ((Y - y1) / Y21) * X21
		BottomX = x1 + ((Y - y1) / Y31) * X31
		YC1 = Y - y1
		A! = Col1 - YC1 / Y21 * Col12
		B! = Col1 - YC1 / Y31 * Col13
		BA! = B! - A!
		MBX = ABS(MidX - BottomX) + 1
		FOR X = MidX TO BottomX STEP S
			IF X >= 0 AND X < 320 THEN
				Col = A! + (ABS(X - MidX) / MBX) * BA!
				POKE X + YRow, Col   'PSET (X, Y), Col
			END IF
		NEXT X
		END IF
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y >= 0 AND Y < 200 THEN
		YRow = Y * 320
		MidX = X3 + ((Y - Y3) / Y23) * X23
		TopX = X3 + ((Y - Y3) / Y13) * X13
		YC3 = Y - Y3
		A! = Col3 + (YC3 / Y23) * Col23
		B! = Col3 + (YC3 / Y13) * Col13
		BA! = B! - A!
		MTX = ABS(MidX - TopX) + 1
		FOR X = MidX TO TopX STEP S
			IF X >= 0 AND X < 320 THEN
				Col = A! + (ABS(X - MidX) / MTX) * BA!
				POKE X + YRow, Col   'PSET (X, Y), Col
			END IF
		NEXT X
		END IF
	NEXT Y
END IF
END SUB

