/*
   Reverie
   starfield.h
   Copyright (C)2003 Dan Potter
*/

#ifndef __STARFIELD_H
#define __STARFIELD_H

/* Pulled and greatly adapted from Tryptonite */

class StarField : public Drawable {
public:
	StarField(int ns);
	virtual ~StarField();

	virtual void draw(int list);
	virtual void nextFrame();

	// Set us into snow mode
	void setSnowMode();

	// Set us into normal 3d mode
	void set3dMode();

	// Set our star move/view direction
	void setCourse(const Vector & dir);

	// Set the active number of stars
	void setActive(int sns);

	class SnowToStars : public Animation {
	public:
		SnowToStars() { }
		virtual ~SnowToStars() { }

		virtual void nextFrame(Drawable * t) {
			StarField * sf = (StarField *)t;
			sf->set3dMode();
			sf->setActive(1024);
			complete(t);
		}
	};

	class ZoomAround : public Animation {
	public:
		ZoomAround(int howlong) {
			m_hl = howlong;
			m_f = 0;
		}
		virtual ~ZoomAround() { }

		virtual void nextFrame(Drawable * t) {
			if (m_f >= m_hl)
				complete(t);
			else {
				StarField * sf = (StarField *)t;
				sf->setCourse(
					Vector(fsin(m_f * 2*M_PI / 240.0f) * 6.0f,
						fsin((m_f + 64.0f) * 2*M_PI / 260.0f) * 6.0f,
						1.0f));

				m_f++;
			}
		}

	private:
		int	m_hl, m_f;
	};

private:
	// Class to contain a single star about to be rendered
	struct StarVector : public Vector {
		bool	active;
		float	b;

		StarVector & operator=(const Vector & other) {
			x = other.x;
			y = other.y;
			z = other.z;
			active = true;
		}
	};

	void wrapStar(const Vector & moveNorm, Vector & toFix);
	void polyPnt(float x, float y, float z, float size, uint32 color);

	int		m_ns, m_sns;
	Vector		* m_stars, * m_starsMoveDir;
	StarVector	* m_starsTran;

	Vector		m_moveDir, m_viewDir, m_moveDirGoal;
	bool		m_snowMode;
};

#endif	// __STARFIELD_H

