/* 
   screenwave.cpp
   Copyright (C)2003 Dan Potter
*/

#include "global.h"
#include "screenwave.h"

/* Taken from the Parallax rotocube example */

ScreenWave::ScreenWave() {
	m_theta = 0;
}

ScreenWave::~ScreenWave() {
}

void ScreenWave::draw(int list) {
	if (list != PLX_LIST_OP_POLY)
		return;

	uint32 color = getColor();
	int i, divs = 320;
	float x, y, t;
	plx_dr_state_t dr;

	plx_dr_init(&dr);

	plx_cxt_texture(NULL);
	plx_cxt_culling(PLX_CULL_NONE);
	plx_cxt_send(list);

	// Convert to radians for sin/cos
	t = m_theta * 2*M_PI / 360.0f;

	Vector pos = getPosition();

	for (i=0; i<=divs; i++) {
		x = i*640.0f/divs;

		// These are more or less magic numbers I played with until
		// it looked neat.
		y = 240.0f + fsin(t + i*M_PI/64.0f)*30.0f*fsin(t*4);
		y += fcos(t + i*M_PI/36.0f)*40.0f*fcos(t*6);
		y += fcos(t + i*M_PI/30.0f)*24.0f*fcos(t*8);

		plx_vert_ind(&dr, PLX_VERT, pos.x+x, y+pos.y, pos.z, color);
		plx_vert_ind(&dr, i == divs ? PLX_VERT_EOS : PLX_VERT, pos.x+x, pos.y+480.0f, pos.z, color);
	}
}

void ScreenWave::nextFrame() {
	m_theta++;
	Drawable::nextFrame();
}
