/*
   Reverie
   phongspheres.h
   Copyright (C)2003 Dan Potter
*/

#ifndef __PHONGSPHERES_H
#define __PHONGSPHERES_H

class PhongSpheres : public Drawable {
public:
	PhongSpheres(Texture * tw, Texture * th, Texture * tb);
	virtual ~PhongSpheres();

	virtual void draw(int list);
	virtual void nextFrame();

private:
	void drawSphere(float a, float za, bool partial);
	void drawLight(const Vector & pos);

	Vector		m_sphereTrans[4], m_lightTrans;
	Vector		m_sphereLights[4];
	Vector		m_light;
	RefPtr<Texture>	m_txr, m_txrh, m_txrb;
	float		m_theta;
};

#endif	// __PHONGSPHERES_H

