/*
   Reverie
   melter.h
   Copyright (C)2003 Dan Potter
*/

#ifndef __MELTER_H
#define __MELTER_H

class Melter : public Drawable {
public:
	Melter(Texture * t);
	virtual ~Melter();

	virtual void draw(int list);
	virtual void nextFrame();

	void	meltOut();

	class MeltOut : public Animation {
	public:
		MeltOut() { }
		virtual ~MeltOut() { }

		virtual void nextFrame(Drawable * t) {
			Melter * m = (Melter *)t;
			if (!m->m_meltOff)
				m->meltOut();
			else {
				if (m->m_pos >= m->m_txr->getH())
					complete(t);
			}
		}
	};

private:
	RefPtr<Texture>		m_txr;
	int			m_pos;
	bool			m_meltOff;
};

#endif
