/*
   Reverie
   linearmover.h
   Copyright (C)2003 Dan Potter
*/

#ifndef __LINEARMOVER_H
#define __LINEARMOVER_H

class LinearMover : public Animation {
public:
	LinearMover(const Vector & to, const Vector & d) {
		m_to = to;
		m_d = d;
	}

	virtual ~LinearMover() { }

	virtual void nextFrame(Drawable * t) {
		Vector pos = t->getTranslate();
		pos += m_d;
		if (clamp(pos)) {
			pos = m_to;
			complete(t);
		}

		t->setTranslate(pos);
	}

	bool clamp(Vector & pos) {
		bool allfinished = true;
		float poses[3] = {pos.x, pos.y, pos.z};
		float tos[3] = {m_to.x, m_to.y, m_to.z};
		float deltas[3] = {m_d.x, m_d.y, m_d.z};

		for (int i=0; i<3; i++) {
			if (deltas[i] < 0.0f) {
				if (poses[i] <= tos[i])
					poses[i] = tos[i];
				else
					allfinished = false;
			} else {
				if (poses[i] >= tos[i])
					poses[i] = tos[i];
				else
					allfinished = false;
			}
		}

		pos = Vector(poses[0], poses[1], poses[2]);
		return allfinished;
	}

private:
	Vector	m_to, m_d;
};

#endif	// __LINEARMOVER_H

