/* 
   Reverie
   endscroller.cpp
   Copyright (C)2003 Dan Potter
*/

#include "global.h"
#include "endscroller.h"

/*
   This is a really simplistic scroller. In fact it's got its text
   and font hard-coded even. :) Anyway, it does the job.
*/

static const char trans[256] = {
	-1, -1, -1, -1,   -1, -1, -1, -1,   -1, -1, -1, -1,   -1, -1, -1, -1,	// 0
	-1, -1, -1, -1,   -1, -1, -1, -1,   -1, -1, -1, -1,   -1, -1, -1, -1,	// 16
	-1, -1, -1, -1,   -1, -1, 31, -1,   -1, -1, -1, -1,   27, -1, 26, -1,	// 32
	28, -1, 29, 30,   -1, -1, -1, -1,   -1, -1, -1, -1,   -1, -1, -1, -1,	// 48

	-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,			// 64
	15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25				// 80
};

static const char * scrtext[] = {
"\bReverie",
"Final Diftro",
"\bby",
"\bDan Potter",
"",
"",
"",
"for the Xmas",
"TUM 2003",
"DC compo",
"",
"",
"",
"The background",
"music was",
"tracked in",
"ModPlug Tracker.",
"Samples were",
"borrowed from",
"Vogue of Triton",
"and",
"Purple Motion",
"of Future Crew.",
"",
"",
"",
"The title screen",
"font is Flubber",
"from the latest",
"Knoppix CD. The",
"other font was",
"created from",
"scratch in The",
"Gimp.",
"",
"",
"",
"I hope you",
"enjoyed this",
"small blast from",
"the past. I only",
"had about a week",
"and a half to",
"write all the",
"code, do art,",
"track music, etc,",
"so it is not as",
"good or as long",
"as I would have",
"hoped. Not too",
"bad though.",
"",
"",
"",
"As you might have",
"implied from the",
"title if you",
"followed the",
"early PC demo",
"scene, this demo",
"concludes the",
"work of the late",
"\bDigital Infinity",
"of Farandole",
"Composer fame.",
"Please check out",
"our recent game",
"work at...",
"",
"www.cagames.com",
"",
"",
"",
"Thanks for",
"watching, have",
"a good new year.",
"",
"",
"",
"",
"",
"",
"",
"",
"\bCopyright & 2003",
"\tDan Potter",
"\bCryptic Allusion",
NULL };


EndScroller::EndScroller(Texture * txr) {
	m_offs = 480;
	m_do = -1.0f;
	m_txr = txr;
	m_stopcnt = 0;
}

EndScroller::~EndScroller() {
}

void EndScroller::draw(int list) {
	if (list != PLX_LIST_TR_POLY)
		return;

	plx_cxt_texture(*m_txr);
	plx_cxt_culling(PLX_CULL_NONE);
	plx_cxt_send(list);

	plx_dr_state_t dr;
	plx_dr_init(&dr);

	Vector pos = getPosition();
	float y = m_offs;
	for (int i=0; scrtext[i]; i++) {
		Color color = getColor();
		const char * c = scrtext[i];
		int ch = c[0];
		bool bold = false;
		if (ch == '\t') {
			ch = '\b';
			if (m_do && y == (240.0f - 16.0f)) {
				m_do = 0.0f;
				m_stopcnt = 240;
			}
		}
		if (ch == '\b') {
			bold = true;
			c++;
			color.g *= 0.8f;
			color.b = 0.0f;
		}
		uint32 col = color;
		int len = strlen(c);
		float w = len * 32.0f;

		float x = 320.0f - w/2.0f;
		for (int j=0; j<len; j++) {
			ch = trans[toupper(c[j])];
			if (ch == -1) {
				x += 20.0f;
				continue;
			}
			int cx = ch % 8;
			int cy = ch / 8;
			plx_vert_ifd(&dr, PLX_VERT, x+00, y+32, pos.z, col, (cx+0)/8.0f, (cy+1)/8.0f);
			plx_vert_ifd(&dr, PLX_VERT, x+00, y+00, pos.z, col, (cx+0)/8.0f, (cy+0)/8.0f + 1.0f/256.0f);
			plx_vert_ifd(&dr, PLX_VERT, x+32, y+32, pos.z, col, (cx+1)/8.0f, (cy+1)/8.0f);
			plx_vert_ifd(&dr, PLX_VERT_EOS, x+32, y+00, pos.z, col, (cx+1)/8.0f, (cy+0)/8.0f + 1.0f/256.0f);
			x += 32.0f;
		}
		y += 34.0f;
	}
}

class GoPoofy : public Trigger {
public:
	virtual void trigger(Drawable * d, Animation * a) {
		arch_exit();
	}
};

void EndScroller::nextFrame() {
	m_offs += m_do;
	if (!m_do && m_stopcnt) {
		m_stopcnt--;
		if (m_stopcnt <= 0) {
			TintFader * tf = new TintFader(Color(1,0,0,0), Color(0,-1.0f/60.0f,-1.0f/60.0f,-1.0/60.0f));
			getParent()->animAdd(tf);

			// Croak us.
			//tf->triggerAdd(new Death(getParent()));
			tf->triggerAdd(new GoPoofy());

			m_stopcnt = 0;
		}
	}
	Drawable::nextFrame();
}

