// trackerView.h : interface of the CPatternView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_TRACKERVIEW_H__1BEC9C48_ADE4_468E_9694_C4FD06104F43__INCLUDED_)
#define AFX_TRACKERVIEW_H__1BEC9C48_ADE4_468E_9694_C4FD06104F43__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "dblbuffView.h"
#include "trackerDoc.h"
#include "gtkformat.h"
#include "MIDIReceptor.h"


class CPatternView : public CDblBuffView, public MIDIReceptor
{
	protected: // create from serialization only
		CPatternView();
		DECLARE_DYNCREATE(CPatternView)

		int seqpatscr;
		CScrollBar seqScroller,patScroller;		

	// Attributes
	public:
		CTrackerDoc* GetDocument();
		int isPatternEdit;
	
		EDT_CURSOR seqCursor,patCursor;	
		int seqPos, patternPos;
	
		GTK_SEQCHANNEL *seqChnPtr;
		GTK_PATTERNPOS *patTrackPtr;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPatternView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	virtual void OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView);
	//}}AFX_VIRTUAL

// Implementation
public:

	// <MIDI HANDLERS>
	virtual void OnMIDIKeyDown( UINT key, UINT velocity );
	virtual void OnMIDIKeyUp( UINT key, UINT velocity );
	// </MIDI HANDLERS>

	void SetSequencerCursor (int val,int flag);
	void MoveSequencerCursor (int val,int flag);
  void ModifySequencerData (int val);

  void PatternInterpolate (int rowcol, int start_pos, int end_pos);///patCursor.rowcol,pDoc->editData.beginmark.pos,pDoc->editData.endmark.pos)
    

  void PastePatternBlock();
  void CopyPatternBlock();
  void SetPatternCursor (int val,int flag);
	void MovePatternCursor (int val,int flag);
	int PatternProcessEditKey (int nChar, int ctrlflag);


	void ProcessSequencerKey(UINT nChar, UINT nRepCnt, UINT nFlags);
	void ProcessPatternKey(UINT nChar, UINT nRepCnt, UINT nFlags);
	void DrawSequencer (CDC *pDC);
	void DrawPattern (CDC *pDC);
	virtual ~CPatternView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
public:
	//{{AFX_MSG(CPatternView)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnActionPlay();
	afx_msg void OnActionStop();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnEditCopy();
	afx_msg void OnEditPaste();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in trackerView.cpp
inline CTrackerDoc* CPatternView::GetDocument()
   { return (CTrackerDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TRACKERVIEW_H__1BEC9C48_ADE4_468E_9694_C4FD06104F43__INCLUDED_)
