/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isVoice_h
#define __isVoice_h

#include "isBase.h"
#include "isModulator.h"
#include "isOscillator.h"
#include "isInsert.h"
#include "isSamplePool.h"

const int MAXINSERTS = 8;

class isVoice : public isBase
{
public:
	isVoice(isSamplePool &samplePool);
	virtual ~isVoice();
	void Load(isFile *f);
	void Save(isFile *f);

	void Play(float *buffer);
	void Event(isEVENT event);
	void SetBufferSize(int length);
	bool Active() { return active; };
	
	// all adding/deleting occurs at the end of the list. so if you got 4 oscillators
	// and do a delete, oscillator 4 is deleted
	// for adding stuff in the voice. remember to supply the correct "type"
	void AddModulator(isTYPE type);
	void AddOscillator();
	void AddInsert(isTYPE type);

	// for deleting stuff in the voice
	void DelModulator();
	void DelOscillator();
	void DelInsert();

	// here goes stuff for the editor API
	// **********************************
	int GetNrOfModulators()		{ return nrOfModulators;	};
	int GetNrOfOscillators()	{ return nrOfOscillators;	};
	int GetNrOfInserts()		{ return nrOfInserts;	};
	
	isModulator		*GetModulator(int index);
	isOscillator	*GetOscillator(int index);
	isInsert			*GetInsert(int index);

	// increase/decrease the polyphony

	void IncPoly() { voicePoly++;};
	void DecPoly() { voicePoly--;};

	int	GetPoly() { return voicePoly; };
	void SetPoly(int poly) { voicePoly=poly; };
	

	// variables
	unsigned char noteRangeStart,noteRangeEnd; // which notes is this voice active for?

	// for volume mod (apart from envelope (modulator 0)
	unsigned char modNr[2];
	float modAmount[2];	
	// **********************************

private:

	isSamplePool &samplePool;
	
	unsigned int noteIndex;					// a increasing counter to help us overwrite the OLDEST note if we're out of poly
	unsigned int voiceNoteIndex[MAXPOLY];	// which is written here on a note on
	unsigned char voicePoly;
	// stuff for polyphony
	bool active[MAXPOLY],noteOn[MAXPOLY];				// is this voice active? And is note on/off
									// if it is off, and modulator[0] is 0, then set active=false
	int pitch[MAXPOLY];				// to check if this should be turned off by note_off

	unsigned char nrOfModulators;
	isModulator *modulator[256];	// more than 256 modulators? I don't think so
									// and modulator[0] is always the volume envelope
	unsigned char nrOfOscillators;
	isOscillator *oscillator[32];	// max 32 oscillators :) 
	
	unsigned char nrOfInserts;
	isInsert *insert[MAXINSERTS];
	

	// volume envelope
	float cVol[MAXPOLY];

	// how long is the buffer?
	int bufferLength;
	// temporary buffer for rendering oscillators, this is just pointers to float **isBase::tempBuffer
	float *tempBuff[2]; 

};

#endif
