/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include "isFile.h"

#include <string.h>
#include <stdlib.h>

isFile::isFile(HANDLE file, bool mem)
{
	this->mem=mem;
	bin = 1;

	if(!mem) {
		f=file;		
	}
	else
    {
        buffer=file;
        orgptr = (BYTE *)file;
    }
}


isFile::~isFile()
{

}

void isFile::WriteInt(long val, int bytes)
{
	for(int byte=0;byte<bytes;byte++)
	{
		long b=(val&(0x000000ff<<(byte*8)))>>(byte*8);
		//fwrite(&b,1,1,f);
		WriteFile(f,&b,1,&num,NULL);
	}
}

void isFile::WriteFloat(float val)
{
	//fwrite(&val,4,1,f);
	WriteFile(f,&val,4,&num,NULL);
}

void isFile::WriteString(char *str)
{
/*	fputs(str,f);
	fputc('\0',f);*/
	WriteFile(f,str,strlen(str)+1,&num,NULL);
}
DWORD isFile::GetPos()
{
    if (mem)
    {
        BYTE *pek = (BYTE *)buffer;
        return (pek - orgptr);
    } else
        return SetFilePointer(f,0,NULL,FILE_CURRENT);
        
}


void isFile::SkipComment()
{
/*	if(!bin)
	{
		int pos=ftell(f);
		fscanf(f,"%s",buf);
		if(buf[0]=='/' && buf[1]=='/')
		{
			fgets(&(buf[2]),BUFSIZE-2,f);
			pos=ftell(f);
			SkipComment();
		}
		else
		{
			fseek(f,pos,SEEK_SET);
			char c;
			int skiplen=-1;
			do
			{
				c=fgetc(f);
				skiplen++;
			} while(c==0x0a || c==' ' || c==0x0d  );
				
			fseek(f,pos+skiplen,SEEK_SET);
		}
	}*/
}

float isFile::ReadFloat()
{
	float val;
	if(mem)
	{
		float *temp=(float *)buffer;
		val=*temp++;
		buffer=(void *)temp;
		return val;

	}
	else
	{
		if(bin)
		{
			//fread(&val,4,1,f);
			ReadFile(f,&val,4,&num,NULL);
			return val;
		}
		else
		{
/*			// text file
			SkipComment();
			float val;
			fscanf(f,"%f",&val);*/
			return 0;
		}
	}
}

int isFile::ReadInt(int bytes)
{
	if(mem)
	{
		long val=0;
		unsigned char *temp=(unsigned char *)buffer;
		for(int byte=0;byte<bytes;byte++)
		{
			long a=(*temp++);
			val+=a<<(byte*8);
		}

		__asm mov eax, val
		__asm mov ecx, 4
		__asm sub ecx, bytes
		__asm shl ecx, 3
		__asm shl eax, cl
		__asm sar eax, cl
		__asm mov val, eax
		buffer=(void *)temp;
		return val;
	}
	else
	{
		if(bin)
		{
			// binary file
			long t,i;
			t=0;
			i=0;
			for(int byte=0;byte<bytes;byte++)
			{				
				//fread(&t,1,1,f);
				ReadFile(f,&t,1,&num,0);
				i+=t<<(byte*8);
			}

			__asm mov eax, i
			__asm mov ecx, 4
			__asm sub ecx, bytes
			__asm shl ecx, 3
			__asm shl eax, cl
			__asm sar eax, cl
			__asm mov i, eax
			
			return i;
		}
		else
		{
/*			// text file
			SkipComment();
			char c;
			int i,len;
			len=0;
			do
			{
				c=fgetc(f);
				buf[len]=c;
				len++;
			} while(c!=' ' && c!='\r' && c!='\n' && c!=' ');
			buf[len+1]='\0';
			i=atoi(buf);*/
			return 0;
		}
	}
}
char *isFile::ReadStr()
{
/*	if(mem)
	{
			unsigned char c,*temp=(unsigned char *)buffer;
			int len=0;
			do
			{	
				c=*temp++;
				buf[len]=c;
				len++;
			} while(c!='\0');
			buffer=(void *)temp;

			char *str=new (char [len]);
			strcpy(str,buf);
			return str;
	}
	else
	{
		if(bin)
		{
			// binary file
			char c;
			int len;
			len=0;
			do
			{
				c=fgetc(f);
				buf[len]=c;
				len++;
			} while(c!='\0');

			char *str=new (char [len]);
			strcpy(str,buf);
			return str;
		}
		else
		{
			// text file
			SkipComment();
			fgets(buf,BUFSIZE,f);
			int pos=ftell(f);
			int len;
			len=strlen(buf);
			char *str=new char[len+1];
			strcpy(str,buf);
			return str;
		}
	}*/
	return NULL;
}
