/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include "isEnvelope.h"

isEnvelope::isEnvelope()
{
	// variables
	a=0;
	d=8;
	s=0.8f;
	r=2;
	veloSens=1.0f;
	useSustain=true;

	// private
	for(int polyNr=0;polyNr<MAXPOLY;polyNr++)
	{
		noteOn[polyNr]=false;
		offVal[polyNr]=0.0f;
		startValue[polyNr]=endValue[polyNr]=val[polyNr]=0.0f;
		tickCounter[polyNr]=0;
		offTick[polyNr]=0;
		velo[polyNr]=0.0f;
		q1[polyNr]=q2[polyNr]=0;
	}

	// for isBase
	type=is_ENVELOPE;
	
}


isEnvelope::~isEnvelope()
{

}

void isEnvelope::Load(isFile *f)
{
	a=f->ReadInt(1);
	d=f->ReadInt(1);
	r=f->ReadInt(1);
	s=f->ReadFloat();
	veloSens=f->ReadFloat();
	useSustain=f->ReadInt(1)==0?false:true;	
}

void isEnvelope::Save(isFile *f)
{
	SaveType(f);
	f->WriteInt(a,1);
	f->WriteInt(d,1);
	f->WriteInt(r,1);
	f->WriteFloat(s);
	f->WriteFloat(veloSens);
	f->WriteInt(useSustain?1:0,1);
}

void isEnvelope::Render(int polyNr)
{
	// q1 and q2 are used for smoothing when an envelope is "overriden" by a note on before it has faded out
	
	// render start value
	if(noteOn[polyNr])
	{
		if(tickCounter[polyNr]<a)
			val[polyNr]=q1[polyNr]*(1.0f-(float)tickCounter[polyNr]/(float)a)+(float)tickCounter[polyNr]/(float)a;
		else if(tickCounter[polyNr]<(a+d))
			val[polyNr]=1.0f-(tickCounter[polyNr]-a)*(1.0f-s)/(float)d;
		else if(!useSustain)
		{
			if(tickCounter[polyNr]<(a+d+r))
			{
				val[polyNr]=s*(1.0f-(tickCounter[polyNr]-a-d)/(float)r);
			}
			else
				val[polyNr]=0.0f;			
		}
		else
		{
			val[polyNr]=s;
		}
	}
	else if(tickCounter[polyNr]<offTick[polyNr]+r) 
		val[polyNr]=offVal[polyNr]-offVal[polyNr]*((float)(tickCounter[polyNr]-offTick[polyNr])/(float)r);
	else val[polyNr]=0.0f;
	
	if(veloSens==0.0f) startValue[polyNr]=val[polyNr];
	else if(veloSens>0)
		startValue[polyNr]=val[polyNr]*((1.0f-veloSens)+(veloSens*velo[polyNr]));
	else
		startValue[polyNr]=val[polyNr]*((1.0f+veloSens)+(-veloSens*(1-velo[polyNr])));

	// render end value
	tickCounter[polyNr]++;

	if(noteOn[polyNr])
	{
		if(tickCounter[polyNr]<a)
			val[polyNr]=q1[polyNr]*(1.0f-(float)tickCounter[polyNr]/(float)a)+(float)tickCounter[polyNr]/(float)a;
		else if(tickCounter[polyNr]<(a+d))
			val[polyNr]=1.0f-(tickCounter[polyNr]-a)*(1.0f-s)/(float)d;
		else if(!useSustain)
		{
			if(tickCounter[polyNr]<(a+d+r))
			{
				val[polyNr]=s*(1.0f-(tickCounter[polyNr]-a-d)/(float)r);
			}
			else
				val[polyNr]=0.0f;			
		}
		else
		{
			val[polyNr]=s;
		}
	}
	else if(tickCounter[polyNr]<offTick[polyNr]+r) 
		val[polyNr]=offVal[polyNr]-offVal[polyNr]*((float)(tickCounter[polyNr]-offTick[polyNr])/(float)r);
	else val[polyNr]=0.0f;
	
	q2[polyNr]=val[polyNr];	
	if(veloSens==0.0f) endValue[polyNr]=val[polyNr];
	else if(veloSens>0)
		endValue[polyNr]=val[polyNr]*((1.0f-veloSens)+(veloSens*velo[polyNr]));
	else
		endValue[polyNr]=val[polyNr]*((1.0f+veloSens)+(-veloSens*(1-velo[polyNr])));
	
}

void isEnvelope::Event(isEVENT event,int polyNr)
{
	float lastVelo;
	switch(event.type)
	{
		case NOTE_ON:
			noteOn[polyNr]=true;
			tickCounter[polyNr]=0;
			startValue[polyNr]=endValue[polyNr]=val[polyNr]=0.0f;
			lastVelo=velo[polyNr];
			velo[polyNr]=event.param2/255.0f;
			q1[polyNr]=q2[polyNr]*lastVelo/velo[polyNr];
			break;
		case NOTE_OFF:
			noteOn[polyNr]=false;
			offTick[polyNr]=tickCounter[polyNr];
			offVal[polyNr]=val[polyNr];
	}
}

