/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include "isEffectChain.h"

#include "isDelay.h"
#include "isChorus.h"

isEffectChain::isEffectChain()
{
	for(int i=0;i<3;i++)
		effect[i] = 0;
	left = right = 0;
}

isEffectChain::~isEffectChain()
{
	for(int i=0;i<3;i++)
		if(effect[i])
			delete effect[i];
}

void isEffectChain::Save(isFile *f)
{
	// first save info about which effects are assigned (bit field)
	unsigned char saved=0;
	
	if(effect[0]!=NULL) saved|=1;
	if(effect[1]!=NULL) saved|=2;
	if(effect[2]!=NULL) saved|=4;
	
	f->WriteInt(saved,1);

	if(effect[0]!=NULL) effect[0]->Save(f);
	if(effect[1]!=NULL) effect[1]->Save(f);	
	if(effect[2]!=NULL) effect[2]->Save(f);
}

void isEffectChain::Load(isFile *f)
{
	for(int i=0;i<3;i++)
		if(effect[i]!=NULL) 
			delete effect[i];
		
	effect[0] = effect[1] = effect[2] = 0;

	unsigned char saved=f->ReadInt(1);
	unsigned char tjaff=1;
	isTYPE loadType;
	if(saved&1) 
	{
		loadType=LoadType(f);
		SetEffect(loadType,0);
		effect[0]->Load(f);
	}
	if(saved&2) 
	{
		loadType=LoadType(f);
		SetEffect(loadType,1);
		effect[1]->Load(f);
	}
	if(saved&4) 
	{
		loadType=LoadType(f);
		SetEffect(loadType,2);
		effect[2]->Load(f);
	}
	
}


void isEffectChain::Play(float *leftIn, float *rightIn, float *leftOut, float *rightOut)
{
	for(unsigned int b=0;b<bufferLength;b++)
	{
		left[b]=right[b]=0.0f;
	}
	// is effect 0 assigned? if so, render it and check if the the other two are assigned and render.
	if(effect[0]!=NULL) 
	{
		if(effect[1]!=NULL || effect[2]!=NULL)
			effect[0]->Play(leftIn,rightIn,left,right);
		else
		{
			effect[0]->Play(leftIn,rightIn,leftOut,rightOut);
			return;
		}
		
		if(effect[1]!=NULL) 
		{
			if(effect[2]!=NULL)
			{
				effect[1]->Play(left,right,left,right);
				effect[2]->Play(left,right,leftOut,rightOut);
			}
			else
			{
				effect[1]->Play(left,right,leftOut,rightOut);
				return;
			}
		}
		if(effect[2]!=NULL) 
		{
			effect[2]->Play(left,right,leftOut,rightOut);
			return;
		}
	}
	// is effect 1 assigned? if so, render it and check if effect 2 is assigned and render.
	if(effect[1]!=NULL) 
	{
		if(effect[2]!=NULL)
		{
			effect[1]->Play(leftIn,rightIn,left,right);
			effect[2]->Play(left,right,leftOut,rightOut);
			return;
		}
		else
			effect[1]->Play(leftIn,rightIn,leftOut,rightOut);
		return;
	}
	// if 0 and 1 was unassigned, is 2 assigned? render it. otherwise do nothing
	if(effect[2]!=NULL) 
	{
		effect[2]->Play(leftIn,rightIn,leftOut,rightOut);
		return;
	}

	
}

void isEffectChain::SetBufferSize(unsigned int length)
{	
	for(int nr=0;nr<3;nr++)
		if(effect[nr]) 
			effect[nr]->SetBufferSize(length);

	if(left!=NULL) 
	{
		delete [] left;
		delete [] right;
	}
	left = new float [length];
	right = new float [length];

	isStereoFX::SetBufferSize(length);
}

void isEffectChain::SetEffect(isTYPE type, unsigned int nr)
{
	if(nr>2) 
		return;

	if(effect[nr]) {
		delete effect[nr];
		effect[nr] = 0;
	}

	switch(type) {
	case is_DELAY:
		effect[nr] = new isDelay();		
		break;
	case is_CHORUS:
		effect[nr] = new isChorus();		
	default:
		break;
	}
	if (effect[nr]) {			
		effect[nr]->Update();
		effect[nr]->SetBufferSize( isStereoFX::bufferLength );
	}
}
void isEffectChain::DelEffect(unsigned int nr)
{
	if (nr > 2)
		return; 

	if(effect[nr]) 
	{
		delete effect[nr];
		effect[nr]=NULL;
	}
}
isStereoFX *isEffectChain::GetEffect(unsigned int nr)
{
	if (nr > 2) 
		return 0;
	else 
		return effect[nr];
}

void isEffectChain::Update()
{
	for(int i=0;i<3;i++)
		if(effect[i]) 
			effect[i]->Update();
}