/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isDelay_h
#define __isDelay_h

#include "isStereoFX.h"

#define MAXDELAY 129 

class isDelay : public isStereoFX
{
public:
	isDelay();
	virtual ~isDelay();
	
	void Save(isFile *f);
	void Load(isFile *f);

	void Play(float *leftIn, float *rightIn, float *leftOut, float *rightOut);
	void SetBufferSize(unsigned int length);
	void Update();

	struct DELAYTAP
	{
		unsigned int delay,echoLength; // 0..128
		float volume,feedback; // -1..1
	};

	DELAYTAP left,right;
	float dryMix; // -1..1
	
private:
	unsigned int bufferLength;
	unsigned int totalLengthLeft,totalLengthRight;
	float *buffersLeft[MAXDELAY];
	unsigned int tickCountLeft,delayTickCountLeft,echoTickCountLeft;
	float *buffersRight[MAXDELAY];
	unsigned int tickCountRight,delayTickCountRight,echoTickCountRight;
};

#endif
