/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isArpeggiator_h
#define __isArpeggiator_h

#include "isFile.h"
#include "isEvent.h"
#include "isVoice.h"

class isArpeggiator
{
public:
	isArpeggiator();
	~isArpeggiator();

	void Load(isFile *f);
	void Save(isFile *f);

	// call on each tick
	void Play(int nrOfVoices, isVoice **voice);

	// note on/off
	void Event(isEVENT event);

	struct isArpStep
	{
		unsigned char index[3]; // three channels
		unsigned char velocity;	// relative to input velocity
		unsigned char length;	// length in ticks until note off
		signed char octave;		// +/- octaves

	} step[32];

	int ticksPerRow;			// arpeggiospeed
private:
	int GetRealNoteNr(int index);

	// input note list
	unsigned char noteNr[16];	// 255 = no note;
	unsigned short velo[16];	// velo for each
	
	// notes to turn off
	struct offNotes
	{
		unsigned char offNoteNr;
		unsigned char offVelo;
		int length,tickCounter;
	} offNotesList[32*3];

//	unsigned char offNoteNr[16];// 255 = no note;
//	unsigned short offVelo[16];	// velo for each


	// increase this on each tick
	// reset when restarting arpeggio
	int tickCounter;
	// reset when reaching correct row
//	int stepTickCounter[32];	// to know when
								// to note off
	int rowCounter;
};
#endif

