/*-------------------------------------------------------------------------
	File    :	d:\source\tracker_release\Samples\bsTestPlayer\bsPlayer.cpp
    Author  :   Steffo
	Orginal :	-- long ago --
	Descr   :	Wrapper for isPlayer

--------------------------------------------------------------------------- 
    Todo [-:undone,+:inprogress,!:done]:


Changes: 

-- Date -- | -- Name ------- | -- Did what...                              
           |                 |

---------------------------------------------------------------------------*/

/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include <stdio.h>
#include <memory.h>
#include <windows.h>
#include <mmsystem.h>

#include <string.h>

#include "bsPlayer.h"
#include "isPlayer.h"
#include "gtkformat.h"

bsPlayer::bsPlayer(void *buff, HWND hWnd, bool precalc, int precalcEndPatter,BS_PRECALC_PROC callback, void *context)
{
	noMusic=false;
	
	syn=new isSynth();
	tune = gtk_load (syn,(char *)buff);
	pl=new isPlayer( hWnd, syn );
	if(precalc)
	{
#ifdef PLAYER_MINI_EDITION
		pl->PrecalcSong(tune,0,precalcEndPatter,TRUE,32768,callback,context);
#else
		::MessageBox(NULL,"Not compiled for precalc..","Error",MB_OK);
#endif
	}
}

bsPlayer::bsPlayer(float bpm)
{
	noMusic=true;
	rowPerSample=bpm;
}


bsPlayer::~bsPlayer()
{
	if(!noMusic)
	{
		pl->Stop();
		delete pl;
		delete syn;
		delete tune;
	}
}

void bsPlayer::process(void)
{
	if (!noMusic)
		pl->process();
}

void bsPlayer::Start(int startPos)
{
	timer.reset();
	while(timer.getTime()>0.1f);
	timer.reset();

	if(!noMusic)
		pl->Start(tune,startPos);
}

int bsPlayer::Row()
{	
	int seqpos,tick;
	if(noMusic)
	{
		return (int)((timer.getTime()/60.0f)*rowPerSample*8)&0x3f;
	}
	else
	{
#ifdef PLAYER_MINI_EDITION
		pl->GetSyncData(&tick,&seqpos);
		return tick>>2;
#else
		tick = seqpos = 0;
		return (int)((timer.getTime()/60.0f)*rowPerSample*8)&0x3f;
#endif
	}
}

int bsPlayer::Pos()
{
	int seqpos,tick;
	if(noMusic)
	{
		return (int)((timer.getTime()/60.0f)*rowPerSample/0x08);
	}
	else
	{
#ifdef PLAYER_MINI_EDITION
		pl->GetSyncData(&tick,&seqpos);
		return seqpos;
#else
		return (int)((timer.getTime()/60.0f)*rowPerSample/0x08);
#endif
	}
}

float bsPlayer::Time()
{
	return (float)timer.getTime();
}


float bsPlayer::GetCPUUsage()
{
	return syn->GetCPUUsage();
}