// RawSampleView.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "RawSampleView.h"
#include "isSamplePool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRawSampleView

CRawSampleView::CRawSampleView()
{
	m_sample = 0;
}

CRawSampleView::~CRawSampleView()
{
}


BEGIN_MESSAGE_MAP(CRawSampleView, CWnd)
	//{{AFX_MSG_MAP(CRawSampleView)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CRawSampleView message handlers

void CRawSampleView::OnPaint() 
{	
	CPaintDC dc(this); // device context for painting	
	RECT dcr;
	CWnd::GetClientRect( &dcr );
	
	// TODO: Add your message handler code here	
	CDC dcc;
	dcc.CreateCompatibleDC(0);
	CBitmap bmp;
	bmp.CreateCompatibleBitmap( &dc, dcr.right, dcr.bottom );
	dcc.SelectObject( &bmp );
	CDC* pDC = &dcc;
	pDC->PatBlt( 0, 0, dcr.right, dcr.bottom, BLACKNESS );


	if (m_sample && m_sample->buffer) {



		CGdiObject *old_pen;


		DWORD col1 = RGB(0,255,0);
		DWORD col2 = RGB(255,255,255);

		CPen pen1( PS_SOLID, 1, col1 );
		CPen pen2( PS_SOLID, 1, col2 );

		old_pen = pDC->SelectObject( &pen1 );

		for (int x=dcr.left;x<dcr.right;x++) {

			int _xp = x - dcr.left;
			int sample1 = _xp * m_sample->sampleLength / (dcr.right - dcr.left);
			int sample2 = (_xp+1) * m_sample->sampleLength / (dcr.right - dcr.left);

			if (sample1<0) sample1=0;
			if (sample1>=m_sample->sampleLength) sample1=m_sample->sampleLength-1;

			int yc = int( float(dcr.top - dcr.bottom) * m_sample->buffer[ sample1 ] );
			if (yc<1)yc=1;

			pDC->MoveTo( x, (dcr.top + dcr.bottom - yc) / 2 );
			pDC->LineTo( x, (dcr.top + dcr.bottom + yc) / 2 );


			bool drawline = false;

	 		if (m_sample->loopStart >= sample1 && m_sample->loopStart < sample2)
				drawline = true;
			if (m_sample->loopEnd >= sample1 && m_sample->loopEnd < sample2)
				drawline = true;


			if (true == drawline) {
				pDC->SelectObject( &pen2 );
				pDC->MoveTo( x, dcr.top );
				pDC->LineTo( x, dcr.bottom );
				pDC->SelectObject( &pen1 );
			}

		}

		pDC->SelectObject( old_pen );
	
	}

	

	dc.BitBlt( 0, 0, dcr.right, dcr.bottom, pDC, 0, 0, SRCCOPY );
	bmp.DeleteObject();
	dcc.DeleteDC();

	// Do not call CWnd::OnPaint() for painting messages
}


void CRawSampleView::setSample( isSamplePool::Sample *sample)
{
	m_sample = sample;
}

void CRawSampleView::update(void)
{
	Invalidate(FALSE);
	UpdateWindow();
}
