// ModulatorMain.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "ModulatorMain.h"
#include "modenvelope.h"
#include "modlfo.h"
#include "modcontroller.h"
#include "modulatornew.h"
#include "instrEditor.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CModulatorMain dialog


CModulatorMain::CModulatorMain(CWnd* pParent /*=NULL*/)
	: CVoiceBaseDlg(CModulatorMain::IDD, pParent)
{
	//{{AFX_DATA_INIT(CModulatorMain)
	//}}AFX_DATA_INIT
}


void CModulatorMain::DoDataExchange(CDataExchange* pDX)
{
	CVoiceBaseDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CModulatorMain)
	DDX_Control(pDX, IDC_STATIC_MODWIN, m_modwin);
	DDX_Control(pDX, IDC_LIST_MODLIST, m_modlist);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CModulatorMain, CVoiceBaseDlg)
	//{{AFX_MSG_MAP(CModulatorMain)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_MODULATORTYPES, OnSelchangeTabModulatortypes)
	ON_BN_CLICKED(IDC_BUTTON_NEWMODULATOR, OnButtonNewmodulator)
	ON_LBN_SELCHANGE(IDC_LIST_MODLIST, OnSelchangeListModlist)
	ON_BN_CLICKED(IDC_BUTTON_DELMODULATOR, OnButtonDelmodulator)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModulatorMain message handlers
static char *modnames[]=
{
  "unused",
  "ENVELOPE",
  "LFO",
  "CONTROLLER",
  NULL,    
};

BOOL CModulatorMain::OnInitDialog() 
{
	CVoiceBaseDlg::OnInitDialog();

  CRect wrect;
  enved = (CModulateBaseDlg *)new CModEnvelope();
  lfoed = (CModulateBaseDlg *)new CModLfo();
  cntred = (CModulateBaseDlg *)new CModController();

  enved->Create(MAKEINTRESOURCE(IDD_DIALOG_MODULATEENVELOPE),&m_modwin);
  lfoed->Create(MAKEINTRESOURCE(IDD_DIALOG_MODULATORLFO),&m_modwin);
  cntred->Create(MAKEINTRESOURCE(IDD_DIALOG_MODULATORCONTR),&m_modwin);
  
  current = enved;

  current->UpdateWindow();
  current->ShowWindow(SW_HIDE);
  current->GetClientRect(&wrect);
  current->MoveWindow(4,20,wrect.Width(),wrect.Height());
  curselmod=0;
  
    return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CModulatorMain::OnSelchangeTabModulatortypes(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
//  int wt=m_modulators.GetCurSel();
//  SetCurrentTab (wt);
	
	*pResult = 0;
}

void CModulatorMain::OnButtonNewmodulator() 
{
	// TODO: Add your control notification handler code here
  CModulatorNew modnew;

  switch (modnew.DoModal())
  {
  case IDC_BUTTON_MODNEWENV :
    voice->AddModulator(is_ENVELOPE);
    break;
  case IDC_BUTTON_MODNEWLFO :
    voice->AddModulator(is_LFO);
    break;
  case IDC_BUTTON_MODNEWCNTR :
    voice->AddModulator(is_CONTROLLER);
    break;
  }
    UpdateVoiceData ();
    ownerDlg->FillVolModCombo();

  
	
}
void CModulatorMain::SetCurrentTab()
{
    CRect wrect;
    //int tab;
    isModulator *mod;  
    mod = voice->GetModulator(curselmod);
    //tab = mod->GetType();

    //m_modulators.SetCurSel (tab);
    current->ShowWindow(SW_HIDE);

    switch (mod->GetType())
    {
        case is_ENVELOPE :
            current = enved;
            m_modwin.SetWindowText("Envelope");
            break;
        case is_LFO :
            current = lfoed;
            m_modwin.SetWindowText("Lfo");
            break;
        case is_CONTROLLER :
            current = cntred;
            m_modwin.SetWindowText("Controller");
            break;
    }
    current->UpdateWindow();
    current->ShowWindow(SW_SHOW);
    current->GetClientRect(&wrect);
    current->MoveWindow(4,20,wrect.Width(),wrect.Height());
    current->SetVoice (voice->GetModulator(curselmod),voice,instrument,synth);
    current->UpdateModulateData();  
}

void CModulatorMain::UpdateVoiceData()
{
    int i;
    isModulator *mod;
    m_modlist.ResetContent();
    for (i=0;i<voice->GetNrOfModulators();i++)
    {
        mod = voice->GetModulator(i);
        m_modlist.InsertString(i,modnames[mod->GetType()]);
        m_modlist.SetItemData(i,mod->GetType());

    //m_modlist.InsertItem (0,"envelope");
    }
    curselmod=0;
    current->SetVoice (voice->GetModulator(curselmod),voice,instrument,synth);
    current->UpdateModulateData();  
    m_modlist.SetCurSel(curselmod);
    SetCurrentTab();
  
  
  
}


void CModulatorMain::OnSelchangeListModlist() 
{
	// TODO: Add your control notification handler code here
	
    curselmod = m_modlist.GetCurSel ();
    
    SetCurrentTab();
}

void CModulatorMain::OnButtonDelmodulator() 
{
	// TODO: Add your control notification handler code here
    voice->DelModulator();
    UpdateVoiceData ();
}
