/**
	
    TODO:
        

	Updates:
		2002-10-16	gnilk	fixed a bug when outputting negative transpose values...
        
**/
#include "stdafx.h"
#include "tracker.h"

#include "mainfrm.h"
#include "gtkformat.h"
#include "trackerDoc.h"
#include "trackerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define NUM_COL 8
#define COL_WIDTH (NUM_COL*20 + 20 + NUM_COL)
// 7*12+3*12
void CPatternView::DrawSequencer(CDC *pDC)
{
	CTrackerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	int xpostab[]={0,20,20*2,20*3,20*4,20*5,20*6,20*7,20*8};//,120,144,166};
	int xpos;
	int seqStart;

	if (!pDoc->gtk ||!pDoc->synth || !pDoc->pl )
		return;


	pDC->SetBkColor  (RGB(0,0,0));
	pDC->SetBkMode (TRANSPARENT);
	pDC->SetTextColor (pDoc->ctrl_text);
	pDC->SelectStockObject (SYSTEM_FIXED_FONT);


	CRect rect;
	int x,i,j;


	seqStart = seqScroller.GetScrollPos ();


	// lets shrink window for tracker data	
	GetClientRect (&rect);
	pDC->SetViewportOrg (0,0);
	pDC->SetViewportExt (10,10);
	GetClientRect (&rect);
	rect.bottom = 128-16;
	pDC->IntersectClipRect (&rect);

	// draw tracker bar
	pDC->FillSolidRect (rect.left,rect.top, rect.Width (), 16,pDoc->ctrl_bg);
	pDC->Draw3dRect (rect.left,rect.top, rect.Width (), 16,pDoc->ctrl_light,pDoc->ctrl_dark);

	for (i=seqStart;i<16;i++)
	{
		char tmp[64];
		sprintf (tmp,"channel %d",i);
			pDC->TextOut ((i-seqStart)*COL_WIDTH+rect.left+25,0,tmp);
	}
//------------------------------
	
//	pDC->SetViewportOrg (0,0);
//	pDC->SetViewportExt (rect.Width (),96);
//	GetClientRect (&rect);

	// draw lousy stuff beetween each track...
	x = rect.left+20;
	for (i=0;i<16;i++)
	{
		pDC->Draw3dRect (x+COL_WIDTH*i,rect.top+16,2,rect.Height (),pDoc->ctrl_light,pDoc->ctrl_dark);		
		if ((x+i*COL_WIDTH) > rect.right) break;
	}
// draw middle "edit" bar
	int middle;
	pDC->SetViewportOrg (0,16);

	middle = rect.Height ();
	middle = ((int)(rect.Height ()/2.0)&0xfffff0);

	pDC->FillSolidRect (rect.left,middle, rect.Width (), 16,pDoc->ctrl_bg);

	// draw cursor

	if ((!isPatternEdit) && (!pDoc->playing))
	{
		xpos = rect.left+25;
		xpos+=seqCursor.rowcol*10;
		xpos+=(seqCursor.col-seqStart)*COL_WIDTH;
		if (seqCursor.rowcol & 0x01) xpos-=1;
		pDC->FillSolidRect (xpos,middle,9,16,pDoc->ctrl_cursor);
	}

	pDC->Draw3dRect (rect.left,middle, rect.Width (), 16,pDoc->ctrl_light,pDoc->ctrl_dark);


	char buf[16];
	int pos_count;
	int pos_start; 
	pDC->SetTextColor (pDoc->ctrl_text);

	if (!pDoc->playing)
		pos_start = seqCursor.pos;
	else
		pos_start = pDoc->play_seqpos;

	pos_start-=(int)(middle/16.0);

	
	pDC->SetTextColor (pDoc->ctrl_text);
	pos_count = pos_start;
	for (i=0;i<64;i++)
	{
        //		if ((pos_count>=0) && (pos_count<64))
        if ((pos_count>=0) && (pos_count<pDoc->gtk->channels[i].len))
        {
			sprintf (buf,"%02x",pos_count);
			pDC->TextOut (0,i*16,buf);
		}
		pos_count++;
		if (i*16 > rect.bottom) break;
	}

	GTK_SEQCHANNEL *schn;
	GTK_SEQPOS *spos;

	for (j=seqStart;j<16;j++)
	{
		if (j == seqCursor.col)	pDC->SetTextColor (pDoc->ctrl_curtext);
		else	pDC->SetTextColor (pDoc->ctrl_text);

		pos_count = pos_start;


		schn = &pDoc->gtk->channels[j];
		for (i=0;i<64;i++)
		{
			if ((pos_count>=0) && (pos_count<schn->len))
			{
				spos = &schn->positions[pos_count];

				if (!spos->pattern) sprintf (buf,"--");
				else sprintf (buf,"%02x",spos->pattern);

				xpos = (j-seqStart)*COL_WIDTH+rect.left+25;

				pDC->TextOut (xpos+xpostab[0],i*16,buf);
				sprintf (buf,"%02x",(unsigned char)spos->transpose);  // must be stored as char, but displayed as unsigned char
				pDC->TextOut (xpos+xpostab[1],i*16,buf);
				sprintf (buf,"%02x",spos->fx);
				pDC->TextOut (xpos+xpostab[2],i*16,buf);			
				sprintf (buf,"%02x",spos->param1);
				pDC->TextOut (xpos+xpostab[3],i*16,buf);			
				sprintf (buf,"%02x",spos->param2);
				pDC->TextOut (xpos+xpostab[4],i*16,buf);			
				sprintf (buf,"%02x",spos->param3);
				pDC->TextOut (xpos+xpostab[5],i*16,buf);			
                sprintf (buf,"%02x",0);
                pDC->TextOut (xpos+xpostab[6],i*16,buf);			
                sprintf (buf,"%02x",0);
                pDC->TextOut (xpos+xpostab[7],i*16,buf);			
                sprintf (buf,"%02x",0);
                pDC->TextOut (xpos+xpostab[8],i*16,buf);			
      }
			pos_count++;
			if (i*16 > rect.bottom) break;

		}
		if ((j-seqStart)*125+rect.left > rect.right) break;
	}

} // drawchn
