// DSPEffectTemplate.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "DSPEffectTemplate.h"
#include "isStereoFX.h"
#include "isEffectChain.h"
#include "SendFxChorus.h"
#include "SendFxDelay.h"

#include <mmsystem.h>
#include "isPlayer.h"

/////////////////////////////////////////////////////////////////////////////
// CDSPEffectTemplate dialog


CDSPEffectTemplate::CDSPEffectTemplate(CWnd* pParent /*=NULL*/)
	: CDialog(CDSPEffectTemplate::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDSPEffectTemplate)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_chain = 0;
	m_chainpos = 0;
	m_current_insert = 0;
	m_current_fx = 0;
	m_player = 0;
}



void CDSPEffectTemplate::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDSPEffectTemplate)
	DDX_Control(pDX, IDC_COMBO1, m_effect_list);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDSPEffectTemplate, CDialog)
	//{{AFX_MSG_MAP(CDSPEffectTemplate)
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDSPEffectTemplate message handlers

void CDSPEffectTemplate::setChain( isEffectChain *chain, int chainpos )
{
	m_chain = chain;
	m_chainpos = chainpos;
}

void CDSPEffectTemplate::setPlayer( isPlayer *player )
{
	m_player = player;
}

BOOL CDSPEffectTemplate::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_effect_list.AddString( _T("No effect") );
	m_effect_list.AddString( _T("Delay") );
	m_effect_list.AddString( _T("Chorus") );
	m_effect_list.SetCurSel(0);

	if (m_player)
		m_player->Pause();
	updateInsert();
	if (m_player)
		m_player->Resume();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDSPEffectTemplate::updateInsert(void)
{

	m_current_fx = 0;

	if (m_current_insert) {
		delete m_current_insert;
		m_current_insert = 0;
	}

	if (!m_chain) {
		return;
	}

	m_effect_list.SetCurSel(0);		

	// ndra m_current_fx
	m_current_fx = m_chain->GetEffect( m_chainpos );

	if (!m_current_fx) {
		m_effect_list.SetCurSel( 0 ); // Stt "No effect" som vald
		return;
	} else {
		switch (m_current_fx->GetType()) {
			case is_DELAY:
				m_effect_list.SetCurSel( 1 );
				m_current_insert = new CSendFxDelay( this );
				((CSendFxDelay*) m_current_insert)->setDelay( (isDelay*) m_current_fx );
				m_current_insert->Create( IDD_SENDFX_DELAY, this );
				break;
			case is_CHORUS:
				m_effect_list.SetCurSel( 2 );
				m_current_insert = new CSendFxChorus( this );
				((CSendFxChorus*) m_current_insert)->setChorus( (isChorus*) m_current_fx );
				m_current_insert->Create( IDD_SENDFX_CHORUS, this );
				break;
		}
	}

	if (!m_current_insert) {
		return;
	}

	m_current_insert->SetWindowPos( 0, 160, 7, 0, 0, SWP_NOSIZE|SWP_SHOWWINDOW );

}

void CDSPEffectTemplate::OnAppExit() 
{
	// TODO: Add your command handler code here
	
}

BOOL CDSPEffectTemplate::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	if (wParam == IDCANCEL || wParam == IDOK)
		return FALSE;
	
	return CDialog::OnCommand(wParam, lParam);
}

void CDSPEffectTemplate::OnSelchangeCombo1() 
{
	if (m_player)
		m_player->Pause();

	if (!m_chain)
		return;

	if (m_chain->GetEffect( m_chainpos ))
		m_chain->DelEffect( m_chainpos );

	// TODO: Add your control notification handler code here
	int n = m_effect_list.GetCurSel();
	if (n == 1) {
		m_chain->SetEffect( is_DELAY, m_chainpos );
		m_chain->GetEffect( m_chainpos )->Update();
	}
	if (n == 2) {
		m_chain->SetEffect( is_CHORUS, m_chainpos );
		m_chain->GetEffect( m_chainpos )->Update();
	}

	m_chain->Update();

	updateInsert();

	if (m_player)
		m_player->Resume();

	
}
