// ChannelMixer.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "ChannelMixer.h"
#include "roundsliderctrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
#define FloatIntMAX 1024
#define uFloatToInt(a) ((a)*1024)
#define sFloatToInt(a) ((a)*1024+1024)

#define uIntToFloat(a) ((a)/1024.0f)
#define sIntToFloat(a) (((a)-1024)/1024.0f)


/////////////////////////////////////////////////////////////////////////////
// CChannelMixer dialog


CChannelMixer::CChannelMixer(CWnd* pParent /*=NULL*/)
	: CDialog(CChannelMixer::IDD, pParent)
{
	//{{AFX_DATA_INIT(CChannelMixer)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CChannelMixer::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChannelMixer)
	DDX_Control(pDX, IDC_ROUNDSLIDER_KNOBVOL, m_volKnob);
	DDX_Control(pDX, IDC_ROUNDSLIDER_KNOBPAN, m_panKnob);
	DDX_Control(pDX, IDC_ROUNDSLIDER_KNOBFX3, m_fx3Knob);
	DDX_Control(pDX, IDC_ROUNDSLIDER_KNOBFX2, m_fx2Knob);
	DDX_Control(pDX, IDC_ROUNDSLIDER_KNOBFX1, m_fx1Knob);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CChannelMixer, CDialog)
	//{{AFX_MSG_MAP(CChannelMixer)
	ON_WM_PAINT()
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChannelMixer message handlers

void CChannelMixer::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
  CRect rect;
  CDC *pDC;
  int xp;
  pDC=GetDC ();
  

  pDC->SetBkMode(TRANSPARENT);
  GetClientRect(&rect);
  CSize sz = pDC->GetTextExtent(m_caption);

  xp = (rect.Width()/2) - (sz.cx/2);

  pDC->TextOut (xp,0,m_caption);
	
	// Do not call CDialog::OnPaint() for painting messages
}
void CChannelMixer::SetSynth(isSynth *_s,int ch)
{
  synth=_s;
  chnr=ch;
  m_caption.Format("ch %.2d",ch);  
}

void CChannelMixer::UpdateSynthData()
{  
  m_volKnob.SetPos (uFloatToInt (synth->volume[chnr]));
  m_panKnob.SetPos (uFloatToInt (synth->panning[chnr]));
  m_fx1Knob.SetPos (uFloatToInt (synth->fx1Gain[chnr]));
  m_fx2Knob.SetPos (uFloatToInt (synth->fx2Gain[chnr]));
  m_fx3Knob.SetPos (uFloatToInt (synth->fx3Gain[chnr]));
}

void CChannelMixer::SetSynthData()
{
  synth->volume[chnr] = uIntToFloat(m_volKnob.GetPos());
  synth->panning[chnr] = uIntToFloat(m_panKnob.GetPos());
  synth->fx1Gain[chnr] = uIntToFloat(m_fx1Knob.GetPos());
  synth->fx2Gain[chnr] = uIntToFloat(m_fx2Knob.GetPos());
  synth->fx3Gain[chnr] = uIntToFloat(m_fx3Knob.GetPos());
}

BOOL CChannelMixer::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

  m_volKnob.SetRange(0,4096);
  m_panKnob.SetRange(0,1024);
  m_fx1Knob.SetRange(0,1024);
  m_fx2Knob.SetRange(0,1024);
  m_fx3Knob.SetRange(0,1024);
  
  
  
  m_volKnob.SetText ("%4.3f");
  m_panKnob.SetText ("%4.3f");
  m_fx1Knob.SetText ("%4.3f");
  m_fx2Knob.SetText ("%4.3f");
  m_fx3Knob.SetText ("%4.3f");

  m_volKnob.SetZero(180);
  m_panKnob.SetZero(180);
  m_fx1Knob.SetZero(180);
  m_fx2Knob.SetZero(180);
  m_fx3Knob.SetZero(180);
  
  m_volKnob.SetScale (1.0/1024.0);
  m_panKnob.SetScale (1.0/1024.0);
  m_fx1Knob.SetScale (1.0/1024.0);
  m_fx2Knob.SetScale (1.0/1024.0);
  m_fx3Knob.SetScale (1.0/1024.0);
  
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CChannelMixer::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	SetSynthData();
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
