/****************************************************************************
 **                                                                        **
 **  Tiny 16/32bit video routines - Aron, 1998.05.12                       **
 **                                                                        **
 ****************************************************************************/

// - sajat fejlecfile-ok ----------------------------------------------------
#include "defs.h"

// - implementacio ----------------------------------------------------------
dword LFBptr;
signed short strobovalue;

dword GetVESAInfo_ASM(void);
#pragma aux GetVESAInfo_ASM "_*" modify [eax ebx ecx edx esi edi] value [eax]

dword GetVESAInfo(void)
{ return GetVESAInfo_ASM();
}

dword Detect320x200Mode_ASM(dword,dword*);
#pragma aux Detect320x200Mode_ASM "_*" modify [eax ebx ecx edx esi edi] parm [ebx] [esi] value [ebx]

dword Detect320x200Mode(dword bitsperpixelwanted,dword *LFBptr)
{ return Detect320x200Mode_ASM(bitsperpixelwanted,LFBptr);
}

void SetVGAMode_ASM(word);
#pragma aux SetVGAMode_ASM =                                            \
            "int 10h"                                                   \
            modify [eax]                                                \
            parm [ax]

void SetVGAMode(word modenr)
{ SetVGAMode_ASM(modenr);
}

word SetVESAMode_ASM(word);
#pragma aux SetVESAMode_ASM =                                           \
                "mov ax,4F02h" /* modszam BX-ben parameter */           \
                "int 10h"                                               \
                "xor bx,bx"                                             \
                "cmp al,4Fh"                                            \
                "je OK1"                                                \
                "mov bx,1"                                              \
"OK1:            cmp ah,0"                                              \
                "je OK2"                                                \
                "mov bx,2"                                              \
"OK2:           "                                                       \
                modify [ax]                                             \
                parm [bx]                                               \
                value [bx]

void SetVESAMode(word modenr)
{ SetVESAMode_ASM(modenr);
}

void HandleStrobo_ASM(byte *,signed int);
#pragma aux HandleStrobo_ASM =                                          \
                "cmp edx,0" /* DL-ben parameter a strobovalue */        \
                "jle NoFlash"                                           \
                "mov ecx,57600" /* 320*180 pixel */                     \
"NxtStr:         mov al,byte ptr [esi]" /* B be */                      \
                "mov bl,byte ptr [esi + 1]" /* G be */                  \
                "mov ah,byte ptr [esi + 2]" /* R be */                  \
                "cmp al,dl"                                             \
                "ja NoFlshB"                                            \
                "mov byte ptr [esi],dl" /* B villan */                  \
"NoFlshB:        cmp bl,dl"                                             \
                "ja NoFlshG"                                            \
                "mov byte ptr [esi + 1],dl" /* G villan */              \
"NoFlshG:        cmp ah,dl"                                             \
                "ja NoFlshR"                                            \
                "mov byte ptr [esi + 2],dl" /* R villan */              \
"NoFlshR:        add esi,4" /* kovetkezo pixel */                       \
                "dec ecx"                                               \
                "jnz NxtStr"                                            \
"NoFlash:       "                                                       \
                modify [ax bl ecx dl esi]                               \
                parm [esi] [dl]

void HandleStrobo(byte *destptr,signed short strobovalue)
{ HandleStrobo_ASM(destptr,strobovalue);
}

void UpdateScreen16bit_ASM(byte *);
#pragma aux UpdateScreen16bit_ASM =                                     \
        "mov edi,LFBptr"                                                \
        "mov ecx,64000" /* 320x200 pixel konverzioja */                 \
"Convrt: mov al,byte ptr [esi + 2]"                                     \
        "mov bl,byte ptr [esi + 1]"                                     \
        "and al,11111000b"                                              \
        "and bx,11111100b"                                              \
        "shl ax,8" /* AX:= R */                                         \
        "shl bx,3"                                                      \
        "mov dl,byte ptr [esi]"                                         \
        "or ax,bx" /* BX:= RG */                                        \
        "shr dl,3"                                                      \
        "add esi,4" /* kovetkezo triplet-re mutat */                    \
        "or al,dl" /* BX:= RGB */                                       \
        "dec ecx"                                                       \
        "stosw" /* kesz 16bites pixel kipakolasa */                     \
        "jnz Convrt"                                                    \
        modify exact [ax bx ecx dl edi]                                 \
        parm [esi]

void UpdateScreen16bit(byte *framebufferptr)
{ UpdateScreen16bit_ASM(framebufferptr);
}

void UpdateScreen24bitBGR_ASM(byte *);
#pragma aux UpdateScreen24bitBGR_ASM=                                   \
        "mov edi,LFBptr"                                                \
        "mov ecx,64000" /* 320x200 BGR pixel kimasolasa az LFB-be */    \
"NxtPix: movsd"                                                         \
        "dec edi" /* egy byte visszalepes a 24bit miatt */              \
        "dec ecx"                                                       \
        "jnz NxtPix"                                                    \
        modify [ecx edi]                                                \
        parm [esi]

void UpdateScreen24bitBGR(byte *framebuffer)
{ UpdateScreen24bitBGR_ASM(framebuffer);
}

void UpdateScreen32bitBGR_ASM(byte *);
#pragma aux UpdateScreen32bitBGR_ASM=                                   \
        "mov edi,LFBptr"                                                \
        "mov ecx,64000" /* 320x200 BGR pixel kimasolasa az LFB-be */    \
        "rep movsd"                                                     \
        modify [ecx edi]                                                \
        parm [esi]

void UpdateScreen32bitBGR(byte *framebuffer)
{ UpdateScreen32bitBGR_ASM(framebuffer);
}

void FillFrameBuffer_ASM(byte *,dword);
#pragma aux FillFrameBuffer_ASM=                                        \
        "mov ecx,64000"                                                 \
        "rep stosd"                                                     \
        modify [ecx]                                                    \
        parm [edi] [eax]

void FillFrameBuffer(byte *framebuffer,dword pixel)
{ FillFrameBuffer_ASM(framebuffer,pixel);
}

void CopyFrameBuffer_ASM(byte *,byte *);
#pragma aux CopyFrameBuffer_ASM=                                        \
        "mov ecx,64000"                                                 \
        "rep movsd"                                                     \
        modify [ecx]                                                    \
        parm [edi] [esi]

void CopyFrameBuffer(byte *destframebuffer,byte *srcframebuffer)
{ CopyFrameBuffer_ASM(destframebuffer,srcframebuffer);
}
