/****************************************************************************
 **                                                                        **
 **  Tiny raytracing engine - Aron, 1998.05.12                             **
 **                                                                        **
 ****************************************************************************/

// - konstansok -------------------------------------------------------------
#define  X_RESOLUTION           80
#define  Y_RESOLUTION           45

#define  INFINITE_DISTANCE      1000.0*1000.0
#define  OBJECT_PRIMITIVES      3

#define  PHONG_EXPONENT         32
#define  TEXTURE_SIZE           4*64*64

// raytracing flag-ek:
enum raytracing_flags { L_WAS_NOT_NORMALIZED= 1 };

// object primitivek kodjai:
enum object_primitive_code { TPLANE= 0, TSPHERE, TCYLINDER };

// metszes kodok:
enum intersection_code { BOOLEAN_INTERSECTION= 0, EXACT_INTERSECTION };

// surfacetype flag-ek:
enum surface_type_flags { DISTANCE_SHADED= 0, PHONG_SHADED= 1,
                          NON_TEXTURED= 0, TEXTURED= 2,
                          NON_REFLECTIVE= 0, REFLECTIVE= 4,
                          NO_SHADOWCASTING= 0, SHADOWCASTING= 8 };

// - altalanos strukturak ---------------------------------------------------
typedef struct { float X,Y,Z;
               } VECTOR;

typedef struct { byte Rd,Bd,Gd;             // diffuse RGB komponensek
                 byte *textureptr;          // texturara mutato
               } COLORSTRUCT;

typedef struct { VECTOR position;           // kamera pozicio
                 VECTOR target;             // nezopont
                 float FOV,roll;            // latoszog es roll szog
               } CAMERA;

typedef struct { float t;                   // metszesponthoz tartozo t parameter
                 VECTOR point;              // metszespont
                 VECTOR normal;             // metszespontbeli normalis
                 COLORSTRUCT *color;        // metszespont szinere mutato
                 byte surfacetype;          // metszespont felulettipusa
                 dword U,V;                 // mapping koordinatak
               } INTERSECTION;

typedef struct { VECTOR Pstart;             // kezdopont
                 VECTOR D;                  // iranyvektor
               } RAY;

typedef struct { VECTOR position;           // omni fenyforras helyvektora
               } OMNI_LIGHTSOURCE;

// - objektum primitivek ----------------------------------------------------
typedef struct { byte type;                 // objektum tipus (sik/gomb)
                 void *data;                // leiro adatokra mutato
                 COLORSTRUCT color;         // szin
                 byte surfacetype;          // felulettipus
               } OBJECT;

typedef struct { VECTOR center;             // kozeppont
                 float radius;              // sugar
               } SPHERE;

typedef struct { VECTOR normal;             // normalis
                 VECTOR onepoint;           // egy sikbeli pont
                 float D;
               } PLANE;

typedef struct { VECTOR A,B;
                 float radius;
                 VECTOR axis;
                 float axis2;
               } CYLINDER;

// - interface --------------------------------------------------------------
void InitTextures(byte *);
void TraceScene(byte *,CAMERA *,OMNI_LIGHTSOURCE *);

void SetupSceneCNT(byte *);
void SetupSceneBlobs(byte *);
void MoveSceneBlobs(float);
void SetupScenePipeObject(byte *);
void SetupSceneColumns(byte *);

