/****************************************************************************
 **                                                                        **
 **  Vector manipulations / object primivite scannings - Aron, 1998.05.22  **
 **                                                                        **
 ****************************************************************************/

// - alapszinek -------------------------------------------------------------
COLORSTRUCT basecolor[]= { {   0,  0,  0,   0},                 // fekete
                           { 255,255,255,   0},                 // feher
                           { 255,  0,  0,   0},                 // piros
                           {   0,255,  0,   0},                 // zold
                           {   0,  0,255,   0},                 // kek
                           { 255,255,  0,   0},                 // sarga
                           { 255,  0,255,   0},                 // lila
                           {   0,255,255,   0}                  // cian
                         };

// - alapveto vektormuveletek -----------------------------------------------
void NormalizeVector(VECTOR *v)
{ float length= fsqrt(v->X*v->X + v->Y*v->Y + v->Z*v->Z);

  // normalas:
  v->X/= length; v->Y/= length; v->Z/= length;
}

float DotProductVectors(VECTOR *v0,VECTOR *v1)
{ return (v0->X*v1->X + v0->Y*v1->Y + v0->Z*v1->Z);
}

void CrossProductVectors(VECTOR *v_result,VECTOR *v0,VECTOR *v1)
{ // vektorialis szorzas:
  v_result->X= (v0->Y * v1->Z) - (v0->Z * v1->Y);
  v_result->Y= (v0->Z * v1->X) - (v0->X * v1->Z);
  v_result->Z= (v0->X * v1->Y) - (v0->Y * v1->X);
}

// - objektumprimitivek inicializalo rutinjai -------------------------------
void InitPlane(OBJECT *plane)
{ // D prekalkulalhato:
  ((PLANE *)plane->data)->D= ((PLANE *)plane->data)->normal.X*((PLANE *)plane->data)->onepoint.X + ((PLANE *)plane->data)->normal.Y*((PLANE *)plane->data)->onepoint.Y + ((PLANE *)plane->data)->normal.Z*((PLANE *)plane->data)->onepoint.Y;
}

void InitSphere(OBJECT *sphere)
{ // nincs prekalkulalhato adat
}

void InitCylinder(OBJECT *cylinder)
{ // AXIS tengelyvektor prekalkulalhato:
  ((CYLINDER *)cylinder->data)->axis.X= ((CYLINDER *)cylinder->data)->B.X - ((CYLINDER *)cylinder->data)->A.X;
  ((CYLINDER *)cylinder->data)->axis.Y= ((CYLINDER *)cylinder->data)->B.Y - ((CYLINDER *)cylinder->data)->A.Y;
  ((CYLINDER *)cylinder->data)->axis.Z= ((CYLINDER *)cylinder->data)->B.Z - ((CYLINDER *)cylinder->data)->A.Z;

  // AXIS hosszanak negyzete prekalkulalhato:
  ((CYLINDER *)cylinder->data)->axis2= DotProductVectors(&((CYLINDER *)cylinder->data)->axis,&((CYLINDER *)cylinder->data)->axis);
}

void (*InitObject[OBJECT_PRIMITIVES])(OBJECT *)=
                                    { InitPlane,
                                      InitSphere,
                                      InitCylinder
                                    };

// - objektumprimitivek metszespontkereso rutinjai --------------------------
byte DetectPlane(RAY *ray,OBJECT *plane,INTERSECTION *intersection,byte flag)
{ float d,t;

  // a sik_normalisanak es a sugar_iranyvektoranak skalaris szorzata:
  d= ((PLANE *)plane->data)->normal.X*ray->D.X + ((PLANE *)plane->data)->normal.Y*ray->D.Y + ((PLANE *)plane->data)->normal.Z*ray->D.Z;
  if(d > 0.0) return 0;         // nincs metszes:

  // ha szuksegunk van a pontos metszespontra:
  if(flag == EXACT_INTERSECTION)
  { t= -(((PLANE *)plane->data)->normal.X*ray->Pstart.X + ((PLANE *)plane->data)->normal.Y*ray->Pstart.Y + ((PLANE *)plane->data)->normal.Z*ray->Pstart.Z + ((PLANE *)plane->data)->D)/d;

    if(t < intersection->t)
    { intersection->t= t;
      // metszespont:
      intersection->point.X= ray->Pstart.X + t*ray->D.X;
      intersection->point.Y= ray->Pstart.Y + t*ray->D.Y;
      intersection->point.Z= ray->Pstart.Z + t*ray->D.Z;
      // felulettipus beallitasa es mapping koordinatak szamitasa:
      intersection->color= &(plane->color);
      intersection->surfacetype= plane->surfacetype;
      if(intersection->surfacetype & TEXTURED)
      { // planar mapping:
        intersection->U= ((dword)intersection->point.X) % 64;
        intersection->V= ((dword)intersection->point.Z) % 64;
      }
    }
  }

  // volt metszespont:
  return 1;
}

byte DetectSphere(RAY *ray,OBJECT *sphere,INTERSECTION *intersection,byte flag)
{ float vX,vY,vZ,b,disc,t;

  // V:= gomb_kozepponja - sugar_kezdopontja;
  vX= ((SPHERE *)sphere->data)->center.X - ray->Pstart.X;
  vY= ((SPHERE *)sphere->data)->center.Y - ray->Pstart.Y;
  vZ= ((SPHERE *)sphere->data)->center.Z - ray->Pstart.Z;

  // b:= V es a sugar_iranyvektoranak skalaris szorzata
  b= vX*ray->D.X + vY*ray->D.Y + vZ*ray->D.Z;

  // diszkriminans:
  disc= b*b - (vX*vX + vY*vY + vZ*vZ) + ((SPHERE *)sphere->data)->radius*((SPHERE *)sphere->data)->radius;
  if(disc < 0) return 0;                  // nincs metszes

  // ha szuksegunk van a pontos metszespontra:
  if(flag == EXACT_INTERSECTION)
  { disc= fsqrt(disc);

    // a kozelebbi metszespont kell:
    t= b - disc;

    if(t < intersection->t)
    { intersection->t= t;
      // metszespont:
      intersection->point.X= ray->Pstart.X + t*ray->D.X;
      intersection->point.Y= ray->Pstart.Y + t*ray->D.Y;
      intersection->point.Z= ray->Pstart.Z + t*ray->D.Z;
      // a gomb normalvektora a metszesi pontban:
      intersection->normal.X= (intersection->point.X - ((SPHERE *)sphere->data)->center.X) / ((SPHERE *)sphere->data)->radius;
      intersection->normal.Y= (intersection->point.Y - ((SPHERE *)sphere->data)->center.Y) / ((SPHERE *)sphere->data)->radius;
      intersection->normal.Z= (intersection->point.Z - ((SPHERE *)sphere->data)->center.Z) / ((SPHERE *)sphere->data)->radius;
      // szin, felulettipus beallitasa es mapping koordinatak szamitasa:
      intersection->color= &(sphere->color);
      intersection->surfacetype= sphere->surfacetype;
      if(intersection->surfacetype & TEXTURED)
      { // spherical mapping:
        intersection->U= 32.0 + 31.0*intersection->normal.X;
        intersection->V= 32.0 + 31.0*intersection->normal.Y;
      }
    }
  }

  // volt metszespont:
  return 1;
}

byte DetectCylinder(RAY *ray,OBJECT *cylinder,INTERSECTION *intersection,byte flag)
{ VECTOR work1,work2;
  float aa,bb,a,b,c,disc,t,t2,p,p2;
  byte validroots= 0;

  work1.X= ray->Pstart.X - ((CYLINDER *)cylinder->data)->A.X;
  work1.Y= ray->Pstart.Y - ((CYLINDER *)cylinder->data)->A.Y;
  work1.Z= ray->Pstart.Z - ((CYLINDER *)cylinder->data)->A.Z;

  // aa= <work1,cylinder->axis> / cylinder->axis
  aa= DotProductVectors(&work1,&((CYLINDER *)cylinder->data)->axis) / ((CYLINDER *)cylinder->data)->axis2;
  work1.X= ray->Pstart.X - aa*((CYLINDER *)cylinder->data)->axis.X - ((CYLINDER *)cylinder->data)->A.X;;
  work1.Y= ray->Pstart.Y - aa*((CYLINDER *)cylinder->data)->axis.Y - ((CYLINDER *)cylinder->data)->A.Y;
  work1.Z= ray->Pstart.Z - aa*((CYLINDER *)cylinder->data)->axis.Z - ((CYLINDER *)cylinder->data)->A.Z;

  // bb= <ray,cylinder->axis> / cylinder->axis
  bb= DotProductVectors(&ray->D,&((CYLINDER *)cylinder->data)->axis) / ((CYLINDER *)cylinder->data)->axis2;
  work2.X= ray->D.X - bb*((CYLINDER *)cylinder->data)->axis.X;
  work2.Y= ray->D.Y - bb*((CYLINDER *)cylinder->data)->axis.Y;
  work2.Z= ray->D.Z - bb*((CYLINDER *)cylinder->data)->axis.Z;

  a= 2.0*DotProductVectors(&work2,&work2);
  b= 2.0*DotProductVectors(&work1,&work2);
  c= DotProductVectors(&work1,&work1) - ((CYLINDER *)cylinder->data)->radius*((CYLINDER *)cylinder->data)->radius;

  // diszkriminans:
  disc= b*b - 2.0*a*c;
  if(disc < 0.0) return 0; // nincs metszes

  // a ket lehetseges metszespont megkeresese:
  disc= fsqrt(disc);
  t= (-b - disc) / a;
  p= aa + t*bb; if((p <= 1.0) && (p >= 0.0)) validroots|= 1;
  t2= (-b + disc) / a;
  p2= aa + t2*bb; if((p2 <= 1.0) && (p2 >= 0.0)) validroots|= 2;

  // kozelebbi metszespont megkeresese:
  if(validroots == 0) return 0;                         // egyik metszes sem ervenyes

  // ha szuksegunk van a pontos metszespontra:
  if(flag == EXACT_INTERSECTION)
  { if((validroots == 3) && (t2 < t)) { t= t2; p= p2; }   // mindket metszes ervenyes
    else if(validroots == 2) { t= t2; p= p2; }            // csak a 2. metszes ervenyes

    if(t < intersection->t)
    { intersection->t= t;
      // metszespont:
      intersection->point.X= ray->Pstart.X + t*ray->D.X;
      intersection->point.Y= ray->Pstart.Y + t*ray->D.Y;
      intersection->point.Z= ray->Pstart.Z + t*ray->D.Z;
      // a henger normalvektora a metszesi pontban:
      intersection->normal.X= (intersection->point.X - (((CYLINDER *)cylinder->data)->A.X + p*((CYLINDER *)cylinder->data)->axis.X)) / ((CYLINDER *)cylinder->data)->radius;
      intersection->normal.Y= (intersection->point.Y - (((CYLINDER *)cylinder->data)->A.Y + p*((CYLINDER *)cylinder->data)->axis.Y)) / ((CYLINDER *)cylinder->data)->radius;
      intersection->normal.Z= (intersection->point.Z - (((CYLINDER *)cylinder->data)->A.Z + p*((CYLINDER *)cylinder->data)->axis.Z)) / ((CYLINDER *)cylinder->data)->radius;
      // szin, felulettipus beallitasa es mapping koordinatak szamitasa:
      intersection->color= &(cylinder->color);
      intersection->surfacetype= cylinder->surfacetype;
      if(intersection->surfacetype & TEXTURED)
      { // cylindrical mapping:
        intersection->U= 32.0 + 31.0*intersection->normal.X;
        intersection->V= 63.0 * p;
      }
    }
  }

  // volt metszespont:
  return 1;
}

byte (*DetectObject[OBJECT_PRIMITIVES])(RAY *,OBJECT *,INTERSECTION *,byte)=
                                    { DetectPlane,
                                      DetectSphere,
                                      DetectCylinder
                                    };

