.386P
.MODEL FLAT,C

_TEXT SEGMENT DWORD PUBLIC 'CODE'
        ASSUME CS:_TEXT,DS:_DATA

; - interface ---------------------------------------------------------------
public  ExtractTexture_ASM
public  FlipTexture_ASM

; - implementacio -----------------------------------------------------------

; - textura kitomorito mag --------------------------------------------------
ExtractTexture_ASM  PROC NEAR
                    ; parameterek: EDI:= destptr, ESI:= texture_srcptr

                    push ebp
                    mov ebp,esi ; ebp -> paletta
                    add esi,3*256 ; esi -> pixel data

                    mov edx,64 ; sorok
NxtConvRow:         mov ecx,64 ; pixelek
NxtConvPix:         lodsb ; AL:= szin indexe
                    and eax,0FFh
                    imul eax,3
                    mov bl,byte ptr [ebp + eax + 0] ; R be
                    mov byte ptr [edi + 0],bl ; R ki
                    mov bl,byte ptr [ebp + eax + 1] ; G be
                    mov byte ptr [edi + 1],bl ; G ki
                    mov bl,byte ptr [ebp + eax + 2] ; B be
                    mov byte ptr [edi + 2],bl ; B ki

                    add edi,4 ; kovetkezo 32bit-es pixel
                    dec ecx
                    jnz NxtConvPix
                    dec edx
                    jnz NxtConvRow

                    pop ebp
                    ret

ExtractTexture_ASM  ENDP

; - textura atfordito mag ---------------------------------------------------
FlipTexture_ASM     PROC NEAR
                    ; parameterek: EDI:= destptr, ESI:= srcptr

                    mov ecx,64*64 ; textura merete
                    add esi,4*(64*64 - 1)

NxtPix:             mov al,byte ptr [esi] ; RGB -> BGR pixelkonverzio
                    mov byte ptr [edi + 2],al
                    mov al,byte ptr [esi + 1]
                    mov byte ptr [edi + 1],al
                    mov al,byte ptr [esi + 2]
                    mov byte ptr [edi],al

                    sub esi,4 ; kovetkezo pixel
                    add edi,4
                    dec ecx
                    jnz NxtPix
                    ret

FlipTexture_ASM     ENDP

_TEXT ENDS

END