/****************************************************************************
 **                                                                        **
 **  "supermarket" 64K intro - Aron, 1998.05.12                            **
 **                                                                        **
 ****************************************************************************/

// - sajat fejlecfile-ok ----------------------------------------------------
#include "compile.h"
#include "defs.h"
#include "bitmap.h"
#include "intro.h"
#include "mxmplay.h"  // tiny XM player
#include "tinymath.h" // tiny math macros
#include "utils.h"
#include "texture.h"
#include "tracer.h"
#include "video.h"

// - implementacio ----------------------------------------------------------
dword xscalingtable[320],yscalingtable[200];
byte motionblurtable3[256][256],motionblurtable31[256][256];
signed int sinTab[256],cosTab[256];
byte *mainframebuffer,*tempframebuffer,*plusframebuffer,
     *shadetable,*texturebuffer;
byte *mxmplaymemory;

void main(int args,char *argv[])
{ dword videomodenr,selected_videomode;
  byte *mainframebuffer,*tempframebuffer,*plusframebuffer,*texturebuffer;
  word modpos;
  dword timer,timerstarted;
  CAMERA camera;
  OMNI_LIGHTSOURCE lightsource;
  byte keypressed= 0;
  int i,j;
  float t;

  extern byte musicdata[28562];
  extern byte texture0data[COMPRESSED_TEXTURE_SIZE];
  extern byte texture1data[COMPRESSED_TEXTURE_SIZE];

  // video inicializalas:
  PutText("\"supermrket\" by contract$");
  if(argv[1][0] == '0')
  { selected_videomode= 0;
    PutText("\n\n\r initializing 320x200x16bit with LFB...$");
  }
  else if(argv[1][0] == '1')
  { selected_videomode= 1;
    PutText("\n\n\r initializing 320x200x24bit with LFB...$");
  }
  else
  { selected_videomode= 2;
    PutText("\n\n\r initializing 320x200x32bit with LFB...$");
  }
  if(GetVESAInfo() < 0x0200) { PutText("\n\r vbe2.0 interface not found!$"); return; }
  videomodenr= Detect320x200Mode(16 + selected_videomode*8,&LFBptr);

#ifdef VIDEO_SHOWVESAINFO
  cprintf("\n\r VESA version: %Xh",GetVESAInfo());
  cprintf("\n\r Videomodenr: %Xh (LFB at %dM)",videomodenr,LFBptr / (1024*1024));
  return;
#endif
  if(!videomodenr || !LFBptr) { PutText("\n\r specified videomode not found!$"); return; }

  // inicializalas:
  finit();
  mainframebuffer= (byte *)malloc(4*320*200);
  tempframebuffer= (byte *)malloc(4*320*200);
  plusframebuffer= (byte *)malloc(4*320*200);
  shadetable= (byte *)malloc(256*256);
  texturebuffer= (byte *)malloc(2*TEXTURES_COMPRESSED*TEXTURE_SIZE);
  mxmplaymemory= (byte *)malloc(16*1024);

  // prekalkulaciok es texturak kitomoritese:
  PutText("\n\r decompressing mpeg animation...$");
  InitTables();
  InitParticleSystem();
  InitTextures(texturebuffer);
  InitFlower(texturebuffer + TEXTURE_SIZE);

  // MXMPLAY inicializalas:
  PutText("\n\r uploading samples...$");
#ifdef PLAYER_PLAYMUSIC
  if(!xmpInit(musicdata,xmpGetGUSPort(xmpGetEnvPtrDPMI(_psp)),mxmplaymemory,65536,MXMINTMODEDOS)) return;
#endif

  // inditas:
  SetVESAMode(videomodenr);
#ifdef GENERATOR_SHOWTEXTURE
  for(timer=0; timer<2*TEXTURES_COMPRESSED; timer++)
  { for(i=0; i<64; i++) for(j=0; j<64; j++)
    { *(mainframebuffer + 4*(320*i + j) + 2)= *(texturebuffer + timer*TEXTURE_SIZE + 4*(64*i + j) + 0);
      *(mainframebuffer + 4*(320*i + j) + 1)= *(texturebuffer + timer*TEXTURE_SIZE + 4*(64*i + j) + 1);
      *(mainframebuffer + 4*(320*i + j) + 0)= *(texturebuffer + timer*TEXTURE_SIZE + 4*(64*i + j) + 2);
    }
    UpdateScreen[selected_videomode](mainframebuffer);
    getch();
  }
#endif
#ifdef PLAYER_PLAYMUSIC
  xmpPlay(0);
#endif

// - scene#1: CNT hengerek --------------------------------------------------
  SetupSceneCNT(texturebuffer);
  while((xmpGetPos() < MUSICPOS(2,1)) && (!keypressed))
  { // timer lekerdezese:
    timer= 5 + xmpGetTimer()/(1193046 / TIMER_RATE); t= 3.0 + timer / 150.0;
    // trace-eles:
    FillFrameBuffer(mainframebuffer,0x00000000);
    camera.position.X= 300.0*fsin(t);
    camera.position.Y= 220.0 - 3.0*t;
    camera.position.Z= 300.0*fcos(t);
    camera.target.X= 15*fcos(t);
    camera.target.Y= 15.0;
    camera.target.Z= 15.0*fsin(t);
    camera.roll= 0.3*fsin(t);
    camera.FOV= 2.0 - t/7.0;
    lightsource.position.X= 30.0*fsin(t);
    lightsource.position.Y= 140.0;
    lightsource.position.Z= 80.0*fcos(t);
    TraceScene(mainframebuffer + 4*320*10,&camera,&lightsource);
    InterpolateFrameBuffer(mainframebuffer + 4*320*10);
    // elejen befade-eles:
    if(timer < 256) FadeFrameBuffer(mainframebuffer,shadetable,timer);
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - sugarak ----------------------------------------------------------------
  FillFrameBuffer(mainframebuffer,0x00000000);
  FillFrameBuffer(tempframebuffer,0x00000000);
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(4,1)) && (!keypressed))
  { // timer lekerdezese:
    timer= 5 + xmpGetTimer()/(1193046 / TIMER_RATE); t= timer / 400.0;
    // sugarak eloszor siman, aztan osztassal:
    DrawRays(mainframebuffer + 4*320*10,texturebuffer + TEXTURE_SIZE + 4*(timer>>2),sinTab[timer % 256]>>2,shadetable);
    // strobo dobra idozitve:
    i= xmpGetPos();
    if((i < MUSICPOS(2,4)) ||
       ((i >= MUSICPOS(2,30)) && (i < MUSICPOS(2,32))) ||
       ((i >= MUSICPOS(3,0)) && (i < MUSICPOS(3,2))) ||
       ((i >= MUSICPOS(3,30)) && (i < MUSICPOS(3,32)))
      ) HandleStrobo(mainframebuffer + 4*320*10,255);
    if(i >= MUSICPOS(3,0))
    { QuadrizeFrameBuffer(tempframebuffer + 4*320*10,mainframebuffer+ 4*320*10);
      CrossFadeFrameBuffer(tempframebuffer,mainframebuffer,shadetable,(byte)(128 + 126.0*fsin(8.0*t)));
      CopyFrameBuffer(plusframebuffer,tempframebuffer);
    }
    else CopyFrameBuffer(plusframebuffer,mainframebuffer);
    // feliratok:
    i= timer - timerstarted;
    if(i > 128) DrawString("we offer everything",(i - 128)>>2,plusframebuffer,20,50);
    if(i > 2*128) DrawString("you may need|",(i - 2*128)>>2,plusframebuffer,20,70);
    if(i > 3*128) DrawString("have a good shopping at us|",(i - 3*128)>>2,plusframebuffer,20,90);
    if(i > 4*128) DrawString("pay by your soul|",(i - 4*128)>>2,plusframebuffer,20,110);
    UpdateScreen[selected_videomode](plusframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - szines particle system -------------------------------------------------
  FillFrameBuffer(mainframebuffer,0x00000000);
  FillFrameBuffer(plusframebuffer,0x00000000);
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(6,1)) && (!keypressed))
  { // timer lekerdezese:
    timer= 5 + xmpGetTimer()/(1193046 / TIMER_RATE);
    // particle system:
    i= timer - timerstarted;
    ScaleFrameBuffer(tempframebuffer + 4*320*10,mainframebuffer + 4*320*10,8);
    UpdateParticleSystem(timer);
    DrawParticleSystem(tempframebuffer + 4*320*10,i>>1);
    BlurFrameBuffer(plusframebuffer + 4*320*10,tempframebuffer + 4*320*10);
    CopyFrameBuffer(mainframebuffer,plusframebuffer);
    // kockazas:
    i= xmpGetPos();
    if(i < MUSICPOS(4,16)) ResampleBitmap(plusframebuffer,mainframebuffer,16);
    else if(i < MUSICPOS(4,32)) ResampleBitmap(plusframebuffer,mainframebuffer,8);
    else if(i < MUSICPOS(4,63)) ResampleBitmap(plusframebuffer,mainframebuffer,4);
    else if(i < MUSICPOS(5,16)) ResampleBitmap(plusframebuffer,mainframebuffer,2);
    else if(i < MUSICPOS(5,32)) ResampleBitmap(plusframebuffer,mainframebuffer,1);
    // feliratok:
    i= timer - timerstarted;
    if(i > 128) DrawString("supermarket",(i - 128)>>2,plusframebuffer,20,20);
    if(i > 256) DrawString("hot buys hot prices|",(i - 256)>>2,plusframebuffer,20,40);
    UpdateScreen[selected_videomode](plusframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - scene#2: blob-ok -------------------------------------------------------
  SetupSceneBlobs(texturebuffer);
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(8,1)) && (!keypressed))
  { FillFrameBuffer(mainframebuffer,0x00000000);
    // timer lekerdezese:
    timer= 5 + xmpGetTimer()/(1193046 / TIMER_RATE); t= timer / 400.0;
    // trace-eles:
    camera.position.X= 250.0 - (timer - timerstarted)/4.0;
    camera.position.Y= 250.0;
    camera.position.Z= 250.0*fcos(t);
    camera.target.X= 0.0;
    camera.target.Y= 10.0*fcos(2.0*t);
    camera.target.Z= 0.0;
    camera.roll= 4.0*t;
    camera.FOV= 1.0;
    lightsource.position.X= 80.0*fsin(4.0*t);
    lightsource.position.Y= 100.0;
    lightsource.position.Z= 80.0*fcos(2.0*t);
    MoveSceneBlobs(t);
    TraceScene(mainframebuffer + 4*320*10,&camera,&lightsource);
    InterpolateFrameBuffer(mainframebuffer + 4*320*10);
    // negalas:
    i= xmpGetPos();
    if(((i > MUSICPOS(7,42)) && (i < MUSICPOS(7,44))) ||
       ((i > MUSICPOS(7,46)) && (i < MUSICPOS(7,48))) ||
       ((i > MUSICPOS(7,50)) && (i < MUSICPOS(7,52))) ||
       ((i > MUSICPOS(7,54)) && (i < MUSICPOS(7,56))) ||
       ((i > MUSICPOS(7,58)) && (i < MUSICPOS(7,60))) ||
       ((i > MUSICPOS(7,62)) && (i < MUSICPOS(7,64)))
      ) NegateFrameBuffer(mainframebuffer + 4*320*10);
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - scene#3: csovekbol-golyokbol allo object -------------------------------
  SetupScenePipeObject(texturebuffer);
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(10,1)) && (!keypressed))
  { // timer lekerdezese:
    timer= 5 + xmpGetTimer()/(1193046 / TIMER_RATE); t= (timer - timerstarted)/400.0;
    // trace-eles:
    FillFrameBuffer(mainframebuffer,0x00000000);
    camera.position.X= 250.0*fsin(3.0*t);
    camera.position.Y= 120.0*fsin(t);
    camera.position.Z= 250.0*fcos(4.0*t);
    camera.target.X= 25.0*fcos(2.0*t);
    camera.target.Y= 50.0*fcos(fsin(t));
    camera.target.Z= 25.0*fsin(3.0*t);
    camera.roll= -t;
    camera.FOV= 0.5 + 0.5*fsin(t);
    lightsource.position.X= 100.0*fsin(2.0*t);
    lightsource.position.Y= 100.0*fsin(t);
    lightsource.position.Z= 100.0*fcos(2.0*t);
    TraceScene(mainframebuffer + 4*320*10,&camera,&lightsource);
    InterpolateFrameBuffer(mainframebuffer + 4*320*10);
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - particle system#2: piros-feher-zold particle-k -------------------------
  InitParticleSystem2();
  FillFrameBuffer(mainframebuffer,0x00000000);
  FillFrameBuffer(plusframebuffer,0x00000000);
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(12,1)) && (!keypressed))
  { // timer lekerdezese:
    timer= 5 + xmpGetTimer()/(1193046 / TIMER_RATE);
    // particle system:
    i= timer - timerstarted;
    ScaleFrameBuffer(tempframebuffer + 4*320*10,mainframebuffer + 4*320*10,12);
    UpdateParticleSystem(timer);
    DrawParticleSystem(tempframebuffer + 4*320*10,i>>1);
    BlurFrameBuffer(plusframebuffer + 4*320*10,tempframebuffer + 4*320*10);
    CopyFrameBuffer(mainframebuffer,plusframebuffer);
    // feliratok:
    i= timer - timerstarted;
    if(i > 128) DrawString("magyarorsz{g",(i - 128)>>2,plusframebuffer,20,20);;
    if(i > 256) DrawString("the big deal|",(i - 256)>>2,plusframebuffer,20,40);;
    // elejen befade-eles:
    if(i < 512) FadeFrameBuffer(plusframebuffer,shadetable,i>>1);
    UpdateScreen[selected_videomode](plusframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
  CopyFrameBuffer(tempframebuffer,plusframebuffer);
// --------------------------------------------------------------------------

// - scene#4: dolo oszlopok kozott egy gomb ---------------------------------
  SetupSceneColumns(texturebuffer);
  timerstarted= timer;
  j= 0;
  while((xmpGetPos() < MUSICPOS(16,1)) && (!keypressed))
  { // timer lekerdezese:
    timer= 5 + xmpGetTimer()/(1193046 / TIMER_RATE); t= timer / 400.0;
    // trace-eles:
    FillFrameBuffer(mainframebuffer,0x00000000);
    camera.position.X= 280.0*fsin(t);
    camera.position.Y= 120.0;
    camera.position.Z= 280.0*fcos(t);
    camera.target.X= 50.0*fcos(2.0*t);
    camera.target.Y= 0.0;
    camera.target.Z= 50.0*fsin(3.0*t);
    camera.roll= 0.25;
    camera.FOV= 1.0;
    lightsource.position.X= 75.0*fsin(2.0*t);
    lightsource.position.Y= 120.0;
    lightsource.position.Z= 50.0*fcos(3.0*t);
    TraceScene(mainframebuffer + 4*320*10,&camera,&lightsource);
    InterpolateFrameBuffer(mainframebuffer + 4*320*10);
    // frame lemasolasa crossfading-hez:
    i= timer - timerstarted;
    if(!j) { CopyFrameBuffer(tempframebuffer,mainframebuffer); j= 1; }
    if(i < 256) CrossFadeFrameBuffer(mainframebuffer,tempframebuffer,shadetable,i);
     else { j= 0; timerstarted= timer; }
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - virag ------------------------------------------------------------------
  FillFrameBuffer(mainframebuffer,0x00000000);
  FillFrameBuffer(tempframebuffer,0x00000000);
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(18,1)) && (!keypressed))
  { // timer lekerdezese:
    timer= 5 + xmpGetTimer()/(1193046 / TIMER_RATE); t= timer / 400.0;
    // virag eloszor siman, aztan osztassal:
    i= timer - timerstarted;
    DrawFlower(mainframebuffer + 4*320*10,i>>2,i/2.0,180.0 + (70.0*sinTab[i % 256])/1024);
    if(i > 512)
    { HexadecimalizeFrameBuffer(tempframebuffer + 4*320*10,mainframebuffer+ 4*320*10);
      CrossFadeFrameBuffer(tempframebuffer,mainframebuffer,shadetable,(byte)(128 + 126.0*fsin(8.0*t)));
      CopyFrameBuffer(plusframebuffer,tempframebuffer);
    }
    else CopyFrameBuffer(plusframebuffer,mainframebuffer);
    // feliratok:
    i= timer - timerstarted;
    if(i > 128) DrawString("thank you for the purchasing|",(i - 128)>>2,plusframebuffer,20,50);
    if(i > 2*128) DrawString("yar satisfaction is our main goal|",(i - 2*128)>>2,plusframebuffer,20,70);
    if(i > 3*128) DrawString("we accept no complaints",(i - 3*128)>>2,plusframebuffer,20,90);
    if(i > 4*128) DrawString("after leaving the checkout|",(i - 4*128)>>2,plusframebuffer,20,110);
    UpdateScreen[selected_videomode](plusframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - kockas hatter elott stablista ------------------------------------------
  FillFrameBuffer(mainframebuffer,0x00000000);
  FillFrameBuffer(tempframebuffer,0x00000000);
  DrawBackGround(tempframebuffer + 40*4*320,texture1data + 3);
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(20,1)) && (!keypressed))
  { // timer lekerdezese:
    timer= 5 + xmpGetTimer()/(1193046 / TIMER_RATE); t= timer / 400.0;
    // kockas hatter:
    i= timer - timerstarted;
    DrawBackGround(mainframebuffer + 40*4*320,texture0data + 3);
    CrossFadeFrameBuffer(mainframebuffer,tempframebuffer,shadetable,(byte)(128 + 126.0*fsin(8.0*t)));
    if(i < 256) CrossFadeFrameBuffer(mainframebuffer,plusframebuffer,shadetable,i);
    // vonalrajzolas:
    if(i > 314) j= 314; else j= i;
    DrawHorizontalLine(mainframebuffer + 4*(42*320 + 2),j);
    DrawHorizontalLine(mainframebuffer + 4*(320*157 + (317 - j)),j);
    i= i>>1;
    if(i > 115) j= 115; else j= i;
    DrawVerticalLine(mainframebuffer + 4*(42*320 + 2),j);
    DrawVerticalLine(mainframebuffer + 4*(320*(157 - j) + 317),j);
    // feliratok:
    if(i > 64) DrawString("aron  code",(i - 64)>>2,mainframebuffer,(320 - 74)/2,52);
    if(i > 128) DrawString("zooley  music",(i - 128)>>2,mainframebuffer,(320 - 96)/2,77);
    if(i > 192) DrawString("tr  support",(i - 192)>>2,mainframebuffer,(320 - 84)/2,102);
    if(i > 256) DrawString("contract  ninetyeight",(i - 256)>>2,mainframebuffer,(320 - 164)/2,127);
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

// - fekete-feher szetblur-olodes -------------------------------------------
  timerstarted= timer;
  while((xmpGetPos() < MUSICPOS(20,30)) && (!keypressed))
  { // timer lekerdezese:
    timer= 5 + xmpGetTimer()/(1193046 / TIMER_RATE);
    // vizszintes szetkenes:
    if((timer - timerstarted) > 1)
    { CopyFrameBuffer(tempframebuffer,mainframebuffer);
      BlurHorizontalBWImage(mainframebuffer + 4*320*5,tempframebuffer + 4*320*5);
      timerstarted= timer;
    }
    UpdateScreen[selected_videomode](mainframebuffer);
    if(CheckKeys()) keypressed= 1;
  }
// --------------------------------------------------------------------------

  // MXMPLAY deinicializalas:
#ifdef PLAYER_PLAYMUSIC
  xmpStop();
#endif

  // deinicializalas:
  SetVGAMode(3);
  free(mainframebuffer);
  free(tempframebuffer);
  free(plusframebuffer);
  free(shadetable);
  free(texturebuffer);
  free(mxmplaymemory);

  // vege:
  PutText("and do not forget: dugongs are nice animals!\n\n\r?design overflow error\n\rready.$");
}