/****************************************************************************
 **                                                                        **
 **  Various bitmap functions - Aron, 1998.                                **
 **                                                                        **
 ****************************************************************************/

// - szabvany fejlecfile-ok -------------------------------------------------
//#include <math.h>
#include "math.h"
//#include <stdlib.h>

// - sajat fejlecfile-ok ----------------------------------------------------
#include "defs.h"
#include "bitmap.h"
#include "intro.h"
#include "stringft.h"
#include "tinymath.h"

// - implementacio ----------------------------------------------------------
// - prekalkulalo rutin -----------------------------------------------------
void InitTables(void)
{ signed int i,j;

  // sin/cos tablazatok:
  for (i=0; i<256; i++) { cosTab[i]= 1024*fcos((2.0*M_PI/256.0)*i);
                          sinTab[i]= 1024*fsin((2.0*M_PI/256.0)*i);
                        }
  // shadetable:
  for(i=0; i<256; i++) for(j=0; j<256; j++) *(shadetable + 256*i + j)= (byte)((float)i*(j/255.0));
  // particle system nagyitotablazat:
  for(i=0; i<319; i++) xscalingtable[i]= i/319.0*(319.0 - 2.0*SCALINGFACTOR) + SCALINGFACTOR;
  for(i=0; i<199; i++) yscalingtable[i]= i/199.0*(199.0 - 2.0*SCALINGFACTOR) + SCALINGFACTOR;
  // 3:1 es 31:1 motion blur tablazatok:
  for(i=0; i<256; i++) for(j=0; j<256; j++)
  { motionblurtable3[j][i]= (byte)((3*i + j) / 4);
    motionblurtable31[j][i]= (byte)((31*i + j) / 32);
  }
}

// - sztring rajzolo --------------------------------------------------------
void DrawString_ASM(char *string,dword length,byte *destptr,PROPORTIONAL_CHAR *fontptr,dword X,dword Y);
#pragma aux DrawString_ASM "_*" modify [eax ebx ecx edx esi edi] parm [ebx] [eax] [edi] [esi] [ecx] [edx]

void DrawString(char *string,dword length,byte *destptr,dword X,dword Y)
{ DrawString_ASM(string,length,destptr,&letter[0],X,Y);
}

// - alap effektek ----------------------------------------------------------
void InterpolateFrameBuffer_ASM(byte *);
#pragma aux InterpolateFrameBuffer_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi]

void InterpolateFrameBuffer(byte *destptr)
{ InterpolateFrameBuffer_ASM(destptr);
}

void FadeFrameBuffer_ASM(byte *,byte *,dword);
#pragma aux FadeFrameBuffer_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [eax]

void FadeFrameBuffer(byte *destptr,byte *shadetable,byte fadefactor)
{ FadeFrameBuffer_ASM(destptr,shadetable,fadefactor);
}

void CrossFadeFrameBuffer_ASM(byte *,byte *,byte *,dword);
#pragma aux CrossFadeFrameBuffer_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [ebx] [eax]

void CrossFadeFrameBuffer(byte *destptr,byte *srcptr,byte *shadetable,byte fadefactor)
{ CrossFadeFrameBuffer_ASM(destptr,srcptr,shadetable,fadefactor);
}

void NegateFrameBuffer_ASM(byte *);
#pragma aux NegateFrameBuffer_ASM =                                     \
        "mov ecx,57920" /* 320x181 pixel invertalasa */                 \
"NxtPix: mov eax,dword ptr [edi]"                                       \
        "xor eax,0FFFFFFFFh"                                            \
        "dec ecx"                                                       \
        "stosd"                                                         \
        "jnz NxtPix"                                                    \
        modify exact [eax ecx]                                          \
        parm [edi]

void NegateFrameBuffer(byte *destptr)
{ NegateFrameBuffer_ASM(destptr);
}

// - particle system --------------------------------------------------------
void ScaleFrameBuffer_ASM(byte *destptr,byte *srcptr,dword);
#pragma aux ScaleFrameBuffer_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [ecx]

void ScaleFrameBuffer(byte *destptr,byte *srcptr,dword factor)
{ ScaleFrameBuffer_ASM(destptr,srcptr,factor);
}

extern void BlurFrameBuffer_ASM(dword *destptr,dword *srcptr);
#pragma aux BlurFrameBuffer_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi]

void BlurFrameBuffer(dword *destptr,dword *srcptr)
{ BlurFrameBuffer_ASM(destptr,srcptr);
}

PARTICLE particle[NR_OF_PARTICLES];

void InitParticleSystem(void)
{ dword i;

  srand(27);
  for(i=0; i<NR_OF_PARTICLES; i++)
  { // random sugar:
    particle[i].radius= 50 + rand()%100;
    particle[i].startt= rand()%256;

    // random szin:
    particle[i].color= ((rand()%256) << 16) | ((rand()%256) << 8) | (rand()%256);
  }
}

void InitParticleSystem2(void)
{ dword i;

  srand(53);
  for(i=0; i<NR_OF_PARTICLES; i++)
  { // random sugar:
    particle[i].radius= 50 + rand()%100;
    particle[i].startt= rand()%256;

    // random szin:
    if((rand()%3) == 0) particle[i].color= (50 << 16) | (50 << 8) | (255);
    else if((rand()%3) == 1) particle[i].color= (255 << 16) | (255 << 8) | (255);
    else particle[i].color= (50 << 16) | (255 << 8) | (50);
  }
}

void UpdateParticleSystem(dword addert)
{ register dword i;
  dword t;

  for(i=0; i<NR_OF_PARTICLES; i++)
  { // t parameter szerinti forgatas:
    t= (particle[i].startt + addert) % 256;
    particle[i].X= (particle[i].radius * sinTab[t])>>10;
    particle[i].Y= (particle[i].radius * cosTab[t])>>10;
  }
}

void DrawParticle_ASM(byte *,dword,dword,dword);
#pragma aux DrawParticle_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [ebx] [ecx] [eax]

void DrawParticleSystem(byte *destptr,dword drawnparticles)
{ register dword i;
  dword sX,sY;

  // rajzolas:
  if(drawnparticles > NR_OF_PARTICLES) drawnparticles= NR_OF_PARTICLES;
  for(i=0; i<drawnparticles; i++)
  { // perspektivikus kepernyokoordinatak:
    sX= 160 + particle[i].X;

    if((sX > 0) && (sX < 319-14))
    { sY= 100 + particle[i].Y;
      if((sY > 10) && (sY < 189-14)) DrawParticle_ASM(destptr,sX,sY,particle[i].color);
    }
  }
}

// - kockas hatter ----------------------------------------------------------
void DrawBackGround_ASM(byte *,byte *);
#pragma aux DrawBackGround_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi]

void DrawBackGround(byte *destptr,byte *srcptr)
{ DrawBackGround_ASM(destptr,srcptr);
}

// - virag ------------------------------------------------------------------
byte flowertable[320*200*2];
byte amptable[256];
byte flowerpalette[4*4*64*64]; // az eredeti paletta 4x-es merete

void InitFlower(byte *palette)
{ signed int x,y;
  dword index= 0;
  float dX,dY,distance,angle;

  // tablazat kiszamitasa:
  for(y=0; y<200; y++) for(x=0; x<320; x++)
  { // tavolsag a kepernyo kozeppontjatol:
    dX= x - 160; dY= y - 100;
    distance= fsqrt(dX*dX*0.8*0.8 + dY*dY);
    // szog a kepernyo kozeppontjahoz huzott vektorral:
    if(distance) angle= acos(dY/distance); else angle= 0;
    if(x > 160) angle= 2*M_PI - angle;

    // tablazat kitoltese (2*i <- distance, 2*i + 1 <- angle):
    flowertable[index]= distance;
    flowertable[index + 1]= 40*angle;
    index+= 2;
  }

  // paletta masolasa a 4. sorokba:
  for(y=0; y<64; y++) for(x=0; x<4*64; x++)
   *(flowerpalette + 4*4*64*y + x)= *(palette + 4*64*y + x);
  // koztes sorok interpolalasa:
  for(y=0; y<63; y++) for(x=0; x<4*64; x++)
  { byte *upperptr= palette + 4*64*y + x,*lowerptr= palette + 4*64*(y + 1) + x;

    *(flowerpalette + 4*64*(4*y + 1) + x)= (3**upperptr + 1**lowerptr)>>2;
    *(flowerpalette + 4*64*(4*y + 2) + x)= (2**upperptr + 2**lowerptr)>>2;
    *(flowerpalette + 4*64*(4*y + 3) + x)= (1**upperptr + 3**lowerptr)>>2;
  }
}

void DrawFlower_ASM(byte *,byte *);
#pragma aux DrawFlower_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [eax]

void DrawFlower(byte *desptr,dword row,float angleoffset,float amplitudo)
{ signed int i;

  // amplitudotable feltoltese az utolso 5 elem interpolaciojaval:
  for(i=0; i<256; i++)
   amptable[i]= (amplitudo*(5*fsin(i/3.0 + angleoffset) +
                            15*fcos(i/2.0 + angleoffset/2) +
                            13*fsin(i/5.0 + angleoffset/3) + 250 - 38))/256.0;

  amptable[251]= 4*amptable[250]/5 + 1*amptable[0]/5;
  amptable[252]= 3*amptable[250]/5 + 2*amptable[0]/5;
  amptable[253]= 2*amptable[250]/5 + 3*amptable[0]/5;
  amptable[254]= 1*amptable[250]/5 + 4*amptable[0]/5;
  amptable[255]=                     5*amptable[0]/5;

  // rajzolas:
  DrawFlower_ASM(desptr,flowerpalette + 4*64*row);
}

void QuadrizeFrameBuffer_ASM(byte *,byte *);
#pragma aux QuadrizeFrameBuffer_ASM =                                   \
        "mov ecx,28800" /* 320*180/2 */                                 \
"NxtPix: lodsd" /* pixel be */                                          \
        "mov dword ptr [edi + 115200],eax" /* 4*320*90 */               \
        "add esi,4" /* 1 pixel atugrasa */                              \
        "dec ecx"                                                       \
        "stosd"                                                         \
        "jnz NxtPix"                                                    \
        modify [eax ecx]                                                \
        parm [edi] [esi]

void QuadrizeFrameBuffer(byte *destptr,byte *srcptr)
{ QuadrizeFrameBuffer_ASM(destptr,srcptr);
}

void HexadecimalizeFrameBuffer_ASM(byte *,byte *);
#pragma aux HexadecimalizeFrameBuffer_ASM =                             \
        "mov ecx,14400" /* 320*180/4 */                                 \
"NxtPix: lodsd" /* pixel be */                                          \
        "mov dword ptr [edi + 57600],eax" /* 4*320*45 */                \
        "mov dword ptr [edi + 115200],eax" /* 4*320*90 */               \
        "mov dword ptr [edi + 172800],eax" /* 4*320*135 */              \
        "add esi,12" /* 3 pixel atugrasa */                             \
        "dec ecx"                                                       \
        "stosd"                                                         \
        "jnz NxtPix"                                                    \
        modify [eax ecx]                                                \
        parm [edi] [esi]

void HexadecimalizeFrameBuffer(byte *destptr,byte *srcptr)
{ HexadecimalizeFrameBuffer_ASM(destptr,srcptr);
}

// - sugarrajzolo -----------------------------------------------------------
extern void DrawRays_ASM(byte *destptr,byte* srcptr,dword factor,byte *shit);
#pragma aux DrawRays_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [ecx] [eax]

void DrawRays(byte *destptr,byte *srcptr,dword factor,byte *ptr)
{ DrawRays_ASM(destptr,srcptr,factor,ptr);
}

// - transzparens grafikakitomorito -----------------------------------------
void ExtractTransparentPicture_ASM(byte *,byte *,dword);
#pragma aux ExtractTransparentPicture_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi] [edx]

void ExtractTransparentPicture(byte *destptr,byte *srcptr,dword width)
{ ExtractTransparentPicture_ASM(destptr,srcptr,width);
}

// - befejezo kep horizontalis blur-olese -----------------------------------
void BlurHorizontalBWImage_ASM(byte *,byte *);
#pragma aux BlurHorizontalBWImage_ASM =                                 \
        "push ebp"                                                      \
        "mov cl,29" /* oszto: 29 */                                     \
        "mov ebp,60800" /* 320x190 */                                   \
"NxtPix: movzx eax,byte ptr [esi + 1]" /* 1x kozepso */                 \
        "movzx bx,byte ptr [esi - 12 + 1]"                              \
        "movzx dx,byte ptr [esi - 8 + 1]"                               \
        "shl bx,3"                                                      \
        "shl dx,2"                                                      \
        "add ax,bx" /* 8x balra#3 */                                    \
        "add ax,dx" /* 4x balra#2 */                                    \
        "movzx bx,byte ptr [esi - 4 + 1]"                               \
        "movzx dx,byte ptr [esi + 12 + 1]"                              \
        "shl bx,1"                                                      \
        "shl dx,3"                                                      \
        "add ax,bx" /* 2x balra#1 */                                    \
        "add ax,dx" /* 8x jobbra#3 */                                   \
        "movzx bx,byte ptr [esi + 8 + 1]"                               \
        "movzx dx,byte ptr [esi + 4 + 1]"                               \
        "shl bx,2"                                                      \
        "shl dx,1"                                                      \
        "add ax,bx" /* 4x jobbra#2 */                                   \
        "add ax,dx" /* 2x jobbra#1 */                                   \
        "div cl" /* /29 */                                              \
        "cmp al,2"                                                      \
        "jb NoDec"                                                      \
        "dec al"                                                        \
        "dec al"                                                        \
"NoDec:  mov ah,al"                                                     \
        "stosw"                                                         \
        "stosw"                                                         \
        "add esi,4" /* kovetkezo pixel */                               \
        "dec ebp"                                                       \
        "jnz NxtPix"                                                    \
        "pop ebp"                                                       \
        modify [eax ebx ecx edx esi edi]                                \
        parm [edi] [esi]

void BlurHorizontalBWImage(byte *destptr,byte *srcptr)
{ BlurHorizontalBWImage_ASM(destptr,srcptr);
}

// - ujramintavetelezes effekt ----------------------------------------------
dword resampleratio,newrows,newcolumns,rowadder,columnadder;

void ResampleBitmap_ASM(byte *,byte *);
#pragma aux ResampleBitmap_ASM =                                        \
"NxtRow: mov edx,[newrows]"                                             \
"NxtPix: mov eax,dword ptr [esi]" /* pixel betoltese */                 \
        "mov ecx,[resampleratio]"                                       \
"NxtDpH: push edi" /* EDI elmentese fuggoleges sokszorozas elott */     \
        "mov ebx,[resampleratio]"                                       \
"NxtDpV: mov dword ptr [edi],eax"                                       \
        "add edi,1280" /* fuggoleges lepes */                           \
        "dec ebx"                                                       \
        "jnz NxtDpV"                                                    \
        "pop edi" /* EDI visszatoltese vizszintes lepeshez */           \
        "add edi,4" /* vizszintes lepes */                              \
        "dec ecx"                                                       \
        "jnz NxtDpH"                                                    \
        "add esi,[rowadder]" /* kovetkezo pixel */                      \
        "dec edx"                                                       \
        "jnz NxtPix"                                                    \
        "add esi,[columnadder]"                                         \
        "add edi,[columnadder]"                                         \
        "dec [newcolumns]"                                              \
        "jnz NxtRow"                                                    \
        modify [eax ebx ecx edx esi edi]                                \
        parm [edi] [esi]

void ResampleBitmap(byte *destptr,byte *srcptr,dword ratio)
{ // konstansok kiszamitasa a mintavetelezesi faktorhoz:
  resampleratio= ratio;
  newrows= 320/ratio;
  newcolumns= 200/ratio;
  rowadder= ratio<<2;
  columnadder= (ratio - 1)*1280;

  // "kockazas":
  ResampleBitmap_ASM(destptr,srcptr);
}

// - vizszintes es fuggoleges vonalrajzolok ---------------------------------
void DrawHorizontalLine_ASM(dword *,dword);
#pragma aux DrawHorizontalLine_ASM =                                    \
        "inc ecx"                                                       \
"NxtPix: shr byte ptr [edi],1" /* pixel sotetitese */                   \
        "shr byte ptr [edi + 1],1"                                      \
        "shr byte ptr [edi + 2],1"                                      \
        "add edi,4" /* kovetkezo pixel */                               \
        "dec ecx"                                                       \
        "jnz NxtPix"                                                    \
        parm [edi] [ecx]

void DrawHorizontalLine(dword *destptr,dword length)
{ DrawHorizontalLine_ASM(destptr,length);
}

void DrawVerticalLine_ASM(dword *,dword);
#pragma aux DrawVerticalLine_ASM =                                      \
        "inc ecx"                                                       \
"NxtPix: shr byte ptr [edi],1" /* pixel elsotetitese */                 \
        "shr byte ptr [edi + 1],1"                                      \
        "shr byte ptr [edi + 2],1"                                      \
        "add edi,1280" /* 320*4 */                                      \
        "dec ecx"                                                       \
        "jnz NxtPix"                                                    \
        parm [edi] [ecx]

void DrawVerticalLine(dword *destptr,dword length)
{ DrawVerticalLine_ASM(destptr,length);
}
