/* Fireworks demo written by Dave Ashley */
/* dash@xdr.com */
/* http://www.xdr.com/dash */
/* Sat Jun 13 02:46:09 PDT 1998 */
/* This is my first attempt at an SDL program */
/* See the SDL home page http://www.devolution.com/~slouken/projects/SDL/ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <string>
#include <time.h>
#include <windows.h>
#include <iostream>
#include <math.h>

#include "SDL.h"


#define XSIZE 48
#define YSIZE 48

#define WIDTH XSIZE
#define HEIGHT YSIZE
#define PI 3.1415926535897932384626433832795f

SDL_Surface *thescreen;
unsigned int *pixels;

std::string g_filename;

int scrlock()
{
	if(SDL_MUSTLOCK(thescreen))
	{
		if ( SDL_LockSurface(thescreen) < 0 )
		{
			fprintf(stderr, "Couldn't lock display surface: %s\n",
				SDL_GetError());
			return -1;
		}
	}

	pixels = (unsigned int *) thescreen->pixels;

	return 0;
}
void scrunlock(void)
{
	if(SDL_MUSTLOCK(thescreen))
		SDL_UnlockSurface(thescreen);
	SDL_UpdateRect(thescreen, 0, 0, 0, 0);
}

void putPixel( int x, int y, unsigned int color )
{
	if ( x < 0 )
		return;

	if ( y < 0 )
		return;

	if ( x >= XSIZE )
		return;

	if ( y >= YSIZE )
		return;

	pixels[ y * XSIZE + x ] = color; // ARGB 0x00FF0000 = red
}

void drawRect( int x1, int y1, int x2, int y2, unsigned int color )
{
	int x, y;

	for ( y = y1; y < y2; y++ )
	{
		for ( x = x1; x < x2; x++ )
		{
			putPixel( x, y, color );
		}
	}
}


// ----------------------------------------------------------------------------
#define screenxsize XSIZE
#define screenysize YSIZE
#define nbsquares 15

unsigned short *gLut;

int campos;
FILE *fileHandle = 0;

// ----------------------------------------------------------------------------
void writeRect( unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2 )
{
	if ( x1 > screenxsize )
	{
		x1 = screenxsize - 1;
	}
	if ( x2 > screenxsize )
	{
		x2 = screenxsize - 1;
	}

	if ( y1 > screenysize )
	{
		y1 = screenysize - 1;
	}
	if ( y2 > screenysize )
	{
		y2 = screenysize - 1;
	}

	if ( g_filename.size()>0)
	{
		fwrite( &x1, 1, 1, fileHandle );
		fwrite( &y1, 1, 1, fileHandle );
		fwrite( &x2, 1, 1, fileHandle );
		fwrite( &y2, 1, 1, fileHandle );
	}
}

unsigned int *texture;
#define TEXWIDTH 32
#define TEXHEIGHT 32

void initTunnel()
{
	campos = 31*256;

	gLut = new unsigned short[WIDTH * HEIGHT];

	int i,j;
	for (i = 0; i < HEIGHT; i++)
	{
		for (j = 0; j < WIDTH; j++)
		{
			int xdist = j - (WIDTH / 2);
			int ydist = i - (HEIGHT / 2);

			// round
			int distance = (int)sqrt((float)(xdist * xdist + ydist * ydist));
			
			// square
			//int distance = (abs(xdist) > abs(ydist)) ? abs(xdist) : abs(ydist);

			// diamond
			//int distance = (abs(xdist) + abs(ydist)) / 2;

			// makes it flower
			 //distance += (int)(sin(atan2((float)xdist, (float)ydist) * 5) * 8);

			if (distance <= 0) distance = 1;

			int d = distance;
			if (d < 7)
			{
				gLut[i * WIDTH + j] = 0xFFFF;
			}
			else
			{
				distance = (32 * 24 / distance) & 0xff;

				int angle = (int)(((atan2((float)xdist, (float)ydist) / PI) + 1.0f) * 64);

				if ( angle >= 255 )
				{
					int a = 0;
				}

				gLut[i * WIDTH + j] = (distance << 8) + angle;
			}
		}
	}

	texture = new unsigned int[ TEXWIDTH * TEXHEIGHT ];
	for ( int y = 0; y < TEXHEIGHT; y++ )
	{
		for ( int x = 0; x < TEXWIDTH; x++ )
		{
			texture[ y * TEXWIDTH + x ] = ( y & 31 ) >= 16 ? ( ( x & 31 ) < 16 ? 0xFFFFFFFF : 0 ) : ( ( x & 31 ) < 16 ? 0 : 0xFFFFFFFF );
		}
	}


	if ( g_filename.size()>0)
		fwrite( gLut, (WIDTH * HEIGHT * 2 )  , 1, fileHandle );
}

void playTunnel()
{
	int tick = SDL_GetTicks( ) / 16;

	int i, j;
	for (i = 0; i < HEIGHT; i++)
	{
		for (j = 0; j < WIDTH; j++)
		{
			unsigned int lut = gLut[(i) * WIDTH + j];

			unsigned char lutx = ( lut + tick ) & (TEXWIDTH-1);
			unsigned char luty = ( ( lut >> 8 ) + tick / 2 ) & (TEXWIDTH-1);

			if ( lut != 0xFFFF )
			{
				unsigned int texel = texture[ lutx + luty * TEXWIDTH ];

				putPixel( j, i, texel );
			}
			
		}
	}
}

int main(int argc, char *argv[])
{
	std::cout << "PrecaTunnel2 version 1.0 -- Create Tunnel (crocolib)" << std::endl;

	if ( argc == 2 )
	{
		g_filename = argv[ 1 ];

		if ( g_filename.size()>0)
			fileHandle = fopen( g_filename.c_str(), "wb" );
	}

	int done = 0;
	SDL_Event event;

	initTunnel( );
	
	if ( SDL_Init(SDL_INIT_VIDEO) < 0 )
	{
		fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
		exit(1);
	}
	
	thescreen = SDL_SetVideoMode(XSIZE, YSIZE, 32, SDL_SWSURFACE|SDL_HWPALETTE);
	if ( thescreen == NULL )
	{
		fprintf(stderr, "Couldn't set display mode: %s\n",
			SDL_GetError());
		SDL_Quit();
		exit(5);
	}

	int nbFrames = 120;
	while(!done)
	{
		scrlock( );

		playTunnel( );

		scrunlock( );
		
		while(SDL_PollEvent(&event))
		{
			switch (event.type)
			{
						case SDL_QUIT:
				done = 1;
				break;
			default:
				break;
			}
		}

		if ( g_filename.size()>0)
		{
			if ( nbFrames-- == 0 )
			{
				done = true;
			}
		}
	}

	if ( fileHandle )
		fclose( fileHandle );

	SDL_Quit();
	exit(0);

	return 0;
}
