/* Fireworks demo written by Dave Ashley */
/* dash@xdr.com */
/* http://www.xdr.com/dash */
/* Sat Jun 13 02:46:09 PDT 1998 */
/* This is my first attempt at an SDL program */
/* See the SDL home page http://www.devolution.com/~slouken/projects/SDL/ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <string>
#include <time.h>
#include <windows.h>
#include <iostream>
#include <math.h>

#include "track.h"

#include "SDL.h"



#define XSIZE 96 * 2
#define YSIZE 255 * 2
//#define XSIZE 640
//#define YSIZE 480

SDL_Surface *thescreen;
unsigned int *pixels;

std::string g_letter;
std::string g_filename;

Track *trackX;
Track *trackY;

int scrlock()
{
	if(SDL_MUSTLOCK(thescreen))
	{
		if ( SDL_LockSurface(thescreen) < 0 )
		{
			fprintf(stderr, "Couldn't lock display surface: %s\n",
				SDL_GetError());
			return -1;
		}
	}
	
	pixels = (unsigned int *) thescreen->pixels;
	
	return 0;
}
void scrunlock(void)
{
	if(SDL_MUSTLOCK(thescreen))
		SDL_UnlockSurface(thescreen);
	SDL_UpdateRect(thescreen, 0, 0, 0, 0);
}

void putPixel( int x, int y, unsigned int color )
{
	if ( x < 0 )
		return;

	if ( y < 0 )
		return;

	if ( x >= XSIZE )
		return;

	if ( y >= YSIZE )
		return;

	pixels[ y * XSIZE + x ] = color; // ARGB 0x00FF0000 = red
}

void drawLine( int x1, int y1, int x2, int y2, unsigned int color )
{
	if ( y1 > y2 )
	{
		float t = y2;
		y2 = y1;
		y1 = t;

		t = x2;
		x2 = x1;
		x1 = t;
	}

	float x = x1;
	float y = y1;

	float deltaX = 1;
	
	if ( y2 != y1 )
		deltaX = (float)( x2 - x1 ) / (float) ( y2 - y1 );

	while ( y < y2 )
	{
		if (deltaX >= 0 )
		{
			for ( float x1 = x; x1 < x + deltaX; x1 += 1.0f )
				putPixel( x1, y, color );
		}
		else
		{
			for ( float x1 = x + deltaX; x1 < x; x1 += 1.0f )
				putPixel( x1, y, color );
		}

		x += deltaX;

		y++;
	}
}

#define SETKEY( track, vtime, v ) \
{ \
	TrackKey k; \
	k.time = vtime;	\
	k.value = v; \
	track->setKey( k ); \
}

void initEffect( )
{
	trackX = Track::createTrack( );
	trackY = Track::createTrack( );

	const float x = 40.0f;
	const float y = 56.0f;

	SETKEY( trackX, 0, x );
	SETKEY( trackX, 200, x );
	SETKEY( trackX, 300, XSIZE - x );
	SETKEY( trackX, 500, XSIZE - x );

	SETKEY( trackY, 0, YSIZE - y );
	SETKEY( trackY, 200, y );
	SETKEY( trackY, 300, y );
	SETKEY( trackY, 500, YSIZE - y );
}

void doEffect( )
{
	const int heightInt = 20;
	const int heightFloat = 20;

	const float timeDeltaFloat = 8.0f;
	const float pi = 3.1415926535897932384626433832795f;

	float angleRadianUp = ( 180.0f + 90.0f ) * ( pi / 180.0f ); 
	float angleRadianDown = ( 90.0f ) * ( pi / 180.0f ); 


	memset( pixels, 0, XSIZE * YSIZE * 4 );

	/*TrackKey k;
	k.time = XSIZE / 2;
	k.value = ( YSIZE / 2.0f ) + ( sinf( (float) ( GetTickCount( ) ) * 0.002f ) ) * ( (float) ( ( YSIZE - heightInt ) / 2 ) );
	trackY->setKey( k );*/

	float valueY = trackY->getValue( 0.0f );
	float valueX = trackX->getValue( 0.0f );

	unsigned int keyCount = trackX->getKeyCount();
	TrackKey *key = trackX->getKey( keyCount - 1 );

	FILE *fileHandle = 0;
	
	if ( g_filename.size()>0)
		fileHandle = fopen( g_filename.c_str(), "wb" );
	
	for ( int time = 0; time < key->time; time += timeDeltaFloat )
	{
		float timeFloat = (float) time;

		float x1 = valueX;
		float y1 = valueY;

		float x2 = trackX->getValue( timeFloat + timeDeltaFloat );
		float y2 = trackY->getValue( timeFloat + timeDeltaFloat );

		valueX = x2;
		valueY = y2;
		
		float angleRadian = atan( ( ( y2 - y1 ) / ( x2 - x1 ) ) );
		
		float _x1 = x1 + ( heightFloat * cosf( angleRadian + angleRadianUp ) );
		float _y1 = y1 + ( heightFloat * sinf( angleRadian + angleRadianUp ) );

		float _x2 = x1 + ( heightFloat * cosf( angleRadian + angleRadianDown ) );
		float _y2 = y1 + ( heightFloat * sinf( angleRadian + angleRadianDown ) );

		drawLine( (int) _x1, (int)_y1, (int)_x2, (int)_y2, 0x0000FFFF );

		if ( fileHandle )
		{
			unsigned char v;

			v = (int) (_x1 * 0.5f); fwrite( &v, 1, 1, fileHandle );
			std::cout << "x1=" << (int)v << std::endl;
			v = (int) (_y1 * 0.5f); fwrite( &v, 1, 1, fileHandle );
			std::cout << "y1=" << (int)v << std::endl;
			v = (int) (_x2 * 0.5f); fwrite( &v, 1, 1, fileHandle );
			std::cout << "x2=" << (int)v << std::endl;
			v = (int) (_y2 * 0.5f); fwrite( &v, 1, 1, fileHandle );
			std::cout << "y2=" << (int)v << std::endl;
		}
	}

	if ( fileHandle )
		fclose( fileHandle );
}

int main(int argc, char *argv[])
{
	std::cout << "precaLines version 1.0 -- Create Letter Lines  (crocolib)" << std::endl;

	if ( argc == 1 )
	{
		std::cerr << "Not enough parameters !" << std::endl << std::endl;

		std::cout << "Usage:" << std::endl;
		std::cout << "  ARG1 = upper-case letter to create" << std::endl;
		std::cout << "  ARG2 = destination filename of X,Y lines to draw" << std::endl;
		std::cout << "    (if no ARG2 specified, then it's a simple preview)" << std::endl;

		std::cout << std::endl;

		return 1;
	}

	g_letter = argv[ 1 ];
	//g_filename = argv[ 2 ];

	int done = 0;
	SDL_Event event;

	initEffect( );
	
	if ( SDL_Init(SDL_INIT_VIDEO) < 0 )
	{
		fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
		exit(1);
	}
	
	thescreen = SDL_SetVideoMode(XSIZE, YSIZE, 32, SDL_SWSURFACE|SDL_HWPALETTE);
	if ( thescreen == NULL )
	{
		fprintf(stderr, "Couldn't set display mode: %s\n",
			SDL_GetError());
		SDL_Quit();
		exit(5);
	}

	while(!done)
	{
		scrlock( );

		doEffect( );

		scrunlock( );
		
		while(SDL_PollEvent(&event))
		{
			switch (event.type)
			{
						case SDL_QUIT:
				done = 1;
				break;
			default:
				break;
			}
		}

		if ( g_filename.size()>0)
		{
			done = true;
		}
	}

	SDL_Quit();
	exit(0);

	return 0;
}
