/* Fireworks demo written by Dave Ashley */
/* dash@xdr.com */
/* http://www.xdr.com/dash */
/* Sat Jun 13 02:46:09 PDT 1998 */
/* This is my first attempt at an SDL program */
/* See the SDL home page http://www.devolution.com/~slouken/projects/SDL/ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <string>
#include <time.h>
#include <windows.h>
#include <iostream>
#include <math.h>

#include "SDL.h"


#define XSIZE 320
#define YSIZE 240

SDL_Surface *thescreen;
unsigned int *pixels;

std::string g_filename;
std::string g_baseFilename;

FILE *g_bozoFile;
unsigned char *g_bozoBuffer;
int iOffset;
int iFrame;
int iNbFrames;

int scrlock()
{
	if(SDL_MUSTLOCK(thescreen))
	{
		if ( SDL_LockSurface(thescreen) < 0 )
		{
			fprintf(stderr, "Couldn't lock display surface: %s\n",
				SDL_GetError());
			return -1;
		}
	}

	pixels = (unsigned int *) thescreen->pixels;

	return 0;
}
void scrunlock(void)
{
	if(SDL_MUSTLOCK(thescreen))
		SDL_UnlockSurface(thescreen);
	SDL_UpdateRect(thescreen, 0, 0, 0, 0);
}

void putPixel( int x, int y, unsigned int color )
{
	if ( x < 0 )
		return;

	if ( y < 0 )
		return;

	if ( x >= XSIZE )
		return;

	if ( y >= YSIZE )
		return;

	pixels[ y * XSIZE + x ] = color; // ARGB 0x00FF0000 = red
}

void drawRect( int x1, int y1, int x2, int y2, unsigned int color )
{
	int x, y;

	for ( y = y1; y < y2; y++ )
	{
		for ( x = x1; x < x2; x++ )
		{
			putPixel( x, y, color );
		}
	}
}


// ----------------------------------------------------------------------------
#define screenxsize XSIZE
#define screenysize YSIZE
#define nbsquares 15

int campos;
FILE *fileHandle = 0;

// ----------------------------------------------------------------------------
void writeRect( unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2 )
{
	if ( x1 > screenxsize )
	{
		x1 = screenxsize - 1;
	}
	if ( x2 > screenxsize )
	{
		x2 = screenxsize - 1;
	}

	if ( y1 > screenysize )
	{
		y1 = screenysize - 1;
	}
	if ( y2 > screenysize )
	{
		y2 = screenysize - 1;
	}

	if ( g_filename.size()>0)
	{
		fwrite( &x1, 1, 1, fileHandle );
		fwrite( &y1, 1, 1, fileHandle );
		fwrite( &x2, 1, 1, fileHandle );
		fwrite( &y2, 1, 1, fileHandle );
	}
}

int timeCount = 0;



void initBozo()
{

	/*FILE *g_bozoFile;
	unsigned char *g_bozoBuffer;
	int iOffset;
	int iFrame;
	int iNbFrames;*/

	g_bozoFile = fopen( "bozo.tmo", "rb" );
	
	fseek( g_bozoFile, 0, SEEK_END );
	int inSize = ftell( g_bozoFile );
	fseek( g_bozoFile, 0, SEEK_SET );

	g_bozoBuffer = new unsigned char[ inSize ];
	fread( g_bozoBuffer, 1, inSize, g_bozoFile );

	fclose( g_bozoFile );

	iNbFrames = g_bozoBuffer[1]&0xff;
	iNbFrames |= (g_bozoBuffer[2]&0xff)<<8;
	iFrame = -1;
	iOffset = 3;

	timeCount = SDL_GetTicks( ) + 1;
}
int maxx = 0;
int maxy = 0;
int done = 0;

int indexFile = 0;

void playBozo()
{
	drawRect( 0, 0, XSIZE - 1, YSIZE - 1, 0 );

	if ( g_filename.size()>0)
	{
		iFrame++;
		iOffset += 10 * 4 * 2 * 2;
	}
	else
	{
		if ( SDL_GetTicks( ) > timeCount )
		{
			timeCount = SDL_GetTicks( ) + 1;

			iFrame++;

			iOffset += 10*4*4 * 2;

		}		
	}

	if ( ( iFrame % 2 ) == 0 )
	{
		fclose( fileHandle );
		fileHandle = 0;

		std::string cmdLine;
		cmdLine+= "pack.exe ";
		cmdLine+= g_filename;
		WinExec(cmdLine.c_str(), SW_NORMAL);

		Sleep( 500 );

		indexFile++;
		g_filename = g_baseFilename;
		char convert[ 16 ];
		itoa( indexFile, convert, 10 );
		g_filename += convert;
		g_filename += ".bzo";

		if ( g_filename.size()>0)
			fileHandle = fopen( g_filename.c_str(), "wb" );


	}

	if (iFrame< ( 200 ) )
	{
		int curOffset = iOffset;

		for (int iLoop=0; iLoop<40; iLoop++)
		{
			unsigned char x = ((float)(g_bozoBuffer[curOffset++] - 50))*0.85f;
			unsigned char y = ((float)g_bozoBuffer[curOffset++])* 0.85f;

			if ( g_filename.size()>0)
			{
				fwrite( &x, 1, 1, fileHandle );
				fwrite( &y, 1, 1, fileHandle );
			}

			if ( x > maxx )
			{
				maxx = x;
			}
			if ( y > maxy )
			{
				maxy = y;
			}
			drawRect( x, y, x + 3, y + 3, 0xFFFFFFFF );
		}
	}
	else
	{
		fclose( fileHandle );
		fileHandle = 0;

		iFrame = -1;
		indexFile = 0;

		Sleep( 1000 );

		int finalSize = 0;
		unsigned char *finalOut = new unsigned char[ 500000 ];
		
		FILE *fileWriteHandle = fopen( "MOCAP.BZO", "wb" );
		
		while ( iFrame < 400 )
		{
			if ( ( iFrame % 2 ) == 0 )
			{
				indexFile++;
				g_filename = g_baseFilename;
				char convert[ 16 ];
				itoa( indexFile, convert, 10 );
				g_filename += convert;
				g_filename += ".bzo.pck";

				fileHandle = fopen( g_filename.c_str(), "rb" );
				if ( fileHandle )
				{
					fseek( fileHandle, 0, SEEK_END );
					int inSize = ftell( fileHandle );
					fseek( fileHandle, 0, SEEK_SET );

					fread( finalOut, 1, inSize, fileHandle );
					finalSize += inSize;

					unsigned char chunkSize = inSize + 1;
					fwrite( &chunkSize, 1, 1, fileWriteHandle );
					fwrite( finalOut, inSize, 1, fileWriteHandle );

					fclose( fileHandle );
				}
			}
			iFrame++;
		}

		
		fclose( fileWriteHandle );
		fileHandle  = 0;
		
		done = true;
	}
}

int main(int argc, char *argv[])
{
	std::cout << "PrecaBozo version 1.0 -- Create Bozo File (crocolib)" << std::endl;

	if ( argc == 2 )
	{
		g_filename = argv[ 1 ];
		g_filename += "1.bzo";
		g_baseFilename = argv[ 1 ];

		if ( g_filename.size()>0)
			fileHandle = fopen( g_filename.c_str(), "wb" );
	}

	SDL_Event event;

	initBozo( );
	
	if ( SDL_Init(SDL_INIT_VIDEO) < 0 )
	{
		fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
		exit(1);
	}
	
	thescreen = SDL_SetVideoMode(XSIZE, YSIZE, 32, SDL_SWSURFACE|SDL_HWPALETTE);
	if ( thescreen == NULL )
	{
		fprintf(stderr, "Couldn't set display mode: %s\n",
			SDL_GetError());
		SDL_Quit();
		exit(5);
	}

	//int nbFrames = 120;
	while(!done)
	{
		scrlock( );

		playBozo( );

		scrunlock( );
		
		while(SDL_PollEvent(&event))
		{
			switch (event.type)
			{
						case SDL_QUIT:
				done = 1;
				break;
			default:
				break;
			}
		}

		if ( g_filename.size()>0)
		{
			//if ( nbFrames-- == 0 )
			{
			//	done = true;
			}
		}
	}

	if ( fileHandle )
		fclose( fileHandle );

	SDL_Quit();
	exit(0);

	return 0;
}
