// Retouche.cpp : implementation file
//

#include  <afxwin.h>
#include  <afxcmn.h>
#include  <afxext.h>

#include  "Bitmap.h"
#include  "Resource.h"
#include  "Constantes.h"
#include  "Conversion.h"
#include  "Retouche.h"
#include  "Locale.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRetouche dialog

#define     TAILLE_RET_X    640

#define     TAILLE_RET_Y    400


enum    { OUTIL_STYLOT, OUTIL_FILL };


CRetouche::CRetouche( int m
                    , int p[ 16 ]
                    , int pl
                    , HDC dcb
                    , StRVB * bm
                    , int l
                    , int tx
                    , int ty
                    , CWnd * pParent /*=NULL*/
                    )
    : CDialog(CRetouche::IDD, pParent)
{
    //{{AFX_DATA_INIT(CRetouche)
    //}}AFX_DATA_INIT
    OffsetX = OffsetY = 0;
    Mode = m;
    memcpy( Palette, p, sizeof( Palette ) );
    CpcPlus = pl;
    DcBitmap = dcb;
    Bitmap = bm;
    Locale = l;
    Stylo = 0;
    TailleX = tx;
    TailleY = ty;
    OldZoom = -1;
    CurCol = -1;
    LButton = RButton = FALSE;
}


void CRetouche::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CRetouche)
    DDX_Control(pDX, IDC_COLCHOIX, m_ColChoix);
    DDX_Control(pDX, IDC_SCROLL_VER, m_ScrollVer);
    DDX_Control(pDX, IDC_SCROLL_HOR, m_ScrollHor);
    DDX_Control(pDX, IDC_ZOOM1, m_BpZoomX1);
    DDX_Control(pDX, IDC_PINCEAU1, m_BpPinceau1);
    DDX_Control(pDX, IDC_PINCEAU3, m_BpPinceau3);
    DDX_Control(pDX, IDC_PINCEAU5, m_BpPinceau5);
    DDX_Control(pDX, IDC_PINCEAU7, m_BpPinceau7);
    DDX_Control(pDX, IDC_FILL, m_BpFill);
    DDX_Control(pDX, IDC_UNDO, m_BpUndo);
    DDX_Control(pDX, IDC_COL15, m_Col[ 15 ] );
    DDX_Control(pDX, IDC_COL14, m_Col[ 14 ] );
    DDX_Control(pDX, IDC_COL13, m_Col[ 13 ] );
    DDX_Control(pDX, IDC_COL12, m_Col[ 12 ] );
    DDX_Control(pDX, IDC_COL11, m_Col[ 11 ] );
    DDX_Control(pDX, IDC_COL10, m_Col[ 10 ] );
    DDX_Control(pDX, IDC_COL09, m_Col[ 9 ] );
    DDX_Control(pDX, IDC_COL08, m_Col[ 8 ] );
    DDX_Control(pDX, IDC_COL07, m_Col[ 7 ] );
    DDX_Control(pDX, IDC_COL06, m_Col[ 6 ] );
    DDX_Control(pDX, IDC_COL05, m_Col[ 5 ] );
    DDX_Control(pDX, IDC_COL04, m_Col[ 4 ] );
    DDX_Control(pDX, IDC_COL03, m_Col[ 3 ] );
    DDX_Control(pDX, IDC_COL02, m_Col[ 2 ] );
    DDX_Control(pDX, IDC_COL01, m_Col[ 1 ] );
    DDX_Control(pDX, IDC_COL00, m_Col[ 0 ] );
    DDX_Control(pDX, IDC_PT_COL00, m_PtCol[ 0 ] );
    DDX_Control(pDX, IDC_PT_COL01, m_PtCol[ 1 ] );
    DDX_Control(pDX, IDC_PT_COL02, m_PtCol[ 2 ] );
    DDX_Control(pDX, IDC_PT_COL03, m_PtCol[ 3 ] );
    DDX_Control(pDX, IDC_PT_COL04, m_PtCol[ 4 ] );
    DDX_Control(pDX, IDC_PT_COL05, m_PtCol[ 5 ] );
    DDX_Control(pDX, IDC_PT_COL06, m_PtCol[ 6 ] );
    DDX_Control(pDX, IDC_PT_COL07, m_PtCol[ 7 ] );
    DDX_Control(pDX, IDC_PT_COL08, m_PtCol[ 8 ] );
    DDX_Control(pDX, IDC_PT_COL09, m_PtCol[ 9 ] );
    DDX_Control(pDX, IDC_PT_COL10, m_PtCol[ 10 ] );
    DDX_Control(pDX, IDC_PT_COL11, m_PtCol[ 11 ] );
    DDX_Control(pDX, IDC_PT_COL12, m_PtCol[ 12 ] );
    DDX_Control(pDX, IDC_PT_COL13, m_PtCol[ 13 ] );
    DDX_Control(pDX, IDC_PT_COL14, m_PtCol[ 14 ] );
    DDX_Control(pDX, IDC_PT_COL15, m_PtCol[ 15 ] );
    DDX_Control(pDX, IDC_STATIC_ZOOM, m_StaticZoom );
    DDX_Control(pDX, IDC_STATIC_PINCEAU, m_StaticPinceau );
    //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRetouche, CDialog)
    //{{AFX_MSG_MAP(CRetouche)
    ON_WM_PAINT()
    ON_BN_CLICKED(IDC_COL00, OnCol00)
    ON_BN_CLICKED(IDC_COL01, OnCol01)
    ON_BN_CLICKED(IDC_COL02, OnCol02)
    ON_BN_CLICKED(IDC_COL03, OnCol03)
    ON_BN_CLICKED(IDC_COL04, OnCol04)
    ON_BN_CLICKED(IDC_COL05, OnCol05)
    ON_BN_CLICKED(IDC_COL06, OnCol06)
    ON_BN_CLICKED(IDC_COL07, OnCol07)
    ON_BN_CLICKED(IDC_COL08, OnCol08)
    ON_BN_CLICKED(IDC_COL09, OnCol09)
    ON_BN_CLICKED(IDC_COL10, OnCol10)
    ON_BN_CLICKED(IDC_COL11, OnCol11)
    ON_BN_CLICKED(IDC_COL12, OnCol12)
    ON_BN_CLICKED(IDC_COL13, OnCol13)
    ON_BN_CLICKED(IDC_COL14, OnCol14)
    ON_BN_CLICKED(IDC_COL15, OnCol15)
    ON_BN_CLICKED(IDC_ZOOM1, OnZoomX1)
    ON_BN_CLICKED(IDC_ZOOM2, OnZoomX2)
    ON_BN_CLICKED(IDC_ZOOM4, OnZoomX4)
    ON_BN_CLICKED(IDC_ZOOM8, OnZoomX8)
    ON_BN_CLICKED(IDC_PINCEAU1, OnPinceau1)
    ON_BN_CLICKED(IDC_PINCEAU3, OnPinceau3)
    ON_BN_CLICKED(IDC_PINCEAU5, OnPinceau5)
    ON_BN_CLICKED(IDC_PINCEAU7, OnPinceau7)
    ON_BN_CLICKED(IDC_FILL, OnFill)
    ON_BN_CLICKED(IDC_UNDO, OnUndo)
    ON_WM_VSCROLL()
    ON_WM_HSCROLL()
    ON_WM_MOUSEMOVE()
    ON_WM_LBUTTONDOWN()
    ON_WM_RBUTTONDOWN()
    ON_WM_LBUTTONUP()
    ON_WM_RBUTTONUP()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRetouche message handlers


BOOL CRetouche::OnInitDialog()
{
    CDialog::OnInitDialog();

    WinDC = GetDC();
    if ( Mode >= 1 )
        for ( int i = 8 >> Mode; i < 16; i++ )
            m_Col[ i ].ShowWindow( FALSE );

    for ( int i = 0; i < 16; i++ )
        m_PtCol[ i ].ShowWindow( FALSE );

    m_ScrollHor.SetScrollRange( 0, 1 );
    m_ScrollVer.SetScrollRange( 0, 1 );
    SetWindowText( GetTexteLoc( 55, Locale ) );
    m_StaticZoom.SetWindowText( GetTexteLoc( 56, Locale ) );
    m_StaticPinceau.SetWindowText( GetTexteLoc( 60, Locale ) );
    m_BpZoomX1.SetCheck( 1 );
    OnPinceau1();
    OnZoomX1();
    m_BpUndo.EnableWindow( FALSE );
    return( BmUndo.Create( WinDC, BITMAP_X, BITMAP_Y ) );
}


void CRetouche::OnPaint()
{
    CRect rect;
    CDC * TempDC;

    for ( int i = 0; i < 16; i++ )
        {
        m_Col[ i ].GetClientRect( rect );
        TempDC = m_Col[ i ].GetDC();
        TempDC->FillSolidRect( rect, GetRgbCPC( Palette[ i ], CpcPlus ) );
        m_Col[ i ].ReleaseDC( TempDC );
        }

    AffichePalette();
    RedrawBitmap();
    CDialog::OnPaint();
}


void CRetouche::RedrawBitmap( void )
{
    int ReelX = TailleX * Zoom;
    int ReelY = TailleY * Zoom;

    if ( ReelX > TAILLE_RET_X )
        ReelX = TAILLE_RET_X;

    if ( ReelY > TAILLE_RET_Y )
        ReelY = TAILLE_RET_Y;

    if ( OldZoom != Zoom )
        {
        OldZoom = Zoom;
        if ( ReelX < TAILLE_RET_X )
            {
            FillRect( WinDC->m_hDC
                    , CRect( ReelX + 3, 3, TAILLE_RET_X + 3, TAILLE_RET_Y + 3 )
                    , GetSysColorBrush( GetSysColor( COLOR_WINDOWFRAME ) )
                    );
            m_ScrollHor.EnableWindow( FALSE );
            }
        else
            m_ScrollHor.EnableWindow( TRUE );

        if ( ReelY < TAILLE_RET_Y )
            {
            FillRect( WinDC->m_hDC
                    , CRect( 3, ReelY + 3, TAILLE_RET_X + 3, TAILLE_RET_Y + 3 )
                    , GetSysColorBrush( GetSysColor( COLOR_WINDOWFRAME ) )
                    );
            m_ScrollVer.EnableWindow( FALSE );
            }
        else
            m_ScrollVer.EnableWindow( TRUE );
        }
    StretchBlt( WinDC->m_hDC
              , 3, 3, ReelX, ReelY
              , DcBitmap
              , OffsetX, OffsetY, ReelX / Zoom, ReelY / Zoom
              , SRCCOPY
              );
    ::PostMessage( GetParent()->m_hWnd, WM_PAINT, 0, 0 );
}


void CRetouche::AffichePalette( void )
{
    CRect rect;
    CDC * TempDC;

    m_ColChoix.GetClientRect( rect );
    TempDC = m_ColChoix.GetDC();
    TempDC->FillSolidRect( rect, GetRgbCPC( Palette[ Stylo ], CpcPlus ) );
    m_ColChoix.ReleaseDC( TempDC );
}


void CRetouche::ModifZoom( int NewZoom )
{
    if ( Zoom != NewZoom )
        {
        Zoom = NewZoom;
        int MinPos, MaxPos;
        int ZoomX = TAILLE_RET_X / Zoom;
        int ZoomY = TAILLE_RET_Y / Zoom;

        m_ScrollHor.GetScrollRange( &MinPos, &MaxPos );
        if ( MaxPos )
            OffsetX = ( OffsetX * ( TailleX - ZoomX ) ) / MaxPos;
        else
            OffsetX = 0;

        if ( OffsetX < 0 )
            OffsetX = 0;

        m_ScrollHor.SetScrollRange( 0, TailleX - ZoomX );
        m_ScrollHor.SetScrollPos( OffsetX );

        m_ScrollVer.GetScrollRange( &MinPos, &MaxPos );
        if ( MaxPos )
            OffsetY = ( OffsetY * ( TailleY - ZoomY ) ) / MaxPos;
        else
            OffsetY = 0;

        if ( OffsetY < 0 )
            OffsetY = 0;

        m_ScrollVer.SetScrollRange( 0, TailleY - ZoomY );
        m_ScrollVer.SetScrollPos( OffsetY );
        RedrawBitmap();
        }
}


void CRetouche::OnZoomX1()
{
    ModifZoom( 1 );
}


void CRetouche::OnZoomX2()
{
    ModifZoom( 2 );
}


void CRetouche::OnZoomX4()
{
    ModifZoom( 4 );
}


void CRetouche::OnZoomX8()
{
    ModifZoom( 8 );
}


void CRetouche::OnPinceau1()
{
    Pinceau = 1;
    m_BpPinceau1.LoadBitmaps( IDB_BITMAP_STYLOT1_SEL );
    m_BpPinceau1.RedrawWindow();
    m_BpPinceau3.LoadBitmaps( IDB_BITMAP_STYLOT3_NSEL );
    m_BpPinceau3.RedrawWindow();
    m_BpPinceau5.LoadBitmaps( IDB_BITMAP_STYLOT5_NSEL );
    m_BpPinceau5.RedrawWindow();
    m_BpPinceau7.LoadBitmaps( IDB_BITMAP_STYLOT7_NSEL );
    m_BpPinceau7.RedrawWindow();
    m_BpFill.LoadBitmaps( IDB_BITMAP_FILL_NSEL );
    m_BpFill.RedrawWindow();
    Outil = OUTIL_STYLOT;
}


void CRetouche::OnPinceau3()
{
    Pinceau = 2;
    m_BpPinceau1.LoadBitmaps( IDB_BITMAP_STYLOT1_NSEL );
    m_BpPinceau1.RedrawWindow();
    m_BpPinceau3.LoadBitmaps( IDB_BITMAP_STYLOT3_SEL );
    m_BpPinceau3.RedrawWindow();
    m_BpPinceau5.LoadBitmaps( IDB_BITMAP_STYLOT5_NSEL );
    m_BpPinceau5.RedrawWindow();
    m_BpPinceau7.LoadBitmaps( IDB_BITMAP_STYLOT7_NSEL );
    m_BpPinceau7.RedrawWindow();
    m_BpFill.LoadBitmaps( IDB_BITMAP_FILL_NSEL );
    m_BpFill.RedrawWindow();
    Outil = OUTIL_STYLOT;
}


void CRetouche::OnPinceau5()
{
    Pinceau = 3;
    m_BpPinceau1.LoadBitmaps( IDB_BITMAP_STYLOT1_NSEL );
    m_BpPinceau3.LoadBitmaps( IDB_BITMAP_STYLOT3_NSEL );
    m_BpPinceau5.LoadBitmaps( IDB_BITMAP_STYLOT5_SEL );
    m_BpPinceau7.LoadBitmaps( IDB_BITMAP_STYLOT7_NSEL );
    m_BpFill.LoadBitmaps( IDB_BITMAP_FILL_NSEL );
    m_BpFill.RedrawWindow();
    m_BpPinceau1.RedrawWindow();
    m_BpPinceau3.RedrawWindow();
    m_BpPinceau5.RedrawWindow();
    m_BpPinceau7.RedrawWindow();
    Outil = OUTIL_STYLOT;
}


void CRetouche::OnPinceau7()
{
    Pinceau = 4;
    m_BpPinceau1.LoadBitmaps( IDB_BITMAP_STYLOT1_NSEL );
    m_BpPinceau1.RedrawWindow();
    m_BpPinceau3.LoadBitmaps( IDB_BITMAP_STYLOT3_NSEL );
    m_BpPinceau3.RedrawWindow();
    m_BpPinceau5.LoadBitmaps( IDB_BITMAP_STYLOT5_NSEL );
    m_BpPinceau5.RedrawWindow();
    m_BpPinceau7.LoadBitmaps( IDB_BITMAP_STYLOT7_SEL );
    m_BpPinceau7.RedrawWindow();
    m_BpFill.LoadBitmaps( IDB_BITMAP_FILL_NSEL );
    m_BpFill.RedrawWindow();
    Outil = OUTIL_STYLOT;
}


void CRetouche::OnFill()
{
    m_BpPinceau1.LoadBitmaps( IDB_BITMAP_STYLOT1_NSEL );
    m_BpPinceau1.RedrawWindow();
    m_BpPinceau3.LoadBitmaps( IDB_BITMAP_STYLOT3_NSEL );
    m_BpPinceau3.RedrawWindow();
    m_BpPinceau5.LoadBitmaps( IDB_BITMAP_STYLOT5_NSEL );
    m_BpPinceau5.RedrawWindow();
    m_BpPinceau7.LoadBitmaps( IDB_BITMAP_STYLOT7_NSEL );
    m_BpPinceau7.RedrawWindow();
    m_BpFill.LoadBitmaps( IDB_BITMAP_FILL_SEL );
    m_BpFill.RedrawWindow();
    Outil = OUTIL_FILL;
}


void CRetouche::OnCol00()
{
    Stylo = 0;
    AffichePalette();
}


void CRetouche::OnCol01()
{
    Stylo = 1;
    AffichePalette();
}


void CRetouche::OnCol02()
{
    Stylo = 2;
    AffichePalette();
}


void CRetouche::OnCol03()
{
    Stylo = 3;
    AffichePalette();
}


void CRetouche::OnCol04()
{
    Stylo = 4;
    AffichePalette();
}


void CRetouche::OnCol05()
{
    Stylo = 5;
    AffichePalette();
}


void CRetouche::OnCol06()
{
    Stylo = 6;
    AffichePalette();
}


void CRetouche::OnCol07()
{
    Stylo = 7;
    AffichePalette();
}


void CRetouche::OnCol08()
{
    Stylo = 8;
    AffichePalette();
}


void CRetouche::OnCol09()
{
    Stylo = 9;
    AffichePalette();
}


void CRetouche::OnCol10()
{
    Stylo = 10;
    AffichePalette();
}


void CRetouche::OnCol11()
{
    Stylo = 11;
    AffichePalette();
}


void CRetouche::OnCol12()
{
    Stylo = 12;
    AffichePalette();
}


void CRetouche::OnCol13()
{
    Stylo = 13;
    AffichePalette();
}


void CRetouche::OnCol14()
{
    Stylo = 14;
    AffichePalette();
}


void CRetouche::OnCol15()
{
    Stylo = 15;
    AffichePalette();
}


void CRetouche::OnHScroll( UINT nSBCode, UINT nPos, CScrollBar * pScrollBar)
{
    int RangeMin, RangeMax, i = OffsetX;

    switch( nSBCode )
        {
        case SB_BOTTOM :
            pScrollBar->GetScrollRange( &RangeMin, &RangeMax );
            OffsetX = RangeMax;
            break;
/*
        case SB_ENDSCROLL :
            i++;
            break;
*/
        case SB_LINEDOWN :
            pScrollBar->GetScrollRange( &RangeMin, &RangeMax );
            if ( OffsetX < RangeMax )
                OffsetX++;

            break;

        case SB_LINEUP :
            if ( OffsetX > 0 )
                OffsetX--;

            break;

        case SB_PAGEUP :
            pScrollBar->GetScrollRange( &RangeMin, &RangeMax );
            OffsetX -= ( RangeMax - RangeMin ) / Zoom;
            if ( OffsetX < 0 )
                OffsetX = 0;

            break;

        case SB_PAGEDOWN :
            pScrollBar->GetScrollRange( &RangeMin, &RangeMax );
            OffsetX += ( RangeMax - RangeMin ) / Zoom;
            if ( OffsetX > RangeMax )
                OffsetX = RangeMax;

            break;

        case SB_THUMBPOSITION :
        case SB_THUMBTRACK :
            OffsetX = nPos;
            break;

        case SB_TOP :
            OffsetX = 0;
            break;
        }
    if ( i != OffsetX )
        {
        pScrollBar->SetScrollPos( OffsetX );
        RedrawBitmap();
        }

    CDialog::OnHScroll( nSBCode, nPos, pScrollBar );
}


void CRetouche::OnVScroll( UINT nSBCode, UINT nPos, CScrollBar * pScrollBar )
{
    int RangeMin, RangeMax, i = OffsetY;

    switch( nSBCode )
        {
        case SB_BOTTOM :
            pScrollBar->GetScrollRange( &RangeMin, &RangeMax );
            OffsetY = RangeMax;
            break;
/*
        case SB_ENDSCROLL :
            i++;
            break;
*/
        case SB_LINEDOWN :
            pScrollBar->GetScrollRange( &RangeMin, &RangeMax );
            if ( OffsetY < RangeMax )
                OffsetY++;

            break;

        case SB_LINEUP :
            if ( OffsetY > 0 )
                OffsetY--;

            break;

        case SB_PAGEUP :
            pScrollBar->GetScrollRange( &RangeMin, &RangeMax );
            OffsetY -= ( RangeMax - RangeMin ) / Zoom;
            if ( OffsetY < 0 )
                OffsetY = 0;

            break;

        case SB_PAGEDOWN :
            pScrollBar->GetScrollRange( &RangeMin, &RangeMax );
            OffsetY += ( RangeMax - RangeMin ) / Zoom;
            if ( OffsetY > RangeMax )
                OffsetY = RangeMax;

            break;

        case SB_THUMBPOSITION :
        case SB_THUMBTRACK :
            OffsetY = nPos;
            break;

        case SB_TOP :
            OffsetY = 0;
            break;
        }
    if ( i != OffsetY )
        {
        pScrollBar->SetScrollPos( OffsetY );
        RedrawBitmap();
        }

    CDialog::OnVScroll( nSBCode, nPos, pScrollBar );
}


int CRetouche::GetPoint( int Posx, int Posy )
{
    int Masque = 0xFFFF, Nbx = 1;

    if ( Posx >= 0 && Posx < TAILLE_RET_X && Posy >= 0 && Posy < TAILLE_RET_Y )
        {
        switch( Mode )
            {
            case 0 :
                Masque = 0xFFFC;
                Nbx = 4;
                break;

            case 1 :
                Masque = 0xFFFE;
                Nbx = 2;
                break;
            }
        Posx = ( OffsetX + Posx / Zoom ) & Masque;
        Posy = ( OffsetY + Posy / Zoom ) & 0xFFFE;
        return( Bitmap[ Posx + BITMAP_X * Posy ].a );
        }
    return( -1 );
}


void CRetouche::SetPoint( int Posx, int Posy, int Coul )
{
    int Adr, x, y, Masque = 0xFFFF, Nbx = 1;
    BYTE r, v, b;
    BOOL Modif = FALSE;
    HBRUSH br;

    if ( Posx >= 0 && Posx < TAILLE_RET_X && Posy >= 0 && Posy < TAILLE_RET_Y )
        {
        switch( Mode )
            {
            case 0 :
                Masque = 0xFFFC;
                Nbx = 4;
                break;

            case 1 :
                Masque = 0xFFFE;
                Nbx = 2;
                break;
            }

        Posx = ( OffsetX + Posx / Zoom ) & Masque;
        Posy = ( OffsetY + Posy / Zoom ) & 0xFFFE;
        StRVB i = GetPalCPC( Palette[ Coul ], CpcPlus );
        b = i.b;
        r = i.r;
        v = i.v;
        switch( Outil )
            {
            case OUTIL_STYLOT:
                for ( x = Nbx * ( 1 - Pinceau ); x < Pinceau * Nbx; x++ )
                    for ( y = 2 * ( 1 -  Pinceau ); y < Pinceau * 2; y++ )
                        {
                        if (  ( x + Posx >= 0 )
                           && ( y + Posy >= 0 ) 
                           && ( x + Posx < TailleX )
                           && ( y + Posy < TailleY )
                           )
                            {
                            Adr = x + Posx + BITMAP_X * ( Posy + y );
                            if ( Bitmap[ Adr ].a != Coul )
                                {
                                Bitmap[ Adr ].a = ( BYTE )Coul;
                                Bitmap[ Adr ].r = r;
                                Bitmap[ Adr ].v = v;
                                Bitmap[ Adr ].b = b;
                                Modif = TRUE;
                                }
                            }
                        }
                break;

            case OUTIL_FILL:
                br = CreateSolidBrush( RGB( r, v, b ) );
                SelectObject( DcBitmap, br );
                Adr = Posx + BITMAP_X * Posy;
                r = Bitmap[ Adr ].r;
                v = Bitmap[ Adr ].v;
                b = Bitmap[ Adr ].b;
                ExtFloodFill( DcBitmap
                            , Posx
                            , Posy
                            , RGB( r, v, b )
                            , FLOODFILLSURFACE
                            );
                DeleteObject( br );
                Passe2( Bitmap
                      , 4 >> Mode
                      , Palette
                      , Mode == 0 ? 16 : Mode == 1 ? 4 : 2
                      , CpcPlus
                      );
                LisseBitmap( Bitmap, 4 >> Mode );
                Modif = TRUE;
                break;
            }
        if ( Modif )
            {
            RedrawBitmap();
            m_BpUndo.EnableWindow( TRUE );
            }
        }
}


void CRetouche::OnLButtonUp( UINT nFlags, CPoint point )
{
    LButton = FALSE;
    SetCurCol( GetPoint( point.x - 3, point.y - 3 ) );
    CDialog::OnLButtonUp( nFlags, point );
}


void CRetouche::OnLButtonDown( UINT nFlags, CPoint point )
{
    if ( ! LButton )
        {
        memcpy( BmUndo.GetMemBitmap(), Bitmap, BmUndo.GetTaille() );
        LButton = TRUE;
        }
    SetPoint( point.x - 3, point.y - 3, Stylo );
    CDialog::OnLButtonDown( nFlags, point );
}


void CRetouche::OnRButtonUp( UINT nFlags, CPoint point )
{
    RButton = FALSE;
    CDialog::OnRButtonUp( nFlags, point );
}


void CRetouche::OnRButtonDown( UINT nFlags, CPoint point )
{
    if (  point.x >= 0
       && point.x < TAILLE_RET_X
       && point.y >= 0 
       && point.y < TAILLE_RET_Y
       )
        {
        if ( ! RButton )
            {
            RButton = TRUE;
            DeltaX = point.x;
            DeltaY = point.y;
            }
        else
            if ( point.x != DeltaX || point.y != DeltaY )
                {
                OffsetX = min( max( 0, OffsetX + point.x - DeltaX )
                             , TailleX - ( TAILLE_RET_X / Zoom )
                             );
                OffsetY = min( max( 0, OffsetY + point.y - DeltaY )
                             , TailleY - ( TAILLE_RET_Y / Zoom )
                             );
                m_ScrollHor.SetScrollPos( OffsetX );
                m_ScrollVer.SetScrollPos( OffsetY );
                DeltaX = point.x;
                DeltaY = point.y;
                RedrawBitmap();
                }
        }
    CDialog::OnRButtonDown( nFlags, point );
}


void CRetouche::OnMouseMove( UINT nFlags, CPoint point )
{
    // fonction appele lorsque l'utilisateur dplace la souris
    switch( nFlags )
        {
        case MK_LBUTTON :
            OnLButtonDown( nFlags, point );
            break;

        case MK_RBUTTON :
            OnRButtonDown( nFlags, point );
            break;

        default : // Dplacement seul
            SetCurCol( GetPoint( point.x - 3, point.y - 3 ) );
            break;
        }
    CDialog::OnMouseMove( nFlags, point );
}


void CRetouche::SetCurCol( int Color )
{
    if ( CurCol != Color )
        {
        if ( CurCol != -1 )
            m_PtCol[ CurCol ].ShowWindow( FALSE );

        if ( Color != -1 )
            m_PtCol[ Color ].ShowWindow( TRUE );

        CurCol = Color;
        }
}


void CRetouche::OnUndo( void )
{
    memcpy( Bitmap, BmUndo.GetMemBitmap(), BmUndo.GetTaille() );
    RedrawBitmap();
    m_BpUndo.EnableWindow( FALSE );
}
