#include  <afxwin.h>


#include  "Constantes.h"
#include  "Conversion.h"
#include  "Locale.h"


#define     LUM_CPC_0       0x00
#define     LUM_CPC_1       0x66
#define     LUM_CPC_2       0xF0

#define     SEUIL_LUM_1     85
#define     SEUIL_LUM_2     170


extern int Locale;

enum { COMP_R, COMP_V, COMP_B };


BYTE TabVGA[ 2720 ];

static int corr[ 4 ];

static char Msg[ 1024 ];

static int Coul[ 4096 ];



static StRVB RgbCPC[ 27 ] =
    {
        { LUM_CPC_0, LUM_CPC_0, LUM_CPC_0, LUM_CPC_0 },
        { LUM_CPC_1, LUM_CPC_0, LUM_CPC_0, LUM_CPC_0 },
        { LUM_CPC_2, LUM_CPC_0, LUM_CPC_0, LUM_CPC_0 },
        { LUM_CPC_0, LUM_CPC_0, LUM_CPC_1, LUM_CPC_0 },
        { LUM_CPC_1, LUM_CPC_0, LUM_CPC_1, LUM_CPC_0 },
        { LUM_CPC_2, LUM_CPC_0, LUM_CPC_1, LUM_CPC_0 },
        { LUM_CPC_0, LUM_CPC_0, LUM_CPC_2, LUM_CPC_0 },
        { LUM_CPC_1, LUM_CPC_0, LUM_CPC_2, LUM_CPC_0 },
        { LUM_CPC_2, LUM_CPC_0, LUM_CPC_2, LUM_CPC_0 },
        { LUM_CPC_0, LUM_CPC_1, LUM_CPC_0, LUM_CPC_0 },
        { LUM_CPC_1, LUM_CPC_1, LUM_CPC_0, LUM_CPC_0 },
        { LUM_CPC_2, LUM_CPC_1, LUM_CPC_0, LUM_CPC_0 },
        { LUM_CPC_0, LUM_CPC_1, LUM_CPC_1, LUM_CPC_0 },
        { LUM_CPC_1, LUM_CPC_1, LUM_CPC_1, LUM_CPC_0 },
        { LUM_CPC_2, LUM_CPC_1, LUM_CPC_1, LUM_CPC_0 },
        { LUM_CPC_0, LUM_CPC_1, LUM_CPC_2, LUM_CPC_0 },
        { LUM_CPC_1, LUM_CPC_1, LUM_CPC_2, LUM_CPC_0 },
        { LUM_CPC_2, LUM_CPC_1, LUM_CPC_2, LUM_CPC_0 },
        { LUM_CPC_0, LUM_CPC_2, LUM_CPC_0, LUM_CPC_0 },
        { LUM_CPC_1, LUM_CPC_2, LUM_CPC_0, LUM_CPC_0 },
        { LUM_CPC_2, LUM_CPC_2, LUM_CPC_0, LUM_CPC_0 },
        { LUM_CPC_0, LUM_CPC_2, LUM_CPC_1, LUM_CPC_0 },
        { LUM_CPC_1, LUM_CPC_2, LUM_CPC_1, LUM_CPC_0 },
        { LUM_CPC_2, LUM_CPC_2, LUM_CPC_1, LUM_CPC_0 },
        { LUM_CPC_0, LUM_CPC_2, LUM_CPC_2, LUM_CPC_0 },
        { LUM_CPC_1, LUM_CPC_2, LUM_CPC_2, LUM_CPC_0 },
        { LUM_CPC_2, LUM_CPC_2, LUM_CPC_2, LUM_CPC_0 }
    };


BYTE ConvColVGA[ 27 ] = 
    {
    0x54, 0x44, 0x55, 0x5C, 0x58, 0x5D, 0x4C, 0x45, 0x4D,
    // 0     1     2     3     4     5     6     7     8
    0x56, 0x46, 0x57, 0x5E, 0x40, 0x5F, 0x4E, 0x47, 0x4F,
    // 9    10    11    12    13    14    15    16    17
    0x52, 0x42, 0x53, 0x5A, 0x59, 0x5B, 0x4A, 0x43, 0x4B
    //18    19    20    21    22    23    24    25    26
    };


int PaletteStandardCPC[ 16 ] =
    {
    1, 24, 20, 6, 26, 0, 2, 7, 10, 12, 14, 16, 18, 22, 1, 14
    };


static void CalcDiff( int diff
                    , int Methode
                    , int Pct
                    , int Matrice
                    , BOOL CpcPlus
                    )
{
    int k;

    if ( Matrice == 3 )
        Pct = Pct / 3;

    if ( CpcPlus )
        Pct = Pct << 2;

    switch( Methode )
        {
        case 1 :
            k = Pct ? 16000 / Pct : 100000;
            corr[ 0 ] = ( diff * 70 ) / k;
            corr[ 1 ] = ( diff * 30 ) / k;
            corr[ 2 ] = ( diff * 50 ) / k;
            corr[ 3 ] = ( diff * 10 ) / k;
            break;

        case 2 :
            k = Pct ? 7500 / Pct : 100000;
            corr[ 0 ] = ( diff * 40 ) / k;
            corr[ 1 ] = ( diff * 20 ) / k;
            corr[ 2 ] = ( diff * 10 ) / k;
            corr[ 3 ] = ( diff * 5 ) / k;
            break;

        case 3 :
            k = Pct ? 15000 / Pct : 100000;
            corr[ 0 ] = ( diff * 80 ) / k;
            corr[ 1 ] = ( diff * 20 ) / k;
            corr[ 2 ] = ( diff * 40 ) / k;
            corr[ 3 ] = ( diff * 10 ) / k;
            break;
        }
}


//
// Ajoute une correction d'erreur  une composante (r,v,b) d'un pixel
//
static void AddPixel( StRVB * Bitmap, int x, int y, int corr, int comp )
{
    if ( x < TailleX && y < TailleY && x >= 0 )
        {
        StRVB * p = &Bitmap[ x + BITMAP_X * y ];
        BYTE * c = &p->r;
        switch( comp )
            {
            case COMP_V :
                c = &p->v;
                break;

            case COMP_B :
                c = &p->b;
                break;
            }
        * c = ( BYTE )min( max( 0, * c + corr ), 255 );
        }
}


//
// Ajoute le tramage  un pixel donn
//
static void AddPixelCor( StRVB * Bitmap
                       , int x
                       , int y
                       , int comp
                       , int Tx
                       , int Matrice
                       , int Methode
                       )
{
    if ( Methode )
        {
        switch( Matrice )
            {
            case 2 :
                AddPixel( Bitmap, x + Tx, y, corr[ 0 ], comp );

                AddPixel( Bitmap, x - Tx, y + 2, corr[ 1 ], comp );
                AddPixel( Bitmap, x, y + 2, corr[ 2 ], comp );
                AddPixel( Bitmap, x + Tx, y + 2, corr[ 3 ], comp );
                break;

            case 3 :
                AddPixel( Bitmap, x + Tx, y, corr[ 0 ], comp );
                AddPixel( Bitmap, x + 2 * Tx, y, corr[ 2 ], comp );

                AddPixel( Bitmap, x - 2 * Tx, y + 2, corr[ 1 ], comp );
                AddPixel( Bitmap, x - Tx, y + 2, corr[ 2 ], comp );
                AddPixel( Bitmap, x, y + 2, corr[ 0 ], comp );
                AddPixel( Bitmap, x + Tx, y + 2, corr[ 2 ], comp );
                AddPixel( Bitmap, x + 2 * Tx, y + 2, corr[ 1 ], comp );

                AddPixel( Bitmap, x - 2 * Tx, y + 2 * 2, corr[ 3 ], comp );
                AddPixel( Bitmap, x - Tx, y + 2 * 2, corr[ 1 ], comp );
                AddPixel( Bitmap, x, y + 2 * 2, corr[ 2 ], comp );
                AddPixel( Bitmap, x + Tx, y + 2 * 2, corr[ 1 ], comp );
                AddPixel( Bitmap, x + 2 * Tx, y + 2 * 2 , corr[ 3 ], comp );
                break;
            }
        }
}


//
// Retourne la couleur CPC la plus proche du pixel pass en paramtre
//
static StRVB RechercheProche( StRVB * p, BOOL CpcPlus, BOOL NewMethode )
{
    StRVB Choix = { 0, 0, 0, 0 };

    if ( CpcPlus )
        {
        Choix.b = ( BYTE )( ( p->b >> 4 ) * 17 );
        Choix.v = ( BYTE )( ( p->v >> 4 ) * 17 );
        Choix.r = ( BYTE )( ( p->r >> 4 ) * 17 );
        }
    else
        {
        if ( NewMethode )
            {
            int Dist1 = 0, OldDist1 = 0x7FFFFFFF;
            for ( int i = 0; i < 27; i++ )
                {
                StRVB s = RgbCPC[ i ];
                Dist1 = abs( s.r - p->r ) * K_R
                      + abs( s.v - p->v ) * K_V
                      + abs( s.b - p->b ) * K_B;
                if ( Dist1 < OldDist1 )
                    {
                    OldDist1 = Dist1;
                    Choix = s;
                    }
                }
            }
        else
            {
            Choix.r = ( BYTE )( p->r > SEUIL_LUM_2 ? LUM_CPC_2 : p->r > SEUIL_LUM_1 ? LUM_CPC_1 : LUM_CPC_0 );
            Choix.v = ( BYTE )( p->v > SEUIL_LUM_2 ? LUM_CPC_2 : p->v > SEUIL_LUM_1 ? LUM_CPC_1 : LUM_CPC_0 );
            Choix.b = ( BYTE )( p->b > SEUIL_LUM_2 ? LUM_CPC_2 : p->b > SEUIL_LUM_1 ? LUM_CPC_1 : LUM_CPC_0 );
            }
        }
    return( Choix );
}


//
// Effectue la moyenne des couleurs sur un groupe de pixels reprsentant
// un point dans le mode CPC dsir
//
static void Passe0( StRVB * Bitmap, int Tx )
{
    int r, v, b, cnt;
    StRVB s;

    for ( int y = 0; y < TailleY; y += 2 )
        for ( int x = 0; x < TailleX; x += Tx )
            {
            cnt = r = v = b = 0;
            for ( int i = 0; i < Tx; i++ )
                {
                r += Bitmap[ i + x + BITMAP_X * y ].r + Bitmap[ BITMAP_X + i + x + BITMAP_X * y ].r;
                v += Bitmap[ i + x + BITMAP_X * y ].v + Bitmap[ BITMAP_X + i + x + BITMAP_X * y ].v;
                b += Bitmap[ i + x + BITMAP_X * y ].b + Bitmap[ BITMAP_X + i + x + BITMAP_X * y ].b;
                cnt += 2;
                }
            s.r = ( BYTE )( r / cnt );
            s.v = ( BYTE )( v / cnt );
            s.b = ( BYTE )( b / cnt );
            for ( int i = 0; i < Tx; i++ )
                {
                Bitmap[ i + x + BITMAP_X * y ] =
                Bitmap[ BITMAP_X + i + x + BITMAP_X * y ] = s;
                }
            }
}


//
// Passe 1 : Rduit la palette aux x couleurs de la palette du CPC.
// Effectue galement un traitement de l'erreur (tramage) si demand.
//
static void Passe1( StRVB * Bitmap
                  , int Methode
                  , int Pct
                  , int Matrice
                  , int Tx
                  , BOOL CpcPlus
                  , BOOL Nb
                  , BOOL NewMethode
                  )
{   
    for ( int y = 0; y < TailleY; y += 2 )
        for ( int x = 0; x < TailleX; x += Tx )
            {
            // Lecture de la couleur du point au coordonnes (x,y)
            StRVB * p1 = &Bitmap[ x + BITMAP_X * y ];
            p1->a = 0;

            // Recherche le point dans la couleur cpc la plus proche
            StRVB p2 = RechercheProche( p1, CpcPlus, NewMethode );

            // Modifie composante Rouge
            CalcDiff( p1->r - p2.r, Methode, Pct, Matrice, CpcPlus );
            p1->r = p2.r;
            AddPixelCor( Bitmap, x, y, COMP_R, Tx, Matrice, Methode );

            // Modifie composante Verte
            CalcDiff( p1->v - p2.v, Methode, Pct, Matrice, CpcPlus );
            p1->v = p2.v;
            AddPixelCor( Bitmap, x, y, COMP_V, Tx, Matrice, Methode );

            // Modifie composante Bleue
            CalcDiff( p1->b - p2.b, Methode, Pct, Matrice, CpcPlus );
            p1->b = p2.b;
            AddPixelCor( Bitmap, x, y, COMP_B, Tx, Matrice, Methode );

            // Convertir en noir & blanc ?
            if ( Nb )
                {
                int l = ( K_R * p1->r + K_V * p1->v + K_B * p1->b ) >> 15;
                p1->r = p1->v = p1->b = ( BYTE )l;
                }
            }
}


//
// Calcule le nombre de couleurs utilises dans l'image, et
// remplit un tableau avec ces couleurs
//
static int CalcNbCoul( StRVB * Bitmap
                     , int Tx
                     , int Mode
                     , BOOL CpcPlus
                     , BOOL ReductPal1
                     , BOOL ReductPal2
                     , BOOL ModeReduct
                     )
{
    int i, NbCol = 0;

    memset( Coul, 0, sizeof( Coul ) );
    if ( CpcPlus )
        {
        for ( int y = 0; y < TailleY; y += 2 )
            for ( int x = 0; x < TailleX; x += Tx )
                {
                StRVB c = Bitmap[ x + BITMAP_X * y ];
                int i = ( ( c.b >> 4 ) << 0 )
                      + ( ( c.r >> 4 ) << 4 )
                      + ( ( c.v >> 4 ) << 8 );
                Coul[ i ]++;
                }
        for ( i = 0; i < 4096; i++ )
            if ( Coul[ i ] )
                NbCol++;

        //
        // Rduction du nombre de couleurs pour viter les couleurs
        // trop proches
        //
        if ( Mode < 3 )
            {
            // Masquer 1 bit par composante
            for ( i = 0; i < 4096; i++ )
                {
                int c1 = ( i & 0xC00 ) * 0xFFF / 0xC00;
                int c2 = ( i & 0xC0 ) * 0xFF / 0xC0;
                int c3 = ( i & 0x0C ) * 0x0F / 0x0C;
                if (  ( ( i & 1 ) && ReductPal1 )
                   || ( ! ( i & 1 ) && ReductPal2 )
                   )
                    {
                    int t = Coul[ i ];
                    Coul[ i ] = 0;
                    if ( ModeReduct )
                        Coul[ ( c1 & 0xF00 ) + ( c2 & 0xF0 ) + ( c3 & 0x0F ) ] += t;
                    else
                        Coul[ ( c1 & 0xC00 ) + ( c2 & 0xC0 ) + ( c3 & 0x0C ) ] += t;
                    }
                }
            NbCol = 0;
            for ( i = 0; i < 4096; i++ )
                if ( Coul[ i ] )
                    NbCol++;
            }
        }
    else
        {
        //
        // Cas CPC "OLD"
        //
        for ( int y = 0; y < TailleY; y += 2 )
            for ( int x = 0; x < TailleX; x += Tx )
                {
                StRVB c = Bitmap[ x + BITMAP_X * y ];
                for ( int i = 0; i < 27; i++ )
                    if ( * ( int * )&c == * ( int * )&RgbCPC[ i ] )
                        Coul[ i ]++;
                }
        for ( int i = 0; i < 27; i++ )
            if ( Coul[ i ] )
                NbCol++;
        }
    return( NbCol );
}


//
// Recherche les x couleurs les plus utilises parmis les n possibles
//
static void RechercheCMax( int MaxCol
                         , int CMax[ 16 ]
                         , int Bloque[ 16 ]
                         , BOOL CpcPlus
                         )
{
    int FindMax = CpcPlus ? 4096 : 27;

    for ( int x = 0; x < MaxCol; x++ )
        if ( Bloque[ x ] )
            Coul[ CMax[ x ] ] = 0;

    for ( int x = 0; x < MaxCol; x++ )
        {
        int valMax = 0;
        if ( ! Bloque[ x ] )
            {
            for ( int i = 0; i < FindMax; i++ )
                {
                if ( valMax < Coul[ i ] )
                    {
                    valMax = Coul[ i ];
                    CMax[ x ] = i;
                    }
                }
            Coul[ CMax[ x ] ] = 0;
            }
        }
}


static void SetPixCol( int x
                     , int y
                     , StRVB * Bitmap
                     , int CMax[ 16 ]
                     , int MaxCol
                     , BOOL CpcPlus
                     )
{
    int i, Dist1 = 0, OldDist1 = 0x7FFFFFFF;
    StRVB s;

    StRVB * pix1 = &Bitmap[ x + BITMAP_X * y ];
    StRVB Choix1 = * pix1;
    for ( i = 0; i < MaxCol; i++ )
        {
        if ( CpcPlus )
            {
            s.r = ( BYTE )( ( ( CMax[ i ] & 0xF0 ) >> 4 ) * 17 );
            s.v = ( BYTE )( ( ( CMax[ i ] & 0xF00 ) >> 8 ) * 17 );
            s.b = ( BYTE )( ( CMax[ i ] & 0x0F ) * 17 );
            }
        else
            s = RgbCPC[ CMax[ i ] ];

        Dist1 = abs( s.r - pix1->r ) * K_R
              + abs( s.v - pix1->v ) * K_V
              + abs( s.b - pix1->b ) * K_B;
        if ( Dist1 < OldDist1 )
            {
            OldDist1 = Dist1;
            Choix1 = s;
            Choix1.a = ( BYTE )i;   // Numro de couleur dans la
                                    // Palette du CPC (0  16)
            }
        }
    * pix1 = Choix1;
}


//
// Passe 2 : rduit l'image  MaxCol couleurs.
//
void Passe2( StRVB * Bitmap
           , int Tx
           , int CMax[ 16 ]
           , int MaxCol
           , BOOL CpcPlus
           )
{
    for ( int y = 0; y < TailleY; y += 2 )
        for ( int x = 0; x < TailleX; x += Tx )
            SetPixCol( x, y, Bitmap, CMax, MaxCol, CpcPlus );
}


static int FctTri( const void * a, const void * b )
{
    return( * ( int * )a - * ( int * )b );
}


//
// Passe 3 : mode Ligne
//
// 1 NOP = 8 pixels
// OUTI = 5 NOPs = 40 pixels
//
static void Passe3( StRVB * Bitmap, int CMax[ 16 ], int Etale )
{
    int PosVga = 0;
    int CoulBloque1 = CMax[ 0 ];
    int CoulBloque2 = CMax[ 1 ];
    static int Coul[ 27 ];

    for ( int y = 0; y < TailleY; y += 2 )
        {
        int yd = max( 0, y - Etale );
        int ya = min( TailleY, y + Etale + 1 );
        memset( Coul, 0, sizeof( Coul ) );

        for ( int yr = yd; yr < ya; yr += 2 )
            for ( int xr = 0; xr < TailleX; xr += 2 )
                {
                int c = * ( int * )&Bitmap[ xr + BITMAP_X * yr ];
                for ( int i = 0; i < 27; i++ )
                    if ( i != CoulBloque1 && i != CoulBloque2 && c == * ( int * )&RgbCPC[ i ] )
                        Coul[ i ]++;
                }
        // Rechercher les 2 couleurs  modifier
        for ( int j = 2; j < 4; j++ )
            {
            int valMax = 0;
            for ( int i = 0; i < 27; i++ )
                {
                if ( valMax < Coul[ i ] )
                    {
                    valMax = Coul[ i ];
                    CMax[ j ] = i;
                    }
                }
            Coul[ CMax[ j ] ] = 0;
            }

        TabVGA[ PosVga++ ] = ConvColVGA[ CMax[ 2 ] ];
        TabVGA[ PosVga++ ] = ConvColVGA[ CMax[ 3 ] ];
        for ( int x = 0; x < TailleX; x += 2 )
            SetPixCol( x, y, Bitmap, CMax, 4, FALSE );
        }
}


//
// Lissage du bitmap en fonction de la rsolution du CPC :
// 160x200 en Mode 0, 320x200 en Mode 1, 640x200 en Mode 2
//
void LisseBitmap( StRVB * Bitmap, int Tx )
{
    for ( int y = 0; y < TailleY; y += 2 )
        for ( int x = 0; x < TailleX; x += Tx )
            for ( int i = 0; i < Tx; i++ )
                {
                Bitmap[ i + x + BITMAP_X * y ] =
                Bitmap[ BITMAP_X + i + x + BITMAP_X * y ] =
                Bitmap[ x + BITMAP_X * y ];
                }
}


void AppliquePalette( StRVB * Bitmap, int Mode, int CMax[ 16 ], BOOL CpcPlus )
{
    StRVB s;
    int Tx = 4 >> Mode;

    for ( int y = 0; y < TailleY; y += 2 )
        for ( int x = 0; x < TailleX; x += Tx )
            for ( int i = 0; i < Tx; i++ )
                {
                BYTE c = Bitmap[ i + x + BITMAP_X * y ].a;
                if ( c < 16 )
                    {
                    if ( CpcPlus )
                        {
                        s.r = ( BYTE )( ( ( CMax[ c ] & 0xF0 ) >> 4 ) * 17 );
                        s.v = ( BYTE )( ( ( CMax[ c ] & 0xF00 ) >> 8 ) * 17 );
                        s.b = ( BYTE )( ( CMax[ c ] & 0x0F ) * 17 );
                        }
                    else
                        s = RgbCPC[ CMax[ c ] ];
                    }
                s.a = c;
                Bitmap[ i + x + BITMAP_X * y ] =
                Bitmap[ BITMAP_X + i + x + BITMAP_X * y ] =
                s;
            }
}


void Convert( CListBox * Liste
            , int MethodeTrame
            , int PctTrame
            , int Matrice
            , int Mode
            , StRVB * Bitmap
            , int CMax[ 16 ]
            , int Bloque[ 16 ]
            , BOOL CpcPlus
            , BOOL Lissage
            , BOOL ReductPal1
            , BOOL ReductPal2
            , BOOL ModeReduct
            , BOOL Nb
            , BOOL TriePal
            , BOOL NewMethode
            , int Etale
            )
{
    int Tx = 4 >> Mode, MaxCol = 16;

    switch( Mode )
        {
        case 0 :
            MaxCol = 16;
            break;

        case 1 :
            MaxCol = 4;
            break;

        case 2 :
            MaxCol = 2;
            break;

        case 3 :
            MaxCol = 4;
            Tx = 2;
            break;
/*
        case 4 :
            MaxCol = 16;
            Tx = 2;
            break;
*/
        }
    if ( Liste )
        {
        Liste->AddString( GetTexteLoc( 42, Locale ) );
        Liste->SetTopIndex( Liste->GetCount() - 1 );
        Liste->UpdateWindow();
        }

    if ( Lissage )
        Passe0( Bitmap, Tx );

    Passe1( Bitmap
          , MethodeTrame
          , PctTrame
          , Matrice
          , Tx
          , CpcPlus
          , Nb
          , NewMethode
          );

    if ( Liste )
        {
        Liste->AddString( GetTexteLoc( 43, Locale ) );
        Liste->SetTopIndex( Liste->GetCount() - 1 );
        Liste->UpdateWindow();
        }

    int NbCol = CalcNbCoul( Bitmap
                          , Tx
                          , Mode
                          , CpcPlus
                          , ReductPal1
                          , ReductPal2
                          , ModeReduct
                          );
    if ( Liste )
        {
        wsprintf( Msg, GetTexteLoc( 44, Locale ), NbCol, CpcPlus ? 4096 : 27 );
        Liste->AddString( Msg );
        wsprintf( Msg, GetTexteLoc( 45, Locale ), MaxCol );
        Liste->AddString( Msg );
        Liste->SetTopIndex( Liste->GetCount() - 1 );
        Liste->UpdateWindow();
        }
    for ( int i = 0; i < 16; i++ )
        if ( ! Bloque[ i ] )
            CMax[ i ] = 0;

    RechercheCMax( MaxCol, CMax, Bloque, CpcPlus );
    wsprintf( Msg, GetTexteLoc( 46, Locale ), MaxCol );
    if ( TriePal )
        qsort( CMax, MaxCol, sizeof( CMax[ 0 ] ), FctTri );

    for ( int i = 0; i < MaxCol; i++ )
        {
        char Tmp[ 16 ];
        if ( ! Bloque[ i ] )
            wsprintf( Tmp, "%d ", CMax[ i ] );
        else
            wsprintf( Tmp, "<%d> ", CMax[ i ] );

        strcat( Msg, Tmp );
        }
    if ( Liste )
        {
        Liste->AddString( Msg );
        Liste->AddString( GetTexteLoc( 47, Locale ) );
        Liste->SetTopIndex( Liste->GetCount() - 1 );
        Liste->UpdateWindow();
        }

    if ( Mode != 3 )
        Passe2( Bitmap, Tx, CMax, MaxCol, CpcPlus );
    else
        if ( ! CpcPlus )
            Passe3( Bitmap, CMax, Etale );

    LisseBitmap( Bitmap, Tx );
    if ( Liste )
        {
        Liste->AddString( GetTexteLoc( 48, Locale ) );
        Liste->SetTopIndex( Liste->GetCount() - 1 );
        Liste->UpdateWindow();
        }
}


void AjusteCouleurs( StRVB * Bitmap, int r, int v, int b )
{
    for ( int y = 0; y < TailleY; y++ )
        for ( int x = 0; x < TailleX; x++ )
            {
            StRVB * p1 = &Bitmap[ x + BITMAP_X * y ];
            p1->r = ( BYTE )min( max( 0, p1->r * r / 100 ), 255 );
            p1->v = ( BYTE )min( max( 0, p1->v * v / 100 ), 255 );
            p1->b = ( BYTE )min( max( 0, p1->b * b / 100 ), 255 );
            }
}


void AjusteContraste( StRVB * Bitmap, int Pct )
{
    int x, y, l, lum = 0;

    for ( y = 0; y < TailleY; y++ )
        for ( x = 0; x < TailleX; x++ )
            {
            StRVB p1 = Bitmap[ x + BITMAP_X * y ];
            lum += ( p1.r * K_R + p1.v * K_V + p1.b * K_B ) >> 15;
            }

    lum /= ( TailleX * TailleY );
    for ( y = 0; y < TailleY; y++ )
        for ( x = 0; x < TailleX; x++ )
            {
            StRVB * p1 = &Bitmap[ x + BITMAP_X * y ];
            l = ( p1->r * K_R + p1->v * K_V + p1->b * K_B ) >> 15;
            if ( l < lum )
                {
                p1->r = min( max( 0, p1->r * ( 1 - ( Pct / 200.0 ) ) ), 255 );
                p1->v = min( max( 0, p1->v * ( 1 - ( Pct / 200.0 ) ) ), 255 );
                p1->b = min( max( 0, p1->b * ( 1 - ( Pct / 200.0 ) ) ), 255 );
                }
            else
                {
                p1->r = min( max( 0, p1->r * ( 1 + ( Pct / 200.0 ) ) ), 255 );
                p1->v = min( max( 0, p1->v * ( 1 + ( Pct / 200.0 ) ) ), 255 );
                p1->b = min( max( 0, p1->b * ( 1 + ( Pct / 200.0 ) ) ), 255 );
                }
            }
}


int GetRgbCPC( int c, BOOL CpcPlus )
{
    if ( CpcPlus )
        {
        return( ( ( c & 0xF0 ) >> 4 ) * 17 
              + ( ( c & 0xF00 ) * 17 )
              + ( ( c & 0x0F ) * 0x110000 )
              );
        }

    if ( c >= 0 && c < 27 )
        {
        StRVB i = RgbCPC[ c ];
        return( ( i.b << 16 ) + ( i.v << 8 ) + i.r );
        }
    return( -1 );
}


StRVB GetPalCPC( int c, BOOL CpcPlus )
{
    static StRVB Col;

    if ( CpcPlus )
        {
        Col.b = ( BYTE )( ( c & 0x0F ) * 17 );
        Col.r = ( BYTE )( ( ( c & 0xF0 ) >> 4 ) * 17 );
        Col.v = ( BYTE )( ( ( c & 0xF00 ) >> 8 ) * 17 );
        return( Col );
        }
    if ( c >= 0 && c < 27 )
        return( RgbCPC[ c ] );

    return( RgbCPC[ 0 ] );
}
