/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

// ----------------------------------------------------------------------------
#include "crLIB.h"
#include <lib3d.h>

#include "Demo.h"

#include <string.h> // memset

// ----------------------------------------------------------------------------
static unsigned int s_palette[ 17 ];

// ----------------------------------------------------------------------------
// #define PRECALCULATE 1
#undef PRECALCULATE

// ----------------------------------------------------------------------------
typedef struct {
	int z;
	unsigned char idx;
} Sort_t;

// ----------------------------------------------------------------------------
#define ANIMLENGTH ((360/4)*2)
#define ANIMCOUNT 1 // 4

#define MAXSINCOS_ 360

// ----------------------------------------------------------------------------
#define MEM_CENTERX		( 0x4000 )
#define MEM_CENTERY		( MEM_CENTERX + MAXSINCOS_ * 2 )
#define MEM_POINTS		( MEM_CENTERY + MAXSINCOS_ * 2 )
#define MEM_SORTITEMS	( MEM_POINTS + 16 * sizeof( Point_t ) )
#define MEM_GEOM1		( MEM_SORTITEMS + 16 * sizeof( Vector_t ) )
#define MEM_COS8		( MEM_GEOM1 + 16 * 2 * 3 )
#define MEM_SIN8		( MEM_COS8 + MAXSINCOS_ * 2 )

#ifdef PRECALCULATE
#define MEM_PRECA		0x5000
#else
#define MEM_PRECA		( MEM_SIN8 + MAXSINCOS_ * 2 )
#endif // PRECALCULATE


static int *s_centerX = (int *) ( MEM_CENTERX );
static int *s_centerY = (int *) ( MEM_CENTERY );

static int *s_sin8 = (int *) ( MEM_COS8 );
static int *s_cos8 = (int *) ( MEM_SIN8 );

static Point_t *s_p = (Point_t *) ( MEM_POINTS );
static Sort_t *s_sortItems = (Sort_t *) ( MEM_SORTITEMS );

// ----------------------------------------------------------------------------
static int s_nullsoftVBLCount;
static int s_isNSFinished;

static int s_sprite;

// ----------------------------------------------------------------------------
static int s_geom;
static int s_geomTimeCount;
static int s_geomSize;
static Vector_t *s_geomData;

static int *s_precaData = (int *) ( MEM_PRECA );
static int s_precaDataOffset;

// ----------------------------------------------------------------------------
static int s_geom1Size;
static Vector_t *s_geom1Data = (Vector_t *) ( MEM_GEOM1 );

static Vector_t rot;
static int s_moveX = 114;
static int s_moveY = 0;

static int s_x, s_y, s_z;
static int s_x2, s_y2, s_z2;

static int s_precaDataOffsetEnd;

#define SETGEOM( vectorName, index, valX, valY, valZ ) \
	vectorName[ index ].x = valX; \
	vectorName[ index ].y = valY; \
	vectorName[ index ].z = valZ;

// ----------------------------------------------------------------------------
void NULLSOFT_InitSpriteHard( )
{
	crPACKERUnpack( 0xC000, crDATAGetPointer( DATA_BALL ) );

	for ( s_sprite = 0; s_sprite < 16; s_sprite++ )
	{
		crASICSetSpriteData( s_sprite, 0xC000 );
	}	
}

// ----------------------------------------------------------------------------
void NULLSOFT_initBackground( )
{
	memset( 0x8000, 0, 0x4000 );
	crTEXTDrawStringRandomScreen( ( unsigned int *) 0x8000, (struct SFont *) &s_solarFont, (struct SFont *) &s_solar2Font, (struct SFont *) &s_solar3Font, 1 );
}

// ----------------------------------------------------------------------------
void NULLSOFT_PreFrameUpdate( )
{
	int i;
	
	NULLSOFT_InitSpriteHard( );
	
	crCRTCSetupScreen( CRTC_OVERSCAN_HORIZONTAL, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGESIZE_16KB );
	//crCRTCSetupScreen( CRTC_OVERSCAN_FULLSCREEN_CONVIMGCPC, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGESIZE_32KB );

	crGASetMode( 1 );
	
	s_nullsoftVBLCount = 0;
	s_isNSFinished = 0;

	s_palette[ 1 ] = 0x194;
	s_palette[ 2 ] = 0x177;
	s_palette[ 3 ] = 0x0d5;

#ifndef PRECALCULATE
	crBANKSetC0( );
	memcpy( 0xC000, crDATAGetPointer( DATA_VECBALLS ), DATA_VECBALLS_SIZE );
	crBANKSetC4( );
	crPACKERUnpack( MEM_PRECA, 0xC000 );
	crBANKSetC0( );
#endif // !PRECALCULATE

	NULLSOFT_initBackground( );

	crSYNCWaitVBL( );
	crASICSetPalette( s_palette );
	crASICSetSpritePalette( crDATAGetPointer( DATA_BALL_PAL ) + 8 );

	crBANKSetC4( );

	s_geom1Size = 8;

#ifdef PRECALCULATE
	for ( i = 0; i < MAXSINCOS_; i++ )
	{
		s_centerX[ i ] = (int) ( 320 + div16384( (long) isin( i ) * (long)( 230 ) ) );
		s_centerY[ i ] = (int) ( 68 + div16384( (long) icos( i ) * (long)( 15 ) ) );

		s_cos8[ i ] = (int) ( div16384( (long) icos( i ) * (long)( 256 ) ) );
		s_sin8[ i ] = (int) ( div16384( (long) isin( i ) * (long)( 256 ) ) );
	}
	{
		SETGEOM( s_geom1Data, 0, -30, 30, 30 );
		SETGEOM( s_geom1Data, 1, 30, 30, 30 );
		SETGEOM( s_geom1Data, 2, 30, -30, 30 );
		SETGEOM( s_geom1Data, 3, -30, -30, 30 );
		SETGEOM( s_geom1Data, 4, -30, 30, -30 );
		SETGEOM( s_geom1Data, 5, 30, 30, -30 );
		SETGEOM( s_geom1Data, 6, 30, -30, -30 );
		SETGEOM( s_geom1Data, 7, -30, -30, -30 );
	}

	crBANKSetC0( );

	rot.x = 23;
	rot.y = 76;
	rot.z = 136;

	{
		Vector_t t;
		Sort_t tmp;
		int j;
		int displayIdx;
		int finalZ;

		int s_sinx;
		int s_cosx;
		int s_siny;
		int s_cosy;
		int s_sinz;
		int s_cosz;

		int frame;

		crBANKSetC4( );

		s_geomData = s_geom1Data;
		s_geomSize = s_geom1Size;

		s_precaDataOffset = 0; // 2 * s_geomSize * ANIMLENGTH;

		for ( frame = 0; frame < ANIMLENGTH; frame++ )
		{
			s_cosx = s_cos8[ rot.x ];
			s_sinx = s_sin8[ rot.x ];
			s_cosy = s_cos8[ rot.y ];
			s_siny = s_sin8[ rot.y ];
			s_cosz = s_cos8[ rot.z ];
			s_sinz = s_sin8[ rot.z ];

			for( i = 0; i < s_geomSize; i++ )
			{
				s_y = s_geomData[ i ].y;
				s_z = s_geomData[ i ].z;
				s_y2 = ( s_y * s_cosx - s_z * s_sinx ) >> 8;
				s_z2 = ( s_y * s_sinx + s_z * s_cosx ) >> 8;

				s_x2 = s_geomData[ i ].x;
				s_x = ( s_x2 * s_cosy - s_z2 * s_siny ) >> 8;
				s_z = ( s_x2 * s_siny + s_z2 * s_cosy ) >> 8;

				s_y = s_y2;
				s_x2 = ( s_x * s_cosz - s_y * s_sinz ) >> 8;
				s_y2 = ( s_x * s_sinz + s_y * s_cosz ) >> 8;

				s_z2 = s_z;

				finalZ = 256 + s_z2;

				s_p[ i ].x = ( s_y2 * finalZ ) >> 8;
				s_p[ i ].y = ( s_x2 * finalZ ) >> 8;

				s_sortItems[ i ].z = finalZ;
				s_sortItems[ i ].idx = i;
			}

			for ( i = 1; i < s_geomSize; i++ )
			{
				tmp.idx = s_sortItems[ i ].idx;
				tmp.z = s_sortItems[ i ].z;

				j = i;

				while ( j != 0 && s_sortItems[ j - 1 ].z < tmp.z )
				{
					s_sortItems[ j ].idx = s_sortItems[ j - 1 ].idx;
					s_sortItems[ j ].z = s_sortItems[ j - 1 ].z;
					j--;
				}
				
				s_sortItems[ j ].idx = tmp.idx;
				s_sortItems[ j ].z = tmp.z;
			}

			for ( s_sprite = 0; s_sprite < s_geomSize; s_sprite++ )
			{
				int x;
				int y;

				displayIdx = s_sortItems[ s_sprite ].idx;

				x = s_centerX[ s_moveX ] + s_p[ displayIdx ].x;
				y = s_centerY[ s_moveY ] + s_p[ displayIdx ].y;

				s_precaData[ s_precaDataOffset++ ] = x;
				s_precaData[ s_precaDataOffset++ ] = y;
			}

			rot.x += 2;
			if ( rot.x >= 360 )
			{
				rot.x -= 360;
			}
			rot.y -= 2;
			if ( rot.y < 0 )
			{
				rot.y += 360;
			}
			rot.z += 4;
			if ( rot.z >= 360 )
			{
				rot.z -= 360;
			}

			s_moveX += 2;
			if ( s_moveX >= 360 )
			{
				s_moveX -= 360;
			}
			s_moveY += 4;
			if ( s_moveY >= 360 )
			{
				s_moveY -= 360;
			}
		}

		s_precaDataOffsetEnd = s_precaDataOffset;
	}

	crBREAK( );

	crBANKSetC0( );

#endif // PRECALCULATE

	s_geomSize = s_geom1Size;
	
	s_precaDataOffset = 0;
	s_precaDataOffsetEnd = 2 * s_geomSize * ANIMLENGTH;
	s_geomTimeCount = 0;

#ifndef PRECALCULATE
	s_precaDataOffset += 16;
#endif // !PRECALCULATE
}

// ----------------------------------------------------------------------------
void NULLSOFT_FrameUpdate( )
{
	crSYNCWaitVBL( );
	crASICSetPalette( s_palette );

	s_geomTimeCount++;
	if ( s_geomTimeCount > 500 )
	{
		for ( s_sprite = 0; s_sprite < 16; s_sprite++ )
		{
			crASICDisableSprite( s_sprite );
		}

		s_isNSFinished = 1;
		return;
	}

	if ( s_precaDataOffset >= s_precaDataOffsetEnd )
	{
		s_precaDataOffset = 0;
	}

	crBANKSetC4( );

	for ( s_sprite = 0; s_sprite < s_geomSize; s_sprite++ )
	{
		int x;
		int y;

		x = s_precaData[ s_precaDataOffset++ ];
		y = s_precaData[ s_precaDataOffset++ ];

		crASICEnableSprite( s_sprite, ASIC_SPRITEMODE_160_320, x, y );

		x = 640 - x;
		y = (68*2) - y;

		crASICEnableSprite( s_sprite + 8, ASIC_SPRITEMODE_160_320, x, y );
	}

	crBANKSetC0( );
}

// ----------------------------------------------------------------------------
void NULLSOFT_Stop( )
{
}

// ----------------------------------------------------------------------------
int NULLSOFT_IsFinished( )
{
	return s_isNSFinished;
}
