/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

// ----------------------------------------------------------------------------
#include "crLIB.h"
#include <lib3d.h>

#include <string.h> // memset

#include "Loading.h"

// ----------------------------------------------------------------------------
unsigned char *s_dataPtr = (unsigned char *) 0x1500;
#define GETDATAPTR( offset ) ( (unsigned char *) ( s_dataPtr + offset ) )


// ----------------------------------------------------------------------------
void main( )
{	
	//asm( "defb $ed, $ff" );
	
	//asm( "ei" );
    asm( "ld sp, $1400" );

	crBANKGetBank( );
	crASICIsBegin( );

	crCRTCSetWidth( 48 );	
	crCRTCSetHeight( 20 );
	crCRTCSetPosX( 50 );
	crCRTCSetPosY( 28 );

	memcpy( 0xC000, GETDATAPTR( DATA_PT3MUSIC ), DATA_PT3MUSIC_SIZE );
	crBANKSetC7( );
	crPACKERUnpack( 0x6300, 0xC000 );
	crBANKSetC0( );

	crLIBInit( 0x4000 );
	
#asm
	ld b, $bc;
	ld hl, dataSequence;
	ld e, 17;

.loopSequence
	ld a, (hl);
	out (c), a;
	inc hl;
	dec e;
	jr nz, loopSequence;

	jr endUnlock;

.dataSequence
	defb $ff, $00, $ff, $77
	defb $b3, $51, $a8, $d4
	defb $62, $39, $9c, $46
	defb $2b, $15, $8a, $cd
	defb $ee

.endUnlock
#endasm

crPACKERUnpack( 0x0100, GETDATAPTR( DATA_DMALIB_LOADING ) );

crPACKERUnpack( 0x6300, 0xC000 );
	
	//asm( "defb $ed, $ff" );



#asm
	ld hl, $6c00;
	call $6300;

	ld hl, 312-15;
	ld de, $5600;
	ld bc, $6303;
	ld a, 37*2;
	call $100;
#endasm

	
	crPACKERUnpack( 0xC000, GETDATAPTR( DATA_LOADING ) );

#asm
	call $103;
#endasm

	//crASICUnlock( );
	// crLIBInit( 0x4000 );


	{
		unsigned char iVBL;
		unsigned char iVBL2;
		unsigned int s_palette[ 17 ];
		memset( s_palette, 0, 16 * 2 );
		
		for ( iVBL = 0; iVBL <= 6; iVBL++ )
		{
			s_palette[ 1 ] += 0x111;
			s_palette[ 2 ] += 0x111;
			s_palette[ 3 ] += 0x222;

			crSYNCWaitVBL( );
			crASICSetPalette( s_palette );
		}
	}

#asm
	ld hl, ( $1500 - 2 );
	jp ( hl );
#endasm
}
