/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

// ----------------------------------------------------------------------------
#include "crLIB.h"
#include <lib3d.h>

#include <string.h> // memset

#include "Demo.h"

#include "Bozo.h"

// ----------------------------------------------------------------------------
unsigned char *s_dataPtr = (unsigned char *) 0x3600;
#define GETDATAPTR( offset ) ( (unsigned char *) ( s_dataPtr + offset ) )

// ----------------------------------------------------------------------------
static void init( );
static void frameUpdate( );
static int isFinished( );

// ----------------------------------------------------------------------------
void main( )
{
#asm
	ei;
	ld sp, $1500 - 2;
#endasm

	crASICIsBegin( );
	crBANKGetBank( );

	playMusic( );

	init( );

	playMusic( );

	while ( isFinished( ) == 0 )
	{
		frameUpdate( );

		playMusic( );
	}

#asm
	ld hl, ( $1500 - 2);
	jp ( hl );
#endasm
}

// ----------------------------------------------------------------------------
static unsigned int s_palette[ 17 ];

// ----------------------------------------------------------------------------
#define BOZO_DATA				GETDATAPTR( DATA_BOZO )
#define BOZO_UNPACKED_BUFFERSIZE	( 40 * 2 * 2 + 1 ) // 40 points * 2 frames * x/y + chunksize
#define BOZO_UNPACKED_BUFFER1	( (unsigned char *) ( 0x8000 - BOZO_UNPACKED_BUFFERSIZE ) )
#define BOZO_UNPACKED_BUFFER2	( (unsigned char *) ( BOZO_UNPACKED_BUFFER1 - BOZO_UNPACKED_BUFFERSIZE ) )
#define BOZO_UNPACKED_BUFFER3	( (unsigned char *) ( BOZO_UNPACKED_BUFFER2 - BOZO_UNPACKED_BUFFERSIZE ) )

#define BOZO_POSX				4

// ----------------------------------------------------------------------------
static unsigned char chunkSize;
static unsigned char iPart;
static unsigned char x;
static unsigned char y;
static unsigned char *unpackDataPtr;
static unsigned char *unpackDataPrev1Ptr;
static unsigned char *unpackDataPrev2Ptr;
static unsigned char *scanline;

static int s_bozoVBLCount;
static int s_isBozoFinished;

static unsigned char *s_bozoPtr;

static int s_currentUnpackBuffer;

static int s_bozoFrame;

static int iPalette;

// ----------------------------------------------------------------------------
void init( )
{
	s_bozoVBLCount = 0;
	s_isBozoFinished = 0;
	s_bozoFrame = 0;

	s_bozoPtr = (unsigned char *) BOZO_DATA;
	
	crGASetMode( 2 );
	
	memset( 0x8000, 0, 0x8000 );

	crCRTCSetupScreen( CRTC_OVERSCAN_VERTICAL, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGE_C000, CRTC_VIDEOPAGESIZE_32KB );

	for ( iPalette = 1; iPalette < 16; iPalette++ )
	{
		s_palette[ iPalette ] = 0xFFF;
	}
	crASICSetPalette( s_palette );
}

// ----------------------------------------------------------------------------
void frameUpdate( )
{
	if ( s_currentUnpackBuffer == 0 )
	{
		s_currentUnpackBuffer = 1;

		unpackDataPrev2Ptr = BOZO_UNPACKED_BUFFER3;
		unpackDataPrev1Ptr = BOZO_UNPACKED_BUFFER2;
		unpackDataPtr = BOZO_UNPACKED_BUFFER1;
	}
	else
	if ( s_currentUnpackBuffer == 1 )
	{
		s_currentUnpackBuffer = 2;

		unpackDataPrev2Ptr = BOZO_UNPACKED_BUFFER2;
		unpackDataPrev1Ptr = BOZO_UNPACKED_BUFFER1;
		unpackDataPtr = BOZO_UNPACKED_BUFFER3;
	}
	else
	{
		s_currentUnpackBuffer = 0;

		unpackDataPrev2Ptr = BOZO_UNPACKED_BUFFER1;
		unpackDataPrev1Ptr = BOZO_UNPACKED_BUFFER3;
		unpackDataPtr = BOZO_UNPACKED_BUFFER2;
	}

	crSYNCWaitVBL( );

	crCRTCFlipScreen( );

	crASICSetPalette( s_palette );
	if ( s_bozoVBLCount >= 198 - 15 )
	{
		for ( iPalette = 1; iPalette < 16; iPalette++ )
		{
			s_palette[ iPalette ] -= 0x111;
		}
	}
	
	chunkSize = *s_bozoPtr;
	
	playMusic( );

	crPACKERUnpack( (unsigned int) unpackDataPtr, (unsigned int) ( s_bozoPtr + 1 ) );

	playMusic( );

	if ( s_bozoFrame == 1 )
	{
		memcpy( unpackDataPtr, unpackDataPtr + 40 * 2, 40 * 2 );
	}

	playMusic( );

	if ( s_bozoVBLCount > 1 )
	{
		for ( iPart = 0; iPart < 40; ++iPart )
		{
			x = BOZO_POSX + ( *( unpackDataPrev2Ptr++ ) >> 1 );
			y = *( unpackDataPrev2Ptr++ ) << 1;

			scanline = (unsigned char *) crCRTCGetScanline( y );
			scanline += x;
			*scanline = 0;
			scanline = (unsigned char *) crCRTCGetScanline( y + 1 );
			scanline += x;
			*scanline = 0;
			scanline = (unsigned char *) crCRTCGetScanline( y + 2 );
			scanline += x;
			*scanline = 0;
			scanline = (unsigned char *) crCRTCGetScanline( y + 3 );
			scanline += x;
			*scanline = 0;
		}
	}
	
	playMusic( );

	for ( iPart = 0; iPart < 40; ++iPart )
	{
		x = BOZO_POSX + ( *( unpackDataPtr++ ) >> 1 );
		y = *( unpackDataPtr++ ) << 1;

		scanline = (unsigned char *) crCRTCGetScanline( y );
		scanline += x;
		*scanline = 126;
		scanline = (unsigned char *) crCRTCGetScanline( y + 1 );
		scanline += x;
		*scanline = 255;
		scanline = (unsigned char *) crCRTCGetScanline( y + 2 );
		scanline += x;
		*scanline = 255;
		scanline = (unsigned char *) crCRTCGetScanline( y + 3 );
		scanline += x;
		*scanline = 126;
	}

	playMusic( );

	s_bozoFrame++;
	if ( s_bozoFrame == 2 )
	{
		s_bozoFrame = 0;
		s_bozoPtr += chunkSize;
	}	

	s_bozoVBLCount++;
	if ( s_bozoVBLCount >= 198 )
	{
		s_isBozoFinished = 1;
	}	
}

// ----------------------------------------------------------------------------
int isFinished( )
{
	return s_isBozoFinished;
}

