/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __CROCOLIB_TEXT_H__
#define __CROCOLIB_TEXT_H__

// ----------------------------------------------------------------------------
struct SFont
{
	unsigned char fontBank;
	unsigned int fontAdress;

	unsigned char fontCharWidth;
	unsigned char fontCharHeight;
	unsigned char fontCharsPerLine;

	unsigned char fontCharSet[ 48 ];

	unsigned int fontCharAdress[ 128 ]; // ASCII code as index
	unsigned int fontPitch;
};

// ----------------------------------------------------------------------------
struct SScroll
{
	unsigned int pageAdress;
	unsigned int posX;
	unsigned int posY;

	unsigned int textOffset;
	unsigned char charOffset;
};

// ----------------------------------------------------------------------------
extern void __LIB__ crTEXTInitFont( struct SFont *font );
extern void __LIB__ crTEXTDrawString( struct SFont *font, unsigned int text, unsigned int screenPage, unsigned int posX, unsigned int posY );
extern void __LIB__ crTEXTDrawScrollerX( struct SFont *font, unsigned int text, struct SScroll *scroll );
extern void __LIB__ crTEXTDrawScrollerY( struct SFont *font, unsigned int text, struct SScroll *scroll );

extern void __LIB__ crTEXTDrawStringRandomScreen( unsigned int *screenPtr, struct SFont *font, struct SFont *font2, struct SFont *font3, int isHexa );

// ----------------------------------------------------------------------------
#endif // __CROCOLIB_GFX_H__
