/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crGFX.h"

#include <string.h> // memset

// ----------------------------------------------------------------------------
void __LIB__ crGFXDrawMonoFrame2( unsigned int *screenPtr, unsigned int *imagePtr, unsigned int *imagePtrEnd )
{
#asm
	di;

	pop bc;
	pop de; // imagePtrEnd
	ld ( makeJP + 1 ), de;
	pop de; // imagePtr
	ld ( srcZoom + 1 ), de;
	pop hl; // screenPtr

	push hl;
	push de;
	ld de, ( makeJP + 1 );
	push de;
	push bc;

	ld ( saveStack + 1 ), sp;

	ld bc, 30*33*2;
	add hl, bc;
	ld ( mainLoop + 1 ), hl;
	
.makeJP
	ld hl, 0;

	//defb $ed, $ff;

	ld a, $c3;
	ld ( hl ), a;
	inc hl;
	ld de, endJump;
	ld a, e;
	ld ( hl ), a;
	inc hl;
	ld a, d;
	ld ( hl ), a;

	ld a, 4;
	ld ( iter + 1 ), a;

	ei;

.mainLoop
	ld hl, 0;
	ld a, h;
	add 8;
	ld h, a;	
	ld ( mainLoop + 1 ), hl;
	sub 8;
	ld h, a;

	ld sp, hl;

	ld de, $CC33; // full // http://www.cantrell.org.uk/david/tech/cpc/cpc-firmware/firmware.pdf page 30
	ld hl, $C030; // intermediate
	ld bc, $0000;
.srcZoom
	jp 0;

.endJump
	
.iter 
	ld a, 4;
	cp 2;
	jp nz, skipDI;
	di;
.skipDI;
	dec a;
	ld ( iter + 1 ), a;
	jp nz, mainLoop;

.saveStack
	ld sp, 0;
	ei;	
#endasm
}
