/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __CROCOLIB_GFX_H__
#define __CROCOLIB_GFX_H__

// ----------------------------------------------------------------------------
extern void __LIB__ crGFXClearClouds( unsigned char compareValue, unsigned int clouds, unsigned char *screen );
extern void __LIB__ crGFXClearIntermediateClouds( unsigned char compareValue, unsigned int clouds, unsigned char *screen );
extern void __LIB__ crGFXDrawClouds( unsigned char compareValue, unsigned int clouds, unsigned char *screen );
extern void __LIB__ crGFXDrawIntermediateClouds( unsigned char compareValue, unsigned int clouds, unsigned char *screen );

extern void __LIB__ crGFXDrawPixel( int posX, int posY, unsigned char pen );
extern void __LIB__ crGFXDrawLine( int x1, int y1, int x2, int y2, unsigned char pen );
extern void __LIB__ crGFXDrawRect( int x1, int y1, int x2, int y2, unsigned char pen );
extern void __LIB__ crGFXDrawRectFast( unsigned int *g_scanlineBuffer, unsigned int startWidth, unsigned int width, unsigned int height, unsigned int pen );

extern void __LIB__ crGFXCreateFrame( unsigned char *framePtr );
extern void __LIB__ crGFXDrawFrame( unsigned int *screenPtr, unsigned int *imagePtr, unsigned int *imagePtrEnd );
extern void __LIB__ crGFXDrawMonoFrame( unsigned int *screenPtr, unsigned int *imagePtr, unsigned int *imagePtrEnd );
extern void __LIB__ crGFXDrawMonoFrame2( unsigned int *screenPtr, unsigned int *imagePtr, unsigned int *imagePtrEnd );
extern void __LIB__ crGFXDrawMonoFrame3( unsigned int *screenPtr, unsigned int *imagePtr, unsigned int *imagePtrEnd );
extern void __LIB__ crGFXCreateMonoRotoZoomFrame( unsigned char *screenPtr, unsigned char *imagePtr, int u, int v, int xx, int yy );
extern void __LIB__ crGFXCreateMonoInterFrame( unsigned char *screenPtr, unsigned char *imagePtr1, unsigned char *imagePtr2 );
extern void __LIB__ crGFXCreateRotoZoomFrame( unsigned char *screenPtr, unsigned char *imagePtr, int u, int v, int xx, int yy );
extern void __LIB__ crGFXCreateMonoTunnelFrame( unsigned char *screenPtr, unsigned char *imagePtr, unsigned int *fxPtr, unsigned int offsetX, unsigned int offsetY );

// ----------------------------------------------------------------------------
extern unsigned int g_framePtr;
extern unsigned int g_frameInterPtr;

// ----------------------------------------------------------------------------
#endif // __CROCOLIB_GFX_H__
